/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.wifi.aware.WifiAwareUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

public class WifiAwareDataPathSecurityConfig
implements Parcelable {
    private final byte[] mPmk;
    private final String mPassphrase;
    private final byte[] mPmkId;
    private final int mCipherSuite;
    @NonNull
    public static final Parcelable.Creator<WifiAwareDataPathSecurityConfig> CREATOR = new Parcelable.Creator<WifiAwareDataPathSecurityConfig>(){

        @Override
        public WifiAwareDataPathSecurityConfig createFromParcel(Parcel in) {
            return new WifiAwareDataPathSecurityConfig(in);
        }

        public WifiAwareDataPathSecurityConfig[] newArray(int size) {
            return new WifiAwareDataPathSecurityConfig[size];
        }
    };

    public WifiAwareDataPathSecurityConfig(int cipherSuite, byte[] pmk, byte[] pmkId, String passphrase) {
        this.mCipherSuite = cipherSuite;
        this.mPassphrase = passphrase;
        this.mPmk = pmk;
        this.mPmkId = pmkId;
    }

    private WifiAwareDataPathSecurityConfig(Parcel in) {
        this.mPmk = in.createByteArray();
        this.mPassphrase = in.readString();
        this.mPmkId = in.createByteArray();
        this.mCipherSuite = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByteArray(this.mPmk);
        dest.writeString(this.mPassphrase);
        dest.writeByteArray(this.mPmkId);
        dest.writeInt(this.mCipherSuite);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiAwareDataPathSecurityConfig)) {
            return false;
        }
        WifiAwareDataPathSecurityConfig lhs = (WifiAwareDataPathSecurityConfig)obj;
        return this.mCipherSuite == lhs.mCipherSuite && Arrays.equals(this.mPmk, lhs.mPmk) && Objects.equals(this.mPassphrase, lhs.mPassphrase) && Arrays.equals(this.mPmkId, lhs.mPmkId);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mPmk), this.mPassphrase, Arrays.hashCode(this.mPmkId), this.mCipherSuite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiAwareDataPathSecurityConfig [");
        sb.append("cipherSuite=").append(this.mCipherSuite).append(", passphrase=").append(TextUtils.isEmpty(this.mPassphrase) ? "<null>" : "<non-null>").append(", PMK=").append(this.mPmk == null ? "<null>" : "<non-null>").append(", PMKID=").append(this.mPmkId == null ? "<null>" : "<non-null>").append("]");
        return sb.toString();
    }

    public boolean isValid() {
        if (this.mCipherSuite == 1 || this.mCipherSuite == 2) {
            if (TextUtils.isEmpty(this.mPassphrase) && this.mPmk == null) {
                return false;
            }
            if (!TextUtils.isEmpty(this.mPassphrase) && this.mPmk != null) {
                return false;
            }
            if (this.mPmkId != null) {
                return false;
            }
            if (WifiAwareUtils.validatePassphrase(this.mPassphrase) && this.mPmk == null) {
                return true;
            }
            return TextUtils.isEmpty(this.mPassphrase) && WifiAwareUtils.validatePmk(this.mPmk);
        }
        if (this.mCipherSuite == 4 || this.mCipherSuite == 8) {
            if (!WifiAwareUtils.validatePmk(this.mPmk) || !WifiAwareUtils.validatePmkId(this.mPmkId)) {
                return false;
            }
            return TextUtils.isEmpty(this.mPassphrase);
        }
        return false;
    }

    public int getCipherSuite() {
        return this.mCipherSuite;
    }

    public byte[] getPmk() {
        return this.mPmk;
    }

    public byte[] getPmkId() {
        return this.mPmkId;
    }

    public String getPskPassphrase() {
        return this.mPassphrase;
    }

    public static class Builder {
        private byte[] mPmk;
        private String mPassphrase;
        private byte[] mPmkId;
        private int mCipherSuite;

        public Builder(int cipherSuite) {
            if (cipherSuite != 1 && cipherSuite != 2 && cipherSuite != 4 && cipherSuite != 8) {
                throw new IllegalArgumentException("Invalid cipher suite");
            }
            this.mCipherSuite = cipherSuite;
        }

        @NonNull
        public Builder setPskPassphrase(@NonNull String pskPassphrase) {
            if (!WifiAwareUtils.validatePassphrase(pskPassphrase)) {
                throw new IllegalArgumentException("Passphrase must meet length requirements");
            }
            this.mPassphrase = pskPassphrase;
            return this;
        }

        @NonNull
        public Builder setPmk(@NonNull byte[] pmk) {
            if (!WifiAwareUtils.validatePmk(pmk)) {
                throw new IllegalArgumentException("PMK must 32 bytes");
            }
            this.mPmk = pmk;
            return this;
        }

        @NonNull
        public Builder setPmkId(@NonNull byte[] pmkId) {
            if (!WifiAwareUtils.validatePmkId(pmkId)) {
                throw new IllegalArgumentException("PMKID must 16 bytes");
            }
            this.mPmkId = pmkId;
            return this;
        }

        @NonNull
        public WifiAwareDataPathSecurityConfig build() {
            if (this.mPassphrase != null && this.mPmk != null) {
                throw new IllegalStateException("Can only specify a Passphrase or a PMK - not both!");
            }
            if (this.mCipherSuite == 1 || this.mCipherSuite == 2) {
                if (TextUtils.isEmpty(this.mPassphrase) && this.mPmk == null) {
                    throw new IllegalStateException("Must set either PMK or Passphrase for shared key cipher suite");
                }
                if (this.mPmkId != null) {
                    throw new IllegalStateException("PMKID should not set for shared key cipher suite");
                }
            } else {
                if (this.mPmk == null || this.mPmkId == null) {
                    throw new IllegalStateException("Must set both PMK and PMKID for public key cipher suite");
                }
                if (!TextUtils.isEmpty(this.mPassphrase)) {
                    throw new IllegalStateException("Passphrase is not support for public key cipher suite");
                }
            }
            return new WifiAwareDataPathSecurityConfig(this.mCipherSuite, this.mPmk, this.mPmkId, this.mPassphrase);
        }
    }
}

