/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HomeSp
implements Parcelable {
    private static final String TAG = "HomeSp";
    private static final int MAX_SSID_BYTES = 32;
    private static final int NULL_VALUE = -1;
    private String mFqdn = null;
    private String mFriendlyName = null;
    private String mIconUrl = null;
    private Map<String, Long> mHomeNetworkIds = null;
    private long[] mMatchAllOis = null;
    private long[] mMatchAnyOis = null;
    private String[] mOtherHomePartners = null;
    private long[] mRoamingConsortiumOis = null;
    public static final Parcelable.Creator<HomeSp> CREATOR = new Parcelable.Creator<HomeSp>(){

        @Override
        public HomeSp createFromParcel(Parcel in) {
            HomeSp homeSp = new HomeSp();
            homeSp.setFqdn(in.readString());
            homeSp.setFriendlyName(in.readString());
            homeSp.setIconUrl(in.readString());
            homeSp.setHomeNetworkIds(this.readHomeNetworkIds(in));
            homeSp.setMatchAllOis(in.createLongArray());
            homeSp.setMatchAnyOis(in.createLongArray());
            homeSp.setOtherHomePartners(in.createStringArray());
            homeSp.setRoamingConsortiumOis(in.createLongArray());
            return homeSp;
        }

        public HomeSp[] newArray(int size) {
            return new HomeSp[size];
        }

        private Map<String, Long> readHomeNetworkIds(Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            HashMap<String, Long> networkIds = new HashMap<String, Long>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                Long value2 = null;
                long readValue = in.readLong();
                if (readValue != -1L) {
                    value2 = readValue;
                }
                networkIds.put(key, value2);
            }
            return networkIds;
        }
    };

    public void setFqdn(String fqdn) {
        this.mFqdn = fqdn;
    }

    public String getFqdn() {
        return this.mFqdn;
    }

    public void setFriendlyName(String friendlyName) {
        this.mFriendlyName = friendlyName;
    }

    public String getFriendlyName() {
        return this.mFriendlyName;
    }

    public void setIconUrl(String iconUrl) {
        this.mIconUrl = iconUrl;
    }

    public String getIconUrl() {
        return this.mIconUrl;
    }

    public void setHomeNetworkIds(Map<String, Long> homeNetworkIds) {
        this.mHomeNetworkIds = homeNetworkIds;
    }

    public Map<String, Long> getHomeNetworkIds() {
        return this.mHomeNetworkIds;
    }

    public void setMatchAllOis(long[] matchAllOis) {
        this.mMatchAllOis = matchAllOis;
    }

    public long[] getMatchAllOis() {
        return this.mMatchAllOis;
    }

    public void setMatchAnyOis(long[] matchAnyOis) {
        this.mMatchAnyOis = matchAnyOis;
    }

    public long[] getMatchAnyOis() {
        return this.mMatchAnyOis;
    }

    public void setOtherHomePartners(String[] otherHomePartners) {
        this.mOtherHomePartners = otherHomePartners;
    }

    public void setOtherHomePartnersList(Collection<String> otherHomePartners) {
        if (otherHomePartners == null) {
            return;
        }
        this.mOtherHomePartners = otherHomePartners.toArray(new String[otherHomePartners.size()]);
    }

    public String[] getOtherHomePartners() {
        return this.mOtherHomePartners;
    }

    public Collection<String> getOtherHomePartnersList() {
        if (this.mOtherHomePartners == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.mOtherHomePartners);
    }

    public void setRoamingConsortiumOis(long[] roamingConsortiumOis) {
        this.mRoamingConsortiumOis = roamingConsortiumOis;
    }

    public long[] getRoamingConsortiumOis() {
        return this.mRoamingConsortiumOis;
    }

    public HomeSp() {
    }

    public HomeSp(HomeSp source) {
        if (source == null) {
            return;
        }
        this.mFqdn = source.mFqdn;
        this.mFriendlyName = source.mFriendlyName;
        this.mIconUrl = source.mIconUrl;
        if (source.mHomeNetworkIds != null) {
            this.mHomeNetworkIds = Collections.unmodifiableMap(source.mHomeNetworkIds);
        }
        if (source.mMatchAllOis != null) {
            this.mMatchAllOis = Arrays.copyOf(source.mMatchAllOis, source.mMatchAllOis.length);
        }
        if (source.mMatchAnyOis != null) {
            this.mMatchAnyOis = Arrays.copyOf(source.mMatchAnyOis, source.mMatchAnyOis.length);
        }
        if (source.mOtherHomePartners != null) {
            this.mOtherHomePartners = Arrays.copyOf(source.mOtherHomePartners, source.mOtherHomePartners.length);
        }
        if (source.mRoamingConsortiumOis != null) {
            this.mRoamingConsortiumOis = Arrays.copyOf(source.mRoamingConsortiumOis, source.mRoamingConsortiumOis.length);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFqdn);
        dest.writeString(this.mFriendlyName);
        dest.writeString(this.mIconUrl);
        HomeSp.writeHomeNetworkIds(dest, this.mHomeNetworkIds);
        dest.writeLongArray(this.mMatchAllOis);
        dest.writeLongArray(this.mMatchAnyOis);
        dest.writeStringArray(this.mOtherHomePartners);
        dest.writeLongArray(this.mRoamingConsortiumOis);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof HomeSp)) {
            return false;
        }
        HomeSp that = (HomeSp)thatObject;
        return TextUtils.equals(this.mFqdn, that.mFqdn) && TextUtils.equals(this.mFriendlyName, that.mFriendlyName) && TextUtils.equals(this.mIconUrl, that.mIconUrl) && (this.mHomeNetworkIds == null ? that.mHomeNetworkIds == null : this.mHomeNetworkIds.equals(that.mHomeNetworkIds)) && Arrays.equals(this.mMatchAllOis, that.mMatchAllOis) && Arrays.equals(this.mMatchAnyOis, that.mMatchAnyOis) && Arrays.equals(this.mOtherHomePartners, that.mOtherHomePartners) && Arrays.equals(this.mRoamingConsortiumOis, that.mRoamingConsortiumOis);
    }

    public int hashCode() {
        return Objects.hash(this.mFqdn, this.mFriendlyName, this.mIconUrl, this.mHomeNetworkIds, Arrays.hashCode(this.mMatchAllOis), Arrays.hashCode(this.mMatchAnyOis), Arrays.hashCode(this.mOtherHomePartners), Arrays.hashCode(this.mRoamingConsortiumOis));
    }

    public int getUniqueId() {
        return Objects.hash(this.mFqdn);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("FQDN: ").append(this.mFqdn).append("\n");
        builder2.append("FriendlyName: ").append(this.mFriendlyName).append("\n");
        builder2.append("IconURL: ").append(this.mIconUrl).append("\n");
        builder2.append("HomeNetworkIDs: ").append(this.mHomeNetworkIds).append("\n");
        builder2.append("MatchAllOIs: ").append(this.mMatchAllOis).append("\n");
        builder2.append("MatchAnyOIs: ").append(this.mMatchAnyOis).append("\n");
        builder2.append("OtherHomePartners: ").append(this.mOtherHomePartners).append("\n");
        builder2.append("RoamingConsortiumOIs: ").append(this.mRoamingConsortiumOis).append("\n");
        return builder2.toString();
    }

    public boolean validate() {
        if (TextUtils.isEmpty(this.mFqdn)) {
            Log.d(TAG, "Missing FQDN");
            return false;
        }
        if (this.mFqdn.getBytes(StandardCharsets.UTF_8).length > 255) {
            Log.d(TAG, "FQDN is too long");
            return false;
        }
        if (TextUtils.isEmpty(this.mFriendlyName)) {
            Log.d(TAG, "Missing friendly name");
            return false;
        }
        if (this.mFriendlyName.getBytes(StandardCharsets.UTF_8).length > 255) {
            Log.d(TAG, "Friendly name is too long");
            return false;
        }
        if (this.mHomeNetworkIds != null) {
            if (this.mHomeNetworkIds.size() > 16) {
                Log.d(TAG, "too many SSID in HomeNetworkIDs");
                return false;
            }
            for (Map.Entry<String, Long> entry : this.mHomeNetworkIds.entrySet()) {
                if (entry.getKey() == null || entry.getKey().getBytes(StandardCharsets.UTF_8).length > 32) {
                    Log.d(TAG, "SSID is too long in HomeNetworkIDs");
                    return false;
                }
                if (entry.getValue() == null || entry.getValue() <= 0xFFFFFFFFFFFFL && entry.getValue() >= 0L) continue;
                Log.d(TAG, "HESSID is out of range");
                return false;
            }
        }
        if (this.mIconUrl != null && this.mIconUrl.getBytes(StandardCharsets.UTF_8).length > 2048) {
            Log.d(TAG, "Icon URL is too long");
            return false;
        }
        if (this.mMatchAllOis != null) {
            if (this.mMatchAllOis.length > 36) {
                Log.d(TAG, "too many match all Organization Identifiers in the profile");
                return false;
            }
            for (String oi : (String[])this.mMatchAllOis) {
                if (oi <= 0xFFFFFFFFFFL && oi >= 0L) continue;
                Log.d(TAG, "Organization Identifiers is out of range");
                return false;
            }
        }
        if (this.mMatchAnyOis != null) {
            if (this.mMatchAnyOis.length > 36) {
                Log.d(TAG, "too many match any Organization Identifiers in the profile");
                return false;
            }
            for (String oi : (String[])this.mMatchAnyOis) {
                if (oi <= 0xFFFFFFFFFFL && oi >= 0L) continue;
                Log.d(TAG, "Organization Identifiers is out of range");
                return false;
            }
        }
        if (this.mRoamingConsortiumOis != null) {
            if (this.mRoamingConsortiumOis.length > 36) {
                Log.d(TAG, "too many Roaming Consortium Organization Identifiers in the profile");
                return false;
            }
            for (String oi : (String[])this.mRoamingConsortiumOis) {
                if (oi <= 0xFFFFFFFFFFL && oi >= 0L) continue;
                Log.d(TAG, "Organization Identifiers is out of range");
                return false;
            }
        }
        if (this.mOtherHomePartners != null) {
            if (this.mOtherHomePartners.length > 16) {
                Log.d(TAG, "too many other home partners in the profile");
                return false;
            }
            for (String fqdn : this.mOtherHomePartners) {
                if (fqdn.length() <= 255) continue;
                Log.d(TAG, "FQDN is too long in OtherHomePartners");
                return false;
            }
        }
        return true;
    }

    private static void writeHomeNetworkIds(Parcel dest, Map<String, Long> networkIds) {
        if (networkIds == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(networkIds.size());
        for (Map.Entry<String, Long> entry : networkIds.entrySet()) {
            dest.writeString(entry.getKey());
            if (entry.getValue() == null) {
                dest.writeLong(-1L);
                continue;
            }
            dest.writeLong(entry.getValue());
        }
    }
}

