/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.wifi.WpsInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.regex.PatternSyntaxException;

public class WifiP2pConfig
implements Parcelable {
    public String deviceAddress = "";
    public WpsInfo wps;
    public String networkName = "";
    public String passphrase = "";
    public int groupOwnerBand = 0;
    public static final int GROUP_OWNER_BAND_AUTO = 0;
    public static final int GROUP_OWNER_BAND_2GHZ = 1;
    public static final int GROUP_OWNER_BAND_5GHZ = 2;
    public static final int GROUP_OWNER_INTENT_MIN = 0;
    public static final int GROUP_OWNER_INTENT_MAX = 15;
    public static final int GROUP_OWNER_INTENT_AUTO = -1;
    public int groupOwnerIntent = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int netId = -2;
    public static final Parcelable.Creator<WifiP2pConfig> CREATOR = new Parcelable.Creator<WifiP2pConfig>(){

        @Override
        public WifiP2pConfig createFromParcel(Parcel in) {
            WifiP2pConfig config = new WifiP2pConfig();
            config.deviceAddress = in.readString();
            config.wps = (WpsInfo)in.readParcelable(null);
            config.groupOwnerIntent = in.readInt();
            config.netId = in.readInt();
            config.networkName = in.readString();
            config.passphrase = in.readString();
            config.groupOwnerBand = in.readInt();
            return config;
        }

        public WifiP2pConfig[] newArray(int size) {
            return new WifiP2pConfig[size];
        }
    };

    public String getNetworkName() {
        return this.networkName;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public int getGroupOwnerBand() {
        return this.groupOwnerBand;
    }

    public int getNetworkId() {
        return this.netId;
    }

    public WifiP2pConfig() {
        this.wps = new WpsInfo();
        this.wps.setup = 0;
    }

    public void invalidate() {
        this.deviceAddress = "";
    }

    @UnsupportedAppUsage
    public WifiP2pConfig(String supplicantEvent) throws IllegalArgumentException {
        String[] tokens = supplicantEvent.split(" ");
        if (tokens.length < 2 || !tokens[0].equals("P2P-GO-NEG-REQUEST")) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = tokens[1];
        this.wps = new WpsInfo();
        if (tokens.length > 2) {
            int devPasswdId;
            String[] nameVal = tokens[2].split("=");
            try {
                devPasswdId = Integer.parseInt(nameVal[1]);
            }
            catch (NumberFormatException e) {
                devPasswdId = 0;
            }
            switch (devPasswdId) {
                case 1: {
                    this.wps.setup = 1;
                    break;
                }
                case 4: {
                    this.wps.setup = 0;
                    break;
                }
                case 5: {
                    this.wps.setup = 2;
                    break;
                }
                default: {
                    this.wps.setup = 0;
                }
            }
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n address: ").append(this.deviceAddress);
        sbuf.append("\n wps: ").append(this.wps);
        sbuf.append("\n groupOwnerIntent: ").append(this.groupOwnerIntent);
        sbuf.append("\n persist: ").append(this.netId);
        sbuf.append("\n networkName: ").append(this.networkName);
        sbuf.append("\n passphrase: ").append(TextUtils.isEmpty(this.passphrase) ? "<empty>" : "<non-empty>");
        sbuf.append("\n groupOwnerBand: ").append(this.groupOwnerBand);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pConfig(WifiP2pConfig source) {
        if (source != null) {
            this.deviceAddress = source.deviceAddress;
            this.wps = new WpsInfo(source.wps);
            this.groupOwnerIntent = source.groupOwnerIntent;
            this.netId = source.netId;
            this.networkName = source.networkName;
            this.passphrase = source.passphrase;
            this.groupOwnerBand = source.groupOwnerBand;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceAddress);
        dest.writeParcelable(this.wps, flags);
        dest.writeInt(this.groupOwnerIntent);
        dest.writeInt(this.netId);
        dest.writeString(this.networkName);
        dest.writeString(this.passphrase);
        dest.writeInt(this.groupOwnerBand);
    }

    public static class Builder {
        private static final MacAddress MAC_ANY_ADDRESS = MacAddress.fromString("02:00:00:00:00:00");
        private static final int MAX_SSID_BYTES = 32;
        private MacAddress mDeviceAddress = MAC_ANY_ADDRESS;
        private String mNetworkName = "";
        private String mPassphrase = "";
        private int mGroupOperatingBand = 0;
        private int mGroupOperatingFrequency = 0;
        private int mNetId = -1;

        public Builder setDeviceAddress(MacAddress deviceAddress) {
            this.mDeviceAddress = deviceAddress == null ? MAC_ANY_ADDRESS : deviceAddress;
            return this;
        }

        public Builder setNetworkName(String networkName) {
            if (TextUtils.isEmpty(networkName)) {
                throw new IllegalArgumentException("network name must be non-empty.");
            }
            if (networkName.getBytes(StandardCharsets.UTF_8).length > 32) {
                throw new IllegalArgumentException("network name exceeds 32 bytes.");
            }
            try {
                if (!networkName.matches("^DIRECT-[a-zA-Z0-9]{2}.*")) {
                    throw new IllegalArgumentException("network name must starts with the prefix DIRECT-xy.");
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            this.mNetworkName = networkName;
            return this;
        }

        public Builder setPassphrase(String passphrase) {
            if (TextUtils.isEmpty(passphrase)) {
                throw new IllegalArgumentException("passphrase must be non-empty.");
            }
            if (passphrase.length() < 8 || passphrase.length() > 63) {
                throw new IllegalArgumentException("The length of a passphrase must be between 8 and 63.");
            }
            this.mPassphrase = passphrase;
            return this;
        }

        public Builder setGroupOperatingBand(int band) {
            switch (band) {
                case 0: 
                case 1: 
                case 2: {
                    this.mGroupOperatingBand = band;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid constant for the group operating band!");
                }
            }
            return this;
        }

        public Builder setGroupOperatingFrequency(int frequency) {
            if (frequency < 0) {
                throw new IllegalArgumentException("Invalid group operating frequency!");
            }
            this.mGroupOperatingFrequency = frequency;
            return this;
        }

        public Builder enablePersistentMode(boolean persistent) {
            this.mNetId = persistent ? -2 : -1;
            return this;
        }

        public WifiP2pConfig build() {
            if (TextUtils.isEmpty(this.mNetworkName) && !TextUtils.isEmpty(this.mPassphrase) || !TextUtils.isEmpty(this.mNetworkName) && TextUtils.isEmpty(this.mPassphrase)) {
                throw new IllegalStateException("network name and passphrase must be non-empty or empty both.");
            }
            if (TextUtils.isEmpty(this.mNetworkName) && this.mDeviceAddress.equals(MAC_ANY_ADDRESS)) {
                throw new IllegalStateException("peer address must be set if network name and pasphrase are not set.");
            }
            if (this.mGroupOperatingFrequency > 0 && this.mGroupOperatingBand > 0) {
                throw new IllegalStateException("Preferred frequency and band are mutually exclusive.");
            }
            WifiP2pConfig config = new WifiP2pConfig();
            config.deviceAddress = this.mDeviceAddress.toString();
            config.networkName = this.mNetworkName;
            config.passphrase = this.mPassphrase;
            config.groupOwnerBand = 0;
            if (this.mGroupOperatingFrequency > 0) {
                config.groupOwnerBand = this.mGroupOperatingFrequency;
            } else if (this.mGroupOperatingBand > 0) {
                config.groupOwnerBand = this.mGroupOperatingBand;
            }
            config.netId = this.mNetId;
            return config;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupOperatingBandType {
    }
}

