/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.net.Uri;
import android.nfc.NdefMessage;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;

public class BeamShareData
implements Parcelable {
    public final NdefMessage ndefMessage;
    public final Uri[] uris;
    public final UserHandle userHandle;
    public final int flags;
    public static final Parcelable.Creator<BeamShareData> CREATOR = new Parcelable.Creator<BeamShareData>(){

        @Override
        public BeamShareData createFromParcel(Parcel source) {
            Uri[] uris = null;
            NdefMessage msg = source.readParcelable(NdefMessage.class.getClassLoader(), NdefMessage.class);
            int numUris = source.readInt();
            if (numUris > 0) {
                uris = new Uri[numUris];
                source.readTypedArray(uris, Uri.CREATOR);
            }
            UserHandle userHandle = source.readParcelable(UserHandle.class.getClassLoader(), UserHandle.class);
            int flags = source.readInt();
            return new BeamShareData(msg, uris, userHandle, flags);
        }

        public BeamShareData[] newArray(int size) {
            return new BeamShareData[size];
        }
    };

    public BeamShareData(NdefMessage msg, Uri[] uris, UserHandle userHandle, int flags) {
        this.ndefMessage = msg;
        this.uris = uris;
        this.userHandle = userHandle;
        this.flags = flags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int urisLength = this.uris != null ? this.uris.length : 0;
        dest.writeParcelable(this.ndefMessage, 0);
        dest.writeInt(urisLength);
        if (urisLength > 0) {
            dest.writeTypedArray(this.uris, 0);
        }
        dest.writeParcelable(this.userHandle, 0);
        dest.writeInt(this.flags);
    }
}

