/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.PendingIntent;
import android.content.IntentFilter;
import android.nfc.BeamShareData;
import android.nfc.IAppCallback;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcControllerAlwaysOnListener;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.ITagRemovedCallback;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INfcAdapter
extends IInterface {
    public INfcTag getNfcTagInterface() throws RemoteException;

    public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException;

    public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException;

    public INfcAdapterExtras getNfcAdapterExtrasInterface(String var1) throws RemoteException;

    public INfcDta getNfcDtaInterface(String var1) throws RemoteException;

    public int getState() throws RemoteException;

    public boolean disable(boolean var1) throws RemoteException;

    public boolean enable() throws RemoteException;

    public boolean enableNdefPush() throws RemoteException;

    public boolean disableNdefPush() throws RemoteException;

    public boolean isNdefPushEnabled() throws RemoteException;

    public void pausePolling(int var1) throws RemoteException;

    public void resumePolling() throws RemoteException;

    public void setForegroundDispatch(PendingIntent var1, IntentFilter[] var2, TechListParcel var3) throws RemoteException;

    public void setAppCallback(IAppCallback var1) throws RemoteException;

    public void invokeBeam() throws RemoteException;

    public void invokeBeamInternal(BeamShareData var1) throws RemoteException;

    public boolean ignore(int var1, int var2, ITagRemovedCallback var3) throws RemoteException;

    public void dispatch(Tag var1) throws RemoteException;

    public void setReaderMode(IBinder var1, IAppCallback var2, int var3, Bundle var4) throws RemoteException;

    public void setP2pModes(int var1, int var2) throws RemoteException;

    public void addNfcUnlockHandler(INfcUnlockHandler var1, int[] var2) throws RemoteException;

    public void removeNfcUnlockHandler(INfcUnlockHandler var1) throws RemoteException;

    public void verifyNfcPermission() throws RemoteException;

    public boolean isNfcSecureEnabled() throws RemoteException;

    public boolean deviceSupportsNfcSecure() throws RemoteException;

    public boolean setNfcSecure(boolean var1) throws RemoteException;

    public boolean setControllerAlwaysOn(boolean var1) throws RemoteException;

    public boolean isControllerAlwaysOn() throws RemoteException;

    public boolean isControllerAlwaysOnSupported() throws RemoteException;

    public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcAdapter {
        public static final String DESCRIPTOR = "android.nfc.INfcAdapter";
        static final int TRANSACTION_getNfcTagInterface = 1;
        static final int TRANSACTION_getNfcCardEmulationInterface = 2;
        static final int TRANSACTION_getNfcFCardEmulationInterface = 3;
        static final int TRANSACTION_getNfcAdapterExtrasInterface = 4;
        static final int TRANSACTION_getNfcDtaInterface = 5;
        static final int TRANSACTION_getState = 6;
        static final int TRANSACTION_disable = 7;
        static final int TRANSACTION_enable = 8;
        static final int TRANSACTION_enableNdefPush = 9;
        static final int TRANSACTION_disableNdefPush = 10;
        static final int TRANSACTION_isNdefPushEnabled = 11;
        static final int TRANSACTION_pausePolling = 12;
        static final int TRANSACTION_resumePolling = 13;
        static final int TRANSACTION_setForegroundDispatch = 14;
        static final int TRANSACTION_setAppCallback = 15;
        static final int TRANSACTION_invokeBeam = 16;
        static final int TRANSACTION_invokeBeamInternal = 17;
        static final int TRANSACTION_ignore = 18;
        static final int TRANSACTION_dispatch = 19;
        static final int TRANSACTION_setReaderMode = 20;
        static final int TRANSACTION_setP2pModes = 21;
        static final int TRANSACTION_addNfcUnlockHandler = 22;
        static final int TRANSACTION_removeNfcUnlockHandler = 23;
        static final int TRANSACTION_verifyNfcPermission = 24;
        static final int TRANSACTION_isNfcSecureEnabled = 25;
        static final int TRANSACTION_deviceSupportsNfcSecure = 26;
        static final int TRANSACTION_setNfcSecure = 27;
        static final int TRANSACTION_setControllerAlwaysOn = 28;
        static final int TRANSACTION_isControllerAlwaysOn = 29;
        static final int TRANSACTION_isControllerAlwaysOnSupported = 30;
        static final int TRANSACTION_registerControllerAlwaysOnListener = 31;
        static final int TRANSACTION_unregisterControllerAlwaysOnListener = 32;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INfcAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INfcAdapter) {
                return (INfcAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getNfcTagInterface";
                }
                case 2: {
                    return "getNfcCardEmulationInterface";
                }
                case 3: {
                    return "getNfcFCardEmulationInterface";
                }
                case 4: {
                    return "getNfcAdapterExtrasInterface";
                }
                case 5: {
                    return "getNfcDtaInterface";
                }
                case 6: {
                    return "getState";
                }
                case 7: {
                    return "disable";
                }
                case 8: {
                    return "enable";
                }
                case 9: {
                    return "enableNdefPush";
                }
                case 10: {
                    return "disableNdefPush";
                }
                case 11: {
                    return "isNdefPushEnabled";
                }
                case 12: {
                    return "pausePolling";
                }
                case 13: {
                    return "resumePolling";
                }
                case 14: {
                    return "setForegroundDispatch";
                }
                case 15: {
                    return "setAppCallback";
                }
                case 16: {
                    return "invokeBeam";
                }
                case 17: {
                    return "invokeBeamInternal";
                }
                case 18: {
                    return "ignore";
                }
                case 19: {
                    return "dispatch";
                }
                case 20: {
                    return "setReaderMode";
                }
                case 21: {
                    return "setP2pModes";
                }
                case 22: {
                    return "addNfcUnlockHandler";
                }
                case 23: {
                    return "removeNfcUnlockHandler";
                }
                case 24: {
                    return "verifyNfcPermission";
                }
                case 25: {
                    return "isNfcSecureEnabled";
                }
                case 26: {
                    return "deviceSupportsNfcSecure";
                }
                case 27: {
                    return "setNfcSecure";
                }
                case 28: {
                    return "setControllerAlwaysOn";
                }
                case 29: {
                    return "isControllerAlwaysOn";
                }
                case 30: {
                    return "isControllerAlwaysOnSupported";
                }
                case 31: {
                    return "registerControllerAlwaysOnListener";
                }
                case 32: {
                    return "unregisterControllerAlwaysOnListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INfcTag _result = this.getNfcTagInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    INfcCardEmulation _result = this.getNfcCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    INfcFCardEmulation _result = this.getNfcFCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcAdapterExtras _result = this.getNfcAdapterExtrasInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcDta _result = this.getNfcDtaInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.disable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _result = this.enable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    boolean _result = this.enableNdefPush();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    boolean _result = this.disableNdefPush();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    boolean _result = this.isNdefPushEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.pausePolling(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    this.resumePolling();
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    IntentFilter[] _arg1 = data.createTypedArray(IntentFilter.CREATOR);
                    TechListParcel _arg2 = data.readTypedObject(TechListParcel.CREATOR);
                    data.enforceNoDataAvail();
                    this.setForegroundDispatch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IAppCallback _arg0 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setAppCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    this.invokeBeam();
                    break;
                }
                case 17: {
                    BeamShareData _arg0 = data.readTypedObject(BeamShareData.CREATOR);
                    data.enforceNoDataAvail();
                    this.invokeBeamInternal(_arg0);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ITagRemovedCallback _arg2 = ITagRemovedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.ignore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    Tag _arg0 = data.readTypedObject(Tag.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatch(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    IAppCallback _arg1 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setReaderMode(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setP2pModes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addNfcUnlockHandler(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeNfcUnlockHandler(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    this.verifyNfcPermission();
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    boolean _result = this.isNfcSecureEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    boolean _result = this.deviceSupportsNfcSecure();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNfcSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setControllerAlwaysOn(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _result = this.isControllerAlwaysOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    boolean _result = this.isControllerAlwaysOnSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 31;
        }

        private static class Proxy
        implements INfcAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcTag getNfcTagInterface() throws RemoteException {
                INfcTag _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcTag.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
                INfcCardEmulation _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
                INfcFCardEmulation _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcFCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
                INfcAdapterExtras _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcAdapterExtras.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
                INfcDta _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcDta.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disable(boolean saveState) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(saveState);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNdefPush() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNdefPush() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNdefPushEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pausePolling(int timeoutInMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(timeoutInMs);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resumePolling() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedArray(filters, 0);
                    _data.writeTypedObject(techLists, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppCallback(IAppCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void invokeBeam() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invokeBeamInternal(BeamShareData shareData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(shareData, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nativeHandle);
                    _data.writeInt(debounceMs);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(Tag tag2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tag2, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setReaderMode(IBinder b, IAppCallback callback2, int flags, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(b);
                    _data.writeStrongInterface(callback2);
                    _data.writeInt(flags);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setP2pModes(int initatorModes, int targetModes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(initatorModes);
                    _data.writeInt(targetModes);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    _data.writeIntArray(techList);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyNfcPermission() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNfcSecureEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deviceSupportsNfcSecure() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNfcSecure(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setControllerAlwaysOn(boolean value2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(value2);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOnSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INfcAdapter {
        @Override
        public INfcTag getNfcTagInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean disable(boolean saveState) throws RemoteException {
            return false;
        }

        @Override
        public boolean enable() throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNdefPush() throws RemoteException {
            return false;
        }

        @Override
        public boolean disableNdefPush() throws RemoteException {
            return false;
        }

        @Override
        public boolean isNdefPushEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void pausePolling(int timeoutInMs) throws RemoteException {
        }

        @Override
        public void resumePolling() throws RemoteException {
        }

        @Override
        public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
        }

        @Override
        public void setAppCallback(IAppCallback callback2) throws RemoteException {
        }

        @Override
        public void invokeBeam() throws RemoteException {
        }

        @Override
        public void invokeBeamInternal(BeamShareData shareData) throws RemoteException {
        }

        @Override
        public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback2) throws RemoteException {
            return false;
        }

        @Override
        public void dispatch(Tag tag2) throws RemoteException {
        }

        @Override
        public void setReaderMode(IBinder b, IAppCallback callback2, int flags, Bundle extras) throws RemoteException {
        }

        @Override
        public void setP2pModes(int initatorModes, int targetModes) throws RemoteException {
        }

        @Override
        public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
        }

        @Override
        public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
        }

        @Override
        public void verifyNfcPermission() throws RemoteException {
        }

        @Override
        public boolean isNfcSecureEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean deviceSupportsNfcSecure() throws RemoteException {
            return false;
        }

        @Override
        public boolean setNfcSecure(boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public boolean setControllerAlwaysOn(boolean value2) throws RemoteException {
            return false;
        }

        @Override
        public boolean isControllerAlwaysOn() throws RemoteException {
            return false;
        }

        @Override
        public boolean isControllerAlwaysOnSupported() throws RemoteException {
            return false;
        }

        @Override
        public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener2) throws RemoteException {
        }

        @Override
        public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

