/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.INfcAdapter;
import android.nfc.INfcControllerAlwaysOnListener;
import android.nfc.NfcAdapter;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class NfcControllerAlwaysOnListener
extends INfcControllerAlwaysOnListener.Stub {
    private static final String TAG = NfcControllerAlwaysOnListener.class.getSimpleName();
    private final INfcAdapter mAdapter;
    private final Map<NfcAdapter.ControllerAlwaysOnListener, Executor> mListenerMap = new HashMap<NfcAdapter.ControllerAlwaysOnListener, Executor>();
    private boolean mCurrentState = false;
    private boolean mIsRegistered = false;

    public NfcControllerAlwaysOnListener(INfcAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Executor executor, NfcAdapter.ControllerAlwaysOnListener listener2) {
        try {
            if (!this.mAdapter.isControllerAlwaysOnSupported()) {
                return;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to register");
            return;
        }
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            if (this.mListenerMap.containsKey(listener2)) {
                return;
            }
            this.mListenerMap.put(listener2, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerControllerAlwaysOnListener(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NfcAdapter.ControllerAlwaysOnListener listener2) {
        try {
            if (!this.mAdapter.isControllerAlwaysOnSupported()) {
                return;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to unregister");
            return;
        }
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            if (!this.mListenerMap.containsKey(listener2)) {
                return;
            }
            this.mListenerMap.remove(listener2);
            if (this.mListenerMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mAdapter.unregisterControllerAlwaysOnListener(this);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister");
                }
                this.mIsRegistered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentState(NfcAdapter.ControllerAlwaysOnListener listener2) {
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            Executor executor = this.mListenerMap.get(listener2);
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> listener2.onControllerAlwaysOnChanged(this.mCurrentState));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControllerAlwaysOnChanged(boolean isEnabled) {
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            this.mCurrentState = isEnabled;
            for (NfcAdapter.ControllerAlwaysOnListener cb : this.mListenerMap.keySet()) {
                this.sendCurrentState(cb);
            }
        }
    }
}

