/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class NfcF
extends BasicTagTechnology {
    private static final String TAG = "NFC";
    public static final String EXTRA_SC = "systemcode";
    public static final String EXTRA_PMM = "pmm";
    private byte[] mSystemCode = null;
    private byte[] mManufacturer = null;

    public static NfcF get(Tag tag2) {
        if (!tag2.hasTech(4)) {
            return null;
        }
        try {
            return new NfcF(tag2);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NfcF(Tag tag2) throws RemoteException {
        super(tag2, 4);
        Bundle extras = tag2.getTechExtras(4);
        if (extras != null) {
            this.mSystemCode = extras.getByteArray(EXTRA_SC);
            this.mManufacturer = extras.getByteArray(EXTRA_PMM);
        }
    }

    public byte[] getSystemCode() {
        return this.mSystemCode;
    }

    public byte[] getManufacturer() {
        return this.mManufacturer;
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public void setTimeout(int timeout) {
        try {
            int err = this.mTag.getTagService().setTimeout(4, timeout);
            if (err != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
    }

    public int getTimeout() {
        try {
            return this.mTag.getTagService().getTimeout(4);
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return 0;
        }
    }
}

