/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadTypeParcelableException;
import android.os.BaseBundle;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Bundle
extends BaseBundle
implements Cloneable,
Parcelable {
    @VisibleForTesting
    static final int FLAG_HAS_FDS = 256;
    @VisibleForTesting
    static final int FLAG_HAS_FDS_KNOWN = 512;
    @VisibleForTesting
    static final int FLAG_ALLOW_FDS = 1024;
    public static final Bundle EMPTY = new Bundle();
    public static final Bundle STRIPPED;
    public static final Parcelable.Creator<Bundle> CREATOR;

    public Bundle() {
        this.mFlags = 1536;
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData) {
        super(parcelledData);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData, int length) {
        super(parcelledData, length);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    Bundle(Bundle from, boolean deep) {
        super(from, deep);
    }

    private void maybePrefillHasFds() {
        if (this.mParcelledData != null) {
            this.mFlags = this.mParcelledData.hasFileDescriptors() ? (this.mFlags |= 0x300) : (this.mFlags |= 0x200);
        }
    }

    public Bundle(ClassLoader loader) {
        super(loader);
        this.mFlags = 1536;
    }

    public Bundle(int capacity) {
        super(capacity);
        this.mFlags = 1536;
    }

    public Bundle(Bundle b) {
        super(b);
        this.mFlags = b.mFlags;
    }

    public Bundle(PersistableBundle b) {
        super(b);
        this.mFlags = 1536;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static Bundle forPair(String key, String value2) {
        Bundle b = new Bundle(1);
        b.putString(key, value2);
        return b;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    public boolean setAllowFds(boolean allowFds) {
        boolean orig;
        boolean bl = orig = (this.mFlags & 0x400) != 0;
        this.mFlags = allowFds ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
        return orig;
    }

    public void setDefusable(boolean defusable) {
        this.mFlags = defusable ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    @UnsupportedAppUsage
    public static Bundle setDefusable(Bundle bundle, boolean defusable) {
        if (bundle != null) {
            bundle.setDefusable(defusable);
        }
        return bundle;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public Bundle deepCopy() {
        return new Bundle(this, true);
    }

    @Override
    public void clear() {
        super.clear();
        this.mFlags = 1536;
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        if ((this.mFlags & 0x100) != 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    public void putAll(Bundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mOwnsLazyValues = false;
        bundle.mOwnsLazyValues = false;
        this.mMap.putAll(bundle.mMap);
        if ((bundle.mFlags & 0x100) != 0) {
            this.mFlags |= 0x100;
        }
        if ((bundle.mFlags & 0x200) == 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getSize() {
        if (this.mParcelledData != null) {
            return this.mParcelledData.dataSize();
        }
        return 0;
    }

    public boolean hasFileDescriptors() {
        if ((this.mFlags & 0x200) == 0) {
            Parcel p = this.mParcelledData;
            this.mFlags = Parcel.hasFileDescriptors(p != null ? p : this.mMap) ? this.mFlags | 0x100 : this.mFlags & 0xFFFFFEFF;
            this.mFlags |= 0x200;
        }
        return (this.mFlags & 0x100) != 0;
    }

    @Override
    public void putObject(String key, Object value2) {
        if (value2 instanceof Byte) {
            this.putByte(key, (Byte)value2);
        } else if (value2 instanceof Character) {
            this.putChar(key, ((Character)value2).charValue());
        } else if (value2 instanceof Short) {
            this.putShort(key, (Short)value2);
        } else if (value2 instanceof Float) {
            this.putFloat(key, ((Float)value2).floatValue());
        } else if (value2 instanceof CharSequence) {
            this.putCharSequence(key, (CharSequence)value2);
        } else if (value2 instanceof Parcelable) {
            this.putParcelable(key, (Parcelable)value2);
        } else if (value2 instanceof Size) {
            this.putSize(key, (Size)value2);
        } else if (value2 instanceof SizeF) {
            this.putSizeF(key, (SizeF)value2);
        } else if (value2 instanceof Parcelable[]) {
            this.putParcelableArray(key, (Parcelable[])value2);
        } else if (value2 instanceof ArrayList) {
            this.putParcelableArrayList(key, (ArrayList)value2);
        } else if (value2 instanceof List) {
            this.putParcelableList(key, (List)value2);
        } else if (value2 instanceof SparseArray) {
            this.putSparseParcelableArray(key, (SparseArray)value2);
        } else if (value2 instanceof Serializable) {
            this.putSerializable(key, (Serializable)value2);
        } else if (value2 instanceof byte[]) {
            this.putByteArray(key, (byte[])value2);
        } else if (value2 instanceof short[]) {
            this.putShortArray(key, (short[])value2);
        } else if (value2 instanceof char[]) {
            this.putCharArray(key, (char[])value2);
        } else if (value2 instanceof float[]) {
            this.putFloatArray(key, (float[])value2);
        } else if (value2 instanceof CharSequence[]) {
            this.putCharSequenceArray(key, (CharSequence[])value2);
        } else if (value2 instanceof Bundle) {
            this.putBundle(key, (Bundle)value2);
        } else if (value2 instanceof Binder) {
            this.putBinder(key, (Binder)value2);
        } else if (value2 instanceof IBinder) {
            this.putIBinder(key, (IBinder)value2);
        } else {
            super.putObject(key, value2);
        }
    }

    @Override
    public void putByte(String key, byte value2) {
        super.putByte(key, value2);
    }

    @Override
    public void putChar(String key, char value2) {
        super.putChar(key, value2);
    }

    @Override
    public void putShort(String key, short value2) {
        super.putShort(key, value2);
    }

    @Override
    public void putFloat(String key, float value2) {
        super.putFloat(key, value2);
    }

    @Override
    public void putCharSequence(String key, CharSequence value2) {
        super.putCharSequence(key, value2);
    }

    public void putParcelable(String key, Parcelable value2) {
        this.unparcel();
        this.mMap.put(key, value2);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putSize(String key, Size value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putSizeF(String key, SizeF value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putParcelableArray(String key, Parcelable[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putParcelableArrayList(String key, ArrayList<? extends Parcelable> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
        this.mFlags &= 0xFFFFFDFF;
    }

    @UnsupportedAppUsage
    public void putParcelableList(String key, List<? extends Parcelable> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putSparseParcelableArray(String key, SparseArray<? extends Parcelable> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
        this.mFlags &= 0xFFFFFDFF;
    }

    @Override
    public void putIntegerArrayList(String key, ArrayList<Integer> value2) {
        super.putIntegerArrayList(key, value2);
    }

    @Override
    public void putStringArrayList(String key, ArrayList<String> value2) {
        super.putStringArrayList(key, value2);
    }

    @Override
    public void putCharSequenceArrayList(String key, ArrayList<CharSequence> value2) {
        super.putCharSequenceArrayList(key, value2);
    }

    @Override
    public void putSerializable(String key, Serializable value2) {
        super.putSerializable(key, value2);
    }

    @Override
    public void putByteArray(String key, byte[] value2) {
        super.putByteArray(key, value2);
    }

    @Override
    public void putShortArray(String key, short[] value2) {
        super.putShortArray(key, value2);
    }

    @Override
    public void putCharArray(String key, char[] value2) {
        super.putCharArray(key, value2);
    }

    @Override
    public void putFloatArray(String key, float[] value2) {
        super.putFloatArray(key, value2);
    }

    @Override
    public void putCharSequenceArray(String key, CharSequence[] value2) {
        super.putCharSequenceArray(key, value2);
    }

    public void putBundle(String key, Bundle value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putBinder(String key, IBinder value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void putIBinder(String key, IBinder value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    @Override
    public byte getByte(String key) {
        return super.getByte(key);
    }

    @Override
    public Byte getByte(String key, byte defaultValue) {
        return super.getByte(key, defaultValue);
    }

    @Override
    public char getChar(String key) {
        return super.getChar(key);
    }

    @Override
    public char getChar(String key, char defaultValue) {
        return super.getChar(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return super.getShort(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return super.getShort(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return super.getFloat(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return super.getFloat(key, defaultValue);
    }

    @Override
    public CharSequence getCharSequence(String key) {
        return super.getCharSequence(key);
    }

    @Override
    public CharSequence getCharSequence(String key, CharSequence defaultValue) {
        return super.getCharSequence(key, defaultValue);
    }

    public Size getSize(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (Size)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Size", e);
            return null;
        }
    }

    public SizeF getSizeF(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (SizeF)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SizeF", e);
            return null;
        }
    }

    public Bundle getBundle(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Bundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    @Deprecated
    public <T extends Parcelable> T getParcelable(String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    public <T> T getParcelable(String key, Class<T> clazz) {
        return this.get(key, clazz);
    }

    @Deprecated
    public Parcelable[] getParcelableArray(String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (Parcelable[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable[]", e);
            return null;
        }
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public <T> T[] getParcelableArray(String key, Class<T> clazz) {
        this.unparcel();
        try {
            return this.getValue(key, Parcelable[].class, Objects.requireNonNull(clazz));
        }
        catch (BadTypeParcelableException | ClassCastException e) {
            this.typeWarning(key, clazz.getCanonicalName() + "[]", e);
            return null;
        }
    }

    @Deprecated
    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    @SuppressLint(value={"NullableCollection"})
    public <T> ArrayList<T> getParcelableArrayList(String key, Class<? extends T> clazz) {
        return this.getArrayList(key, clazz);
    }

    @Deprecated
    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (SparseArray)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SparseArray", e);
            return null;
        }
    }

    public <T> SparseArray<T> getSparseParcelableArray(String key, Class<? extends T> clazz) {
        this.unparcel();
        try {
            return this.getValue(key, SparseArray.class, Objects.requireNonNull(clazz));
        }
        catch (BadTypeParcelableException | ClassCastException e) {
            this.typeWarning(key, "SparseArray<" + clazz.getCanonicalName() + ">", e);
            return null;
        }
    }

    @Override
    @Deprecated
    public Serializable getSerializable(String key) {
        return super.getSerializable(key);
    }

    @Override
    public <T extends Serializable> T getSerializable(String key, Class<T> clazz) {
        return super.getSerializable(key, Objects.requireNonNull(clazz));
    }

    @Override
    public ArrayList<Integer> getIntegerArrayList(String key) {
        return super.getIntegerArrayList(key);
    }

    @Override
    public ArrayList<String> getStringArrayList(String key) {
        return super.getStringArrayList(key);
    }

    @Override
    public ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        return super.getCharSequenceArrayList(key);
    }

    @Override
    public byte[] getByteArray(String key) {
        return super.getByteArray(key);
    }

    @Override
    public short[] getShortArray(String key) {
        return super.getShortArray(key);
    }

    @Override
    public char[] getCharArray(String key) {
        return super.getCharArray(key);
    }

    @Override
    public float[] getFloatArray(String key) {
        return super.getFloatArray(key);
    }

    @Override
    public CharSequence[] getCharSequenceArray(String key) {
        return super.getCharSequenceArray(key);
    }

    public IBinder getBinder(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public IBinder getIBinder(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Override
    public int describeContents() {
        int mask = 0;
        if (this.hasFileDescriptors()) {
            mask |= 1;
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean oldAllowFds = parcel.pushAllowFds((this.mFlags & 0x400) != 0);
        try {
            this.writeToParcelInner(parcel, flags);
        }
        finally {
            parcel.restoreAllowFds(oldAllowFds);
        }
    }

    public void readFromParcel(Parcel parcel) {
        this.readFromParcelInner(parcel);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    public synchronized String toString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "Bundle[EMPTY_PARCEL]";
            }
            return "Bundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
        return "Bundle[" + this.mMap.toString() + "]";
    }

    public synchronized String toShortString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "EMPTY_PARCEL";
            }
            return "mParcelledData.dataSize=" + this.mParcelledData.dataSize();
        }
        return this.mMap.toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                proto.write(0x10500000001L, 0);
            } else {
                proto.write(0x10500000001L, this.mParcelledData.dataSize());
            }
        } else {
            proto.write(1138166333442L, this.mMap.toString());
        }
        proto.end(token);
    }

    static {
        Bundle.EMPTY.mMap = ArrayMap.EMPTY;
        STRIPPED = new Bundle();
        STRIPPED.putInt("STRIPPED", 1);
        CREATOR = new Parcelable.Creator<Bundle>(){

            @Override
            public Bundle createFromParcel(Parcel in) {
                return in.readBundle();
            }

            public Bundle[] newArray(int size) {
                return new Bundle[size];
            }
        };
    }
}

