/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CoolingDevice
implements Parcelable {
    private final long mValue;
    private final int mType;
    private final String mName;
    public static final int TYPE_FAN = 0;
    public static final int TYPE_BATTERY = 1;
    public static final int TYPE_CPU = 2;
    public static final int TYPE_GPU = 3;
    public static final int TYPE_MODEM = 4;
    public static final int TYPE_NPU = 5;
    public static final int TYPE_COMPONENT = 6;
    public static final Parcelable.Creator<CoolingDevice> CREATOR = new Parcelable.Creator<CoolingDevice>(){

        @Override
        public CoolingDevice createFromParcel(Parcel p) {
            long value2 = p.readLong();
            int type = p.readInt();
            String name = p.readString();
            return new CoolingDevice(value2, type, name);
        }

        public CoolingDevice[] newArray(int size) {
            return new CoolingDevice[size];
        }
    };

    public static boolean isValidType(int type) {
        return type >= 0 && type <= 6;
    }

    public CoolingDevice(long value2, int type, String name) {
        Preconditions.checkArgument(CoolingDevice.isValidType(type), "Invalid Type");
        this.mValue = value2;
        this.mType = type;
        this.mName = Preconditions.checkStringNotEmpty(name);
    }

    public long getValue() {
        return this.mValue;
    }

    public int getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "CoolingDevice{mValue=" + this.mValue + ", mType=" + this.mType + ", mName=" + this.mName + "}";
    }

    public int hashCode() {
        int hash2 = this.mName.hashCode();
        hash2 = 31 * hash2 + Long.hashCode(this.mValue);
        hash2 = 31 * hash2 + this.mType;
        return hash2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CoolingDevice)) {
            return false;
        }
        CoolingDevice other = (CoolingDevice)o;
        return other.mValue == this.mValue && other.mType == this.mType && other.mName.equals(this.mName);
    }

    @Override
    public void writeToParcel(Parcel p, int flags) {
        p.writeLong(this.mValue);
        p.writeInt(this.mType);
        p.writeString(this.mName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

