/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.os.IHwInterface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

@SystemApi
public class HidlSupport {
    @SystemApi
    public static boolean deepEquals(Object lft, Object rgt) {
        Class<?> rgtClazz;
        if (lft == rgt) {
            return true;
        }
        if (lft == null || rgt == null) {
            return false;
        }
        Class<?> lftClazz = lft.getClass();
        if (lftClazz != (rgtClazz = rgt.getClass())) {
            return false;
        }
        if (lftClazz.isArray()) {
            Class<?> lftElementType = lftClazz.getComponentType();
            if (lftElementType != rgtClazz.getComponentType()) {
                return false;
            }
            if (lftElementType.isPrimitive()) {
                return Objects.deepEquals(lft, rgt);
            }
            Object[] lftArray = (Object[])lft;
            Object[] rgtArray = (Object[])rgt;
            return lftArray.length == rgtArray.length && IntStream.range(0, lftArray.length).allMatch(i -> HidlSupport.deepEquals(lftArray[i], rgtArray[i]));
        }
        if (lft instanceof List) {
            List lftList = (List)lft;
            List rgtList = (List)rgt;
            if (lftList.size() != rgtList.size()) {
                return false;
            }
            Iterator lftIter = lftList.iterator();
            return rgtList.stream().allMatch(rgtElement -> HidlSupport.deepEquals(lftIter.next(), rgtElement));
        }
        HidlSupport.throwErrorIfUnsupportedType(lft);
        return lft.equals(rgt);
    }

    @SystemApi
    public static int deepHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            Class<?> elementType = clazz.getComponentType();
            if (elementType.isPrimitive()) {
                return HidlSupport.primitiveArrayHashCode(o);
            }
            return Arrays.hashCode(Arrays.stream((Object[])o).mapToInt(element -> HidlSupport.deepHashCode(element)).toArray());
        }
        if (o instanceof List) {
            return Arrays.hashCode(((List)o).stream().mapToInt(element -> HidlSupport.deepHashCode(element)).toArray());
        }
        HidlSupport.throwErrorIfUnsupportedType(o);
        return o.hashCode();
    }

    private static void throwErrorIfUnsupportedType(Object o) {
        if (o instanceof Collection && !(o instanceof List)) {
            throw new UnsupportedOperationException("Cannot check equality on collections other than lists: " + o.getClass().getName());
        }
        if (o instanceof Map) {
            throw new UnsupportedOperationException("Cannot check equality on maps");
        }
    }

    private static int primitiveArrayHashCode(Object o) {
        Class<?> elementType = o.getClass().getComponentType();
        if (elementType == Boolean.TYPE) {
            return Arrays.hashCode((boolean[])o);
        }
        if (elementType == Byte.TYPE) {
            return Arrays.hashCode((byte[])o);
        }
        if (elementType == Character.TYPE) {
            return Arrays.hashCode((char[])o);
        }
        if (elementType == Double.TYPE) {
            return Arrays.hashCode((double[])o);
        }
        if (elementType == Float.TYPE) {
            return Arrays.hashCode((float[])o);
        }
        if (elementType == Integer.TYPE) {
            return Arrays.hashCode((int[])o);
        }
        if (elementType == Long.TYPE) {
            return Arrays.hashCode((long[])o);
        }
        if (elementType == Short.TYPE) {
            return Arrays.hashCode((short[])o);
        }
        throw new UnsupportedOperationException();
    }

    @SystemApi
    public static boolean interfacesEqual(IHwInterface lft, Object rgt) {
        if (lft == rgt) {
            return true;
        }
        if (lft == null || rgt == null) {
            return false;
        }
        if (!(rgt instanceof IHwInterface)) {
            return false;
        }
        return Objects.equals(lft.asBinder(), ((IHwInterface)rgt).asBinder());
    }

    @SystemApi
    public static int getPidIfSharable() {
        return OverrideMethod.invokeI("android.os.HidlSupport#getPidIfSharable()I", true, null);
    }

    public static class Mutable<E> {
        public E value;

        public Mutable() {
            this.value = null;
        }

        public Mutable(E value2) {
            this.value = value2;
        }
    }
}

