/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.INetworkManagementEventObserver;
import android.net.ITetheringStatsProvider;
import android.net.InterfaceConfiguration;
import android.net.NetworkStats;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INetworkManagementService
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:39:1:39:25")
    public void registerObserver(INetworkManagementEventObserver var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:45:1:45:25")
    public void unregisterObserver(INetworkManagementEventObserver var1) throws RemoteException;

    public String[] listInterfaces() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:57:1:57:25")
    public InterfaceConfiguration getInterfaceConfig(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:63:1:63:25")
    public void setInterfaceConfig(String var1, InterfaceConfiguration var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:69:1:69:69")
    public void clearInterfaceAddresses(String var1) throws RemoteException;

    public void setInterfaceDown(String var1) throws RemoteException;

    public void setInterfaceUp(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:85:1:85:69")
    public void setInterfaceIpv6PrivacyExtensions(String var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:91:1:91:69")
    public void disableIpv6(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:97:1:97:69")
    public void enableIpv6(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:104:1:104:69")
    public void setIPv6AddrGenMode(String var1, int var2) throws RemoteException;

    public void addRoute(int var1, RouteInfo var2) throws RemoteException;

    public void removeRoute(int var1, RouteInfo var2) throws RemoteException;

    public void shutdown() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:129:1:129:25")
    public boolean getIpForwardingEnabled() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:135:1:135:25")
    public void setIpForwardingEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:142:1:142:25")
    public void startTethering(String[] var1) throws RemoteException;

    public void startTetheringWithConfiguration(boolean var1, String[] var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:156:1:156:25")
    public void stopTethering() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:162:1:162:25")
    public boolean isTetheringStarted() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:168:1:168:25")
    public void tetherInterface(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:174:1:174:25")
    public void untetherInterface(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:180:1:180:25")
    public String[] listTetheredInterfaces() throws RemoteException;

    public String[] getDnsForwarders() throws RemoteException;

    public void startInterfaceForwarding(String var1, String var2) throws RemoteException;

    public void stopInterfaceForwarding(String var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:205:1:205:25")
    public void enableNat(String var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:211:1:211:25")
    public void disableNat(String var1, String var2) throws RemoteException;

    public void registerTetheringStatsProvider(ITetheringStatsProvider var1, String var2) throws RemoteException;

    public void unregisterTetheringStatsProvider(ITetheringStatsProvider var1) throws RemoteException;

    public void tetherLimitReached(ITetheringStatsProvider var1) throws RemoteException;

    public NetworkStats getNetworkStatsTethering(int var1) throws RemoteException;

    public void setInterfaceQuota(String var1, long var2) throws RemoteException;

    public void removeInterfaceQuota(String var1) throws RemoteException;

    public void setInterfaceAlert(String var1, long var2) throws RemoteException;

    public void removeInterfaceAlert(String var1) throws RemoteException;

    public void setGlobalAlert(long var1) throws RemoteException;

    public void setUidOnMeteredNetworkDenylist(int var1, boolean var2) throws RemoteException;

    public void setUidOnMeteredNetworkAllowlist(int var1, boolean var2) throws RemoteException;

    public boolean setDataSaverModeEnabled(boolean var1) throws RemoteException;

    public void setUidCleartextNetworkPolicy(int var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/INetworkManagementService.aidl:287:1:287:69")
    public boolean isBandwidthControlEnabled() throws RemoteException;

    public void setFirewallEnabled(boolean var1) throws RemoteException;

    public boolean isFirewallEnabled() throws RemoteException;

    public void setFirewallInterfaceRule(String var1, boolean var2) throws RemoteException;

    public void setFirewallUidRule(int var1, int var2, int var3) throws RemoteException;

    public void setFirewallUidRules(int var1, int[] var2, int[] var3) throws RemoteException;

    public void setFirewallChainEnabled(int var1, boolean var2) throws RemoteException;

    public void allowProtect(int var1) throws RemoteException;

    public void denyProtect(int var1) throws RemoteException;

    public void addInterfaceToLocalNetwork(String var1, List<RouteInfo> var2) throws RemoteException;

    public void removeInterfaceFromLocalNetwork(String var1) throws RemoteException;

    public int removeRoutesFromLocalNetwork(List<RouteInfo> var1) throws RemoteException;

    public boolean isNetworkRestricted(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkManagementService {
        public static final String DESCRIPTOR = "android.os.INetworkManagementService";
        static final int TRANSACTION_registerObserver = 1;
        static final int TRANSACTION_unregisterObserver = 2;
        static final int TRANSACTION_listInterfaces = 3;
        static final int TRANSACTION_getInterfaceConfig = 4;
        static final int TRANSACTION_setInterfaceConfig = 5;
        static final int TRANSACTION_clearInterfaceAddresses = 6;
        static final int TRANSACTION_setInterfaceDown = 7;
        static final int TRANSACTION_setInterfaceUp = 8;
        static final int TRANSACTION_setInterfaceIpv6PrivacyExtensions = 9;
        static final int TRANSACTION_disableIpv6 = 10;
        static final int TRANSACTION_enableIpv6 = 11;
        static final int TRANSACTION_setIPv6AddrGenMode = 12;
        static final int TRANSACTION_addRoute = 13;
        static final int TRANSACTION_removeRoute = 14;
        static final int TRANSACTION_shutdown = 15;
        static final int TRANSACTION_getIpForwardingEnabled = 16;
        static final int TRANSACTION_setIpForwardingEnabled = 17;
        static final int TRANSACTION_startTethering = 18;
        static final int TRANSACTION_startTetheringWithConfiguration = 19;
        static final int TRANSACTION_stopTethering = 20;
        static final int TRANSACTION_isTetheringStarted = 21;
        static final int TRANSACTION_tetherInterface = 22;
        static final int TRANSACTION_untetherInterface = 23;
        static final int TRANSACTION_listTetheredInterfaces = 24;
        static final int TRANSACTION_getDnsForwarders = 25;
        static final int TRANSACTION_startInterfaceForwarding = 26;
        static final int TRANSACTION_stopInterfaceForwarding = 27;
        static final int TRANSACTION_enableNat = 28;
        static final int TRANSACTION_disableNat = 29;
        static final int TRANSACTION_registerTetheringStatsProvider = 30;
        static final int TRANSACTION_unregisterTetheringStatsProvider = 31;
        static final int TRANSACTION_tetherLimitReached = 32;
        static final int TRANSACTION_getNetworkStatsTethering = 33;
        static final int TRANSACTION_setInterfaceQuota = 34;
        static final int TRANSACTION_removeInterfaceQuota = 35;
        static final int TRANSACTION_setInterfaceAlert = 36;
        static final int TRANSACTION_removeInterfaceAlert = 37;
        static final int TRANSACTION_setGlobalAlert = 38;
        static final int TRANSACTION_setUidOnMeteredNetworkDenylist = 39;
        static final int TRANSACTION_setUidOnMeteredNetworkAllowlist = 40;
        static final int TRANSACTION_setDataSaverModeEnabled = 41;
        static final int TRANSACTION_setUidCleartextNetworkPolicy = 42;
        static final int TRANSACTION_isBandwidthControlEnabled = 43;
        static final int TRANSACTION_setFirewallEnabled = 44;
        static final int TRANSACTION_isFirewallEnabled = 45;
        static final int TRANSACTION_setFirewallInterfaceRule = 46;
        static final int TRANSACTION_setFirewallUidRule = 47;
        static final int TRANSACTION_setFirewallUidRules = 48;
        static final int TRANSACTION_setFirewallChainEnabled = 49;
        static final int TRANSACTION_allowProtect = 50;
        static final int TRANSACTION_denyProtect = 51;
        static final int TRANSACTION_addInterfaceToLocalNetwork = 52;
        static final int TRANSACTION_removeInterfaceFromLocalNetwork = 53;
        static final int TRANSACTION_removeRoutesFromLocalNetwork = 54;
        static final int TRANSACTION_isNetworkRestricted = 55;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkManagementService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkManagementService) {
                return (INetworkManagementService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerObserver";
                }
                case 2: {
                    return "unregisterObserver";
                }
                case 3: {
                    return "listInterfaces";
                }
                case 4: {
                    return "getInterfaceConfig";
                }
                case 5: {
                    return "setInterfaceConfig";
                }
                case 6: {
                    return "clearInterfaceAddresses";
                }
                case 7: {
                    return "setInterfaceDown";
                }
                case 8: {
                    return "setInterfaceUp";
                }
                case 9: {
                    return "setInterfaceIpv6PrivacyExtensions";
                }
                case 10: {
                    return "disableIpv6";
                }
                case 11: {
                    return "enableIpv6";
                }
                case 12: {
                    return "setIPv6AddrGenMode";
                }
                case 13: {
                    return "addRoute";
                }
                case 14: {
                    return "removeRoute";
                }
                case 15: {
                    return "shutdown";
                }
                case 16: {
                    return "getIpForwardingEnabled";
                }
                case 17: {
                    return "setIpForwardingEnabled";
                }
                case 18: {
                    return "startTethering";
                }
                case 19: {
                    return "startTetheringWithConfiguration";
                }
                case 20: {
                    return "stopTethering";
                }
                case 21: {
                    return "isTetheringStarted";
                }
                case 22: {
                    return "tetherInterface";
                }
                case 23: {
                    return "untetherInterface";
                }
                case 24: {
                    return "listTetheredInterfaces";
                }
                case 25: {
                    return "getDnsForwarders";
                }
                case 26: {
                    return "startInterfaceForwarding";
                }
                case 27: {
                    return "stopInterfaceForwarding";
                }
                case 28: {
                    return "enableNat";
                }
                case 29: {
                    return "disableNat";
                }
                case 30: {
                    return "registerTetheringStatsProvider";
                }
                case 31: {
                    return "unregisterTetheringStatsProvider";
                }
                case 32: {
                    return "tetherLimitReached";
                }
                case 33: {
                    return "getNetworkStatsTethering";
                }
                case 34: {
                    return "setInterfaceQuota";
                }
                case 35: {
                    return "removeInterfaceQuota";
                }
                case 36: {
                    return "setInterfaceAlert";
                }
                case 37: {
                    return "removeInterfaceAlert";
                }
                case 38: {
                    return "setGlobalAlert";
                }
                case 39: {
                    return "setUidOnMeteredNetworkDenylist";
                }
                case 40: {
                    return "setUidOnMeteredNetworkAllowlist";
                }
                case 41: {
                    return "setDataSaverModeEnabled";
                }
                case 42: {
                    return "setUidCleartextNetworkPolicy";
                }
                case 43: {
                    return "isBandwidthControlEnabled";
                }
                case 44: {
                    return "setFirewallEnabled";
                }
                case 45: {
                    return "isFirewallEnabled";
                }
                case 46: {
                    return "setFirewallInterfaceRule";
                }
                case 47: {
                    return "setFirewallUidRule";
                }
                case 48: {
                    return "setFirewallUidRules";
                }
                case 49: {
                    return "setFirewallChainEnabled";
                }
                case 50: {
                    return "allowProtect";
                }
                case 51: {
                    return "denyProtect";
                }
                case 52: {
                    return "addInterfaceToLocalNetwork";
                }
                case 53: {
                    return "removeInterfaceFromLocalNetwork";
                }
                case 54: {
                    return "removeRoutesFromLocalNetwork";
                }
                case 55: {
                    return "isNetworkRestricted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INetworkManagementEventObserver _arg0 = INetworkManagementEventObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    INetworkManagementEventObserver _arg0 = INetworkManagementEventObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String[] _result = this.listInterfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    InterfaceConfiguration _result = this.getInterfaceConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    InterfaceConfiguration _arg1 = data.readTypedObject(InterfaceConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInterfaceConfig(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearInterfaceAddresses(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setInterfaceDown(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setInterfaceUp(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInterfaceIpv6PrivacyExtensions(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableIpv6(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.enableIpv6(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setIPv6AddrGenMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    RouteInfo _arg1 = data.readTypedObject(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.addRoute(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    RouteInfo _arg1 = data.readTypedObject(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeRoute(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    this.shutdown();
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _result = this.getIpForwardingEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIpForwardingEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String[] _arg0 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.startTethering(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.startTetheringWithConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    this.stopTethering();
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    boolean _result = this.isTetheringStarted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.tetherInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.untetherInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String[] _result = this.listTetheredInterfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 25: {
                    String[] _result = this.getDnsForwarders();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.startInterfaceForwarding(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.stopInterfaceForwarding(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.enableNat(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableNat(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    ITetheringStatsProvider _arg0 = ITetheringStatsProvider.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerTetheringStatsProvider(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    ITetheringStatsProvider _arg0 = ITetheringStatsProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterTetheringStatsProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    ITetheringStatsProvider _arg0 = ITetheringStatsProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.tetherLimitReached(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getNetworkStatsTethering(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setInterfaceQuota(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeInterfaceQuota(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setInterfaceAlert(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeInterfaceAlert(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setGlobalAlert(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setUidOnMeteredNetworkDenylist(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setUidOnMeteredNetworkAllowlist(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDataSaverModeEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setUidCleartextNetworkPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    boolean _result = this.isBandwidthControlEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 44: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setFirewallEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    boolean _result = this.isFirewallEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setFirewallInterfaceRule(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFirewallUidRule(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setFirewallUidRules(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setFirewallChainEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.allowProtect(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.denyProtect(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    String _arg0 = data.readString();
                    ArrayList<RouteInfo> _arg1 = data.createTypedArrayList(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.addInterfaceToLocalNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeInterfaceFromLocalNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    ArrayList<RouteInfo> _arg0 = data.createTypedArrayList(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeRoutesFromLocalNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isNetworkRestricted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 54;
        }

        private static class Proxy
        implements INetworkManagementService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerObserver(INetworkManagementEventObserver obs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(obs);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterObserver(INetworkManagementEventObserver obs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(obs);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listInterfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InterfaceConfiguration getInterfaceConfig(String iface) throws RemoteException {
                InterfaceConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InterfaceConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(cfg, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearInterfaceAddresses(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceDown(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceUp(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableIpv6(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableIpv6(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIPv6AddrGenMode(String iface, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRoute(int netId, RouteInfo route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRoute(int netId, RouteInfo route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getIpForwardingEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIpForwardingEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTethering(String[] dhcpRanges) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(dhcpRanges);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTetheringWithConfiguration(boolean usingLegacyDnsProxy, String[] dhcpRanges) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(usingLegacyDnsProxy);
                    _data.writeStringArray(dhcpRanges);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTethering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTetheringStarted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tetherInterface(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void untetherInterface(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listTetheredInterfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getDnsForwarders() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInterfaceForwarding(String fromIface, String toIface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fromIface);
                    _data.writeString(toIface);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopInterfaceForwarding(String fromIface, String toIface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fromIface);
                    _data.writeString(toIface);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableNat(String internalInterface, String externalInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(internalInterface);
                    _data.writeString(externalInterface);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableNat(String internalInterface, String externalInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(internalInterface);
                    _data.writeString(externalInterface);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTetheringStatsProvider(ITetheringStatsProvider provider2, String name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider2);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTetheringStatsProvider(ITetheringStatsProvider provider2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider2);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tetherLimitReached(ITetheringStatsProvider provider2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider2);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getNetworkStatsTethering(int how) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(how);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceQuota(String iface, long quotaBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(quotaBytes);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeInterfaceQuota(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterfaceAlert(String iface, long alertBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(alertBytes);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeInterfaceAlert(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGlobalAlert(long alertBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(alertBytes);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidOnMeteredNetworkDenylist(int uid, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidOnMeteredNetworkAllowlist(int uid, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDataSaverModeEnabled(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidCleartextNetworkPolicy(int uid, int policy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBandwidthControlEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirewallEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFirewallEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirewallInterfaceRule(String iface, boolean allow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeBoolean(allow);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirewallUidRule(int chain, int uid, int rule) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(chain);
                    _data.writeInt(uid);
                    _data.writeInt(rule);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirewallUidRules(int chain, int[] uids, int[] rules) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(chain);
                    _data.writeIntArray(uids);
                    _data.writeIntArray(rules);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirewallChainEnabled(int chain, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(chain);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowProtect(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void denyProtect(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addInterfaceToLocalNetwork(String iface, List<RouteInfo> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeInterfaceFromLocalNetwork(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeRoutesFromLocalNetwork(List<RouteInfo> routes) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNetworkRestricted(int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INetworkManagementService {
        @Override
        public void registerObserver(INetworkManagementEventObserver obs) throws RemoteException {
        }

        @Override
        public void unregisterObserver(INetworkManagementEventObserver obs) throws RemoteException {
        }

        @Override
        public String[] listInterfaces() throws RemoteException {
            return null;
        }

        @Override
        public InterfaceConfiguration getInterfaceConfig(String iface) throws RemoteException {
            return null;
        }

        @Override
        public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) throws RemoteException {
        }

        @Override
        public void clearInterfaceAddresses(String iface) throws RemoteException {
        }

        @Override
        public void setInterfaceDown(String iface) throws RemoteException {
        }

        @Override
        public void setInterfaceUp(String iface) throws RemoteException {
        }

        @Override
        public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) throws RemoteException {
        }

        @Override
        public void disableIpv6(String iface) throws RemoteException {
        }

        @Override
        public void enableIpv6(String iface) throws RemoteException {
        }

        @Override
        public void setIPv6AddrGenMode(String iface, int mode) throws RemoteException {
        }

        @Override
        public void addRoute(int netId, RouteInfo route) throws RemoteException {
        }

        @Override
        public void removeRoute(int netId, RouteInfo route) throws RemoteException {
        }

        @Override
        public void shutdown() throws RemoteException {
        }

        @Override
        public boolean getIpForwardingEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setIpForwardingEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void startTethering(String[] dhcpRanges) throws RemoteException {
        }

        @Override
        public void startTetheringWithConfiguration(boolean usingLegacyDnsProxy, String[] dhcpRanges) throws RemoteException {
        }

        @Override
        public void stopTethering() throws RemoteException {
        }

        @Override
        public boolean isTetheringStarted() throws RemoteException {
            return false;
        }

        @Override
        public void tetherInterface(String iface) throws RemoteException {
        }

        @Override
        public void untetherInterface(String iface) throws RemoteException {
        }

        @Override
        public String[] listTetheredInterfaces() throws RemoteException {
            return null;
        }

        @Override
        public String[] getDnsForwarders() throws RemoteException {
            return null;
        }

        @Override
        public void startInterfaceForwarding(String fromIface, String toIface) throws RemoteException {
        }

        @Override
        public void stopInterfaceForwarding(String fromIface, String toIface) throws RemoteException {
        }

        @Override
        public void enableNat(String internalInterface, String externalInterface) throws RemoteException {
        }

        @Override
        public void disableNat(String internalInterface, String externalInterface) throws RemoteException {
        }

        @Override
        public void registerTetheringStatsProvider(ITetheringStatsProvider provider2, String name) throws RemoteException {
        }

        @Override
        public void unregisterTetheringStatsProvider(ITetheringStatsProvider provider2) throws RemoteException {
        }

        @Override
        public void tetherLimitReached(ITetheringStatsProvider provider2) throws RemoteException {
        }

        @Override
        public NetworkStats getNetworkStatsTethering(int how) throws RemoteException {
            return null;
        }

        @Override
        public void setInterfaceQuota(String iface, long quotaBytes) throws RemoteException {
        }

        @Override
        public void removeInterfaceQuota(String iface) throws RemoteException {
        }

        @Override
        public void setInterfaceAlert(String iface, long alertBytes) throws RemoteException {
        }

        @Override
        public void removeInterfaceAlert(String iface) throws RemoteException {
        }

        @Override
        public void setGlobalAlert(long alertBytes) throws RemoteException {
        }

        @Override
        public void setUidOnMeteredNetworkDenylist(int uid, boolean enable) throws RemoteException {
        }

        @Override
        public void setUidOnMeteredNetworkAllowlist(int uid, boolean enable) throws RemoteException {
        }

        @Override
        public boolean setDataSaverModeEnabled(boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public void setUidCleartextNetworkPolicy(int uid, int policy) throws RemoteException {
        }

        @Override
        public boolean isBandwidthControlEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setFirewallEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isFirewallEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setFirewallInterfaceRule(String iface, boolean allow) throws RemoteException {
        }

        @Override
        public void setFirewallUidRule(int chain, int uid, int rule) throws RemoteException {
        }

        @Override
        public void setFirewallUidRules(int chain, int[] uids, int[] rules) throws RemoteException {
        }

        @Override
        public void setFirewallChainEnabled(int chain, boolean enable) throws RemoteException {
        }

        @Override
        public void allowProtect(int uid) throws RemoteException {
        }

        @Override
        public void denyProtect(int uid) throws RemoteException {
        }

        @Override
        public void addInterfaceToLocalNetwork(String iface, List<RouteInfo> routes) throws RemoteException {
        }

        @Override
        public void removeInterfaceFromLocalNetwork(String iface) throws RemoteException {
        }

        @Override
        public int removeRoutesFromLocalNetwork(List<RouteInfo> routes) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isNetworkRestricted(int uid) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

