/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.StatsDimensionsValueParcel;

public interface IPendingIntentRef
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IPendingIntentRef";

    public void sendDataBroadcast(long var1) throws RemoteException;

    public void sendActiveConfigsChangedBroadcast(long[] var1) throws RemoteException;

    public void sendSubscriberBroadcast(long var1, long var3, long var5, long var7, String[] var9, StatsDimensionsValueParcel var10) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPendingIntentRef {
        static final int TRANSACTION_sendDataBroadcast = 1;
        static final int TRANSACTION_sendActiveConfigsChangedBroadcast = 2;
        static final int TRANSACTION_sendSubscriberBroadcast = 3;

        public Stub() {
            this.attachInterface(this, IPendingIntentRef.DESCRIPTOR);
        }

        public static IPendingIntentRef asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPendingIntentRef.DESCRIPTOR);
            if (iin != null && iin instanceof IPendingIntentRef) {
                return (IPendingIntentRef)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPendingIntentRef.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    this.sendDataBroadcast(_arg0);
                    break;
                }
                case 2: {
                    long[] _arg0 = data.createLongArray();
                    this.sendActiveConfigsChangedBroadcast(_arg0);
                    break;
                }
                case 3: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    String[] _arg4 = data.createStringArray();
                    StatsDimensionsValueParcel _arg5 = data.readTypedObject(StatsDimensionsValueParcel.CREATOR);
                    this.sendSubscriberBroadcast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IPendingIntentRef {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPendingIntentRef.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDataBroadcast(long lastReportTimeNs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPendingIntentRef.DESCRIPTOR);
                    _data.writeLong(lastReportTimeNs);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendActiveConfigsChangedBroadcast(long[] configIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPendingIntentRef.DESCRIPTOR);
                    _data.writeLongArray(configIds);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSubscriberBroadcast(long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValueParcel dimensionsValueParcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPendingIntentRef.DESCRIPTOR);
                    _data.writeLong(configUid);
                    _data.writeLong(configId);
                    _data.writeLong(subscriptionId);
                    _data.writeLong(subscriptionRuleId);
                    _data.writeStringArray(cookies);
                    _data.writeTypedObject(dimensionsValueParcel, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPendingIntentRef {
        @Override
        public void sendDataBroadcast(long lastReportTimeNs) throws RemoteException {
        }

        @Override
        public void sendActiveConfigsChangedBroadcast(long[] configIds) throws RemoteException {
        }

        @Override
        public void sendSubscriberBroadcast(long configUid, long configId, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValueParcel dimensionsValueParcel) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

