/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.BatterySaverPolicyConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IWakeLockCallback;
import android.os.Parcel;
import android.os.ParcelDuration;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.WorkSource;

public interface IPowerManager
extends IInterface {
    public static final int LOCATION_MODE_NO_CHANGE = 0;
    public static final int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1;
    public static final int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2;
    public static final int LOCATION_MODE_FOREGROUND_ONLY = 3;
    public static final int LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 4;
    public static final int MIN_LOCATION_MODE = 0;
    public static final int MAX_LOCATION_MODE = 4;
    public static final int GO_TO_SLEEP_REASON_MIN = 0;
    public static final int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static final int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static final int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static final int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static final int GO_TO_SLEEP_REASON_HDMI = 5;
    public static final int GO_TO_SLEEP_REASON_SLEEP_BUTTON = 6;
    public static final int GO_TO_SLEEP_REASON_ACCESSIBILITY = 7;
    public static final int GO_TO_SLEEP_REASON_FORCE_SUSPEND = 8;
    public static final int GO_TO_SLEEP_REASON_INATTENTIVE = 9;
    public static final int GO_TO_SLEEP_REASON_QUIESCENT = 10;
    public static final int GO_TO_SLEEP_REASON_MAX = 10;
    public static final int GO_TO_SLEEP_FLAG_NO_DOZE = 1;

    public void acquireWakeLock(IBinder var1, int var2, String var3, String var4, WorkSource var5, String var6, int var7, IWakeLockCallback var8) throws RemoteException;

    public void acquireWakeLockWithUid(IBinder var1, int var2, String var3, String var4, int var5, int var6, IWakeLockCallback var7) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:34:1:34:25")
    public void releaseWakeLock(IBinder var1, int var2) throws RemoteException;

    public void updateWakeLockUids(IBinder var1, int[] var2) throws RemoteException;

    public void setPowerBoost(int var1, int var2) throws RemoteException;

    public void setPowerMode(int var1, boolean var2) throws RemoteException;

    public boolean setPowerModeChecked(int var1, boolean var2) throws RemoteException;

    public void updateWakeLockWorkSource(IBinder var1, WorkSource var2, String var3) throws RemoteException;

    public void updateWakeLockCallback(IBinder var1, IWakeLockCallback var2) throws RemoteException;

    public boolean isWakeLockLevelSupported(int var1) throws RemoteException;

    public void userActivity(int var1, long var2, int var4, int var5) throws RemoteException;

    public void wakeUp(long var1, int var3, String var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:49:1:49:69")
    public void goToSleep(long var1, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:51:1:51:44")
    public void nap(long var1) throws RemoteException;

    public float getBrightnessConstraint(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:54:1:54:25")
    public boolean isInteractive() throws RemoteException;

    public boolean isPowerSaveMode() throws RemoteException;

    public PowerSaveState getPowerSaveState(int var1) throws RemoteException;

    public boolean setPowerSaveModeEnabled(boolean var1) throws RemoteException;

    public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException;

    public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig var1) throws RemoteException;

    public boolean setDynamicPowerSaveHint(boolean var1, int var2) throws RemoteException;

    public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig var1) throws RemoteException;

    public boolean setAdaptivePowerSaveEnabled(boolean var1) throws RemoteException;

    public int getPowerSaveModeTrigger() throws RemoteException;

    public void setBatteryDischargePrediction(ParcelDuration var1, boolean var2) throws RemoteException;

    public ParcelDuration getBatteryDischargePrediction() throws RemoteException;

    public boolean isBatteryDischargePredictionPersonalized() throws RemoteException;

    public boolean isDeviceIdleMode() throws RemoteException;

    public boolean isLightDeviceIdleMode() throws RemoteException;

    public boolean isLowPowerStandbySupported() throws RemoteException;

    public boolean isLowPowerStandbyEnabled() throws RemoteException;

    public void setLowPowerStandbyEnabled(boolean var1) throws RemoteException;

    public void setLowPowerStandbyActiveDuringMaintenance(boolean var1) throws RemoteException;

    public void forceLowPowerStandbyActive(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:76:1:76:25")
    public void reboot(boolean var1, String var2, boolean var3) throws RemoteException;

    public void rebootSafeMode(boolean var1, boolean var2) throws RemoteException;

    public void shutdown(boolean var1, String var2, boolean var3) throws RemoteException;

    public void crash(String var1) throws RemoteException;

    public int getLastShutdownReason() throws RemoteException;

    public int getLastSleepReason() throws RemoteException;

    public void setStayOnSetting(int var1) throws RemoteException;

    public void boostScreenBrightness(long var1) throws RemoteException;

    public void acquireWakeLockAsync(IBinder var1, int var2, String var3, String var4, WorkSource var5, String var6) throws RemoteException;

    public void releaseWakeLockAsync(IBinder var1, int var2) throws RemoteException;

    public void updateWakeLockUidsAsync(IBinder var1, int[] var2) throws RemoteException;

    public boolean isScreenBrightnessBoosted() throws RemoteException;

    public void setAttentionLight(boolean var1, int var2) throws RemoteException;

    public void setDozeAfterScreenOff(boolean var1) throws RemoteException;

    public boolean isAmbientDisplayAvailable() throws RemoteException;

    public void suppressAmbientDisplay(String var1, boolean var2) throws RemoteException;

    public boolean isAmbientDisplaySuppressedForToken(String var1) throws RemoteException;

    public boolean isAmbientDisplaySuppressed() throws RemoteException;

    public boolean isAmbientDisplaySuppressedForTokenByApp(String var1, int var2) throws RemoteException;

    public boolean forceSuspend() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPowerManager {
        public static final String DESCRIPTOR = "android.os.IPowerManager";
        static final int TRANSACTION_acquireWakeLock = 1;
        static final int TRANSACTION_acquireWakeLockWithUid = 2;
        static final int TRANSACTION_releaseWakeLock = 3;
        static final int TRANSACTION_updateWakeLockUids = 4;
        static final int TRANSACTION_setPowerBoost = 5;
        static final int TRANSACTION_setPowerMode = 6;
        static final int TRANSACTION_setPowerModeChecked = 7;
        static final int TRANSACTION_updateWakeLockWorkSource = 8;
        static final int TRANSACTION_updateWakeLockCallback = 9;
        static final int TRANSACTION_isWakeLockLevelSupported = 10;
        static final int TRANSACTION_userActivity = 11;
        static final int TRANSACTION_wakeUp = 12;
        static final int TRANSACTION_goToSleep = 13;
        static final int TRANSACTION_nap = 14;
        static final int TRANSACTION_getBrightnessConstraint = 15;
        static final int TRANSACTION_isInteractive = 16;
        static final int TRANSACTION_isPowerSaveMode = 17;
        static final int TRANSACTION_getPowerSaveState = 18;
        static final int TRANSACTION_setPowerSaveModeEnabled = 19;
        static final int TRANSACTION_getFullPowerSavePolicy = 20;
        static final int TRANSACTION_setFullPowerSavePolicy = 21;
        static final int TRANSACTION_setDynamicPowerSaveHint = 22;
        static final int TRANSACTION_setAdaptivePowerSavePolicy = 23;
        static final int TRANSACTION_setAdaptivePowerSaveEnabled = 24;
        static final int TRANSACTION_getPowerSaveModeTrigger = 25;
        static final int TRANSACTION_setBatteryDischargePrediction = 26;
        static final int TRANSACTION_getBatteryDischargePrediction = 27;
        static final int TRANSACTION_isBatteryDischargePredictionPersonalized = 28;
        static final int TRANSACTION_isDeviceIdleMode = 29;
        static final int TRANSACTION_isLightDeviceIdleMode = 30;
        static final int TRANSACTION_isLowPowerStandbySupported = 31;
        static final int TRANSACTION_isLowPowerStandbyEnabled = 32;
        static final int TRANSACTION_setLowPowerStandbyEnabled = 33;
        static final int TRANSACTION_setLowPowerStandbyActiveDuringMaintenance = 34;
        static final int TRANSACTION_forceLowPowerStandbyActive = 35;
        static final int TRANSACTION_reboot = 36;
        static final int TRANSACTION_rebootSafeMode = 37;
        static final int TRANSACTION_shutdown = 38;
        static final int TRANSACTION_crash = 39;
        static final int TRANSACTION_getLastShutdownReason = 40;
        static final int TRANSACTION_getLastSleepReason = 41;
        static final int TRANSACTION_setStayOnSetting = 42;
        static final int TRANSACTION_boostScreenBrightness = 43;
        static final int TRANSACTION_acquireWakeLockAsync = 44;
        static final int TRANSACTION_releaseWakeLockAsync = 45;
        static final int TRANSACTION_updateWakeLockUidsAsync = 46;
        static final int TRANSACTION_isScreenBrightnessBoosted = 47;
        static final int TRANSACTION_setAttentionLight = 48;
        static final int TRANSACTION_setDozeAfterScreenOff = 49;
        static final int TRANSACTION_isAmbientDisplayAvailable = 50;
        static final int TRANSACTION_suppressAmbientDisplay = 51;
        static final int TRANSACTION_isAmbientDisplaySuppressedForToken = 52;
        static final int TRANSACTION_isAmbientDisplaySuppressed = 53;
        static final int TRANSACTION_isAmbientDisplaySuppressedForTokenByApp = 54;
        static final int TRANSACTION_forceSuspend = 55;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPowerManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPowerManager) {
                return (IPowerManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "acquireWakeLock";
                }
                case 2: {
                    return "acquireWakeLockWithUid";
                }
                case 3: {
                    return "releaseWakeLock";
                }
                case 4: {
                    return "updateWakeLockUids";
                }
                case 5: {
                    return "setPowerBoost";
                }
                case 6: {
                    return "setPowerMode";
                }
                case 7: {
                    return "setPowerModeChecked";
                }
                case 8: {
                    return "updateWakeLockWorkSource";
                }
                case 9: {
                    return "updateWakeLockCallback";
                }
                case 10: {
                    return "isWakeLockLevelSupported";
                }
                case 11: {
                    return "userActivity";
                }
                case 12: {
                    return "wakeUp";
                }
                case 13: {
                    return "goToSleep";
                }
                case 14: {
                    return "nap";
                }
                case 15: {
                    return "getBrightnessConstraint";
                }
                case 16: {
                    return "isInteractive";
                }
                case 17: {
                    return "isPowerSaveMode";
                }
                case 18: {
                    return "getPowerSaveState";
                }
                case 19: {
                    return "setPowerSaveModeEnabled";
                }
                case 20: {
                    return "getFullPowerSavePolicy";
                }
                case 21: {
                    return "setFullPowerSavePolicy";
                }
                case 22: {
                    return "setDynamicPowerSaveHint";
                }
                case 23: {
                    return "setAdaptivePowerSavePolicy";
                }
                case 24: {
                    return "setAdaptivePowerSaveEnabled";
                }
                case 25: {
                    return "getPowerSaveModeTrigger";
                }
                case 26: {
                    return "setBatteryDischargePrediction";
                }
                case 27: {
                    return "getBatteryDischargePrediction";
                }
                case 28: {
                    return "isBatteryDischargePredictionPersonalized";
                }
                case 29: {
                    return "isDeviceIdleMode";
                }
                case 30: {
                    return "isLightDeviceIdleMode";
                }
                case 31: {
                    return "isLowPowerStandbySupported";
                }
                case 32: {
                    return "isLowPowerStandbyEnabled";
                }
                case 33: {
                    return "setLowPowerStandbyEnabled";
                }
                case 34: {
                    return "setLowPowerStandbyActiveDuringMaintenance";
                }
                case 35: {
                    return "forceLowPowerStandbyActive";
                }
                case 36: {
                    return "reboot";
                }
                case 37: {
                    return "rebootSafeMode";
                }
                case 38: {
                    return "shutdown";
                }
                case 39: {
                    return "crash";
                }
                case 40: {
                    return "getLastShutdownReason";
                }
                case 41: {
                    return "getLastSleepReason";
                }
                case 42: {
                    return "setStayOnSetting";
                }
                case 43: {
                    return "boostScreenBrightness";
                }
                case 44: {
                    return "acquireWakeLockAsync";
                }
                case 45: {
                    return "releaseWakeLockAsync";
                }
                case 46: {
                    return "updateWakeLockUidsAsync";
                }
                case 47: {
                    return "isScreenBrightnessBoosted";
                }
                case 48: {
                    return "setAttentionLight";
                }
                case 49: {
                    return "setDozeAfterScreenOff";
                }
                case 50: {
                    return "isAmbientDisplayAvailable";
                }
                case 51: {
                    return "suppressAmbientDisplay";
                }
                case 52: {
                    return "isAmbientDisplaySuppressedForToken";
                }
                case 53: {
                    return "isAmbientDisplaySuppressed";
                }
                case 54: {
                    return "isAmbientDisplaySuppressedForTokenByApp";
                }
                case 55: {
                    return "forceSuspend";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    WorkSource _arg4 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    IWakeLockCallback _arg7 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acquireWakeLock(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    IWakeLockCallback _arg6 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acquireWakeLockWithUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseWakeLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.updateWakeLockUids(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPowerBoost(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setPowerMode(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setPowerModeChecked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateWakeLockWorkSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    IWakeLockCallback _arg1 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateWakeLockCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWakeLockLevelSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.userActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.wakeUp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.goToSleep(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.nap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getBrightnessConstraint(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 16: {
                    boolean _result = this.isInteractive();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    boolean _result = this.isPowerSaveMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    PowerSaveState _result = this.getPowerSaveState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setPowerSaveModeEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    BatterySaverPolicyConfig _result = this.getFullPowerSavePolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    BatterySaverPolicyConfig _arg0 = data.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setFullPowerSavePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDynamicPowerSaveHint(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    BatterySaverPolicyConfig _arg0 = data.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdaptivePowerSavePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdaptivePowerSaveEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    int _result = this.getPowerSaveModeTrigger();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 26: {
                    ParcelDuration _arg0 = data.readTypedObject(ParcelDuration.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBatteryDischargePrediction(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    ParcelDuration _result = this.getBatteryDischargePrediction();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 28: {
                    boolean _result = this.isBatteryDischargePredictionPersonalized();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _result = this.isDeviceIdleMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    boolean _result = this.isLightDeviceIdleMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    boolean _result = this.isLowPowerStandbySupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    boolean _result = this.isLowPowerStandbyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLowPowerStandbyEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLowPowerStandbyActiveDuringMaintenance(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceLowPowerStandbyActive(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reboot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.rebootSafeMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.shutdown(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.crash(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _result = this.getLastShutdownReason();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 41: {
                    int _result = this.getLastSleepReason();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setStayOnSetting(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.boostScreenBrightness(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    WorkSource _arg4 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.acquireWakeLockAsync(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 45: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseWakeLockAsync(_arg0, _arg1);
                    break;
                }
                case 46: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.updateWakeLockUidsAsync(_arg0, _arg1);
                    break;
                }
                case 47: {
                    boolean _result = this.isScreenBrightnessBoosted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 48: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAttentionLight(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDozeAfterScreenOff(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    boolean _result = this.isAmbientDisplayAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAmbientDisplaySuppressedForToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    boolean _result = this.isAmbientDisplaySuppressed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAmbientDisplaySuppressedForTokenByApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 55: {
                    boolean _result = this.forceSuspend();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 54;
        }

        private static class Proxy
        implements IPowerManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLock(IBinder lock, int flags, String tag2, String packageName, WorkSource ws, String historyTag, int displayId, IWakeLockCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag2);
                    _data.writeString(packageName);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLockWithUid(IBinder lock, int flags, String tag2, String packageName, int uidtoblame, int displayId, IWakeLockCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag2);
                    _data.writeString(packageName);
                    _data.writeInt(uidtoblame);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseWakeLock(IBinder lock, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockUids(IBinder lock, int[] uids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeIntArray(uids);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPowerBoost(int boost, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(boost);
                    _data.writeInt(durationMs);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPowerMode(int mode, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPowerModeChecked(int mode, boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockCallback(IBinder lock, IWakeLockCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWakeLockLevelSupported(int level) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(level);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void userActivity(int displayId, long time, int event, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(time);
                    _data.writeInt(event);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wakeUp(long time, int reason, String details, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeString(details);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void goToSleep(long time, int reason, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nap(long time) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getBrightnessConstraint(int constraint) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(constraint);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInteractive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPowerSaveMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PowerSaveState getPowerSaveState(int serviceType) throws RemoteException {
                PowerSaveState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serviceType);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PowerSaveState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPowerSaveModeEnabled(boolean mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mode);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException {
                BatterySaverPolicyConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(powerSaveHint);
                    _data.writeInt(disableThreshold);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdaptivePowerSaveEnabled(boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPowerSaveModeTrigger() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBatteryDischargePrediction(ParcelDuration timeRemaining, boolean isCustomized) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(timeRemaining, 0);
                    _data.writeBoolean(isCustomized);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelDuration getBatteryDischargePrediction() throws RemoteException {
                ParcelDuration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelDuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBatteryDischargePredictionPersonalized() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceIdleMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLightDeviceIdleMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLowPowerStandbySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLowPowerStandbyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowPowerStandbyEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(activeDuringMaintenance);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceLowPowerStandbyActive(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reboot(boolean confirm, String reason, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeString(reason);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rebootSafeMode(boolean confirm, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown(boolean confirm, String reason, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeString(reason);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void crash(String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastShutdownReason() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastSleepReason() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStayOnSetting(int val) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(val);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void boostScreenBrightness(long time) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLockAsync(IBinder lock, int flags, String tag2, String packageName, WorkSource ws, String historyTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag2);
                    _data.writeString(packageName);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    boolean bl = this.mRemote.transact(44, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseWakeLockAsync(IBinder lock, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockUidsAsync(IBinder lock, int[] uids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeIntArray(uids);
                    boolean bl = this.mRemote.transact(46, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScreenBrightnessBoosted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAttentionLight(boolean on, int color2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    _data.writeInt(color2);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDozeAfterScreenOff(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplayAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(String token, boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeBoolean(suppress);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressedForToken(String token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressedForTokenByApp(String token, int appUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeInt(appUid);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean forceSuspend() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPowerManager {
        @Override
        public void acquireWakeLock(IBinder lock, int flags, String tag2, String packageName, WorkSource ws, String historyTag, int displayId, IWakeLockCallback callback2) throws RemoteException {
        }

        @Override
        public void acquireWakeLockWithUid(IBinder lock, int flags, String tag2, String packageName, int uidtoblame, int displayId, IWakeLockCallback callback2) throws RemoteException {
        }

        @Override
        public void releaseWakeLock(IBinder lock, int flags) throws RemoteException {
        }

        @Override
        public void updateWakeLockUids(IBinder lock, int[] uids) throws RemoteException {
        }

        @Override
        public void setPowerBoost(int boost, int durationMs) throws RemoteException {
        }

        @Override
        public void setPowerMode(int mode, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setPowerModeChecked(int mode, boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) throws RemoteException {
        }

        @Override
        public void updateWakeLockCallback(IBinder lock, IWakeLockCallback callback2) throws RemoteException {
        }

        @Override
        public boolean isWakeLockLevelSupported(int level) throws RemoteException {
            return false;
        }

        @Override
        public void userActivity(int displayId, long time, int event, int flags) throws RemoteException {
        }

        @Override
        public void wakeUp(long time, int reason, String details, String opPackageName) throws RemoteException {
        }

        @Override
        public void goToSleep(long time, int reason, int flags) throws RemoteException {
        }

        @Override
        public void nap(long time) throws RemoteException {
        }

        @Override
        public float getBrightnessConstraint(int constraint) throws RemoteException {
            return 0.0f;
        }

        @Override
        public boolean isInteractive() throws RemoteException {
            return false;
        }

        @Override
        public boolean isPowerSaveMode() throws RemoteException {
            return false;
        }

        @Override
        public PowerSaveState getPowerSaveState(int serviceType) throws RemoteException {
            return null;
        }

        @Override
        public boolean setPowerSaveModeEnabled(boolean mode) throws RemoteException {
            return false;
        }

        @Override
        public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException {
            return null;
        }

        @Override
        public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
            return false;
        }

        @Override
        public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAdaptivePowerSaveEnabled(boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public int getPowerSaveModeTrigger() throws RemoteException {
            return 0;
        }

        @Override
        public void setBatteryDischargePrediction(ParcelDuration timeRemaining, boolean isCustomized) throws RemoteException {
        }

        @Override
        public ParcelDuration getBatteryDischargePrediction() throws RemoteException {
            return null;
        }

        @Override
        public boolean isBatteryDischargePredictionPersonalized() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDeviceIdleMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLightDeviceIdleMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLowPowerStandbySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLowPowerStandbyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setLowPowerStandbyEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) throws RemoteException {
        }

        @Override
        public void forceLowPowerStandbyActive(boolean active) throws RemoteException {
        }

        @Override
        public void reboot(boolean confirm, String reason, boolean wait) throws RemoteException {
        }

        @Override
        public void rebootSafeMode(boolean confirm, boolean wait) throws RemoteException {
        }

        @Override
        public void shutdown(boolean confirm, String reason, boolean wait) throws RemoteException {
        }

        @Override
        public void crash(String message) throws RemoteException {
        }

        @Override
        public int getLastShutdownReason() throws RemoteException {
            return 0;
        }

        @Override
        public int getLastSleepReason() throws RemoteException {
            return 0;
        }

        @Override
        public void setStayOnSetting(int val) throws RemoteException {
        }

        @Override
        public void boostScreenBrightness(long time) throws RemoteException {
        }

        @Override
        public void acquireWakeLockAsync(IBinder lock, int flags, String tag2, String packageName, WorkSource ws, String historyTag) throws RemoteException {
        }

        @Override
        public void releaseWakeLockAsync(IBinder lock, int flags) throws RemoteException {
        }

        @Override
        public void updateWakeLockUidsAsync(IBinder lock, int[] uids) throws RemoteException {
        }

        @Override
        public boolean isScreenBrightnessBoosted() throws RemoteException {
            return false;
        }

        @Override
        public void setAttentionLight(boolean on, int color2) throws RemoteException {
        }

        @Override
        public void setDozeAfterScreenOff(boolean on) throws RemoteException {
        }

        @Override
        public boolean isAmbientDisplayAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void suppressAmbientDisplay(String token, boolean suppress) throws RemoteException {
        }

        @Override
        public boolean isAmbientDisplaySuppressedForToken(String token) throws RemoteException {
            return false;
        }

        @Override
        public boolean isAmbientDisplaySuppressed() throws RemoteException {
            return false;
        }

        @Override
        public boolean isAmbientDisplaySuppressedForTokenByApp(String token, int appUid) throws RemoteException {
            return false;
        }

        @Override
        public boolean forceSuspend() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

