/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPendingIntentRef;
import android.os.IPullAtomCallback;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.PropertyParcel;

public interface IStatsd
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IStatsd";
    public static final int FLAG_REQUIRE_STAGING = 1;
    public static final int FLAG_ROLLBACK_ENABLED = 2;
    public static final int FLAG_REQUIRE_LOW_LATENCY_MONITOR = 4;

    public void systemRunning() throws RemoteException;

    public void bootCompleted() throws RemoteException;

    public void statsCompanionReady() throws RemoteException;

    public void informAnomalyAlarmFired() throws RemoteException;

    public void informPollAlarmFired() throws RemoteException;

    public void informAlarmForSubscriberTriggeringFired() throws RemoteException;

    public void informDeviceShutdown() throws RemoteException;

    public void informAllUidData(ParcelFileDescriptor var1) throws RemoteException;

    public void informOnePackage(String var1, int var2, long var3, String var5, String var6, byte[] var7) throws RemoteException;

    public void informOnePackageRemoved(String var1, int var2) throws RemoteException;

    public byte[] getData(long var1, int var3) throws RemoteException;

    public byte[] getMetadata() throws RemoteException;

    public void addConfiguration(long var1, byte[] var3, int var4) throws RemoteException;

    public void setDataFetchOperation(long var1, IPendingIntentRef var3, int var4) throws RemoteException;

    public void removeDataFetchOperation(long var1, int var3) throws RemoteException;

    public long[] setActiveConfigsChangedOperation(IPendingIntentRef var1, int var2) throws RemoteException;

    public void removeActiveConfigsChangedOperation(int var1) throws RemoteException;

    public void removeConfiguration(long var1, int var3) throws RemoteException;

    public void setBroadcastSubscriber(long var1, long var3, IPendingIntentRef var5, int var6) throws RemoteException;

    public void unsetBroadcastSubscriber(long var1, long var3, int var5) throws RemoteException;

    public void allPullersFromBootRegistered() throws RemoteException;

    public void registerPullAtomCallback(int var1, int var2, long var3, long var5, int[] var7, IPullAtomCallback var8) throws RemoteException;

    public void registerNativePullAtomCallback(int var1, long var2, long var4, int[] var6, IPullAtomCallback var7) throws RemoteException;

    public void unregisterPullAtomCallback(int var1, int var2) throws RemoteException;

    public void unregisterNativePullAtomCallback(int var1) throws RemoteException;

    public long[] getRegisteredExperimentIds() throws RemoteException;

    public void updateProperties(PropertyParcel[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsd {
        static final int TRANSACTION_systemRunning = 1;
        static final int TRANSACTION_bootCompleted = 2;
        static final int TRANSACTION_statsCompanionReady = 3;
        static final int TRANSACTION_informAnomalyAlarmFired = 4;
        static final int TRANSACTION_informPollAlarmFired = 5;
        static final int TRANSACTION_informAlarmForSubscriberTriggeringFired = 6;
        static final int TRANSACTION_informDeviceShutdown = 7;
        static final int TRANSACTION_informAllUidData = 8;
        static final int TRANSACTION_informOnePackage = 9;
        static final int TRANSACTION_informOnePackageRemoved = 10;
        static final int TRANSACTION_getData = 11;
        static final int TRANSACTION_getMetadata = 12;
        static final int TRANSACTION_addConfiguration = 13;
        static final int TRANSACTION_setDataFetchOperation = 14;
        static final int TRANSACTION_removeDataFetchOperation = 15;
        static final int TRANSACTION_setActiveConfigsChangedOperation = 16;
        static final int TRANSACTION_removeActiveConfigsChangedOperation = 17;
        static final int TRANSACTION_removeConfiguration = 18;
        static final int TRANSACTION_setBroadcastSubscriber = 19;
        static final int TRANSACTION_unsetBroadcastSubscriber = 20;
        static final int TRANSACTION_allPullersFromBootRegistered = 21;
        static final int TRANSACTION_registerPullAtomCallback = 22;
        static final int TRANSACTION_registerNativePullAtomCallback = 23;
        static final int TRANSACTION_unregisterPullAtomCallback = 24;
        static final int TRANSACTION_unregisterNativePullAtomCallback = 25;
        static final int TRANSACTION_getRegisteredExperimentIds = 26;
        static final int TRANSACTION_updateProperties = 27;

        public Stub() {
            this.attachInterface(this, IStatsd.DESCRIPTOR);
        }

        public static IStatsd asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStatsd.DESCRIPTOR);
            if (iin != null && iin instanceof IStatsd) {
                return (IStatsd)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStatsd.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.systemRunning();
                    break;
                }
                case 2: {
                    this.bootCompleted();
                    break;
                }
                case 3: {
                    this.statsCompanionReady();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.informAnomalyAlarmFired();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.informPollAlarmFired();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.informAlarmForSubscriberTriggeringFired();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    this.informDeviceShutdown();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    this.informAllUidData(_arg0);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    byte[] _arg5 = data.createByteArray();
                    this.informOnePackage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.informOnePackageRemoved(_arg0, _arg1);
                    break;
                }
                case 11: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    byte[] _result = this.getData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 12: {
                    byte[] _result = this.getMetadata();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 13: {
                    long _arg0 = data.readLong();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    this.addConfiguration(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    long _arg0 = data.readLong();
                    IPendingIntentRef _arg1 = IPendingIntentRef.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.setDataFetchOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    this.removeDataFetchOperation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IPendingIntentRef _arg0 = IPendingIntentRef.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    long[] _result = this.setActiveConfigsChangedOperation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    this.removeActiveConfigsChangedOperation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    this.removeConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    IPendingIntentRef _arg2 = IPendingIntentRef.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.setBroadcastSubscriber(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    this.unsetBroadcastSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    this.allPullersFromBootRegistered();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    int[] _arg4 = data.createIntArray();
                    IPullAtomCallback _arg5 = IPullAtomCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerPullAtomCallback(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    int[] _arg3 = data.createIntArray();
                    IPullAtomCallback _arg4 = IPullAtomCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerNativePullAtomCallback(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.unregisterPullAtomCallback(_arg0, _arg1);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    this.unregisterNativePullAtomCallback(_arg0);
                    break;
                }
                case 26: {
                    long[] _result = this.getRegisteredExperimentIds();
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 27: {
                    PropertyParcel[] _arg0 = data.createTypedArray(PropertyParcel.CREATOR);
                    this.updateProperties(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IStatsd {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStatsd.DESCRIPTOR;
            }

            @Override
            public void systemRunning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void bootCompleted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void statsCompanionReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informAnomalyAlarmFired() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informPollAlarmFired() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informAlarmForSubscriberTriggeringFired() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informDeviceShutdown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informAllUidData(ParcelFileDescriptor fd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeTypedObject(fd, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informOnePackage(String app, int uid, long version, String version_string, String installer, byte[] certificate_hash) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeString(app);
                    _data.writeInt(uid);
                    _data.writeLong(version);
                    _data.writeString(version_string);
                    _data.writeString(installer);
                    _data.writeByteArray(certificate_hash);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informOnePackageRemoved(String app, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeString(app);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getData(long key, int callingUid) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(key);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadata() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addConfiguration(long configId, byte[] config, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeByteArray(config);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDataFetchOperation(long configId, IPendingIntentRef pendingIntentRef, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeStrongInterface(pendingIntentRef);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDataFetchOperation(long configId, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] setActiveConfigsChangedOperation(IPendingIntentRef pendingIntentRef, int callingUid) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeStrongInterface(pendingIntentRef);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeActiveConfigsChangedOperation(int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeConfiguration(long configId, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBroadcastSubscriber(long configId, long subscriberId, IPendingIntentRef pir, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeLong(subscriberId);
                    _data.writeStrongInterface(pir);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsetBroadcastSubscriber(long configId, long subscriberId, int callingUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeLong(subscriberId);
                    _data.writeInt(callingUid);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void allPullersFromBootRegistered() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPullAtomCallback(int uid, int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(atomTag);
                    _data.writeLong(coolDownMillis);
                    _data.writeLong(timeoutMillis);
                    _data.writeIntArray(additiveFields);
                    _data.writeStrongInterface(pullerCallback);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNativePullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    _data.writeLong(coolDownMillis);
                    _data.writeLong(timeoutMillis);
                    _data.writeIntArray(additiveFields);
                    _data.writeStrongInterface(pullerCallback);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPullAtomCallback(int uid, int atomTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(atomTag);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNativePullAtomCallback(int atomTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getRegisteredExperimentIds() throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateProperties(PropertyParcel[] properties2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsd.DESCRIPTOR);
                    _data.writeTypedArray(properties2, 0);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatsd {
        @Override
        public void systemRunning() throws RemoteException {
        }

        @Override
        public void bootCompleted() throws RemoteException {
        }

        @Override
        public void statsCompanionReady() throws RemoteException {
        }

        @Override
        public void informAnomalyAlarmFired() throws RemoteException {
        }

        @Override
        public void informPollAlarmFired() throws RemoteException {
        }

        @Override
        public void informAlarmForSubscriberTriggeringFired() throws RemoteException {
        }

        @Override
        public void informDeviceShutdown() throws RemoteException {
        }

        @Override
        public void informAllUidData(ParcelFileDescriptor fd) throws RemoteException {
        }

        @Override
        public void informOnePackage(String app, int uid, long version, String version_string, String installer, byte[] certificate_hash) throws RemoteException {
        }

        @Override
        public void informOnePackageRemoved(String app, int uid) throws RemoteException {
        }

        @Override
        public byte[] getData(long key, int callingUid) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMetadata() throws RemoteException {
            return null;
        }

        @Override
        public void addConfiguration(long configId, byte[] config, int callingUid) throws RemoteException {
        }

        @Override
        public void setDataFetchOperation(long configId, IPendingIntentRef pendingIntentRef, int callingUid) throws RemoteException {
        }

        @Override
        public void removeDataFetchOperation(long configId, int callingUid) throws RemoteException {
        }

        @Override
        public long[] setActiveConfigsChangedOperation(IPendingIntentRef pendingIntentRef, int callingUid) throws RemoteException {
            return null;
        }

        @Override
        public void removeActiveConfigsChangedOperation(int callingUid) throws RemoteException {
        }

        @Override
        public void removeConfiguration(long configId, int callingUid) throws RemoteException {
        }

        @Override
        public void setBroadcastSubscriber(long configId, long subscriberId, IPendingIntentRef pir, int callingUid) throws RemoteException {
        }

        @Override
        public void unsetBroadcastSubscriber(long configId, long subscriberId, int callingUid) throws RemoteException {
        }

        @Override
        public void allPullersFromBootRegistered() throws RemoteException {
        }

        @Override
        public void registerPullAtomCallback(int uid, int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
        }

        @Override
        public void registerNativePullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
        }

        @Override
        public void unregisterPullAtomCallback(int uid, int atomTag) throws RemoteException {
        }

        @Override
        public void unregisterNativePullAtomCallback(int atomTag) throws RemoteException {
        }

        @Override
        public long[] getRegisteredExperimentIds() throws RemoteException {
            return null;
        }

        @Override
        public void updateProperties(PropertyParcel[] properties2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

