/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.Uri;
import android.os.IIncidentAuthListener;
import android.os.IIncidentCompanion;
import android.os.IIncidentDumpCallback;
import android.os.IIncidentManager;
import android.os.IncidentReportArgs;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class IncidentManager {
    private static final String TAG = "IncidentManager";
    public static final String URI_SCHEME = "content";
    public static final String URI_AUTHORITY = "android.os.IncidentManager";
    public static final String URI_PATH = "/pending";
    public static final String URI_PARAM_ID = "id";
    public static final String URI_PARAM_REPORT_ID = "r";
    public static final String URI_PARAM_CALLING_PACKAGE = "pkg";
    public static final String URI_PARAM_TIMESTAMP = "t";
    public static final String URI_PARAM_FLAGS = "flags";
    public static final String URI_PARAM_RECEIVER_CLASS = "receiver";
    public static final int FLAG_CONFIRMATION_DIALOG = 1;
    public static final int PRIVACY_POLICY_LOCAL = 0;
    public static final int PRIVACY_POLICY_EXPLICIT = 100;
    public static final int PRIVACY_POLICY_AUTO = 200;
    private final Context mContext;
    private Object mLock = new Object();
    private IIncidentManager mIncidentService;
    private IIncidentCompanion mCompanionService;

    public IncidentManager(Context context) {
        this.mContext = context;
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void reportIncident(IncidentReportArgs args) {
        this.reportIncidentInternal(args);
    }

    @RequiresPermission(value="android.permission.REQUEST_INCIDENT_REPORT_APPROVAL")
    public void requestAuthorization(int callingUid, String callingPackage, int flags, AuthListener listener2) {
        this.requestAuthorization(callingUid, callingPackage, flags, this.mContext.getMainExecutor(), listener2);
    }

    @RequiresPermission(value="android.permission.REQUEST_INCIDENT_REPORT_APPROVAL")
    public void requestAuthorization(int callingUid, String callingPackage, int flags, Executor executor, AuthListener listener2) {
        try {
            if (listener2.mExecutor != null) {
                throw new RuntimeException("Do not reuse AuthListener objects when calling requestAuthorization");
            }
            listener2.mExecutor = executor;
            this.getCompanionServiceLocked().authorizeReport(callingUid, callingPackage, null, null, flags, listener2.mBinder);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_INCIDENT_REPORT_APPROVAL")
    public void cancelAuthorization(AuthListener listener2) {
        try {
            this.getCompanionServiceLocked().cancelAuthorization(listener2.mBinder);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    @RequiresPermission(value="android.permission.APPROVE_INCIDENT_REPORTS")
    public List<PendingReport> getPendingReports() {
        List<String> strings;
        try {
            strings = this.getCompanionServiceLocked().getPendingReports();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
        int size = strings.size();
        ArrayList<PendingReport> result = new ArrayList<PendingReport>(size);
        for (int i = 0; i < size; ++i) {
            result.add(new PendingReport(Uri.parse(strings.get(i))));
        }
        return result;
    }

    @RequiresPermission(value="android.permission.APPROVE_INCIDENT_REPORTS")
    public void approveReport(Uri uri) {
        try {
            this.getCompanionServiceLocked().approveReport(uri.toString());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    @RequiresPermission(value="android.permission.APPROVE_INCIDENT_REPORTS")
    public void denyReport(Uri uri) {
        try {
            this.getCompanionServiceLocked().denyReport(uri.toString());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void registerSection(int id2, String name, Executor executor, DumpCallback callback2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        try {
            if (callback2.mExecutor != null) {
                throw new RuntimeException("Do not reuse DumpCallback objects when calling registerSection");
            }
            callback2.mExecutor = executor;
            callback2.mId = id2;
            IIncidentManager service = this.getIIncidentManagerLocked();
            if (service == null) {
                Slog.e(TAG, "registerSection can't find incident binder service");
                return;
            }
            service.registerSection(id2, name, callback2.mBinder);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "registerSection failed", ex);
        }
    }

    public void unregisterSection(int id2) {
        try {
            IIncidentManager service = this.getIIncidentManagerLocked();
            if (service == null) {
                Slog.e(TAG, "unregisterSection can't find incident binder service");
                return;
            }
            service.unregisterSection(id2);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "unregisterSection failed", ex);
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public List<Uri> getIncidentReportList(String receiverClass) {
        List<String> strings;
        try {
            strings = this.getCompanionServiceLocked().getIncidentReportList(this.mContext.getPackageName(), receiverClass);
        }
        catch (RemoteException ex) {
            throw new RuntimeException("System server or incidentd going down", ex);
        }
        int size = strings.size();
        ArrayList<Uri> result = new ArrayList<Uri>(size);
        for (int i = 0; i < size; ++i) {
            result.add(Uri.parse(strings.get(i)));
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public IncidentReport getIncidentReport(Uri uri) {
        String id2 = uri.getQueryParameter(URI_PARAM_REPORT_ID);
        if (id2 == null) {
            return null;
        }
        String pkg = uri.getQueryParameter(URI_PARAM_CALLING_PACKAGE);
        if (pkg == null) {
            throw new RuntimeException("Invalid URI: No pkg parameter. " + uri);
        }
        String cls = uri.getQueryParameter(URI_PARAM_RECEIVER_CLASS);
        if (cls == null) {
            throw new RuntimeException("Invalid URI: No receiver parameter. " + uri);
        }
        try {
            return this.getCompanionServiceLocked().getIncidentReport(pkg, cls, id2);
        }
        catch (RemoteException ex) {
            throw new RuntimeException("System server or incidentd going down", ex);
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void deleteIncidentReports(Uri uri) {
        if (uri == null) {
            try {
                this.getCompanionServiceLocked().deleteAllIncidentReports(this.mContext.getPackageName());
            }
            catch (RemoteException ex) {
                throw new RuntimeException("System server or incidentd going down", ex);
            }
        }
        String pkg = uri.getQueryParameter(URI_PARAM_CALLING_PACKAGE);
        if (pkg == null) {
            throw new RuntimeException("Invalid URI: No pkg parameter. " + uri);
        }
        String cls = uri.getQueryParameter(URI_PARAM_RECEIVER_CLASS);
        if (cls == null) {
            throw new RuntimeException("Invalid URI: No receiver parameter. " + uri);
        }
        String id2 = uri.getQueryParameter(URI_PARAM_REPORT_ID);
        if (id2 == null) {
            throw new RuntimeException("Invalid URI: No r parameter. " + uri);
        }
        try {
            this.getCompanionServiceLocked().deleteIncidentReports(pkg, cls, id2);
        }
        catch (RemoteException ex) {
            throw new RuntimeException("System server or incidentd going down", ex);
        }
    }

    private void reportIncidentInternal(IncidentReportArgs args) {
        try {
            IIncidentManager service = this.getIIncidentManagerLocked();
            if (service == null) {
                Slog.e(TAG, "reportIncident can't find incident binder service");
                return;
            }
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "reportIncident failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIncidentManager getIIncidentManagerLocked() throws RemoteException {
        if (this.mIncidentService != null) {
            return this.mIncidentService;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIncidentService != null) {
                return this.mIncidentService;
            }
            this.mIncidentService = IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
            if (this.mIncidentService != null) {
                this.mIncidentService.asBinder().linkToDeath(() -> {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mIncidentService = null;
                    }
                }, 0);
            }
            return this.mIncidentService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIncidentCompanion getCompanionServiceLocked() throws RemoteException {
        if (this.mCompanionService != null) {
            return this.mCompanionService;
        }
        IncidentManager incidentManager = this;
        synchronized (incidentManager) {
            if (this.mCompanionService != null) {
                return this.mCompanionService;
            }
            this.mCompanionService = IIncidentCompanion.Stub.asInterface(ServiceManager.getService("incidentcompanion"));
            if (this.mCompanionService != null) {
                this.mCompanionService.asBinder().linkToDeath(() -> {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mCompanionService = null;
                    }
                }, 0);
            }
            return this.mCompanionService;
        }
    }

    public static class DumpCallback {
        private int mId;
        private Executor mExecutor;
        IIncidentDumpCallback.Stub mBinder = new IIncidentDumpCallback.Stub(){

            @Override
            public void onDumpSection(ParcelFileDescriptor pfd) {
                if (mExecutor != null) {
                    mExecutor.execute(() -> this.onDumpSection(mId, new ParcelFileDescriptor.AutoCloseOutputStream(pfd)));
                } else {
                    this.onDumpSection(mId, new ParcelFileDescriptor.AutoCloseOutputStream(pfd));
                }
            }
        };

        public void onDumpSection(int id2, OutputStream out) {
        }
    }

    public static class AuthListener {
        Executor mExecutor;
        IIncidentAuthListener.Stub mBinder = new IIncidentAuthListener.Stub(){

            @Override
            public void onReportApproved() {
                if (mExecutor != null) {
                    mExecutor.execute(() -> this.onReportApproved());
                } else {
                    this.onReportApproved();
                }
            }

            @Override
            public void onReportDenied() {
                if (mExecutor != null) {
                    mExecutor.execute(() -> this.onReportDenied());
                } else {
                    this.onReportDenied();
                }
            }
        };

        public void onReportApproved() {
        }

        public void onReportDenied() {
        }
    }

    @SystemApi
    public static class IncidentReport
    implements Parcelable,
    Closeable {
        private final long mTimestampNs;
        private final int mPrivacyPolicy;
        private ParcelFileDescriptor mFileDescriptor;
        public static final Parcelable.Creator<IncidentReport> CREATOR = new Parcelable.Creator(){

            public IncidentReport[] newArray(int size) {
                return new IncidentReport[size];
            }

            public IncidentReport createFromParcel(Parcel in) {
                return new IncidentReport(in);
            }
        };

        public IncidentReport(Parcel in) {
            this.mTimestampNs = in.readLong();
            this.mPrivacyPolicy = in.readInt();
            this.mFileDescriptor = in.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(in) : null;
        }

        @Override
        public void close() {
            try {
                if (this.mFileDescriptor != null) {
                    this.mFileDescriptor.close();
                    this.mFileDescriptor = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public long getTimestamp() {
            return this.mTimestampNs / 1000000L;
        }

        public long getPrivacyPolicy() {
            return this.mPrivacyPolicy;
        }

        public InputStream getInputStream() throws IOException {
            if (this.mFileDescriptor == null) {
                return null;
            }
            return new ParcelFileDescriptor.AutoCloseInputStream(this.mFileDescriptor);
        }

        @Override
        public int describeContents() {
            return this.mFileDescriptor != null ? 1 : 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeLong(this.mTimestampNs);
            out.writeInt(this.mPrivacyPolicy);
            if (this.mFileDescriptor != null) {
                out.writeInt(1);
                this.mFileDescriptor.writeToParcel(out, flags);
            } else {
                out.writeInt(0);
            }
        }
    }

    @SystemApi
    public static class PendingReport {
        private final Uri mUri;
        private final int mFlags;
        private final String mRequestingPackage;
        private final long mTimestamp;

        public PendingReport(Uri uri) {
            int flags = 0;
            try {
                flags = Integer.parseInt(uri.getQueryParameter(IncidentManager.URI_PARAM_FLAGS));
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Invalid URI: No flags parameter. " + uri);
            }
            this.mFlags = flags;
            String requestingPackage = uri.getQueryParameter(IncidentManager.URI_PARAM_CALLING_PACKAGE);
            if (requestingPackage == null) {
                throw new RuntimeException("Invalid URI: No pkg parameter. " + uri);
            }
            this.mRequestingPackage = requestingPackage;
            long timestamp = -1L;
            try {
                timestamp = Long.parseLong(uri.getQueryParameter(IncidentManager.URI_PARAM_TIMESTAMP));
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Invalid URI: No t parameter. " + uri);
            }
            this.mTimestamp = timestamp;
            this.mUri = uri;
        }

        public String getRequestingPackage() {
            return this.mRequestingPackage;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public String toString() {
            return "PendingReport(" + this.getUri().toString() + ")";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PendingReport)) {
                return false;
            }
            PendingReport that = (PendingReport)obj;
            return this.mUri.equals(that.mUri) && this.mFlags == that.mFlags && this.mRequestingPackage.equals(that.mRequestingPackage) && this.mTimestamp == that.mTimestamp;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrivacyPolicy {
    }
}

