/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.app.PropertyInvalidatedCache;
import android.os.RemoteException;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class IpcDataCache<Query, Result>
extends PropertyInvalidatedCache<Query, Result> {
    public static final String MODULE_TEST = "test";
    public static final String MODULE_SYSTEM = "system_server";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String MODULE_BLUETOOTH = "bluetooth";

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public IpcDataCache(int maxEntries, String module2, String api, String cacheName, QueryHandler<Query, Result> computer) {
        super(maxEntries, module2, api, cacheName, computer);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void disableForCurrentProcess() {
        super.disableForCurrentProcess();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void disableForCurrentProcess(String cacheName) {
        PropertyInvalidatedCache.disableForCurrentProcess(cacheName);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public Result query(Query query) {
        return super.query(query);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void invalidateCache() {
        super.invalidateCache();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void invalidateCache(String module2, String api) {
        PropertyInvalidatedCache.invalidateCache(module2, api);
    }

    public IpcDataCache(Config config, QueryHandler<Query, Result> computer) {
        super(config.maxEntries(), config.module(), config.api(), config.name(), computer);
    }

    public IpcDataCache(Config config, RemoteCall<Query, Result> computer) {
        this(config, new SystemServerCallHandler(computer));
    }

    private static class SystemServerCallHandler<Query, Result>
    extends QueryHandler<Query, Result> {
        private final RemoteCall<Query, Result> mHandler;

        public SystemServerCallHandler(RemoteCall handler) {
            this.mHandler = handler;
        }

        @Override
        public Result apply(Query query) {
            try {
                return this.mHandler.apply(query);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static interface RemoteCall<Query, Result> {
        public Result apply(Query var1) throws RemoteException;
    }

    public static class Config {
        private final int mMaxEntries;
        private final String mModule;
        private final String mApi;
        private final String mName;
        private ArraySet<String> mChildren;
        private boolean mDisabled = false;

        public Config(int maxEntries, String module2, String api, String name) {
            this.mMaxEntries = maxEntries;
            this.mModule = module2;
            this.mApi = api;
            this.mName = name;
        }

        public Config(int maxEntries, String module2, String api) {
            this(maxEntries, module2, api, api);
        }

        public Config(Config root, String api, String name) {
            this(root.maxEntries(), root.module(), api, name);
        }

        public Config(Config root, String api) {
            this(root.maxEntries(), root.module(), api, api);
        }

        public Config child(String name) {
            Config result = new Config(this, this.api(), name);
            this.registerChild(name);
            return result;
        }

        public int maxEntries() {
            return this.mMaxEntries;
        }

        public String module() {
            return this.mModule;
        }

        public String api() {
            return this.mApi;
        }

        public String name() {
            return this.mName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChild(String name) {
            Config config = this;
            synchronized (config) {
                if (this.mChildren == null) {
                    this.mChildren = new ArraySet();
                }
                this.mChildren.add(name);
                if (this.mDisabled) {
                    IpcDataCache.disableForCurrentProcess(name);
                }
            }
        }

        public void invalidateCache() {
            IpcDataCache.invalidateCache(this.mModule, this.mApi);
        }

        public void disableForCurrentProcess() {
            IpcDataCache.disableForCurrentProcess(this.mName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disableAllForCurrentProcess() {
            Config config = this;
            synchronized (config) {
                this.mDisabled = true;
                this.disableForCurrentProcess();
                if (this.mChildren != null) {
                    for (String c : this.mChildren) {
                        IpcDataCache.disableForCurrentProcess(c);
                    }
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IpcDataCacheModule {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static abstract class QueryHandler<Q, R>
    extends PropertyInvalidatedCache.QueryHandler<Q, R> {
        @Override
        public abstract R apply(Q var1);

        @Override
        public boolean shouldBypassCache(Q query) {
            return false;
        }
    }
}

