/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.graphics.Bitmap;
import android.os.PersistableBundle;
import android.text.TextUtils;

@SystemApi
@SuppressLint(value={"PackageLayering"})
public class NewUserRequest {
    private final String mName;
    private final boolean mAdmin;
    private final boolean mEphemeral;
    private final String mUserType;
    private final Bitmap mUserIcon;
    private final String mAccountName;
    private final String mAccountType;
    private final PersistableBundle mAccountOptions;

    private NewUserRequest(Builder builder2) {
        this.mName = builder2.mName;
        this.mAdmin = builder2.mAdmin;
        this.mEphemeral = builder2.mEphemeral;
        this.mUserType = builder2.mUserType;
        this.mUserIcon = builder2.mUserIcon;
        this.mAccountName = builder2.mAccountName;
        this.mAccountType = builder2.mAccountType;
        this.mAccountOptions = builder2.mAccountOptions;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isEphemeral() {
        return this.mEphemeral;
    }

    public boolean isAdmin() {
        return this.mAdmin;
    }

    int getFlags() {
        int flags = 0;
        if (this.isAdmin()) {
            flags |= 2;
        }
        if (this.isEphemeral()) {
            flags |= 0x100;
        }
        return flags;
    }

    public String getUserType() {
        return this.mUserType;
    }

    public Bitmap getUserIcon() {
        return this.mUserIcon;
    }

    public String getAccountName() {
        return this.mAccountName;
    }

    public String getAccountType() {
        return this.mAccountType;
    }

    @SuppressLint(value={"NullableCollection"})
    public PersistableBundle getAccountOptions() {
        return this.mAccountOptions;
    }

    public String toString() {
        return "NewUserRequest{mName='" + this.mName + '\'' + ", mAdmin=" + this.mAdmin + ", mEphemeral=" + this.mEphemeral + ", mUserType='" + this.mUserType + '\'' + ", mAccountName='" + this.mAccountName + '\'' + ", mAccountType='" + this.mAccountType + '\'' + ", mAccountOptions=" + this.mAccountOptions + '}';
    }

    @SuppressLint(value={"PackageLayering"})
    public static class Builder {
        private String mName;
        private boolean mAdmin;
        private boolean mEphemeral;
        private String mUserType = "android.os.usertype.full.SECONDARY";
        private Bitmap mUserIcon;
        private String mAccountName;
        private String mAccountType;
        private PersistableBundle mAccountOptions;

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setAdmin() {
            this.mAdmin = true;
            return this;
        }

        public Builder setEphemeral() {
            this.mEphemeral = true;
            return this;
        }

        public Builder setUserType(String type) {
            this.mUserType = type;
            return this;
        }

        public Builder setUserIcon(Bitmap userIcon) {
            this.mUserIcon = userIcon;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.mAccountName = accountName;
            return this;
        }

        public Builder setAccountType(String accountType) {
            this.mAccountType = accountType;
            return this;
        }

        public Builder setAccountOptions(PersistableBundle accountOptions) {
            this.mAccountOptions = accountOptions;
            return this;
        }

        public NewUserRequest build() {
            this.checkIfPropertiesAreCompatible();
            return new NewUserRequest(this);
        }

        private void checkIfPropertiesAreCompatible() {
            if (this.mUserType == null) {
                throw new IllegalStateException("Usertype cannot be null");
            }
            if (this.mAdmin && !this.mUserType.equals("android.os.usertype.full.SECONDARY")) {
                throw new IllegalStateException("Admin user can't be of type: " + this.mUserType);
            }
            if (TextUtils.isEmpty(this.mAccountName) != TextUtils.isEmpty(this.mAccountType)) {
                throw new IllegalStateException("Account name and account type should be provided together.");
            }
        }
    }
}

