/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.BadTypeParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.MathUtils;
import android.util.Size;
import android.util.SizeF;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import libcore.util.SneakyThrow;

public class Parcel {
    private static final boolean DEBUG_RECYCLE = false;
    private static final boolean DEBUG_ARRAY_MAP = false;
    private static final String TAG = "Parcel";
    @UnsupportedAppUsage
    private long mNativePtr;
    private boolean mOwnsNativeParcelObject;
    private long mNativeSize;
    private ArrayMap<Class, Object> mClassCookies;
    private RuntimeException mStack;
    public static final int FLAG_IS_REPLY_FROM_BLOCKING_ALLOWED_OBJECT = 1;
    public static final int FLAG_PROPAGATE_ALLOW_BLOCKING = 2;
    private int mFlags;
    private static boolean sParcelExceptionStackTrace;
    private static final Object sPoolSync;
    @GuardedBy(value={"sPoolSync"})
    private Parcel mPoolNext;
    @GuardedBy(value={"sPoolSync"})
    private static Parcel sOwnedPool;
    @GuardedBy(value={"sPoolSync"})
    private static Parcel sHolderPool;
    @GuardedBy(value={"sPoolSync"})
    private static int sOwnedPoolSize;
    @GuardedBy(value={"sPoolSync"})
    private static int sHolderPoolSize;
    private static final int POOL_SIZE = 32;
    private static final int VAL_NULL = -1;
    private static final int VAL_STRING = 0;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_MAP = 2;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_SHORT = 5;
    private static final int VAL_LONG = 6;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_LIST = 11;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_STRINGARRAY = 14;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_BYTE = 20;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int VAL_PERSISTABLEBUNDLE = 25;
    private static final int VAL_SIZE = 26;
    private static final int VAL_SIZEF = 27;
    private static final int VAL_DOUBLEARRAY = 28;
    private static final int VAL_CHAR = 29;
    private static final int VAL_SHORTARRAY = 30;
    private static final int VAL_CHARARRAY = 31;
    private static final int VAL_FLOATARRAY = 32;
    private static final int EX_SECURITY = -1;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_NETWORK_MAIN_THREAD = -6;
    private static final int EX_UNSUPPORTED_OPERATION = -7;
    private static final int EX_SERVICE_SPECIFIC = -8;
    private static final int EX_PARCELABLE = -9;
    public static final int EX_HAS_NOTED_APPOPS_REPLY_HEADER = -127;
    private static final int EX_HAS_STRICTMODE_REPLY_HEADER = -128;
    private static final int EX_TRANSACTION_FAILED = -129;
    private static volatile long sLastWriteExceptionStackTrace;
    private static final int WRITE_EXCEPTION_STACK_TRACE_THRESHOLD_MS = 1000;
    public static final Parcelable.Creator<String> STRING_CREATOR;
    private ReadWriteHelper mReadWriteHelper = ReadWriteHelper.DEFAULT;
    private static final int OK = 0;
    private ArrayMap<Parcelable, Integer> mWrittenSquashableParcelables;
    private boolean mAllowSquashing = false;
    private SparseArray<Parcelable> mReadSquashableParcelables;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> mCreators;

    @CriticalNative
    private static void nativeMarkSensitive(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeMarkSensitive(J)V", true, null);
    }

    @FastNative
    private static void nativeMarkForBinder(long l, IBinder iBinder) {
        OverrideMethod.invokeV("android.os.Parcel#nativeMarkForBinder(JLandroid/os/IBinder;)V", true, null);
    }

    @CriticalNative
    private static int nativeDataSize(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataSize(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataAvail(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataAvail(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataPosition(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataPosition(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataCapacity(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataCapacity(J)I", true, null);
    }

    @FastNative
    private static void nativeSetDataSize(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataSize(JI)V", true, null);
    }

    @CriticalNative
    private static void nativeSetDataPosition(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataPosition(JI)V", true, null);
    }

    @FastNative
    private static void nativeSetDataCapacity(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataCapacity(JI)V", true, null);
    }

    @CriticalNative
    private static boolean nativePushAllowFds(long l, boolean bl) {
        return OverrideMethod.invokeI("android.os.Parcel#nativePushAllowFds(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nativeRestoreAllowFds(long l, boolean bl) {
        OverrideMethod.invokeV("android.os.Parcel#nativeRestoreAllowFds(JZ)V", true, null);
    }

    private static void nativeWriteByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteByteArray(J[BII)V", true, null);
    }

    private static void nativeWriteBlob(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteBlob(J[BII)V", true, null);
    }

    @CriticalNative
    private static int nativeWriteInt(long l, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteInt(JI)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteLong(long l, long l2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteLong(JJ)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteFloat(long l, float f) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteFloat(JF)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteDouble(long l, double d) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteDouble(JD)I", true, null);
    }

    private static void nativeSignalExceptionForError(int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSignalExceptionForError(I)V", true, null);
    }

    @FastNative
    private static void nativeWriteString8(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteString8(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeWriteString16(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteString16(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeWriteStrongBinder(long l, IBinder iBinder) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteStrongBinder(JLandroid/os/IBinder;)V", true, null);
    }

    @FastNative
    private static void nativeWriteFileDescriptor(long l, FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteFileDescriptor(JLjava/io/FileDescriptor;)V", true, null);
    }

    private static byte[] nativeCreateByteArray(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeCreateByteArray(J)[B", true, null);
    }

    private static boolean nativeReadByteArray(long l, byte[] byArray, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadByteArray(J[BI)Z", true, null) != 0;
    }

    private static byte[] nativeReadBlob(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeReadBlob(J)[B", true, null);
    }

    @CriticalNative
    private static int nativeReadInt(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadInt(J)I", true, null);
    }

    @CriticalNative
    private static long nativeReadLong(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeReadLong(J)J", true, null);
    }

    @CriticalNative
    private static float nativeReadFloat(long l) {
        return OverrideMethod.invokeF("android.os.Parcel#nativeReadFloat(J)F", true, null);
    }

    @CriticalNative
    private static double nativeReadDouble(long l) {
        return OverrideMethod.invokeD("android.os.Parcel#nativeReadDouble(J)D", true, null);
    }

    @FastNative
    private static String nativeReadString8(long l) {
        return (String)OverrideMethod.invokeA("android.os.Parcel#nativeReadString8(J)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static String nativeReadString16(long l) {
        return (String)OverrideMethod.invokeA("android.os.Parcel#nativeReadString16(J)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static IBinder nativeReadStrongBinder(long l) {
        return (IBinder)OverrideMethod.invokeA("android.os.Parcel#nativeReadStrongBinder(J)Landroid/os/IBinder;", true, null);
    }

    @FastNative
    private static FileDescriptor nativeReadFileDescriptor(long l) {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.Parcel#nativeReadFileDescriptor(J)Ljava/io/FileDescriptor;", true, null);
    }

    private static long nativeCreate() {
        return OverrideMethod.invokeL("android.os.Parcel#nativeCreate()J", true, null);
    }

    private static void nativeFreeBuffer(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeFreeBuffer(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeDestroy(J)V", true, null);
    }

    private static byte[] nativeMarshall(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeMarshall(J)[B", true, null);
    }

    private static void nativeUnmarshall(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeUnmarshall(J[BII)V", true, null);
    }

    private static int nativeCompareData(long l, long l2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeCompareData(JJ)I", true, null);
    }

    private static boolean nativeCompareDataInRange(long l, int n, long l2, int n2, int n3) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeCompareDataInRange(JIJII)Z", true, null) != 0;
    }

    private static void nativeAppendFrom(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeAppendFrom(JJII)V", true, null);
    }

    @CriticalNative
    private static boolean nativeHasFileDescriptors(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeHasFileDescriptors(J)Z", true, null) != 0;
    }

    private static boolean nativeHasFileDescriptorsInRange(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeHasFileDescriptorsInRange(JII)Z", true, null) != 0;
    }

    private static void nativeWriteInterfaceToken(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteInterfaceToken(JLjava/lang/String;)V", true, null);
    }

    private static void nativeEnforceInterface(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeEnforceInterface(JLjava/lang/String;)V", true, null);
    }

    @CriticalNative
    private static boolean nativeReplaceCallingWorkSourceUid(long l, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReplaceCallingWorkSourceUid(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static int nativeReadCallingWorkSourceUid(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadCallingWorkSourceUid(J)I", true, null);
    }

    @CriticalNative
    private static long nativeGetOpenAshmemSize(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeGetOpenAshmemSize(J)J", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parcel obtain() {
        Parcel res = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sOwnedPool != null) {
                res = sOwnedPool;
                sOwnedPool = res.mPoolNext;
                res.mPoolNext = null;
                --sOwnedPoolSize;
            }
        }
        if (res == null) {
            res = new Parcel(0L);
        } else {
            res.mReadWriteHelper = ReadWriteHelper.DEFAULT;
        }
        return res;
    }

    public static Parcel obtain(IBinder binder) {
        Parcel parcel = Parcel.obtain();
        parcel.markForBinder(binder);
        return parcel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.mClassCookies = null;
        this.freeBuffer();
        if (this.mOwnsNativeParcelObject) {
            Object object = sPoolSync;
            synchronized (object) {
                if (sOwnedPoolSize < 32) {
                    this.mPoolNext = sOwnedPool;
                    sOwnedPool = this;
                    ++sOwnedPoolSize;
                }
            }
        }
        this.mNativePtr = 0L;
        Object object = sPoolSync;
        synchronized (object) {
            if (sHolderPoolSize < 32) {
                this.mPoolNext = sHolderPool;
                sHolderPool = this;
                ++sHolderPoolSize;
            }
        }
    }

    public void setReadWriteHelper(ReadWriteHelper helper) {
        this.mReadWriteHelper = helper != null ? helper : ReadWriteHelper.DEFAULT;
    }

    public boolean hasReadWriteHelper() {
        return this.mReadWriteHelper != null && this.mReadWriteHelper != ReadWriteHelper.DEFAULT;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getGlobalAllocSize() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocSize()J", true, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getGlobalAllocCount() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocCount()J", true, null);
    }

    public void markSensitive() {
        Parcel.nativeMarkSensitive(this.mNativePtr);
    }

    private void markForBinder(IBinder binder) {
        Parcel.nativeMarkForBinder(this.mNativePtr, binder);
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    public void addFlags(int flags) {
        this.mFlags |= flags;
    }

    private boolean hasFlags(int flags) {
        return (this.mFlags & flags) == flags;
    }

    public void setPropagateAllowBlocking() {
        this.addFlags(2);
    }

    public int dataSize() {
        return Parcel.nativeDataSize(this.mNativePtr);
    }

    public int dataAvail() {
        return Parcel.nativeDataAvail(this.mNativePtr);
    }

    public int dataPosition() {
        return Parcel.nativeDataPosition(this.mNativePtr);
    }

    public int dataCapacity() {
        return Parcel.nativeDataCapacity(this.mNativePtr);
    }

    public void setDataSize(int size) {
        Parcel.nativeSetDataSize(this.mNativePtr, size);
    }

    public void setDataPosition(int pos) {
        Parcel.nativeSetDataPosition(this.mNativePtr, pos);
    }

    public void setDataCapacity(int size) {
        Parcel.nativeSetDataCapacity(this.mNativePtr, size);
    }

    public boolean pushAllowFds(boolean allowFds) {
        return Parcel.nativePushAllowFds(this.mNativePtr, allowFds);
    }

    public void restoreAllowFds(boolean lastValue) {
        Parcel.nativeRestoreAllowFds(this.mNativePtr, lastValue);
    }

    public byte[] marshall() {
        return Parcel.nativeMarshall(this.mNativePtr);
    }

    public void unmarshall(byte[] data, int offset2, int length) {
        Parcel.nativeUnmarshall(this.mNativePtr, data, offset2, length);
    }

    public void appendFrom(Parcel parcel, int offset2, int length) {
        Parcel.nativeAppendFrom(this.mNativePtr, parcel.mNativePtr, offset2, length);
    }

    public int compareData(Parcel other) {
        return Parcel.nativeCompareData(this.mNativePtr, other.mNativePtr);
    }

    public static boolean compareData(Parcel a, int offsetA, Parcel b, int offsetB, int length) {
        return Parcel.nativeCompareDataInRange(a.mNativePtr, offsetA, b.mNativePtr, offsetB, length);
    }

    public void setClassCookie(Class clz, Object cookie) {
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.put(clz, cookie);
    }

    public Object getClassCookie(Class clz) {
        return this.mClassCookies != null ? this.mClassCookies.get(clz) : null;
    }

    public void adoptClassCookies(Parcel from) {
        this.mClassCookies = from.mClassCookies;
    }

    public Map<Class, Object> copyClassCookies() {
        return new ArrayMap<Class, Object>(this.mClassCookies);
    }

    public void putClassCookies(Map<Class, Object> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.putAll(cookies);
    }

    public boolean hasFileDescriptors() {
        return Parcel.nativeHasFileDescriptors(this.mNativePtr);
    }

    public boolean hasFileDescriptors(int offset2, int length) {
        return Parcel.nativeHasFileDescriptorsInRange(this.mNativePtr, offset2, length);
    }

    public static boolean hasFileDescriptors(Object value2) {
        if (value2 instanceof Parcel) {
            Parcel parcel = (Parcel)value2;
            if (parcel.hasFileDescriptors()) {
                return true;
            }
        } else if (value2 instanceof LazyValue) {
            LazyValue lazy = (LazyValue)value2;
            if (lazy.hasFileDescriptors()) {
                return true;
            }
        } else if (value2 instanceof Parcelable) {
            Parcelable parcelable = (Parcelable)value2;
            if ((parcelable.describeContents() & 1) != 0) {
                return true;
            }
        } else if (value2 instanceof ArrayMap) {
            ArrayMap map2 = (ArrayMap)value2;
            int n = map2.size();
            for (int i = 0; i < n; ++i) {
                if (!Parcel.hasFileDescriptors(map2.keyAt(i)) && !Parcel.hasFileDescriptors(map2.valueAt(i))) continue;
                return true;
            }
        } else if (value2 instanceof Map) {
            Map map3 = (Map)value2;
            for (Map.Entry entry : map3.entrySet()) {
                if (!Parcel.hasFileDescriptors(entry.getKey()) && !Parcel.hasFileDescriptors(entry.getValue())) continue;
                return true;
            }
        } else if (value2 instanceof List) {
            List list = (List)value2;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!Parcel.hasFileDescriptors(list.get(i))) continue;
                return true;
            }
        } else if (value2 instanceof SparseArray) {
            SparseArray array2 = (SparseArray)value2;
            int n = array2.size();
            for (int i = 0; i < n; ++i) {
                if (!Parcel.hasFileDescriptors(array2.valueAt(i))) continue;
                return true;
            }
        } else if (value2 instanceof Object[]) {
            Object[] array3 = (Object[])value2;
            int n = array3.length;
            for (int i = 0; i < n; ++i) {
                if (!Parcel.hasFileDescriptors(array3[i])) continue;
                return true;
            }
        } else {
            Parcel.getValueType(value2);
        }
        return false;
    }

    public void writeInterfaceToken(String interfaceName) {
        Parcel.nativeWriteInterfaceToken(this.mNativePtr, interfaceName);
    }

    public void enforceInterface(String interfaceName) {
        Parcel.nativeEnforceInterface(this.mNativePtr, interfaceName);
    }

    public void enforceNoDataAvail() {
        int n = this.dataAvail();
        if (n > 0) {
            throw new BadParcelableException("Parcel data not fully consumed, unread size: " + n);
        }
    }

    public boolean replaceCallingWorkSourceUid(int workSourceUid) {
        return Parcel.nativeReplaceCallingWorkSourceUid(this.mNativePtr, workSourceUid);
    }

    public int readCallingWorkSourceUid() {
        return Parcel.nativeReadCallingWorkSourceUid(this.mNativePtr);
    }

    public void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b != null ? b.length : 0);
    }

    public void writeByteArray(byte[] b, int offset2, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        ArrayUtils.throwsIfOutOfBounds(b.length, offset2, len);
        Parcel.nativeWriteByteArray(this.mNativePtr, b, offset2, len);
    }

    public void writeBlob(byte[] b) {
        this.writeBlob(b, 0, b != null ? b.length : 0);
    }

    public void writeBlob(byte[] b, int offset2, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        ArrayUtils.throwsIfOutOfBounds(b.length, offset2, len);
        Parcel.nativeWriteBlob(this.mNativePtr, b, offset2, len);
    }

    public void writeInt(int val) {
        int err = Parcel.nativeWriteInt(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeLong(long val) {
        int err = Parcel.nativeWriteLong(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeFloat(float val) {
        int err = Parcel.nativeWriteFloat(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeDouble(double val) {
        int err = Parcel.nativeWriteDouble(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeString(String val) {
        this.writeString16(val);
    }

    public void writeString8(String val) {
        this.mReadWriteHelper.writeString8(this, val);
    }

    public void writeString16(String val) {
        this.mReadWriteHelper.writeString16(this, val);
    }

    public void writeStringNoHelper(String val) {
        this.writeString16NoHelper(val);
    }

    public void writeString8NoHelper(String val) {
        Parcel.nativeWriteString8(this.mNativePtr, val);
    }

    public void writeString16NoHelper(String val) {
        Parcel.nativeWriteString16(this.mNativePtr, val);
    }

    public void writeBoolean(boolean val) {
        this.writeInt(val ? 1 : 0);
    }

    @UnsupportedAppUsage
    public void writeCharSequence(CharSequence val) {
        TextUtils.writeToParcel(val, this, 0);
    }

    public void writeStrongBinder(IBinder val) {
        Parcel.nativeWriteStrongBinder(this.mNativePtr, val);
    }

    public void writeStrongInterface(IInterface val) {
        this.writeStrongBinder(val == null ? null : val.asBinder());
    }

    public void writeFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    public void writeRawFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    public void writeRawFileDescriptorArray(FileDescriptor[] value2) {
        if (value2 != null) {
            int N = value2.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeRawFileDescriptor(value2[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeByte(byte val) {
        this.writeInt(val);
    }

    public void writeMap(Map val) {
        this.writeMapInternal(val);
    }

    void writeMapInternal(Map<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> entries = val.entrySet();
        int size = entries.size();
        this.writeInt(size);
        for (Map.Entry<String, Object> e : entries) {
            this.writeValue(e.getKey());
            this.writeValue(e.getValue());
            --size;
        }
        if (size != 0) {
            throw new BadParcelableException("Map size does not match number of entries!");
        }
    }

    void writeArrayMapInternal(ArrayMap<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void writeArrayMap(ArrayMap<String, Object> val) {
        this.writeArrayMapInternal(val);
    }

    public <T extends Parcelable> void writeTypedArrayMap(ArrayMap<String, T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int count = val.size();
        this.writeInt(count);
        for (int i = 0; i < count; ++i) {
            this.writeString(val.keyAt(i));
            this.writeTypedObject((Parcelable)val.valueAt(i), parcelableFlags);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void writeArraySet(ArraySet<? extends Object> val) {
        int size = val != null ? val.size() : -1;
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeBundle(Bundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writePersistableBundle(PersistableBundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writeSize(Size val) {
        this.writeInt(val.getWidth());
        this.writeInt(val.getHeight());
    }

    public void writeSizeF(SizeF val) {
        this.writeFloat(val.getWidth());
        this.writeFloat(val.getHeight());
    }

    public void writeList(List val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val.get(i));
        }
    }

    public void writeArray(Object[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.length;
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val[i]);
        }
    }

    public <T> void writeSparseArray(SparseArray<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeSparseBooleanArray(SparseBooleanArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeByte((byte)(val.valueAt(i) ? 1 : 0));
        }
    }

    public void writeSparseIntArray(SparseIntArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeInt(val.valueAt(i));
        }
    }

    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public boolean[] createBooleanArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            boolean[] val = new boolean[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
            return val;
        }
        return null;
    }

    public void readBooleanArray(boolean[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeShortArray(short[] val) {
        if (val != null) {
            int n = val.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public short[] createShortArray() {
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 2) {
            short[] val = new short[n];
            for (int i = 0; i < n; ++i) {
                val[i] = (short)this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readShortArray(short[] val) {
        int n = this.readInt();
        if (n == val.length) {
            for (int i = 0; i < n; ++i) {
                val[i] = (short)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeCharArray(char[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public char[] createCharArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            char[] val = new char[N];
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readCharArray(char[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeIntArray(int[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public int[] createIntArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            int[] val = new int[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readIntArray(int[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeLongArray(long[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public long[] createLongArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            long[] val = new long[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
            return val;
        }
        return null;
    }

    public void readLongArray(long[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeFloatArray(float[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public float[] createFloatArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            float[] val = new float[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
            return val;
        }
        return null;
    }

    public void readFloatArray(float[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeDoubleArray(double[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public double[] createDoubleArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            double[] val = new double[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
            return val;
        }
        return null;
    }

    public void readDoubleArray(double[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeStringArray(String[] val) {
        this.writeString16Array(val);
    }

    public String[] createStringArray() {
        return this.createString16Array();
    }

    public void readStringArray(String[] val) {
        this.readString16Array(val);
    }

    public void writeString8Array(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString8(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public String[] createString8Array() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString8();
            }
            return val;
        }
        return null;
    }

    public void readString8Array(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString8();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeString16Array(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString16(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public String[] createString16Array() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString16();
            }
            return val;
        }
        return null;
    }

    public void readString16Array(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString16();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeBinderArray(IBinder[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongBinder(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public <T extends IInterface> void writeInterfaceArray(@SuppressLint(value={"ArrayReturn"}) T[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongInterface((IInterface)val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceArray(CharSequence[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceList(ArrayList<CharSequence> val) {
        if (val != null) {
            int N = val.size();
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val.get(i));
            }
        } else {
            this.writeInt(-1);
        }
    }

    public IBinder[] createBinderArray() {
        int N = this.readInt();
        if (N >= 0) {
            IBinder[] val = new IBinder[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
            return val;
        }
        return null;
    }

    public void readBinderArray(IBinder[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection", "SamShouldBeLast"})
    public <T extends IInterface> T[] createInterfaceArray(IntFunction<T[]> newArray, Function<IBinder, T> asInterface) {
        int N = this.readInt();
        if (N >= 0) {
            IInterface[] val = (IInterface[])newArray.apply(N);
            for (int i = 0; i < N; ++i) {
                val[i] = (IInterface)asInterface.apply(this.readStrongBinder());
            }
            return val;
        }
        return null;
    }

    public <T extends IInterface> void readInterfaceArray(@SuppressLint(value={"ArrayReturn"}) T[] val, Function<IBinder, T> asInterface) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (IInterface)asInterface.apply(this.readStrongBinder());
            }
        } else {
            throw new BadParcelableException("bad array lengths");
        }
    }

    public <T extends Parcelable> void writeTypedList(List<T> val) {
        this.writeTypedList(val, 0);
    }

    public <T extends Parcelable> void writeTypedSparseArray(SparseArray<T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int count = val.size();
        this.writeInt(count);
        for (int i = 0; i < count; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeTypedObject((Parcelable)val.valueAt(i), parcelableFlags);
        }
    }

    public <T extends Parcelable> void writeTypedList(List<T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeTypedObject((Parcelable)val.get(i), parcelableFlags);
        }
    }

    public void writeStringList(List<String> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.get(i));
        }
    }

    public void writeBinderList(List<IBinder> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongBinder(val.get(i));
        }
    }

    public <T extends IInterface> void writeInterfaceList(List<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongInterface((IInterface)val.get(i));
        }
    }

    public <T extends Parcelable> void writeParcelableList(List<T> val, int flags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeParcelable((Parcelable)val.get(i), flags);
        }
    }

    public <T extends Parcelable> void writeTypedArray(T[] val, int parcelableFlags) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeTypedObject(val[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public <T extends Parcelable> void writeTypedObject(T val, int parcelableFlags) {
        if (val != null) {
            this.writeInt(1);
            val.writeToParcel(this, parcelableFlags);
        } else {
            this.writeInt(0);
        }
    }

    public <T> void writeFixedArray(T val, int parcelableFlags, int ... dimensions) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        this.writeFixedArrayInternal(val, parcelableFlags, 0, dimensions);
    }

    private <T> void writeFixedArrayInternal(T val, int parcelableFlags, int index, int[] dimensions) {
        if (index >= dimensions.length) {
            throw new BadParcelableException("Array has more dimensions than expected: " + dimensions.length);
        }
        int length = dimensions[index];
        if (val == null) {
            throw new BadParcelableException("Non-null array shouldn't have a null array.");
        }
        if (!val.getClass().isArray()) {
            throw new BadParcelableException("Not an array: " + val);
        }
        if (Array.getLength(val) != length) {
            throw new BadParcelableException("bad length: expected " + length + ", but got " + Array.getLength(val));
        }
        Class<?> componentType = val.getClass().getComponentType();
        if (!componentType.isArray() && index + 1 != dimensions.length) {
            throw new BadParcelableException("Array has fewer dimensions than expected: " + dimensions.length);
        }
        if (componentType == Boolean.TYPE) {
            this.writeBooleanArray((boolean[])val);
        } else if (componentType == Byte.TYPE) {
            this.writeByteArray((byte[])val);
        } else if (componentType == Character.TYPE) {
            this.writeCharArray((char[])val);
        } else if (componentType == Integer.TYPE) {
            this.writeIntArray((int[])val);
        } else if (componentType == Long.TYPE) {
            this.writeLongArray((long[])val);
        } else if (componentType == Float.TYPE) {
            this.writeFloatArray((float[])val);
        } else if (componentType == Double.TYPE) {
            this.writeDoubleArray((double[])val);
        } else if (componentType == IBinder.class) {
            this.writeBinderArray((IBinder[])val);
        } else if (IInterface.class.isAssignableFrom(componentType)) {
            this.writeInterfaceArray((IInterface[])val);
        } else if (Parcelable.class.isAssignableFrom(componentType)) {
            this.writeTypedArray((Parcelable[])val, parcelableFlags);
        } else if (componentType.isArray()) {
            this.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeFixedArrayInternal(Array.get(val, i), parcelableFlags, index + 1, dimensions);
            }
        } else {
            throw new BadParcelableException("unknown type for fixed-size array: " + componentType);
        }
    }

    public void writeValue(Object v) {
        if (v instanceof LazyValue) {
            LazyValue value2 = (LazyValue)v;
            value2.writeToParcel(this);
            return;
        }
        int type = Parcel.getValueType(v);
        this.writeInt(type);
        if (this.isLengthPrefixed(type)) {
            int length = this.dataPosition();
            this.writeInt(-1);
            int start = this.dataPosition();
            this.writeValue(type, v);
            int end = this.dataPosition();
            this.setDataPosition(length);
            this.writeInt(end - start);
            this.setDataPosition(end);
        } else {
            this.writeValue(type, v);
        }
    }

    public static int getValueType(Object v) {
        if (v == null) {
            return -1;
        }
        if (v instanceof String) {
            return 0;
        }
        if (v instanceof Integer) {
            return 1;
        }
        if (v instanceof Map) {
            return 2;
        }
        if (v instanceof Bundle) {
            return 3;
        }
        if (v instanceof PersistableBundle) {
            return 25;
        }
        if (v instanceof SizeF) {
            return 27;
        }
        if (v instanceof Parcelable) {
            return 4;
        }
        if (v instanceof Short) {
            return 5;
        }
        if (v instanceof Long) {
            return 6;
        }
        if (v instanceof Float) {
            return 7;
        }
        if (v instanceof Double) {
            return 8;
        }
        if (v instanceof Boolean) {
            return 9;
        }
        if (v instanceof CharSequence) {
            return 10;
        }
        if (v instanceof List) {
            return 11;
        }
        if (v instanceof SparseArray) {
            return 12;
        }
        if (v instanceof boolean[]) {
            return 23;
        }
        if (v instanceof byte[]) {
            return 13;
        }
        if (v instanceof String[]) {
            return 14;
        }
        if (v instanceof CharSequence[]) {
            return 24;
        }
        if (v instanceof IBinder) {
            return 15;
        }
        if (v instanceof Parcelable[]) {
            return 16;
        }
        if (v instanceof int[]) {
            return 18;
        }
        if (v instanceof long[]) {
            return 19;
        }
        if (v instanceof Byte) {
            return 20;
        }
        if (v instanceof Size) {
            return 26;
        }
        if (v instanceof double[]) {
            return 28;
        }
        if (v instanceof Character) {
            return 29;
        }
        if (v instanceof short[]) {
            return 30;
        }
        if (v instanceof char[]) {
            return 31;
        }
        if (v instanceof float[]) {
            return 32;
        }
        Class<?> clazz = v.getClass();
        if (clazz.isArray() && clazz.getComponentType() == Object.class) {
            return 17;
        }
        if (v instanceof Serializable) {
            return 21;
        }
        throw new IllegalArgumentException("Parcel: unknown type for value " + v);
    }

    public void writeValue(int type, Object v) {
        switch (type) {
            case -1: {
                break;
            }
            case 0: {
                this.writeString((String)v);
                break;
            }
            case 1: {
                this.writeInt((Integer)v);
                break;
            }
            case 2: {
                this.writeMap((Map)v);
                break;
            }
            case 3: {
                this.writeBundle((Bundle)v);
                break;
            }
            case 25: {
                this.writePersistableBundle((PersistableBundle)v);
                break;
            }
            case 4: {
                this.writeParcelable((Parcelable)v, 0);
                break;
            }
            case 5: {
                this.writeInt(((Short)v).intValue());
                break;
            }
            case 6: {
                this.writeLong((Long)v);
                break;
            }
            case 7: {
                this.writeFloat(((Float)v).floatValue());
                break;
            }
            case 8: {
                this.writeDouble((Double)v);
                break;
            }
            case 9: {
                this.writeInt((Boolean)v != false ? 1 : 0);
                break;
            }
            case 10: {
                this.writeCharSequence((CharSequence)v);
                break;
            }
            case 11: {
                this.writeList((List)v);
                break;
            }
            case 12: {
                this.writeSparseArray((SparseArray)v);
                break;
            }
            case 23: {
                this.writeBooleanArray((boolean[])v);
                break;
            }
            case 13: {
                this.writeByteArray((byte[])v);
                break;
            }
            case 14: {
                this.writeStringArray((String[])v);
                break;
            }
            case 24: {
                this.writeCharSequenceArray((CharSequence[])v);
                break;
            }
            case 15: {
                this.writeStrongBinder((IBinder)v);
                break;
            }
            case 16: {
                this.writeParcelableArray((Parcelable[])v, 0);
                break;
            }
            case 18: {
                this.writeIntArray((int[])v);
                break;
            }
            case 19: {
                this.writeLongArray((long[])v);
                break;
            }
            case 20: {
                this.writeInt(((Byte)v).byteValue());
                break;
            }
            case 26: {
                this.writeSize((Size)v);
                break;
            }
            case 27: {
                this.writeSizeF((SizeF)v);
                break;
            }
            case 28: {
                this.writeDoubleArray((double[])v);
                break;
            }
            case 29: {
                this.writeInt(((Character)v).charValue());
                break;
            }
            case 30: {
                this.writeShortArray((short[])v);
                break;
            }
            case 31: {
                this.writeCharArray((char[])v);
                break;
            }
            case 32: {
                this.writeFloatArray((float[])v);
                break;
            }
            case 17: {
                this.writeArray((Object[])v);
                break;
            }
            case 21: {
                this.writeSerializable((Serializable)v);
                break;
            }
            default: {
                throw new RuntimeException("Parcel: unable to marshal value " + v);
            }
        }
    }

    public void writeParcelable(Parcelable p, int parcelableFlags) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        this.writeParcelableCreator(p);
        p.writeToParcel(this, parcelableFlags);
    }

    public void writeParcelableCreator(Parcelable p) {
        String name = p.getClass().getName();
        this.writeString(name);
    }

    private void ensureWrittenSquashableParcelables() {
        if (this.mWrittenSquashableParcelables != null) {
            return;
        }
        this.mWrittenSquashableParcelables = new ArrayMap();
    }

    public boolean allowSquashing() {
        boolean previous = this.mAllowSquashing;
        this.mAllowSquashing = true;
        return previous;
    }

    public void restoreAllowSquashing(boolean previous) {
        this.mAllowSquashing = previous;
        if (!this.mAllowSquashing) {
            this.mWrittenSquashableParcelables = null;
        }
    }

    private void resetSqaushingState() {
        if (this.mAllowSquashing) {
            Slog.wtf(TAG, "allowSquashing wasn't restored.");
        }
        this.mWrittenSquashableParcelables = null;
        this.mReadSquashableParcelables = null;
        this.mAllowSquashing = false;
    }

    private void ensureReadSquashableParcelables() {
        if (this.mReadSquashableParcelables != null) {
            return;
        }
        this.mReadSquashableParcelables = new SparseArray();
    }

    public boolean maybeWriteSquashed(Parcelable p) {
        if (!this.mAllowSquashing) {
            this.writeInt(0);
            return false;
        }
        this.ensureWrittenSquashableParcelables();
        Integer firstPos = this.mWrittenSquashableParcelables.get(p);
        if (firstPos != null) {
            int pos = this.dataPosition();
            this.writeInt(pos - firstPos + 4);
            return true;
        }
        this.writeInt(0);
        int pos = this.dataPosition();
        this.mWrittenSquashableParcelables.put(p, pos);
        return false;
    }

    public <T extends Parcelable> T readSquashed(SquashReadHelper<T> reader) {
        int offset2 = this.readInt();
        int pos = this.dataPosition();
        if (offset2 == 0) {
            Parcelable p = (Parcelable)reader.readRawParceled(this);
            this.ensureReadSquashableParcelables();
            this.mReadSquashableParcelables.put(pos, p);
            return (T)p;
        }
        int firstAbsolutePos = pos - offset2;
        Parcelable p = this.mReadSquashableParcelables.get(firstAbsolutePos);
        if (p == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mReadSquashableParcelables.size(); ++i) {
                sb.append(this.mReadSquashableParcelables.keyAt(i)).append(' ');
            }
            Slog.wtfStack(TAG, "Map doesn't contain offset " + firstAbsolutePos + " : contains=" + sb.toString());
        }
        return (T)p;
    }

    public void writeSerializable(Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new BadParcelableException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    public static void setStackTraceParceling(boolean enabled) {
        sParcelExceptionStackTrace = enabled;
    }

    public void writeException(Exception e) {
        long timeNow;
        AppOpsManager.prefixParcelWithAppOpsIfNeeded(this);
        int code = Parcel.getExceptionCode(e);
        this.writeInt(code);
        StrictMode.clearGatheredViolations();
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
        long l = timeNow = sParcelExceptionStackTrace ? SystemClock.elapsedRealtime() : 0L;
        if (sParcelExceptionStackTrace && timeNow - sLastWriteExceptionStackTrace > 1000L) {
            sLastWriteExceptionStackTrace = timeNow;
            this.writeStackTrace(e);
        } else {
            this.writeInt(0);
        }
        switch (code) {
            case -8: {
                this.writeInt(((ServiceSpecificException)e).errorCode);
                break;
            }
            case -9: {
                int sizePosition = this.dataPosition();
                this.writeInt(0);
                this.writeParcelable((Parcelable)((Object)e), 1);
                int payloadPosition = this.dataPosition();
                this.setDataPosition(sizePosition);
                this.writeInt(payloadPosition - sizePosition);
                this.setDataPosition(payloadPosition);
            }
        }
    }

    public static int getExceptionCode(Throwable e) {
        int code = 0;
        if (e instanceof Parcelable && e.getClass().getClassLoader() == Parcelable.class.getClassLoader()) {
            code = -9;
        } else if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        } else if (e instanceof NetworkOnMainThreadException) {
            code = -6;
        } else if (e instanceof UnsupportedOperationException) {
            code = -7;
        } else if (e instanceof ServiceSpecificException) {
            code = -8;
        }
        return code;
    }

    public void writeStackTrace(Throwable e) {
        int sizePosition = this.dataPosition();
        this.writeInt(0);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int truncatedSize = Math.min(stackTrace.length, 5);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < truncatedSize; ++i) {
            sb.append("\tat ").append(stackTrace[i]).append('\n');
        }
        this.writeString(sb.toString());
        int payloadPosition = this.dataPosition();
        this.setDataPosition(sizePosition);
        this.writeInt(payloadPosition - sizePosition);
        this.setDataPosition(payloadPosition);
    }

    public void writeNoException() {
        AppOpsManager.prefixParcelWithAppOpsIfNeeded(this);
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int sizePosition = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
    }

    public void readException() {
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            this.readException(code, msg);
        }
    }

    @UnsupportedAppUsage
    public int readExceptionCode() {
        int code = this.readInt();
        if (code == -127) {
            AppOpsManager.readAndLogNotedAppops(this);
            code = this.readInt();
        }
        if (code == -128) {
            int headerSize = this.readInt();
            if (headerSize == 0) {
                Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            } else {
                StrictMode.readAndHandleBinderCallViolations(this);
            }
            return 0;
        }
        return code;
    }

    public void readException(int code, String msg) {
        String remoteStackTrace = null;
        int remoteStackPayloadSize = this.readInt();
        if (remoteStackPayloadSize > 0) {
            remoteStackTrace = this.readString();
        }
        Exception e = this.createException(code, msg);
        if (remoteStackTrace != null) {
            RemoteException cause = new RemoteException("Remote stack trace:\n" + remoteStackTrace, null, false, false);
            ExceptionUtils.appendCause(e, cause);
        }
        SneakyThrow.sneakyThrow(e);
    }

    private Exception createException(int code, String msg) {
        Exception exception = this.createExceptionOrNull(code, msg);
        return exception != null ? exception : new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    public Exception createExceptionOrNull(int code, String msg) {
        switch (code) {
            case -9: {
                if (this.readInt() > 0) {
                    return (Exception)this.readParcelable(Parcelable.class.getClassLoader());
                }
                return new RuntimeException(msg + " [missing Parcelable]");
            }
            case -1: {
                return new SecurityException(msg);
            }
            case -2: {
                return new BadParcelableException(msg);
            }
            case -3: {
                return new IllegalArgumentException(msg);
            }
            case -4: {
                return new NullPointerException(msg);
            }
            case -5: {
                return new IllegalStateException(msg);
            }
            case -6: {
                return new NetworkOnMainThreadException();
            }
            case -7: {
                return new UnsupportedOperationException(msg);
            }
            case -8: {
                return new ServiceSpecificException(this.readInt(), msg);
            }
        }
        return null;
    }

    public int readInt() {
        return Parcel.nativeReadInt(this.mNativePtr);
    }

    public long readLong() {
        return Parcel.nativeReadLong(this.mNativePtr);
    }

    public float readFloat() {
        return Parcel.nativeReadFloat(this.mNativePtr);
    }

    public double readDouble() {
        return Parcel.nativeReadDouble(this.mNativePtr);
    }

    public String readString() {
        return this.readString16();
    }

    public String readString8() {
        return this.mReadWriteHelper.readString8(this);
    }

    public String readString16() {
        return this.mReadWriteHelper.readString16(this);
    }

    public String readStringNoHelper() {
        return this.readString16NoHelper();
    }

    public String readString8NoHelper() {
        return Parcel.nativeReadString8(this.mNativePtr);
    }

    public String readString16NoHelper() {
        return Parcel.nativeReadString16(this.mNativePtr);
    }

    public boolean readBoolean() {
        return this.readInt() != 0;
    }

    @UnsupportedAppUsage
    public CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public IBinder readStrongBinder() {
        IBinder result = Parcel.nativeReadStrongBinder(this.mNativePtr);
        if (result != null && this.hasFlags(3)) {
            Binder.allowBlocking(result);
        }
        return result;
    }

    public ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fd = Parcel.nativeReadFileDescriptor(this.mNativePtr);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    @UnsupportedAppUsage
    public FileDescriptor readRawFileDescriptor() {
        return Parcel.nativeReadFileDescriptor(this.mNativePtr);
    }

    public FileDescriptor[] createRawFileDescriptorArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        FileDescriptor[] f = new FileDescriptor[N];
        for (int i = 0; i < N; ++i) {
            f[i] = this.readRawFileDescriptor();
        }
        return f;
    }

    public void readRawFileDescriptorArray(FileDescriptor[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readRawFileDescriptor();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public byte readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    @Deprecated
    public void readMap(Map outVal, ClassLoader loader) {
        this.readMapInternal(outVal, loader, null, null);
    }

    public <K, V> void readMap(Map<? super K, ? super V> outVal, ClassLoader loader, Class<K> clazzKey, Class<V> clazzValue) {
        Objects.requireNonNull(clazzKey);
        Objects.requireNonNull(clazzValue);
        this.readMapInternal(outVal, loader, clazzKey, clazzValue);
    }

    @Deprecated
    public void readList(List outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readListInternal(outVal, N, loader, null);
    }

    public <T> void readList(List<? super T> outVal, ClassLoader loader, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        int n = this.readInt();
        this.readListInternal(outVal, n, loader, clazz);
    }

    @Deprecated
    public HashMap readHashMap(ClassLoader loader) {
        return this.readHashMapInternal(loader, null, null);
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public <K, V> HashMap<K, V> readHashMap(ClassLoader loader, Class<? extends K> clazzKey, Class<? extends V> clazzValue) {
        Objects.requireNonNull(clazzKey);
        Objects.requireNonNull(clazzValue);
        return this.readHashMapInternal(loader, clazzKey, clazzValue);
    }

    public Bundle readBundle() {
        return this.readBundle(null);
    }

    public Bundle readBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public PersistableBundle readPersistableBundle() {
        return this.readPersistableBundle(null);
    }

    public PersistableBundle readPersistableBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        PersistableBundle bundle = new PersistableBundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public Size readSize() {
        int width2 = this.readInt();
        int height2 = this.readInt();
        return new Size(width2, height2);
    }

    public SizeF readSizeF() {
        float width2 = this.readFloat();
        float height2 = this.readFloat();
        return new SizeF(width2, height2);
    }

    public byte[] createByteArray() {
        return Parcel.nativeCreateByteArray(this.mNativePtr);
    }

    public void readByteArray(byte[] val) {
        boolean valid = Parcel.nativeReadByteArray(this.mNativePtr, val, val != null ? val.length : 0);
        if (!valid) {
            throw new RuntimeException("bad array lengths");
        }
    }

    public byte[] readBlob() {
        return Parcel.nativeReadBlob(this.mNativePtr);
    }

    @UnsupportedAppUsage
    public String[] readStringArray() {
        return this.createString16Array();
    }

    public CharSequence[] readCharSequenceArray() {
        CharSequence[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new CharSequence[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readCharSequence();
            }
        }
        return array2;
    }

    public ArrayList<CharSequence> readCharSequenceList() {
        ArrayList<CharSequence> array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new ArrayList<CharSequence>(length);
            for (int i = 0; i < length; ++i) {
                array2.add(this.readCharSequence());
            }
        }
        return array2;
    }

    @Deprecated
    public ArrayList readArrayList(ClassLoader loader) {
        return this.readArrayListInternal(loader, null);
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public <T> ArrayList<T> readArrayList(ClassLoader loader, Class<? extends T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readArrayListInternal(loader, clazz);
    }

    @Deprecated
    public Object[] readArray(ClassLoader loader) {
        return this.readArrayInternal(loader, null);
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public <T> T[] readArray(ClassLoader loader, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readArrayInternal(loader, clazz);
    }

    @Deprecated
    public <T> SparseArray<T> readSparseArray(ClassLoader loader) {
        return this.readSparseArrayInternal(loader, null);
    }

    public <T> SparseArray<T> readSparseArray(ClassLoader loader, Class<? extends T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readSparseArrayInternal(loader, clazz);
    }

    public SparseBooleanArray readSparseBooleanArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(N);
        this.readSparseBooleanArrayInternal(sa, N);
        return sa;
    }

    public SparseIntArray readSparseIntArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseIntArray sa = new SparseIntArray(N);
        this.readSparseIntArrayInternal(sa, N);
        return sa;
    }

    public <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(N);
        while (N > 0) {
            l.add(this.readTypedObject(c));
            --N;
        }
        return l;
    }

    public <T> void readTypedList(List<T> list, Parcelable.Creator<T> c) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readTypedObject(c));
        }
        while (i < N) {
            list.add(this.readTypedObject(c));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public <T extends Parcelable> SparseArray<T> createTypedSparseArray(Parcelable.Creator<T> creator) {
        int count = this.readInt();
        if (count < 0) {
            return null;
        }
        SparseArray<Parcelable> array2 = new SparseArray<Parcelable>(count);
        for (int i = 0; i < count; ++i) {
            int index = this.readInt();
            Parcelable value2 = (Parcelable)this.readTypedObject(creator);
            array2.append(index, value2);
        }
        return array2;
    }

    public <T extends Parcelable> ArrayMap<String, T> createTypedArrayMap(Parcelable.Creator<T> creator) {
        int count = this.readInt();
        if (count < 0) {
            return null;
        }
        ArrayMap<String, Parcelable> map2 = new ArrayMap<String, Parcelable>(count);
        for (int i = 0; i < count; ++i) {
            String key = this.readString();
            Parcelable value2 = (Parcelable)this.readTypedObject(creator);
            map2.append(key, value2);
        }
        return map2;
    }

    public ArrayList<String> createStringArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(N);
        while (N > 0) {
            l.add(this.readString());
            --N;
        }
        return l;
    }

    public ArrayList<IBinder> createBinderArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IBinder> l = new ArrayList<IBinder>(N);
        while (N > 0) {
            l.add(this.readStrongBinder());
            --N;
        }
        return l;
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public <T extends IInterface> ArrayList<T> createInterfaceArrayList(Function<IBinder, T> asInterface) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IInterface> l = new ArrayList<IInterface>(N);
        while (N > 0) {
            l.add((IInterface)asInterface.apply(this.readStrongBinder()));
            --N;
        }
        return l;
    }

    public void readStringList(List<String> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readString());
        }
        while (i < N) {
            list.add(this.readString());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public void readBinderList(List<IBinder> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readStrongBinder());
        }
        while (i < N) {
            list.add(this.readStrongBinder());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public <T extends IInterface> void readInterfaceList(List<T> list, Function<IBinder, T> asInterface) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, (IInterface)asInterface.apply(this.readStrongBinder()));
        }
        while (i < N) {
            list.add((IInterface)asInterface.apply(this.readStrongBinder()));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    @Deprecated
    public <T extends Parcelable> List<T> readParcelableList(List<T> list, ClassLoader cl) {
        return this.readParcelableListInternal(list, cl, null);
    }

    public <T> List<T> readParcelableList(List<T> list, ClassLoader cl, Class<? extends T> clazz) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(clazz);
        return this.readParcelableListInternal(list, cl, clazz);
    }

    private <T> List<T> readParcelableListInternal(List<T> list, ClassLoader cl, Class<? extends T> clazz) {
        int i;
        int n = this.readInt();
        if (n == -1) {
            list.clear();
            return list;
        }
        int m = list.size();
        for (i = 0; i < m && i < n; ++i) {
            list.set(i, this.readParcelableInternal(cl, clazz));
        }
        while (i < n) {
            list.add(this.readParcelableInternal(cl, clazz));
            ++i;
        }
        while (i < m) {
            list.remove(n);
            ++i;
        }
        return list;
    }

    public <T> T[] createTypedArray(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        T[] l = c.newArray(N);
        for (int i = 0; i < N; ++i) {
            l[i] = this.readTypedObject(c);
        }
        return l;
    }

    public <T> void readTypedArray(T[] val, Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readTypedObject(c);
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    public <T> T[] readTypedArray(Parcelable.Creator<T> c) {
        return this.createTypedArray(c);
    }

    public <T> T readTypedObject(Parcelable.Creator<T> c) {
        if (this.readInt() != 0) {
            return c.createFromParcel(this);
        }
        return null;
    }

    public <T> void readFixedArray(T val) {
        Class<?> componentType = val.getClass().getComponentType();
        if (componentType == Boolean.TYPE) {
            this.readBooleanArray((boolean[])val);
        } else if (componentType == Byte.TYPE) {
            this.readByteArray((byte[])val);
        } else if (componentType == Character.TYPE) {
            this.readCharArray((char[])val);
        } else if (componentType == Integer.TYPE) {
            this.readIntArray((int[])val);
        } else if (componentType == Long.TYPE) {
            this.readLongArray((long[])val);
        } else if (componentType == Float.TYPE) {
            this.readFloatArray((float[])val);
        } else if (componentType == Double.TYPE) {
            this.readDoubleArray((double[])val);
        } else if (componentType == IBinder.class) {
            this.readBinderArray((IBinder[])val);
        } else if (componentType.isArray()) {
            int length = this.readInt();
            if (length != Array.getLength(val)) {
                throw new BadParcelableException("Bad length: expected " + Array.getLength(val) + ", but got " + length);
            }
            for (int i = 0; i < length; ++i) {
                this.readFixedArray(Array.get(val, i));
            }
        } else {
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
    }

    public <T, S extends IInterface> void readFixedArray(T val, Function<IBinder, S> asInterface) {
        Class<?> componentType = val.getClass().getComponentType();
        if (IInterface.class.isAssignableFrom(componentType)) {
            this.readInterfaceArray((IInterface[])val, asInterface);
        } else if (componentType.isArray()) {
            int length = this.readInt();
            if (length != Array.getLength(val)) {
                throw new BadParcelableException("Bad length: expected " + Array.getLength(val) + ", but got " + length);
            }
            for (int i = 0; i < length; ++i) {
                this.readFixedArray(Array.get(val, i), asInterface);
            }
        } else {
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
    }

    public <T, S extends Parcelable> void readFixedArray(T val, Parcelable.Creator<S> c) {
        Class<?> componentType = val.getClass().getComponentType();
        if (Parcelable.class.isAssignableFrom(componentType)) {
            this.readTypedArray((Parcelable[])val, c);
        } else if (componentType.isArray()) {
            int length = this.readInt();
            if (length != Array.getLength(val)) {
                throw new BadParcelableException("Bad length: expected " + Array.getLength(val) + ", but got " + length);
            }
            for (int i = 0; i < length; ++i) {
                this.readFixedArray(Array.get(val, i), c);
            }
        } else {
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
    }

    private void ensureClassHasExpectedDimensions(Class<?> cls, int numDimension) {
        if (numDimension <= 0) {
            throw new BadParcelableException("Fixed-size array should have dimensions.");
        }
        for (int i = 0; i < numDimension; ++i) {
            if (!cls.isArray()) {
                throw new BadParcelableException("Array has fewer dimensions than expected: " + numDimension);
            }
            cls = cls.getComponentType();
        }
        if (cls.isArray()) {
            throw new BadParcelableException("Array has more dimensions than expected: " + numDimension);
        }
    }

    public <T> T createFixedArray(Class<T> cls, int ... dimensions) {
        this.ensureClassHasExpectedDimensions(cls, dimensions.length);
        Object val = null;
        Class<?> componentType = cls.getComponentType();
        if (componentType == Boolean.TYPE) {
            val = this.createBooleanArray();
        } else if (componentType == Byte.TYPE) {
            val = this.createByteArray();
        } else if (componentType == Character.TYPE) {
            val = this.createCharArray();
        } else if (componentType == Integer.TYPE) {
            val = this.createIntArray();
        } else if (componentType == Long.TYPE) {
            val = this.createLongArray();
        } else if (componentType == Float.TYPE) {
            val = this.createFloatArray();
        } else if (componentType == Double.TYPE) {
            val = this.createDoubleArray();
        } else if (componentType == IBinder.class) {
            val = this.createBinderArray();
        } else {
            if (componentType.isArray()) {
                int length = this.readInt();
                if (length < 0) {
                    return null;
                }
                if (length != dimensions[0]) {
                    throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + length);
                }
                Class<?> innermost = componentType.getComponentType();
                while (innermost.isArray()) {
                    innermost = innermost.getComponentType();
                }
                val = Array.newInstance(innermost, dimensions);
                for (int i = 0; i < length; ++i) {
                    this.readFixedArray(Array.get(val, i));
                }
                return (T)val;
            }
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
        if (val != null && Array.getLength(val) != dimensions[0]) {
            throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + Array.getLength(val));
        }
        return (T)val;
    }

    public <T, S extends IInterface> T createFixedArray(Class<T> cls, Function<IBinder, S> asInterface, int ... dimensions) {
        this.ensureClassHasExpectedDimensions(cls, dimensions.length);
        Object val = null;
        Class<?> componentType = cls.getComponentType();
        if (!IInterface.class.isAssignableFrom(componentType)) {
            if (componentType.isArray()) {
                int length = this.readInt();
                if (length < 0) {
                    return null;
                }
                if (length != dimensions[0]) {
                    throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + length);
                }
                Class<?> innermost = componentType.getComponentType();
                while (innermost.isArray()) {
                    innermost = innermost.getComponentType();
                }
                val = Array.newInstance(innermost, dimensions);
                for (int i = 0; i < length; ++i) {
                    this.readFixedArray(Array.get(val, i), asInterface);
                }
                return (T)val;
            }
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
        val = this.createInterfaceArray(n -> (IInterface[])Array.newInstance(componentType, n), asInterface);
        if (val != null && Array.getLength(val) != dimensions[0]) {
            throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + Array.getLength(val));
        }
        return (T)val;
    }

    public <T, S extends Parcelable> T createFixedArray(Class<T> cls, Parcelable.Creator<S> c, int ... dimensions) {
        this.ensureClassHasExpectedDimensions(cls, dimensions.length);
        Object val = null;
        Class<?> componentType = cls.getComponentType();
        if (!Parcelable.class.isAssignableFrom(componentType)) {
            if (componentType.isArray()) {
                int length = this.readInt();
                if (length < 0) {
                    return null;
                }
                if (length != dimensions[0]) {
                    throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + length);
                }
                Class<?> innermost = componentType.getComponentType();
                while (innermost.isArray()) {
                    innermost = innermost.getComponentType();
                }
                val = Array.newInstance(innermost, dimensions);
                for (int i = 0; i < length; ++i) {
                    this.readFixedArray(Array.get(val, i), c);
                }
                return (T)val;
            }
            throw new BadParcelableException("Unknown type for fixed-size array: " + componentType);
        }
        val = this.createTypedArray(c);
        if (val != null && Array.getLength(val) != dimensions[0]) {
            throw new BadParcelableException("Bad length: expected " + dimensions[0] + ", but got " + Array.getLength(val));
        }
        return (T)val;
    }

    public <T extends Parcelable> void writeParcelableArray(T[] value2, int parcelableFlags) {
        if (value2 != null) {
            int N = value2.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeParcelable((Parcelable)value2[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public Object readValue(ClassLoader loader) {
        return this.readValue(loader, null, new Class[0]);
    }

    private <T> T readValue(ClassLoader loader, Class<T> clazz, Class<?> ... itemTypes) {
        T object;
        int type = this.readInt();
        if (this.isLengthPrefixed(type)) {
            int length = this.readInt();
            int start = this.dataPosition();
            object = this.readValue(type, loader, clazz, itemTypes);
            int actual = this.dataPosition() - start;
            if (actual != length) {
                Slog.wtfStack(TAG, "Unparcelling of " + object + " of type " + Parcel.valueTypeToString(type) + "  consumed " + actual + " bytes, but " + length + " expected.");
            }
        } else {
            object = this.readValue(type, loader, clazz, itemTypes);
        }
        return object;
    }

    public Object readLazyValue(ClassLoader loader) {
        int start = this.dataPosition();
        int type = this.readInt();
        if (this.isLengthPrefixed(type)) {
            int objectLength = this.readInt();
            if (objectLength < 0) {
                return null;
            }
            int end = MathUtils.addOrThrow(this.dataPosition(), objectLength);
            int valueLength = end - start;
            this.setDataPosition(end);
            return new LazyValue(this, start, valueLength, type, loader);
        }
        return this.readValue(type, loader, null);
    }

    private <T> T readValue(int type, ClassLoader loader, Class<T> clazz) {
        return this.readValue(type, loader, clazz, (Class[])null);
    }

    private <T> T readValue(int type, ClassLoader loader, Class<T> clazz, Class<?> ... itemTypes) {
        Object object;
        switch (type) {
            case -1: {
                object = null;
                break;
            }
            case 0: {
                object = this.readString();
                break;
            }
            case 1: {
                object = this.readInt();
                break;
            }
            case 2: {
                this.checkTypeToUnparcel(clazz, HashMap.class);
                Class<?> keyType = ArrayUtils.getOrNull(itemTypes, 0);
                Class<?> valueType = ArrayUtils.getOrNull(itemTypes, 1);
                Preconditions.checkArgument(keyType == null == (valueType == null));
                object = this.readHashMapInternal(loader, keyType, valueType);
                break;
            }
            case 4: {
                object = this.readParcelableInternal(loader, clazz);
                break;
            }
            case 5: {
                object = (short)this.readInt();
                break;
            }
            case 6: {
                object = this.readLong();
                break;
            }
            case 7: {
                object = Float.valueOf(this.readFloat());
                break;
            }
            case 8: {
                object = this.readDouble();
                break;
            }
            case 9: {
                object = this.readInt() == 1;
                break;
            }
            case 10: {
                object = this.readCharSequence();
                break;
            }
            case 11: {
                this.checkTypeToUnparcel(clazz, ArrayList.class);
                Class<?> itemType = ArrayUtils.getOrNull(itemTypes, 0);
                object = this.readArrayListInternal(loader, itemType);
                break;
            }
            case 23: {
                object = this.createBooleanArray();
                break;
            }
            case 13: {
                object = this.createByteArray();
                break;
            }
            case 14: {
                object = this.readStringArray();
                break;
            }
            case 24: {
                object = this.readCharSequenceArray();
                break;
            }
            case 15: {
                object = this.readStrongBinder();
                break;
            }
            case 17: {
                Class<?> itemType = ArrayUtils.getOrNull(itemTypes, 0);
                this.checkArrayTypeToUnparcel(clazz, itemType != null ? itemType : Object.class);
                object = this.readArrayInternal(loader, itemType);
                break;
            }
            case 18: {
                object = this.createIntArray();
                break;
            }
            case 19: {
                object = this.createLongArray();
                break;
            }
            case 20: {
                object = this.readByte();
                break;
            }
            case 21: {
                object = this.readSerializableInternal(loader, clazz);
                break;
            }
            case 16: {
                Class<?> itemType = ArrayUtils.getOrNull(itemTypes, 0);
                this.checkArrayTypeToUnparcel(clazz, itemType != null ? itemType : Parcelable.class);
                object = this.readParcelableArrayInternal(loader, itemType);
                break;
            }
            case 12: {
                this.checkTypeToUnparcel(clazz, SparseArray.class);
                Class<?> itemType = ArrayUtils.getOrNull(itemTypes, 0);
                object = this.readSparseArrayInternal(loader, itemType);
                break;
            }
            case 22: {
                object = this.readSparseBooleanArray();
                break;
            }
            case 3: {
                object = this.readBundle(loader);
                break;
            }
            case 25: {
                object = this.readPersistableBundle(loader);
                break;
            }
            case 26: {
                object = this.readSize();
                break;
            }
            case 27: {
                object = this.readSizeF();
                break;
            }
            case 28: {
                object = this.createDoubleArray();
                break;
            }
            case 29: {
                object = Character.valueOf((char)this.readInt());
                break;
            }
            case 30: {
                object = this.createShortArray();
                break;
            }
            case 31: {
                object = this.createCharArray();
                break;
            }
            case 32: {
                object = this.createFloatArray();
                break;
            }
            default: {
                int off = this.dataPosition() - 4;
                throw new BadParcelableException("Parcel " + this + ": Unmarshalling unknown type code " + type + " at offset " + off);
            }
        }
        if (object != null && clazz != null && !clazz.isInstance(object)) {
            throw new BadTypeParcelableException("Unparcelled object " + object + " is not an instance of required class " + clazz.getName() + " provided in the parameter");
        }
        return (T)object;
    }

    private boolean isLengthPrefixed(int type) {
        switch (type) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    private void checkArrayTypeToUnparcel(Class<?> requiredArrayType, Class<?> componentTypeToUnparcel) {
        if (requiredArrayType != null) {
            Class<?> requiredComponentType = requiredArrayType.getComponentType();
            if (requiredComponentType == null) {
                throw new BadTypeParcelableException("About to unparcel an array but type " + requiredArrayType.getCanonicalName() + " required by caller is not an array.");
            }
            this.checkTypeToUnparcel(requiredComponentType, componentTypeToUnparcel);
        }
    }

    private void checkTypeToUnparcel(Class<?> requiredType, Class<?> typeToUnparcel) {
        if (requiredType != null && !requiredType.isAssignableFrom(typeToUnparcel)) {
            throw new BadTypeParcelableException("About to unparcel a " + typeToUnparcel.getCanonicalName() + ", which is not a subtype of type " + requiredType.getCanonicalName() + " required by caller.");
        }
    }

    @Deprecated
    public <T extends Parcelable> T readParcelable(ClassLoader loader) {
        return (T)((Parcelable)this.readParcelableInternal(loader, null));
    }

    public <T> T readParcelable(ClassLoader loader, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readParcelableInternal(loader, clazz);
    }

    private <T> T readParcelableInternal(ClassLoader loader, Class<T> clazz) {
        Parcelable.Creator<T> creator = this.readParcelableCreatorInternal(loader, clazz);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(this, loader);
        }
        return creator.createFromParcel(this);
    }

    @UnsupportedAppUsage
    public <T extends Parcelable> T readCreator(Parcelable.Creator<?> creator, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    @Deprecated
    public Parcelable.Creator<?> readParcelableCreator(ClassLoader loader) {
        return this.readParcelableCreatorInternal(loader, null);
    }

    public <T> Parcelable.Creator<T> readParcelableCreator(ClassLoader loader, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readParcelableCreatorInternal(loader, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Parcelable.Creator<T> readParcelableCreatorInternal(ClassLoader loader, Class<T> clazz) {
        Parcelable.Creator creator;
        HashMap<String, Parcelable.Creator<Object>> map2;
        String name = this.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> hashMap = mCreators;
        synchronized (hashMap) {
            map2 = mCreators.get(loader);
            if (map2 == null) {
                map2 = new HashMap();
                mCreators.put(loader, map2);
            }
            creator = map2.get(name);
        }
        if (creator != null) {
            Class<?> parcelableClass;
            if (clazz != null && !clazz.isAssignableFrom(parcelableClass = creator.getClass().getEnclosingClass())) {
                throw new BadTypeParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            return creator;
        }
        try {
            ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
            Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
            if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                throw new BadParcelableException("Parcelable protocol requires subclassing from Parcelable on class " + name);
            }
            if (clazz != null && !clazz.isAssignableFrom(parcelableClass)) {
                throw new BadTypeParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            Field f = parcelableClass.getField("CREATOR");
            if ((f.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            Class<?> creatorType = f.getType();
            if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f.get(null);
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Illegal access when unmarshalling: " + name, e);
            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name, e);
        }
        catch (ClassNotFoundException e) {
            Log.e(TAG, "Class not found when unmarshalling: " + name, e);
            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name, e);
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name, e);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        hashMap = mCreators;
        synchronized (hashMap) {
            map2.put(name, creator);
        }
        return creator;
    }

    @Deprecated
    public Parcelable[] readParcelableArray(ClassLoader loader) {
        return (Parcelable[])this.readParcelableArrayInternal(loader, null);
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public <T> T[] readParcelableArray(ClassLoader loader, Class<T> clazz) {
        return this.readParcelableArrayInternal(loader, Objects.requireNonNull(clazz));
    }

    private <T> T[] readParcelableArrayInternal(ClassLoader loader, Class<T> clazz) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Object[] p = (Object[])(clazz == null ? new Parcelable[n] : Array.newInstance(clazz, n));
        for (int i = 0; i < n; ++i) {
            p[i] = this.readParcelableInternal(loader, clazz);
        }
        return p;
    }

    @Deprecated
    public Serializable readSerializable() {
        return (Serializable)this.readSerializableInternal(null, null);
    }

    public <T> T readSerializable(ClassLoader loader, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.readSerializableInternal(loader == null ? this.getClass().getClassLoader() : loader, clazz);
    }

    private <T> T readSerializableInternal(final ClassLoader loader, Class<T> clazz) {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        try {
            Class<?> cl;
            if (clazz != null && loader != null && !clazz.isAssignableFrom(cl = Class.forName(name, false, loader))) {
                throw new BadTypeParcelableException("Serializable object " + cl.getName() + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            byte[] serializedData = this.createByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
            ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                    if (loader != null) {
                        Class<?> c = Class.forName(osClass.getName(), false, loader);
                        return Objects.requireNonNull(c);
                    }
                    return super.resolveClass(osClass);
                }
            };
            Object object = ois.readObject();
            if (clazz != null && loader == null && !clazz.isAssignableFrom(object.getClass())) {
                throw new BadTypeParcelableException("Serializable object " + object.getClass().getName() + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            return (T)object;
        }
        catch (IOException ioe) {
            throw new BadParcelableException("Parcelable encountered IOException reading a Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BadParcelableException("Parcelable encountered ClassNotFoundException reading a Serializable object (name = " + name + ")", cnfe);
        }
    }

    protected static Parcel obtain(int obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Parcel obtain(long obj) {
        Parcel res = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sHolderPool != null) {
                res = sHolderPool;
                sHolderPool = res.mPoolNext;
                res.mPoolNext = null;
                --sHolderPoolSize;
            }
        }
        if (res == null) {
            res = new Parcel(obj);
        } else {
            res.init(obj);
        }
        return res;
    }

    private Parcel(long nativePtr) {
        this.init(nativePtr);
    }

    private void init(long nativePtr) {
        if (nativePtr != 0L) {
            this.mNativePtr = nativePtr;
            this.mOwnsNativeParcelObject = false;
        } else {
            this.mNativePtr = Parcel.nativeCreate();
            this.mOwnsNativeParcelObject = true;
        }
    }

    private void freeBuffer() {
        this.mFlags = 0;
        this.resetSqaushingState();
        if (this.mOwnsNativeParcelObject) {
            Parcel.nativeFreeBuffer(this.mNativePtr);
        }
        this.mReadWriteHelper = ReadWriteHelper.DEFAULT;
    }

    private void destroy() {
        this.resetSqaushingState();
        if (this.mNativePtr != 0L) {
            if (this.mOwnsNativeParcelObject) {
                Parcel.nativeDestroy(this.mNativePtr);
            }
            this.mNativePtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    void readMapInternal(Map outVal, int n, ClassLoader loader) {
        this.readMapInternal(outVal, n, loader, null, null);
    }

    private <K, V> HashMap<K, V> readHashMapInternal(ClassLoader loader, Class<? extends K> clazzKey, Class<? extends V> clazzValue) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        HashMap map2 = new HashMap(n);
        this.readMapInternal(map2, n, loader, clazzKey, clazzValue);
        return map2;
    }

    private <K, V> void readMapInternal(Map<? super K, ? super V> outVal, ClassLoader loader, Class<K> clazzKey, Class<V> clazzValue) {
        int n = this.readInt();
        this.readMapInternal(outVal, n, loader, clazzKey, clazzValue);
    }

    private <K, V> void readMapInternal(Map<? super K, ? super V> outVal, int n, ClassLoader loader, Class<K> clazzKey, Class<V> clazzValue) {
        while (n > 0) {
            K key = this.readValue(loader, clazzKey, new Class[0]);
            V value2 = this.readValue(loader, clazzValue, new Class[0]);
            outVal.put(key, value2);
            --n;
        }
    }

    private void readArrayMapInternal(ArrayMap<? super String, Object> outVal, int size, ClassLoader loader) {
        this.readArrayMap(outVal, size, true, false, loader);
    }

    boolean readArrayMap(ArrayMap<? super String, Object> map2, int size, boolean sorted, boolean lazy, ClassLoader loader) {
        boolean recycle = true;
        while (size > 0) {
            Object value2;
            String key = this.readString();
            Object object = value2 = lazy ? this.readLazyValue(loader) : this.readValue(loader);
            if (value2 instanceof LazyValue) {
                recycle = false;
            }
            if (sorted) {
                map2.append(key, value2);
            } else {
                map2.put(key, value2);
            }
            --size;
        }
        if (sorted) {
            map2.validate();
        }
        return recycle;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void readArrayMap(ArrayMap<? super String, Object> outVal, ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return;
        }
        this.readArrayMapInternal(outVal, N, loader);
    }

    @UnsupportedAppUsage
    public ArraySet<? extends Object> readArraySet(ClassLoader loader) {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        ArraySet<Object> result = new ArraySet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object value2 = this.readValue(loader);
            result.append(value2);
        }
        return result;
    }

    private void readListInternal(List outVal, int n, ClassLoader loader) {
        this.readListInternal(outVal, n, loader, null);
    }

    private <T> void readListInternal(List<? super T> outVal, int n, ClassLoader loader, Class<T> clazz) {
        while (n > 0) {
            T value2 = this.readValue(loader, clazz, new Class[0]);
            outVal.add(value2);
            --n;
        }
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    private <T> ArrayList<T> readArrayListInternal(ClassLoader loader, Class<? extends T> clazz) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList l = new ArrayList(n);
        this.readListInternal(l, n, loader, clazz);
        return l;
    }

    private void readArrayInternal(Object[] outVal, int N, ClassLoader loader) {
        for (int i = 0; i < N; ++i) {
            Object value2 = this.readValue(loader, null, new Class[0]);
            outVal[i] = value2;
        }
    }

    private <T> T[] readArrayInternal(ClassLoader loader, Class<T> clazz) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Object outVal = clazz == null ? new Object[n] : Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            T value2 = this.readValue(loader, clazz, new Class[0]);
            outVal[i] = value2;
        }
        return outVal;
    }

    private void readSparseArrayInternal(SparseArray outVal, int N, ClassLoader loader) {
        while (N > 0) {
            int key = this.readInt();
            Object value2 = this.readValue(loader);
            outVal.append(key, value2);
            --N;
        }
    }

    private <T> SparseArray<T> readSparseArrayInternal(ClassLoader loader, Class<? extends T> clazz) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseArray<T> outVal = new SparseArray<T>(n);
        while (n > 0) {
            int key = this.readInt();
            T value2 = this.readValue(loader, clazz, new Class[0]);
            outVal.append(key, value2);
            --n;
        }
        return outVal;
    }

    private void readSparseBooleanArrayInternal(SparseBooleanArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            boolean value2 = this.readByte() == 1;
            outVal.append(key, value2);
            --N;
        }
    }

    private void readSparseIntArrayInternal(SparseIntArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            int value2 = this.readInt();
            outVal.append(key, value2);
            --N;
        }
    }

    public long getOpenAshmemSize() {
        return Parcel.nativeGetOpenAshmemSize(this.mNativePtr);
    }

    private static String valueTypeToString(int type) {
        switch (type) {
            case -1: {
                return "VAL_NULL";
            }
            case 1: {
                return "VAL_INTEGER";
            }
            case 2: {
                return "VAL_MAP";
            }
            case 3: {
                return "VAL_BUNDLE";
            }
            case 25: {
                return "VAL_PERSISTABLEBUNDLE";
            }
            case 4: {
                return "VAL_PARCELABLE";
            }
            case 5: {
                return "VAL_SHORT";
            }
            case 6: {
                return "VAL_LONG";
            }
            case 7: {
                return "VAL_FLOAT";
            }
            case 8: {
                return "VAL_DOUBLE";
            }
            case 9: {
                return "VAL_BOOLEAN";
            }
            case 10: {
                return "VAL_CHARSEQUENCE";
            }
            case 11: {
                return "VAL_LIST";
            }
            case 12: {
                return "VAL_SPARSEARRAY";
            }
            case 23: {
                return "VAL_BOOLEANARRAY";
            }
            case 13: {
                return "VAL_BYTEARRAY";
            }
            case 14: {
                return "VAL_STRINGARRAY";
            }
            case 24: {
                return "VAL_CHARSEQUENCEARRAY";
            }
            case 15: {
                return "VAL_IBINDER";
            }
            case 16: {
                return "VAL_PARCELABLEARRAY";
            }
            case 18: {
                return "VAL_INTARRAY";
            }
            case 19: {
                return "VAL_LONGARRAY";
            }
            case 20: {
                return "VAL_BYTE";
            }
            case 26: {
                return "VAL_SIZE";
            }
            case 27: {
                return "VAL_SIZEF";
            }
            case 28: {
                return "VAL_DOUBLEARRAY";
            }
            case 29: {
                return "VAL_CHAR";
            }
            case 30: {
                return "VAL_SHORTARRAY";
            }
            case 31: {
                return "VAL_CHARARRAY";
            }
            case 32: {
                return "VAL_FLOATARRAY";
            }
            case 17: {
                return "VAL_OBJECTARRAY";
            }
            case 21: {
                return "VAL_SERIALIZABLE";
            }
        }
        return "UNKNOWN(" + type + ")";
    }

    static {
        sPoolSync = new Object();
        sOwnedPoolSize = 0;
        sHolderPoolSize = 0;
        STRING_CREATOR = new Parcelable.Creator<String>(){

            @Override
            public String createFromParcel(Parcel source) {
                return source.readString();
            }

            public String[] newArray(int size) {
                return new String[size];
            }
        };
        mCreators = new HashMap();
    }

    private static class LazyValue
    implements BiFunction<Class<?>, Class<?>[], Object> {
        private final int mPosition;
        private final int mLength;
        private final int mType;
        private final ClassLoader mLoader;
        private Object mObject;
        private volatile Parcel mSource;

        LazyValue(Parcel source, int position, int length, int type, ClassLoader loader) {
            this.mSource = Objects.requireNonNull(source);
            this.mPosition = position;
            this.mLength = length;
            this.mType = type;
            this.mLoader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object apply(Class<?> clazz, Class<?>[] itemTypes) {
            Parcel source = this.mSource;
            if (source != null) {
                Parcel parcel = source;
                synchronized (parcel) {
                    if (this.mSource != null) {
                        int restore = source.dataPosition();
                        try {
                            source.setDataPosition(this.mPosition);
                            this.mObject = source.readValue(this.mLoader, clazz, itemTypes);
                        }
                        finally {
                            source.setDataPosition(restore);
                        }
                        this.mSource = null;
                    }
                }
            }
            return this.mObject;
        }

        public void writeToParcel(Parcel out) {
            Parcel source = this.mSource;
            if (source != null) {
                out.appendFrom(source, this.mPosition, this.mLength);
            } else {
                out.writeValue(this.mObject);
            }
        }

        public boolean hasFileDescriptors() {
            Parcel source = this.mSource;
            return source != null ? source.hasFileDescriptors(this.mPosition, this.mLength) : Parcel.hasFileDescriptors(this.mObject);
        }

        public String toString() {
            return this.mSource != null ? "Supplier{" + Parcel.valueTypeToString(this.mType) + "@" + this.mPosition + "+" + this.mLength + '}' : "Supplier{" + this.mObject + "}";
        }

        public boolean equals(Object other) {
            Parcel otherSource;
            if (this == other) {
                return true;
            }
            if (!(other instanceof LazyValue)) {
                return false;
            }
            LazyValue value2 = (LazyValue)other;
            Parcel source = this.mSource;
            if (source == null != ((otherSource = value2.mSource) == null)) {
                return false;
            }
            if (source == null) {
                return Objects.equals(this.mObject, value2.mObject);
            }
            if (!Objects.equals(this.mLoader, value2.mLoader)) {
                return false;
            }
            if (this.mType != value2.mType || this.mLength != value2.mLength) {
                return false;
            }
            return Parcel.compareData(source, this.mPosition, otherSource, value2.mPosition, this.mLength);
        }

        public int hashCode() {
            return Objects.hash(this.mSource == null, this.mObject, this.mLoader, this.mType, this.mLength);
        }
    }

    public static interface SquashReadHelper<T> {
        public T readRawParceled(Parcel var1);
    }

    public static class ReadWriteHelper {
        public static final ReadWriteHelper DEFAULT = new ReadWriteHelper();

        @UnsupportedAppUsage
        public ReadWriteHelper() {
        }

        public void writeString8(Parcel p, String s) {
            p.writeString8NoHelper(s);
        }

        public void writeString16(Parcel p, String s) {
            p.writeString16NoHelper(s);
        }

        public String readString8(Parcel p) {
            return p.readString8NoHelper();
        }

        public String readString16(Parcel p) {
            return p.readString16NoHelper();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParcelFlags {
    }
}

