/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import java.util.ArrayList;

public class PerformanceCollector {
    public static final String METRIC_KEY_ITERATIONS = "iterations";
    public static final String METRIC_KEY_LABEL = "label";
    public static final String METRIC_KEY_CPU_TIME = "cpu_time";
    public static final String METRIC_KEY_EXECUTION_TIME = "execution_time";
    public static final String METRIC_KEY_PRE_RECEIVED_TRANSACTIONS = "pre_received_transactions";
    public static final String METRIC_KEY_PRE_SENT_TRANSACTIONS = "pre_sent_transactions";
    public static final String METRIC_KEY_RECEIVED_TRANSACTIONS = "received_transactions";
    public static final String METRIC_KEY_SENT_TRANSACTIONS = "sent_transactions";
    public static final String METRIC_KEY_GC_INVOCATION_COUNT = "gc_invocation_count";
    public static final String METRIC_KEY_JAVA_ALLOCATED = "java_allocated";
    public static final String METRIC_KEY_JAVA_FREE = "java_free";
    public static final String METRIC_KEY_JAVA_PRIVATE_DIRTY = "java_private_dirty";
    public static final String METRIC_KEY_JAVA_PSS = "java_pss";
    public static final String METRIC_KEY_JAVA_SHARED_DIRTY = "java_shared_dirty";
    public static final String METRIC_KEY_JAVA_SIZE = "java_size";
    public static final String METRIC_KEY_NATIVE_ALLOCATED = "native_allocated";
    public static final String METRIC_KEY_NATIVE_FREE = "native_free";
    public static final String METRIC_KEY_NATIVE_PRIVATE_DIRTY = "native_private_dirty";
    public static final String METRIC_KEY_NATIVE_PSS = "native_pss";
    public static final String METRIC_KEY_NATIVE_SHARED_DIRTY = "native_shared_dirty";
    public static final String METRIC_KEY_NATIVE_SIZE = "native_size";
    public static final String METRIC_KEY_GLOBAL_ALLOC_COUNT = "global_alloc_count";
    public static final String METRIC_KEY_GLOBAL_ALLOC_SIZE = "global_alloc_size";
    public static final String METRIC_KEY_GLOBAL_FREED_COUNT = "global_freed_count";
    public static final String METRIC_KEY_GLOBAL_FREED_SIZE = "global_freed_size";
    public static final String METRIC_KEY_OTHER_PRIVATE_DIRTY = "other_private_dirty";
    public static final String METRIC_KEY_OTHER_PSS = "other_pss";
    public static final String METRIC_KEY_OTHER_SHARED_DIRTY = "other_shared_dirty";
    private PerformanceResultsWriter mPerfWriter;
    private Bundle mPerfSnapshot;
    private Bundle mPerfMeasurement;
    private long mSnapshotCpuTime;
    private long mSnapshotExecTime;
    private long mCpuTime;
    private long mExecTime;

    @UnsupportedAppUsage
    public PerformanceCollector() {
    }

    public PerformanceCollector(PerformanceResultsWriter writer) {
        this.setPerformanceResultsWriter(writer);
    }

    public void setPerformanceResultsWriter(PerformanceResultsWriter writer) {
        this.mPerfWriter = writer;
    }

    @UnsupportedAppUsage
    public void beginSnapshot(String label) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeBeginSnapshot(label);
        }
        this.startPerformanceSnapshot();
    }

    @UnsupportedAppUsage
    public Bundle endSnapshot() {
        this.endPerformanceSnapshot();
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeEndSnapshot(this.mPerfSnapshot);
        }
        return this.mPerfSnapshot;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void startTiming(String label) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeStartTiming(label);
        }
        this.mPerfMeasurement = new Bundle();
        this.mPerfMeasurement.putParcelableArrayList(METRIC_KEY_ITERATIONS, new ArrayList());
        this.mExecTime = SystemClock.uptimeMillis();
        this.mCpuTime = Process.getElapsedCpuTime();
    }

    public Bundle addIteration(String label) {
        this.mCpuTime = Process.getElapsedCpuTime() - this.mCpuTime;
        this.mExecTime = SystemClock.uptimeMillis() - this.mExecTime;
        Bundle iteration = new Bundle();
        iteration.putString(METRIC_KEY_LABEL, label);
        iteration.putLong(METRIC_KEY_EXECUTION_TIME, this.mExecTime);
        iteration.putLong(METRIC_KEY_CPU_TIME, this.mCpuTime);
        this.mPerfMeasurement.getParcelableArrayList(METRIC_KEY_ITERATIONS).add(iteration);
        this.mExecTime = SystemClock.uptimeMillis();
        this.mCpuTime = Process.getElapsedCpuTime();
        return iteration;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Bundle stopTiming(String label) {
        this.addIteration(label);
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeStopTiming(this.mPerfMeasurement);
        }
        return this.mPerfMeasurement;
    }

    public void addMeasurement(String label, long value2) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value2);
        }
    }

    public void addMeasurement(String label, float value2) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value2);
        }
    }

    public void addMeasurement(String label, String value2) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value2);
        }
    }

    private void startPerformanceSnapshot() {
        this.mPerfSnapshot = new Bundle();
        Bundle binderCounts = PerformanceCollector.getBinderCounts();
        for (String key : binderCounts.keySet()) {
            this.mPerfSnapshot.putLong("pre_" + key, binderCounts.getLong(key));
        }
        PerformanceCollector.startAllocCounting();
        this.mSnapshotExecTime = SystemClock.uptimeMillis();
        this.mSnapshotCpuTime = Process.getElapsedCpuTime();
    }

    private void endPerformanceSnapshot() {
        this.mSnapshotCpuTime = Process.getElapsedCpuTime() - this.mSnapshotCpuTime;
        this.mSnapshotExecTime = SystemClock.uptimeMillis() - this.mSnapshotExecTime;
        PerformanceCollector.stopAllocCounting();
        long nativeMax = Debug.getNativeHeapSize() / 1024L;
        long nativeAllocated = Debug.getNativeHeapAllocatedSize() / 1024L;
        long nativeFree = Debug.getNativeHeapFreeSize() / 1024L;
        Debug.MemoryInfo memInfo = new Debug.MemoryInfo();
        Debug.getMemoryInfo(memInfo);
        Runtime runtime = Runtime.getRuntime();
        long dalvikMax = runtime.totalMemory() / 1024L;
        long dalvikFree = runtime.freeMemory() / 1024L;
        long dalvikAllocated = dalvikMax - dalvikFree;
        Bundle binderCounts = PerformanceCollector.getBinderCounts();
        for (String key : binderCounts.keySet()) {
            this.mPerfSnapshot.putLong(key, binderCounts.getLong(key));
        }
        Bundle allocCounts = PerformanceCollector.getAllocCounts();
        for (String key : allocCounts.keySet()) {
            this.mPerfSnapshot.putLong(key, allocCounts.getLong(key));
        }
        this.mPerfSnapshot.putLong(METRIC_KEY_EXECUTION_TIME, this.mSnapshotExecTime);
        this.mPerfSnapshot.putLong(METRIC_KEY_CPU_TIME, this.mSnapshotCpuTime);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_SIZE, nativeMax);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_ALLOCATED, nativeAllocated);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_FREE, nativeFree);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_PSS, memInfo.nativePss);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_PRIVATE_DIRTY, memInfo.nativePrivateDirty);
        this.mPerfSnapshot.putLong(METRIC_KEY_NATIVE_SHARED_DIRTY, memInfo.nativeSharedDirty);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_SIZE, dalvikMax);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_ALLOCATED, dalvikAllocated);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_FREE, dalvikFree);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_PSS, memInfo.dalvikPss);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_PRIVATE_DIRTY, memInfo.dalvikPrivateDirty);
        this.mPerfSnapshot.putLong(METRIC_KEY_JAVA_SHARED_DIRTY, memInfo.dalvikSharedDirty);
        this.mPerfSnapshot.putLong(METRIC_KEY_OTHER_PSS, memInfo.otherPss);
        this.mPerfSnapshot.putLong(METRIC_KEY_OTHER_PRIVATE_DIRTY, memInfo.otherPrivateDirty);
        this.mPerfSnapshot.putLong(METRIC_KEY_OTHER_SHARED_DIRTY, memInfo.otherSharedDirty);
    }

    private static void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    private static void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    private static Bundle getAllocCounts() {
        Bundle results = new Bundle();
        results.putLong(METRIC_KEY_GLOBAL_ALLOC_COUNT, Debug.getGlobalAllocCount());
        results.putLong(METRIC_KEY_GLOBAL_ALLOC_SIZE, Debug.getGlobalAllocSize());
        results.putLong(METRIC_KEY_GLOBAL_FREED_COUNT, Debug.getGlobalFreedCount());
        results.putLong(METRIC_KEY_GLOBAL_FREED_SIZE, Debug.getGlobalFreedSize());
        results.putLong(METRIC_KEY_GC_INVOCATION_COUNT, Debug.getGlobalGcInvocationCount());
        return results;
    }

    private static Bundle getBinderCounts() {
        Bundle results = new Bundle();
        results.putLong(METRIC_KEY_SENT_TRANSACTIONS, Debug.getBinderSentTransactions());
        results.putLong(METRIC_KEY_RECEIVED_TRANSACTIONS, Debug.getBinderReceivedTransactions());
        return results;
    }

    public static interface PerformanceResultsWriter {
        public void writeBeginSnapshot(String var1);

        public void writeEndSnapshot(Bundle var1);

        public void writeStartTiming(String var1);

        public void writeStopTiming(Bundle var1);

        public void writeMeasurement(String var1, long var2);

        public void writeMeasurement(String var1, float var2);

        public void writeMeasurement(String var1, String var2);
    }
}

