/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;

public class PowerSaveState
implements Parcelable {
    public final boolean batterySaverEnabled;
    public final boolean globalBatterySaverEnabled;
    public final int locationMode;
    public final int soundTriggerMode;
    public final float brightnessFactor;
    public static final Parcelable.Creator<PowerSaveState> CREATOR = new Parcelable.Creator<PowerSaveState>(){

        @Override
        public PowerSaveState createFromParcel(Parcel source) {
            return new PowerSaveState(source);
        }

        public PowerSaveState[] newArray(int size) {
            return new PowerSaveState[size];
        }
    };

    public PowerSaveState(Builder builder2) {
        this.batterySaverEnabled = builder2.mBatterySaverEnabled;
        this.locationMode = builder2.mLocationMode;
        this.soundTriggerMode = builder2.mSoundTriggerMode;
        this.brightnessFactor = builder2.mBrightnessFactor;
        this.globalBatterySaverEnabled = builder2.mGlobalBatterySaverEnabled;
    }

    public PowerSaveState(Parcel in) {
        this.batterySaverEnabled = in.readByte() != 0;
        this.globalBatterySaverEnabled = in.readByte() != 0;
        this.locationMode = in.readInt();
        this.soundTriggerMode = in.readInt();
        this.brightnessFactor = in.readFloat();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.batterySaverEnabled ? 1 : 0));
        dest.writeByte((byte)(this.globalBatterySaverEnabled ? 1 : 0));
        dest.writeInt(this.locationMode);
        dest.writeInt(this.soundTriggerMode);
        dest.writeFloat(this.brightnessFactor);
    }

    public static class Builder {
        private boolean mBatterySaverEnabled = false;
        private boolean mGlobalBatterySaverEnabled = false;
        private int mLocationMode = 0;
        private int mSoundTriggerMode = 0;
        private float mBrightnessFactor = 0.5f;

        public Builder setBatterySaverEnabled(boolean enabled) {
            this.mBatterySaverEnabled = enabled;
            return this;
        }

        public Builder setGlobalBatterySaverEnabled(boolean enabled) {
            this.mGlobalBatterySaverEnabled = enabled;
            return this;
        }

        public Builder setSoundTriggerMode(int mode) {
            this.mSoundTriggerMode = mode;
            return this;
        }

        public Builder setLocationMode(int mode) {
            this.mLocationMode = mode;
            return this;
        }

        public Builder setBrightnessFactor(float factor) {
            this.mBrightnessFactor = factor;
            return this;
        }

        public PowerSaveState build() {
            return new PowerSaveState(this);
        }
    }
}

