/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.PowerComponents;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParserException;

public class UidBatteryConsumer
extends BatteryConsumer {
    static final int CONSUMER_TYPE_UID = 1;
    public static final int STATE_FOREGROUND = 0;
    public static final int STATE_BACKGROUND = 1;
    static final int COLUMN_INDEX_UID = 1;
    static final int COLUMN_INDEX_PACKAGE_WITH_HIGHEST_DRAIN = 2;
    static final int COLUMN_INDEX_TIME_IN_FOREGROUND = 3;
    static final int COLUMN_INDEX_TIME_IN_BACKGROUND = 4;
    static final int COLUMN_COUNT = 5;

    UidBatteryConsumer(BatteryConsumer.BatteryConsumerData data) {
        super(data);
    }

    private UidBatteryConsumer(Builder builder2) {
        super(builder2.mData, builder2.mPowerComponentsBuilder.build());
    }

    public int getUid() {
        return this.mData.getInt(1);
    }

    public String getPackageWithHighestDrain() {
        return this.mData.getString(2);
    }

    public long getTimeInStateMs(int state) {
        switch (state) {
            case 1: {
                return this.mData.getInt(4);
            }
            case 0: {
                return this.mData.getInt(3);
            }
        }
        return 0L;
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        pw.print("UID ");
        UserHandle.formatUid(pw, this.getUid());
        pw.print(": ");
        PowerCalculator.printPowerMah(pw, this.getConsumedPower());
        if (this.mData.layout.processStateDataIncluded) {
            StringBuilder sb = new StringBuilder();
            this.appendProcessStateData(sb, 1, skipEmptyComponents);
            this.appendProcessStateData(sb, 2, skipEmptyComponents);
            this.appendProcessStateData(sb, 3, skipEmptyComponents);
            this.appendProcessStateData(sb, 4, skipEmptyComponents);
            pw.print(sb);
        }
        pw.print(" ( ");
        this.mPowerComponents.dump(pw, skipEmptyComponents);
        pw.print(" ) ");
    }

    private void appendProcessStateData(StringBuilder sb, int processState, boolean skipEmptyComponents) {
        BatteryConsumer.Dimensions dimensions = new BatteryConsumer.Dimensions(-1, processState);
        double power = this.mPowerComponents.getConsumedPower(dimensions);
        if (power == 0.0 && skipEmptyComponents) {
            return;
        }
        sb.append(" ").append(UidBatteryConsumer.processStateToString(processState)).append(": ").append(BatteryStats.formatCharge(power));
    }

    static UidBatteryConsumer create(BatteryConsumer.BatteryConsumerData data) {
        return new UidBatteryConsumer(data);
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        if (this.getConsumedPower() == 0.0) {
            return;
        }
        serializer.startTag(null, "uid");
        serializer.attributeInt(null, "uid", this.getUid());
        String packageWithHighestDrain = this.getPackageWithHighestDrain();
        if (!TextUtils.isEmpty(packageWithHighestDrain)) {
            serializer.attribute(null, "highest_drain_package", packageWithHighestDrain);
        }
        serializer.attributeLong(null, "time_in_foreground", this.getTimeInStateMs(0));
        serializer.attributeLong(null, "time_in_background", this.getTimeInStateMs(1));
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "uid");
    }

    static void createFromXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder2) throws XmlPullParserException, IOException {
        int uid = parser.getAttributeInt(null, "uid");
        Builder consumerBuilder = builder2.getOrCreateUidBatteryConsumerBuilder(uid);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("uid")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        consumerBuilder.setPackageWithHighestDrain(parser.getAttributeValue(null, "highest_drain_package"));
        consumerBuilder.setTimeInStateMs(0, parser.getAttributeLong(null, "time_in_foreground"));
        consumerBuilder.setTimeInStateMs(1, parser.getAttributeLong(null, "time_in_background"));
        while (!(eventType == 3 && parser.getName().equals("uid") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private static final String PACKAGE_NAME_UNINITIALIZED = "";
        private final BatteryStats.Uid mBatteryStatsUid;
        private final int mUid;
        private final boolean mIsVirtualUid;
        private String mPackageWithHighestDrain = "";
        private boolean mExcludeFromBatteryUsageStats;

        public Builder(BatteryConsumer.BatteryConsumerData data, BatteryStats.Uid batteryStatsUid) {
            this(data, batteryStatsUid, batteryStatsUid.getUid());
        }

        public Builder(BatteryConsumer.BatteryConsumerData data, int uid) {
            this(data, null, uid);
        }

        private Builder(BatteryConsumer.BatteryConsumerData data, BatteryStats.Uid batteryStatsUid, int uid) {
            super(data, 1);
            this.mBatteryStatsUid = batteryStatsUid;
            this.mUid = uid;
            this.mIsVirtualUid = this.mUid == 1090;
            data.putLong(1, this.mUid);
        }

        public BatteryStats.Uid getBatteryStatsUid() {
            if (this.mBatteryStatsUid == null) {
                throw new IllegalStateException("UidBatteryConsumer.Builder was initialized without a BatteryStats.Uid");
            }
            return this.mBatteryStatsUid;
        }

        public int getUid() {
            return this.mUid;
        }

        public boolean isVirtualUid() {
            return this.mIsVirtualUid;
        }

        public Builder setPackageWithHighestDrain(String packageName) {
            this.mPackageWithHighestDrain = TextUtils.nullIfEmpty(packageName);
            return this;
        }

        public Builder setTimeInStateMs(int state, long timeInStateMs) {
            switch (state) {
                case 0: {
                    this.mData.putLong(3, timeInStateMs);
                    break;
                }
                case 1: {
                    this.mData.putLong(4, timeInStateMs);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported state: " + state);
                }
            }
            return this;
        }

        public Builder excludeFromBatteryUsageStats() {
            this.mExcludeFromBatteryUsageStats = true;
            return this;
        }

        public Builder add(UidBatteryConsumer consumer) {
            this.mPowerComponentsBuilder.addPowerAndDuration(consumer.mPowerComponents);
            this.setTimeInStateMs(0, this.mData.getLong(3) + consumer.getTimeInStateMs(0));
            this.setTimeInStateMs(1, this.mData.getLong(4) + consumer.getTimeInStateMs(1));
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = consumer.getPackageWithHighestDrain();
            } else if (!TextUtils.equals(this.mPackageWithHighestDrain, consumer.getPackageWithHighestDrain())) {
                this.mPackageWithHighestDrain = null;
            }
            return this;
        }

        public boolean isExcludedFromBatteryUsageStats() {
            return this.mExcludeFromBatteryUsageStats;
        }

        public UidBatteryConsumer build() {
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = null;
            }
            if (this.mPackageWithHighestDrain != null) {
                this.mData.putString(2, this.mPackageWithHighestDrain);
            }
            return new UidBatteryConsumer(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

