/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IUpdateLock;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class UpdateLock {
    private static final boolean DEBUG = false;
    private static final String TAG = "UpdateLock";
    private static IUpdateLock sService;
    IBinder mToken;
    int mCount = 0;
    boolean mRefCounted = true;
    boolean mHeld = false;
    final String mTag;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String UPDATE_LOCK_CHANGED = "android.os.UpdateLock.UPDATE_LOCK_CHANGED";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String NOW_IS_CONVENIENT = "nowisconvenient";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String TIMESTAMP = "timestamp";

    private static void checkService() {
        if (sService == null) {
            sService = IUpdateLock.Stub.asInterface(ServiceManager.getService("updatelock"));
        }
    }

    public UpdateLock(String tag2) {
        this.mTag = tag2;
        this.mToken = new Binder();
    }

    public void setReferenceCounted(boolean isRefCounted) {
        this.mRefCounted = isRefCounted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isHeld() {
        IBinder iBinder = this.mToken;
        synchronized (iBinder) {
            return this.mHeld;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void acquire() {
        UpdateLock.checkService();
        IBinder iBinder = this.mToken;
        synchronized (iBinder) {
            this.acquireLocked();
        }
    }

    private void acquireLocked() {
        if (!this.mRefCounted || this.mCount++ == 0) {
            if (sService != null) {
                try {
                    sService.acquireUpdateLock(this.mToken, this.mTag);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to contact service to acquire");
                }
            }
            this.mHeld = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void release() {
        UpdateLock.checkService();
        IBinder iBinder = this.mToken;
        synchronized (iBinder) {
            this.releaseLocked();
        }
    }

    private void releaseLocked() {
        if (!this.mRefCounted || --this.mCount == 0) {
            if (sService != null) {
                try {
                    sService.releaseUpdateLock(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to contact service to release");
                }
            }
            this.mHeld = false;
        }
        if (this.mCount < 0) {
            throw new RuntimeException("UpdateLock under-locked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        IBinder iBinder = this.mToken;
        synchronized (iBinder) {
            if (this.mHeld) {
                Log.wtf(TAG, "UpdateLock finalized while still held");
                try {
                    sService.releaseUpdateLock(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to contact service to release");
                }
            }
        }
    }
}

