/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryUsageStats;
import android.os.PowerComponents;
import android.os.UidBatteryConsumer;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class UserBatteryConsumer
extends BatteryConsumer {
    static final int CONSUMER_TYPE_USER = 2;
    private static final int COLUMN_INDEX_USER_ID = 1;
    static final int COLUMN_COUNT = 2;

    UserBatteryConsumer(BatteryConsumer.BatteryConsumerData data) {
        super(data);
    }

    private UserBatteryConsumer(Builder builder2) {
        super(builder2.mData, builder2.mPowerComponentsBuilder.build());
    }

    public int getUserId() {
        return this.mData.getInt(1);
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        double consumedPower = this.getConsumedPower();
        pw.print("User ");
        pw.print(this.getUserId());
        pw.print(": ");
        PowerCalculator.printPowerMah(pw, consumedPower);
        pw.print(" ( ");
        this.mPowerComponents.dump(pw, skipEmptyComponents);
        pw.print(" ) ");
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        if (this.getConsumedPower() == 0.0) {
            return;
        }
        serializer.startTag(null, "user");
        serializer.attributeInt(null, "user_id", this.getUserId());
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "user");
    }

    static void createFromXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder2) throws XmlPullParserException, IOException {
        int userId = parser.getAttributeInt(null, "user_id");
        Builder consumerBuilder = builder2.getOrCreateUserBatteryConsumerBuilder(userId);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("user")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        while (!(eventType == 3 && parser.getName().equals("user") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private List<UidBatteryConsumer.Builder> mUidBatteryConsumers;

        Builder(BatteryConsumer.BatteryConsumerData data, int userId) {
            super(data, 2);
            data.putLong(1, userId);
        }

        public void addUidBatteryConsumer(UidBatteryConsumer.Builder uidBatteryConsumerBuilder) {
            if (this.mUidBatteryConsumers == null) {
                this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer.Builder>();
            }
            this.mUidBatteryConsumers.add(uidBatteryConsumerBuilder);
        }

        public UserBatteryConsumer build() {
            if (this.mUidBatteryConsumers != null) {
                for (int i = this.mUidBatteryConsumers.size() - 1; i >= 0; --i) {
                    UidBatteryConsumer.Builder uidBatteryConsumer = this.mUidBatteryConsumers.get(i);
                    this.mPowerComponentsBuilder.addPowerAndDuration(uidBatteryConsumer.mPowerComponentsBuilder);
                }
            }
            return new UserBatteryConsumer(this);
        }
    }
}

