/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UserHandle
implements Parcelable {
    @UnsupportedAppUsage
    public static final int PER_USER_RANGE = 100000;
    @UnsupportedAppUsage
    public static final int USER_ALL = -1;
    @SystemApi
    public static final UserHandle ALL = new UserHandle(-1);
    @UnsupportedAppUsage
    public static final int USER_CURRENT = -2;
    @SystemApi
    public static final UserHandle CURRENT = new UserHandle(-2);
    @UnsupportedAppUsage
    public static final int USER_CURRENT_OR_SELF = -3;
    @UnsupportedAppUsage
    public static final UserHandle CURRENT_OR_SELF = new UserHandle(-3);
    @UnsupportedAppUsage
    public static final int USER_NULL = -10000;
    private static final UserHandle NULL = new UserHandle(-10000);
    @Deprecated
    @UnsupportedAppUsage
    public static final int USER_OWNER = 0;
    @Deprecated
    @UnsupportedAppUsage
    public static final UserHandle OWNER = new UserHandle(0);
    @UnsupportedAppUsage
    public static final int USER_SYSTEM = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int USER_SERIAL_SYSTEM = 0;
    @SystemApi
    public static final UserHandle SYSTEM = new UserHandle(0);
    @UnsupportedAppUsage
    public static final boolean MU_ENABLED = true;
    public static final int MIN_SECONDARY_USER_ID = 10;
    private static final int NUM_CACHED_USERS = 8;
    private static final UserHandle[] CACHED_USER_HANDLES = new UserHandle[8];
    @GuardedBy(value={"sExtraUserHandleCache"})
    @VisibleForTesting
    public static final SparseArray<UserHandle> sExtraUserHandleCache = new SparseArray(0);
    @VisibleForTesting
    public static final int MAX_EXTRA_USER_HANDLE_CACHE_SIZE = 32;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int ERR_GID = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int AID_ROOT = 0;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int AID_APP_START = 10000;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int AID_APP_END = 19999;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int AID_SHARED_GID_START = 50000;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int AID_CACHE_GID_START = 20000;
    @UnsupportedAppUsage
    final int mHandle;
    public static final Parcelable.Creator<UserHandle> CREATOR;

    public static boolean isSameUser(int uid1, int uid2) {
        return UserHandle.getUserId(uid1) == UserHandle.getUserId(uid2);
    }

    @UnsupportedAppUsage
    public static boolean isSameApp(int uid1, int uid2) {
        return UserHandle.getAppId(uid1) == UserHandle.getAppId(uid2);
    }

    @UnsupportedAppUsage
    public static boolean isIsolated(int uid) {
        if (uid > 0) {
            return Process.isIsolated(uid);
        }
        return false;
    }

    @UnsupportedAppUsage
    public static boolean isApp(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 10000 && appId <= 19999;
        }
        return false;
    }

    public static boolean isCore(int uid) {
        if (uid >= 0) {
            int appId = UserHandle.getAppId(uid);
            return appId < 10000;
        }
        return false;
    }

    public static boolean isSharedAppGid(int uid) {
        return UserHandle.getAppIdFromSharedAppGid(uid) != -1;
    }

    public static UserHandle getUserHandleForUid(int uid) {
        return UserHandle.of(UserHandle.getUserId(uid));
    }

    @UnsupportedAppUsage
    public static int getUserId(int uid) {
        return uid / 100000;
    }

    @UnsupportedAppUsage
    public static int getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    public static int getCallingAppId() {
        return UserHandle.getAppId(Binder.getCallingUid());
    }

    public static int[] fromUserHandles(List<UserHandle> users) {
        int[] userIds = new int[users.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = users.get(i).getIdentifier();
        }
        return userIds;
    }

    public static List<UserHandle> toUserHandles(int[] userIds) {
        ArrayList<UserHandle> users = new ArrayList<UserHandle>(userIds.length);
        for (int i = 0; i < userIds.length; ++i) {
            users.add(UserHandle.of(userIds[i]));
        }
        return users;
    }

    @SystemApi
    public static UserHandle of(int userId) {
        if (userId == 0) {
            return SYSTEM;
        }
        switch (userId) {
            case -1: {
                return ALL;
            }
            case -2: {
                return CURRENT;
            }
            case -3: {
                return CURRENT_OR_SELF;
            }
        }
        if (userId >= 10 && userId < 10 + CACHED_USER_HANDLES.length) {
            return CACHED_USER_HANDLES[userId - 10];
        }
        if (userId == -10000) {
            return NULL;
        }
        return UserHandle.getUserHandleFromExtraCache(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static UserHandle getUserHandleFromExtraCache(int userId) {
        SparseArray<UserHandle> sparseArray = sExtraUserHandleCache;
        synchronized (sparseArray) {
            UserHandle extraCached = sExtraUserHandleCache.get(userId);
            if (extraCached != null) {
                return extraCached;
            }
            if (sExtraUserHandleCache.size() >= 32) {
                sExtraUserHandleCache.removeAt(new Random().nextInt(32));
            }
            UserHandle newHandle = new UserHandle(userId);
            sExtraUserHandleCache.put(userId, newHandle);
            return newHandle;
        }
    }

    @UnsupportedAppUsage
    public static int getUid(int userId, int appId) {
        return userId * 100000 + appId % 100000;
    }

    @SystemApi
    public int getUid(int appId) {
        return UserHandle.getUid(this.getIdentifier(), appId);
    }

    @SystemApi
    public static int getAppId(int uid) {
        return uid % 100000;
    }

    public static int getUserGid(int userId) {
        return UserHandle.getUid(userId, 9997);
    }

    public static int getSharedAppGid(int uid) {
        return UserHandle.getSharedAppGid(UserHandle.getUserId(uid), UserHandle.getAppId(uid));
    }

    public static int getSharedAppGid(int userId, int appId) {
        if (appId >= 10000 && appId <= 19999) {
            return appId - 10000 + 50000;
        }
        if (appId >= 0 && appId <= 10000) {
            return appId;
        }
        return -1;
    }

    @UnsupportedAppUsage
    public static int getAppIdFromSharedAppGid(int gid) {
        int appId = UserHandle.getAppId(gid) + 10000 - 50000;
        if (appId < 0 || appId >= 50000) {
            return -1;
        }
        return appId;
    }

    public static int getCacheAppGid(int uid) {
        return UserHandle.getCacheAppGid(UserHandle.getUserId(uid), UserHandle.getAppId(uid));
    }

    public static int getCacheAppGid(int userId, int appId) {
        if (appId >= 10000 && appId <= 19999) {
            return UserHandle.getUid(userId, appId - 10000 + 20000);
        }
        return -1;
    }

    public static void formatUid(StringBuilder sb, int uid) {
        if (uid < 10000) {
            sb.append(uid);
        } else {
            sb.append('u');
            sb.append(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (UserHandle.isIsolated(appId)) {
                if (appId > 99000) {
                    sb.append('i');
                    sb.append(appId - 99000);
                } else {
                    sb.append("ai");
                    sb.append(appId - 90000);
                }
            } else if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
        }
    }

    @SystemApi
    public static String formatUid(int uid) {
        StringBuilder sb = new StringBuilder();
        UserHandle.formatUid(sb, uid);
        return sb.toString();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static void formatUid(PrintWriter pw, int uid) {
        if (uid < 10000) {
            pw.print(uid);
        } else {
            pw.print('u');
            pw.print(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (UserHandle.isIsolated(appId)) {
                if (appId > 99000) {
                    pw.print('i');
                    pw.print(appId - 99000);
                } else {
                    pw.print("ai");
                    pw.print(appId - 90000);
                }
            } else if (appId >= 10000) {
                pw.print('a');
                pw.print(appId - 10000);
            } else {
                pw.print('s');
                pw.print(appId);
            }
        }
    }

    public static int parseUserArg(String arg) {
        int userId;
        if ("all".equals(arg)) {
            userId = -1;
        } else if ("current".equals(arg) || "cur".equals(arg)) {
            userId = -2;
        } else {
            try {
                userId = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad user number: " + arg);
            }
        }
        return userId;
    }

    @SystemApi
    public static int myUserId() {
        return UserHandle.getUserId(Process.myUid());
    }

    @Deprecated
    @SystemApi
    public boolean isOwner() {
        return this.equals(OWNER);
    }

    @SystemApi
    public boolean isSystem() {
        return this.equals(SYSTEM);
    }

    @UnsupportedAppUsage
    public UserHandle(int userId) {
        this.mHandle = userId;
    }

    @SystemApi
    public int getIdentifier() {
        return this.mHandle;
    }

    public String toString() {
        return "UserHandle{" + this.mHandle + "}";
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                UserHandle other = (UserHandle)obj;
                return this.mHandle == other.mHandle;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.mHandle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mHandle);
    }

    public static void writeToParcel(UserHandle h, Parcel out) {
        if (h != null) {
            h.writeToParcel(out, 0);
        } else {
            out.writeInt(-10000);
        }
    }

    public static UserHandle readFromParcel(Parcel in) {
        int h = in.readInt();
        return h != -10000 ? new UserHandle(h) : null;
    }

    public UserHandle(Parcel in) {
        this.mHandle = in.readInt();
    }

    static {
        for (int i = 0; i < CACHED_USER_HANDLES.length; ++i) {
            UserHandle.CACHED_USER_HANDLES[i] = new UserHandle(10 + i);
        }
        CREATOR = new Parcelable.Creator<UserHandle>(){

            @Override
            public UserHandle createFromParcel(Parcel in) {
                return UserHandle.of(in.readInt());
            }

            public UserHandle[] newArray(int size) {
                return new UserHandle[size];
            }
        };
    }
}

