/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class WakeLockStats
implements Parcelable {
    private final List<WakeLock> mWakeLocks;
    public static final Parcelable.Creator<WakeLockStats> CREATOR = new Parcelable.Creator<WakeLockStats>(){

        @Override
        public WakeLockStats createFromParcel(Parcel in) {
            return new WakeLockStats(in);
        }

        public WakeLockStats[] newArray(int size) {
            return new WakeLockStats[size];
        }
    };

    public WakeLockStats(List<WakeLock> wakeLocks) {
        this.mWakeLocks = wakeLocks;
    }

    public List<WakeLock> getWakeLocks() {
        return this.mWakeLocks;
    }

    private WakeLockStats(Parcel in) {
        int size = in.readInt();
        this.mWakeLocks = new ArrayList<WakeLock>(size);
        for (int i = 0; i < size; ++i) {
            this.mWakeLocks.add(new WakeLock(in));
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        int size = this.mWakeLocks.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            WakeLock stats = this.mWakeLocks.get(i);
            stats.writeToParcel(out);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "WakeLockStats " + this.mWakeLocks;
    }

    public static class WakeLock {
        public final int uid;
        public final String name;
        public final int timesAcquired;
        public final long totalTimeHeldMs;
        public final long timeHeldMs;

        public WakeLock(int uid, String name, int timesAcquired, long totalTimeHeldMs, long timeHeldMs) {
            this.uid = uid;
            this.name = name;
            this.timesAcquired = timesAcquired;
            this.totalTimeHeldMs = totalTimeHeldMs;
            this.timeHeldMs = timeHeldMs;
        }

        private WakeLock(Parcel in) {
            this.uid = in.readInt();
            this.name = in.readString();
            this.timesAcquired = in.readInt();
            this.totalTimeHeldMs = in.readLong();
            this.timeHeldMs = in.readLong();
        }

        private void writeToParcel(Parcel out) {
            out.writeInt(this.uid);
            out.writeString(this.name);
            out.writeInt(this.timesAcquired);
            out.writeLong(this.totalTimeHeldMs);
            out.writeLong(this.timeHeldMs);
        }

        public String toString() {
            return "WakeLock{uid=" + this.uid + ", name='" + this.name + '\'' + ", timesAcquired=" + this.timesAcquired + ", totalTimeHeldMs=" + this.totalTimeHeldMs + ", timeHeldMs=" + this.timeHeldMs + '}';
        }
    }
}

