/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.app.PendingIntent;
import android.content.pm.IPackageMoveObserver;
import android.content.res.ObbInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVoldTaskListener;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.storage.DiskInfo;
import android.os.storage.IObbActionListener;
import android.os.storage.IStorageEventListener;
import android.os.storage.IStorageShutdownObserver;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;
import com.android.internal.os.AppFuseMount;

public interface IStorageManager
extends IInterface {
    public void registerListener(IStorageEventListener var1) throws RemoteException;

    public void unregisterListener(IStorageEventListener var1) throws RemoteException;

    public void shutdown(IStorageShutdownObserver var1) throws RemoteException;

    public void mountObb(String var1, String var2, IObbActionListener var3, int var4, ObbInfo var5) throws RemoteException;

    public void unmountObb(String var1, boolean var2, IObbActionListener var3, int var4) throws RemoteException;

    public boolean isObbMounted(String var1) throws RemoteException;

    public String getMountedObbPath(String var1) throws RemoteException;

    public StorageVolume[] getVolumeList(int var1, String var2, int var3) throws RemoteException;

    public void mkdirs(String var1, String var2) throws RemoteException;

    public long lastMaintenance() throws RemoteException;

    public void runMaintenance() throws RemoteException;

    public DiskInfo[] getDisks() throws RemoteException;

    public VolumeInfo[] getVolumes(int var1) throws RemoteException;

    public VolumeRecord[] getVolumeRecords(int var1) throws RemoteException;

    public void mount(String var1) throws RemoteException;

    public void unmount(String var1) throws RemoteException;

    public void format(String var1) throws RemoteException;

    public void partitionPublic(String var1) throws RemoteException;

    public void partitionPrivate(String var1) throws RemoteException;

    public void partitionMixed(String var1, int var2) throws RemoteException;

    public void setVolumeNickname(String var1, String var2) throws RemoteException;

    public void setVolumeUserFlags(String var1, int var2, int var3) throws RemoteException;

    public void forgetVolume(String var1) throws RemoteException;

    public void forgetAllVolumes() throws RemoteException;

    public String getPrimaryStorageUuid() throws RemoteException;

    public void setPrimaryStorageUuid(String var1, IPackageMoveObserver var2) throws RemoteException;

    public void benchmark(String var1, IVoldTaskListener var2) throws RemoteException;

    public void setDebugFlags(int var1, int var2) throws RemoteException;

    public void createUserKey(int var1, int var2, boolean var3) throws RemoteException;

    public void destroyUserKey(int var1) throws RemoteException;

    public void unlockUserKey(int var1, int var2, byte[] var3) throws RemoteException;

    public void lockUserKey(int var1) throws RemoteException;

    public boolean isUserKeyUnlocked(int var1) throws RemoteException;

    public void prepareUserStorage(String var1, int var2, int var3, int var4) throws RemoteException;

    public void destroyUserStorage(String var1, int var2, int var3) throws RemoteException;

    public void addUserKeyAuth(int var1, int var2, byte[] var3) throws RemoteException;

    public void fixateNewestUserKeyAuth(int var1) throws RemoteException;

    public void fstrim(int var1, IVoldTaskListener var2) throws RemoteException;

    public AppFuseMount mountProxyFileDescriptorBridge() throws RemoteException;

    public ParcelFileDescriptor openProxyFileDescriptor(int var1, int var2, int var3) throws RemoteException;

    public long getCacheQuotaBytes(String var1, int var2) throws RemoteException;

    public long getCacheSizeBytes(String var1, int var2) throws RemoteException;

    public long getAllocatableBytes(String var1, int var2, String var3) throws RemoteException;

    public void allocateBytes(String var1, long var2, int var4, String var5) throws RemoteException;

    public void runIdleMaintenance() throws RemoteException;

    public void abortIdleMaintenance() throws RemoteException;

    public void commitChanges() throws RemoteException;

    public boolean supportsCheckpoint() throws RemoteException;

    public void startCheckpoint(int var1) throws RemoteException;

    public boolean needsCheckpoint() throws RemoteException;

    public void abortChanges(String var1, boolean var2) throws RemoteException;

    public void clearUserKeyAuth(int var1, int var2, byte[] var3) throws RemoteException;

    public void fixupAppDir(String var1) throws RemoteException;

    public void disableAppDataIsolation(String var1, int var2, int var3) throws RemoteException;

    public PendingIntent getManageSpaceActivityIntent(String var1, int var2) throws RemoteException;

    public void notifyAppIoBlocked(String var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyAppIoResumed(String var1, int var2, int var3, int var4) throws RemoteException;

    public int getExternalStorageMountMode(int var1, String var2) throws RemoteException;

    public boolean isAppIoBlocked(String var1, int var2, int var3, int var4) throws RemoteException;

    public void setCloudMediaProvider(String var1) throws RemoteException;

    public String getCloudMediaProvider() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStorageManager {
        public static final String DESCRIPTOR = "android.os.storage.IStorageManager";
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_unregisterListener = 2;
        static final int TRANSACTION_shutdown = 20;
        static final int TRANSACTION_mountObb = 22;
        static final int TRANSACTION_unmountObb = 23;
        static final int TRANSACTION_isObbMounted = 24;
        static final int TRANSACTION_getMountedObbPath = 25;
        static final int TRANSACTION_getVolumeList = 30;
        static final int TRANSACTION_mkdirs = 35;
        static final int TRANSACTION_lastMaintenance = 42;
        static final int TRANSACTION_runMaintenance = 43;
        static final int TRANSACTION_getDisks = 45;
        static final int TRANSACTION_getVolumes = 46;
        static final int TRANSACTION_getVolumeRecords = 47;
        static final int TRANSACTION_mount = 48;
        static final int TRANSACTION_unmount = 49;
        static final int TRANSACTION_format = 50;
        static final int TRANSACTION_partitionPublic = 51;
        static final int TRANSACTION_partitionPrivate = 52;
        static final int TRANSACTION_partitionMixed = 53;
        static final int TRANSACTION_setVolumeNickname = 54;
        static final int TRANSACTION_setVolumeUserFlags = 55;
        static final int TRANSACTION_forgetVolume = 56;
        static final int TRANSACTION_forgetAllVolumes = 57;
        static final int TRANSACTION_getPrimaryStorageUuid = 58;
        static final int TRANSACTION_setPrimaryStorageUuid = 59;
        static final int TRANSACTION_benchmark = 60;
        static final int TRANSACTION_setDebugFlags = 61;
        static final int TRANSACTION_createUserKey = 62;
        static final int TRANSACTION_destroyUserKey = 63;
        static final int TRANSACTION_unlockUserKey = 64;
        static final int TRANSACTION_lockUserKey = 65;
        static final int TRANSACTION_isUserKeyUnlocked = 66;
        static final int TRANSACTION_prepareUserStorage = 67;
        static final int TRANSACTION_destroyUserStorage = 68;
        static final int TRANSACTION_addUserKeyAuth = 71;
        static final int TRANSACTION_fixateNewestUserKeyAuth = 72;
        static final int TRANSACTION_fstrim = 73;
        static final int TRANSACTION_mountProxyFileDescriptorBridge = 74;
        static final int TRANSACTION_openProxyFileDescriptor = 75;
        static final int TRANSACTION_getCacheQuotaBytes = 76;
        static final int TRANSACTION_getCacheSizeBytes = 77;
        static final int TRANSACTION_getAllocatableBytes = 78;
        static final int TRANSACTION_allocateBytes = 79;
        static final int TRANSACTION_runIdleMaintenance = 80;
        static final int TRANSACTION_abortIdleMaintenance = 81;
        static final int TRANSACTION_commitChanges = 84;
        static final int TRANSACTION_supportsCheckpoint = 85;
        static final int TRANSACTION_startCheckpoint = 86;
        static final int TRANSACTION_needsCheckpoint = 87;
        static final int TRANSACTION_abortChanges = 88;
        static final int TRANSACTION_clearUserKeyAuth = 89;
        static final int TRANSACTION_fixupAppDir = 90;
        static final int TRANSACTION_disableAppDataIsolation = 91;
        static final int TRANSACTION_getManageSpaceActivityIntent = 92;
        static final int TRANSACTION_notifyAppIoBlocked = 93;
        static final int TRANSACTION_notifyAppIoResumed = 94;
        static final int TRANSACTION_getExternalStorageMountMode = 95;
        static final int TRANSACTION_isAppIoBlocked = 96;
        static final int TRANSACTION_setCloudMediaProvider = 97;
        static final int TRANSACTION_getCloudMediaProvider = 98;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStorageManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStorageManager) {
                return (IStorageManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerListener";
                }
                case 2: {
                    return "unregisterListener";
                }
                case 20: {
                    return "shutdown";
                }
                case 22: {
                    return "mountObb";
                }
                case 23: {
                    return "unmountObb";
                }
                case 24: {
                    return "isObbMounted";
                }
                case 25: {
                    return "getMountedObbPath";
                }
                case 30: {
                    return "getVolumeList";
                }
                case 35: {
                    return "mkdirs";
                }
                case 42: {
                    return "lastMaintenance";
                }
                case 43: {
                    return "runMaintenance";
                }
                case 45: {
                    return "getDisks";
                }
                case 46: {
                    return "getVolumes";
                }
                case 47: {
                    return "getVolumeRecords";
                }
                case 48: {
                    return "mount";
                }
                case 49: {
                    return "unmount";
                }
                case 50: {
                    return "format";
                }
                case 51: {
                    return "partitionPublic";
                }
                case 52: {
                    return "partitionPrivate";
                }
                case 53: {
                    return "partitionMixed";
                }
                case 54: {
                    return "setVolumeNickname";
                }
                case 55: {
                    return "setVolumeUserFlags";
                }
                case 56: {
                    return "forgetVolume";
                }
                case 57: {
                    return "forgetAllVolumes";
                }
                case 58: {
                    return "getPrimaryStorageUuid";
                }
                case 59: {
                    return "setPrimaryStorageUuid";
                }
                case 60: {
                    return "benchmark";
                }
                case 61: {
                    return "setDebugFlags";
                }
                case 62: {
                    return "createUserKey";
                }
                case 63: {
                    return "destroyUserKey";
                }
                case 64: {
                    return "unlockUserKey";
                }
                case 65: {
                    return "lockUserKey";
                }
                case 66: {
                    return "isUserKeyUnlocked";
                }
                case 67: {
                    return "prepareUserStorage";
                }
                case 68: {
                    return "destroyUserStorage";
                }
                case 71: {
                    return "addUserKeyAuth";
                }
                case 72: {
                    return "fixateNewestUserKeyAuth";
                }
                case 73: {
                    return "fstrim";
                }
                case 74: {
                    return "mountProxyFileDescriptorBridge";
                }
                case 75: {
                    return "openProxyFileDescriptor";
                }
                case 76: {
                    return "getCacheQuotaBytes";
                }
                case 77: {
                    return "getCacheSizeBytes";
                }
                case 78: {
                    return "getAllocatableBytes";
                }
                case 79: {
                    return "allocateBytes";
                }
                case 80: {
                    return "runIdleMaintenance";
                }
                case 81: {
                    return "abortIdleMaintenance";
                }
                case 84: {
                    return "commitChanges";
                }
                case 85: {
                    return "supportsCheckpoint";
                }
                case 86: {
                    return "startCheckpoint";
                }
                case 87: {
                    return "needsCheckpoint";
                }
                case 88: {
                    return "abortChanges";
                }
                case 89: {
                    return "clearUserKeyAuth";
                }
                case 90: {
                    return "fixupAppDir";
                }
                case 91: {
                    return "disableAppDataIsolation";
                }
                case 92: {
                    return "getManageSpaceActivityIntent";
                }
                case 93: {
                    return "notifyAppIoBlocked";
                }
                case 94: {
                    return "notifyAppIoResumed";
                }
                case 95: {
                    return "getExternalStorageMountMode";
                }
                case 96: {
                    return "isAppIoBlocked";
                }
                case 97: {
                    return "setCloudMediaProvider";
                }
                case 98: {
                    return "getCloudMediaProvider";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IStorageEventListener _arg0 = IStorageEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IStorageEventListener _arg0 = IStorageEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IStorageShutdownObserver _arg0 = IStorageShutdownObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.shutdown(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IObbActionListener _arg2 = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    ObbInfo _arg4 = data.readTypedObject(ObbInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.mountObb(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    IObbActionListener _arg2 = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unmountObb(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isObbMounted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getMountedObbPath(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getVolumeList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.mkdirs(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    long _result = this.lastMaintenance();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 43: {
                    this.runMaintenance();
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    Parcelable[] _result = this.getDisks();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getVolumes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getVolumeRecords(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.mount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unmount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.format(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.partitionPublic(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.partitionPrivate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.partitionMixed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setVolumeNickname(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVolumeUserFlags(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.forgetVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    this.forgetAllVolumes();
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    String _result = this.getPrimaryStorageUuid();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 59: {
                    String _arg0 = data.readString();
                    IPackageMoveObserver _arg1 = IPackageMoveObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setPrimaryStorageUuid(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    String _arg0 = data.readString();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.benchmark(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDebugFlags(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.createUserKey(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyUserKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.unlockUserKey(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.lockUserKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUserKeyUnlocked(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.prepareUserStorage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyUserStorage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.addUserKeyAuth(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 72: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.fixateNewestUserKeyAuth(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    int _arg0 = data.readInt();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.fstrim(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 74: {
                    AppFuseMount _result = this.mountProxyFileDescriptorBridge();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 75: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openProxyFileDescriptor(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 76: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getCacheQuotaBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 77: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getCacheSizeBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 78: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getAllocatableBytes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 79: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.allocateBytes(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    this.runIdleMaintenance();
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    this.abortIdleMaintenance();
                    reply.writeNoException();
                    break;
                }
                case 84: {
                    this.commitChanges();
                    reply.writeNoException();
                    break;
                }
                case 85: {
                    boolean _result = this.supportsCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 86: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startCheckpoint(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 87: {
                    boolean _result = this.needsCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 88: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.abortChanges(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 89: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.clearUserKeyAuth(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.fixupAppDir(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableAppDataIsolation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 92: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.getManageSpaceActivityIntent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 93: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAppIoBlocked(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 94: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAppIoResumed(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getExternalStorageMountMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 96: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAppIoBlocked(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 97: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setCloudMediaProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    String _result = this.getCloudMediaProvider();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 97;
        }

        private static class Proxy
        implements IStorageManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(IStorageEventListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(IStorageEventListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown(IStorageShutdownObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mountObb(String rawPath, String canonicalPath, IObbActionListener token, int nonce, ObbInfo obbInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rawPath);
                    _data.writeString(canonicalPath);
                    _data.writeStrongInterface(token);
                    _data.writeInt(nonce);
                    _data.writeTypedObject(obbInfo, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rawPath);
                    _data.writeBoolean(force);
                    _data.writeStrongInterface(token);
                    _data.writeInt(nonce);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isObbMounted(String rawPath) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rawPath);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getMountedObbPath(String rawPath) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rawPath);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StorageVolume[] getVolumeList(int userId, String callingPackage, int flags) throws RemoteException {
                StorageVolume[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(callingPackage);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StorageVolume.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mkdirs(String callingPkg, String path) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long lastMaintenance() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DiskInfo[] getDisks() throws RemoteException {
                DiskInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(DiskInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo[] getVolumes(int flags) throws RemoteException {
                VolumeInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeRecord[] getVolumeRecords(int flags) throws RemoteException {
                VolumeRecord[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VolumeRecord.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mount(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmount(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void format(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void partitionPublic(String diskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(diskId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void partitionPrivate(String diskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(diskId);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void partitionMixed(String diskId, int ratio) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(diskId);
                    _data.writeInt(ratio);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeNickname(String fsUuid, String nickname) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fsUuid);
                    _data.writeString(nickname);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeUserFlags(String fsUuid, int flags, int mask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fsUuid);
                    _data.writeInt(flags);
                    _data.writeInt(mask);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetVolume(String fsUuid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fsUuid);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetAllVolumes() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrimaryStorageUuid() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void benchmark(String volId, IVoldTaskListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDebugFlags(int flags, int mask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(mask);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createUserKey(int userId, int serialNumber, boolean ephemeral) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeBoolean(ephemeral);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockUserKey(int userId, int serialNumber, byte[] secret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeByteArray(secret);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUserKeyUnlocked(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyUserStorage(String volumeUuid, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUserKeyAuth(int userId, int serialNumber, byte[] secret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeByteArray(secret);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fixateNewestUserKeyAuth(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fstrim(int flags, IVoldTaskListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AppFuseMount mountProxyFileDescriptorBridge() throws RemoteException {
                AppFuseMount _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AppFuseMount.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openProxyFileDescriptor(int mountPointId, int fileId, int mode) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mountPointId);
                    _data.writeInt(fileId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCacheQuotaBytes(String volumeUuid, int uid) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCacheSizeBytes(String volumeUuid, int uid) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAllocatableBytes(String volumeUuid, int flags, String callingPackage) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allocateBytes(String volumeUuid, long bytes, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeLong(bytes);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runIdleMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortIdleMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitChanges() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCheckpoint(int numTries) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(numTries);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean needsCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortChanges(String message, boolean retry) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    _data.writeBoolean(retry);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearUserKeyAuth(int userId, int serialNumber, byte[] secret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeByteArray(secret);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fixupAppDir(String path) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableAppDataIsolation(String pkgName, int pid, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    _data.writeInt(pid);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent getManageSpaceActivityIntent(String packageName, int requestCode) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAppIoBlocked(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    _data.writeInt(tid);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAppIoResumed(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    _data.writeInt(tid);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getExternalStorageMountMode(int uid, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAppIoBlocked(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    _data.writeInt(tid);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCloudMediaProvider(String authority) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(authority);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCloudMediaProvider() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IStorageManager {
        @Override
        public void registerListener(IStorageEventListener listener2) throws RemoteException {
        }

        @Override
        public void unregisterListener(IStorageEventListener listener2) throws RemoteException {
        }

        @Override
        public void shutdown(IStorageShutdownObserver observer) throws RemoteException {
        }

        @Override
        public void mountObb(String rawPath, String canonicalPath, IObbActionListener token, int nonce, ObbInfo obbInfo) throws RemoteException {
        }

        @Override
        public void unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) throws RemoteException {
        }

        @Override
        public boolean isObbMounted(String rawPath) throws RemoteException {
            return false;
        }

        @Override
        public String getMountedObbPath(String rawPath) throws RemoteException {
            return null;
        }

        @Override
        public StorageVolume[] getVolumeList(int userId, String callingPackage, int flags) throws RemoteException {
            return null;
        }

        @Override
        public void mkdirs(String callingPkg, String path) throws RemoteException {
        }

        @Override
        public long lastMaintenance() throws RemoteException {
            return 0L;
        }

        @Override
        public void runMaintenance() throws RemoteException {
        }

        @Override
        public DiskInfo[] getDisks() throws RemoteException {
            return null;
        }

        @Override
        public VolumeInfo[] getVolumes(int flags) throws RemoteException {
            return null;
        }

        @Override
        public VolumeRecord[] getVolumeRecords(int flags) throws RemoteException {
            return null;
        }

        @Override
        public void mount(String volId) throws RemoteException {
        }

        @Override
        public void unmount(String volId) throws RemoteException {
        }

        @Override
        public void format(String volId) throws RemoteException {
        }

        @Override
        public void partitionPublic(String diskId) throws RemoteException {
        }

        @Override
        public void partitionPrivate(String diskId) throws RemoteException {
        }

        @Override
        public void partitionMixed(String diskId, int ratio) throws RemoteException {
        }

        @Override
        public void setVolumeNickname(String fsUuid, String nickname) throws RemoteException {
        }

        @Override
        public void setVolumeUserFlags(String fsUuid, int flags, int mask) throws RemoteException {
        }

        @Override
        public void forgetVolume(String fsUuid) throws RemoteException {
        }

        @Override
        public void forgetAllVolumes() throws RemoteException {
        }

        @Override
        public String getPrimaryStorageUuid() throws RemoteException {
            return null;
        }

        @Override
        public void setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback2) throws RemoteException {
        }

        @Override
        public void benchmark(String volId, IVoldTaskListener listener2) throws RemoteException {
        }

        @Override
        public void setDebugFlags(int flags, int mask) throws RemoteException {
        }

        @Override
        public void createUserKey(int userId, int serialNumber, boolean ephemeral) throws RemoteException {
        }

        @Override
        public void destroyUserKey(int userId) throws RemoteException {
        }

        @Override
        public void unlockUserKey(int userId, int serialNumber, byte[] secret) throws RemoteException {
        }

        @Override
        public void lockUserKey(int userId) throws RemoteException {
        }

        @Override
        public boolean isUserKeyUnlocked(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) throws RemoteException {
        }

        @Override
        public void destroyUserStorage(String volumeUuid, int userId, int flags) throws RemoteException {
        }

        @Override
        public void addUserKeyAuth(int userId, int serialNumber, byte[] secret) throws RemoteException {
        }

        @Override
        public void fixateNewestUserKeyAuth(int userId) throws RemoteException {
        }

        @Override
        public void fstrim(int flags, IVoldTaskListener listener2) throws RemoteException {
        }

        @Override
        public AppFuseMount mountProxyFileDescriptorBridge() throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openProxyFileDescriptor(int mountPointId, int fileId, int mode) throws RemoteException {
            return null;
        }

        @Override
        public long getCacheQuotaBytes(String volumeUuid, int uid) throws RemoteException {
            return 0L;
        }

        @Override
        public long getCacheSizeBytes(String volumeUuid, int uid) throws RemoteException {
            return 0L;
        }

        @Override
        public long getAllocatableBytes(String volumeUuid, int flags, String callingPackage) throws RemoteException {
            return 0L;
        }

        @Override
        public void allocateBytes(String volumeUuid, long bytes, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void runIdleMaintenance() throws RemoteException {
        }

        @Override
        public void abortIdleMaintenance() throws RemoteException {
        }

        @Override
        public void commitChanges() throws RemoteException {
        }

        @Override
        public boolean supportsCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public void startCheckpoint(int numTries) throws RemoteException {
        }

        @Override
        public boolean needsCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public void abortChanges(String message, boolean retry) throws RemoteException {
        }

        @Override
        public void clearUserKeyAuth(int userId, int serialNumber, byte[] secret) throws RemoteException {
        }

        @Override
        public void fixupAppDir(String path) throws RemoteException {
        }

        @Override
        public void disableAppDataIsolation(String pkgName, int pid, int userId) throws RemoteException {
        }

        @Override
        public PendingIntent getManageSpaceActivityIntent(String packageName, int requestCode) throws RemoteException {
            return null;
        }

        @Override
        public void notifyAppIoBlocked(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
        }

        @Override
        public void notifyAppIoResumed(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
        }

        @Override
        public int getExternalStorageMountMode(int uid, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isAppIoBlocked(String volumeUuid, int uid, int tid, int reason) throws RemoteException {
            return false;
        }

        @Override
        public void setCloudMediaProvider(String authority) throws RemoteException {
        }

        @Override
        public String getCloudMediaProvider() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

