/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.content.res.Resources;

public class VibrationConfig {
    private final float mHapticChannelMaxVibrationAmplitude;
    private final int mRampStepDurationMs;
    private final int mRampDownDurationMs;
    private final int mDefaultAlarmVibrationIntensity;
    private final int mDefaultHapticFeedbackIntensity;
    private final int mDefaultMediaVibrationIntensity;
    private final int mDefaultNotificationVibrationIntensity;
    private final int mDefaultRingVibrationIntensity;

    public VibrationConfig(Resources resources) {
        this.mHapticChannelMaxVibrationAmplitude = VibrationConfig.loadFloat(resources, 17105076, 0.0f);
        this.mRampDownDurationMs = VibrationConfig.loadInteger(resources, 17694961, 0);
        this.mRampStepDurationMs = VibrationConfig.loadInteger(resources, 17694962, 0);
        this.mDefaultAlarmVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694780);
        this.mDefaultHapticFeedbackIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694785);
        this.mDefaultMediaVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694786);
        this.mDefaultNotificationVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694793);
        this.mDefaultRingVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694800);
    }

    private static int loadDefaultIntensity(Resources res, int resId) {
        int defaultIntensity = 2;
        int value2 = VibrationConfig.loadInteger(res, resId, defaultIntensity);
        if (value2 < 0 || value2 > 3) {
            return defaultIntensity;
        }
        return value2;
    }

    private static float loadFloat(Resources res, int resId, float defaultValue) {
        return res != null ? res.getFloat(resId) : defaultValue;
    }

    private static int loadInteger(Resources res, int resId, int defaultValue) {
        return res != null ? res.getInteger(resId) : defaultValue;
    }

    public float getHapticChannelMaximumAmplitude() {
        if (this.mHapticChannelMaxVibrationAmplitude <= 0.0f) {
            return Float.NaN;
        }
        return this.mHapticChannelMaxVibrationAmplitude;
    }

    public int getRampDownDurationMs() {
        if (this.mRampDownDurationMs < 0) {
            return 0;
        }
        return this.mRampDownDurationMs;
    }

    public int getRampStepDurationMs() {
        if (this.mRampStepDurationMs < 0) {
            return 0;
        }
        return this.mRampStepDurationMs;
    }

    public int getDefaultVibrationIntensity(int usage) {
        switch (usage) {
            case 17: {
                return this.mDefaultAlarmVibrationIntensity;
            }
            case 49: 
            case 65: {
                return this.mDefaultNotificationVibrationIntensity;
            }
            case 33: {
                return this.mDefaultRingVibrationIntensity;
            }
            case 18: 
            case 34: 
            case 50: 
            case 66: {
                return this.mDefaultHapticFeedbackIntensity;
            }
        }
        return this.mDefaultMediaVibrationIntensity;
    }

    public String toString() {
        return "VibrationConfig{mHapticChannelMaxVibrationAmplitude=" + this.mHapticChannelMaxVibrationAmplitude + ", mRampStepDurationMs=" + this.mRampStepDurationMs + ", mRampDownDurationMs=" + this.mRampDownDurationMs + ", mDefaultAlarmIntensity=" + this.mDefaultAlarmVibrationIntensity + ", mDefaultHapticFeedbackIntensity=" + this.mDefaultHapticFeedbackIntensity + ", mDefaultMediaIntensity=" + this.mDefaultMediaVibrationIntensity + ", mDefaultNotificationIntensity=" + this.mDefaultNotificationVibrationIntensity + ", mDefaultRingIntensity=" + this.mDefaultRingVibrationIntensity + "}";
    }
}

