/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.NotificationManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.media.audiopolicy.AudioProductStrategy;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.preference.VolumePreference;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.util.Log;
import android.widget.SeekBar;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.SomeArgs;
import java.util.concurrent.TimeUnit;

@Deprecated
public class SeekBarVolumizer
implements SeekBar.OnSeekBarChangeListener,
Handler.Callback {
    private static final String TAG = "SeekBarVolumizer";
    private static final int MSG_GROUP_VOLUME_CHANGED = 1;
    private static long sStopVolumeTime = 0L;
    private final Handler mVolumeHandler = new VolumeHandler();
    private AudioAttributes mAttributes;
    private int mVolumeGroupId;
    private final AudioManager.VolumeGroupCallback mVolumeGroupCallback = new AudioManager.VolumeGroupCallback(){

        @Override
        public void onAudioVolumeGroupChanged(int group, int flags) {
            if (SeekBarVolumizer.this.mHandler == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = group;
            args.arg2 = flags;
            SeekBarVolumizer.this.mVolumeHandler.sendMessage(SeekBarVolumizer.this.mHandler.obtainMessage(1, args));
        }
    };
    @UnsupportedAppUsage
    private final Context mContext;
    private final H mUiHandler = new H();
    private final Callback mCallback;
    private final Uri mDefaultUri;
    @UnsupportedAppUsage
    private final AudioManager mAudioManager;
    private final NotificationManager mNotificationManager;
    @UnsupportedAppUsage
    private final int mStreamType;
    private final int mMaxStreamVolume;
    private boolean mAffectedByRingerMode;
    private boolean mNotificationOrRing;
    private final Receiver mReceiver = new Receiver();
    private Handler mHandler;
    private Observer mVolumeObserver;
    @UnsupportedAppUsage
    private int mOriginalStreamVolume;
    private int mLastAudibleStreamVolume;
    @GuardedBy(value={"this"})
    @UnsupportedAppUsage
    private Ringtone mRingtone;
    @UnsupportedAppUsage
    private int mLastProgress = -1;
    private boolean mMuted;
    @UnsupportedAppUsage
    private SeekBar mSeekBar;
    private int mVolumeBeforeMute = -1;
    private int mRingerMode;
    private int mZenMode;
    private boolean mPlaySample;
    private static final int MSG_SET_STREAM_VOLUME = 0;
    private static final int MSG_START_SAMPLE = 1;
    private static final int MSG_STOP_SAMPLE = 2;
    private static final int MSG_INIT_SAMPLE = 3;
    private static final int CHECK_RINGTONE_PLAYBACK_DELAY_MS = 1000;
    private static final long SET_STREAM_VOLUME_DELAY_MS = TimeUnit.MILLISECONDS.toMillis(500L);
    private static final long START_SAMPLE_DELAY_MS = TimeUnit.MILLISECONDS.toMillis(500L);
    private static final long DURATION_TO_START_DELAYING = TimeUnit.MILLISECONDS.toMillis(2000L);
    private NotificationManager.Policy mNotificationPolicy;
    private boolean mAllowAlarms;
    private boolean mAllowMedia;
    private boolean mAllowRinger;

    @UnsupportedAppUsage
    public SeekBarVolumizer(Context context, int streamType, Uri defaultUri, Callback callback2) {
        this(context, streamType, defaultUri, callback2, true);
    }

    public SeekBarVolumizer(Context context, int streamType, Uri defaultUri, Callback callback2, boolean playSample) {
        this.mContext = context;
        this.mAudioManager = context.getSystemService(AudioManager.class);
        this.mNotificationManager = context.getSystemService(NotificationManager.class);
        this.mNotificationPolicy = this.mNotificationManager.getConsolidatedNotificationPolicy();
        this.mAllowAlarms = (this.mNotificationPolicy.priorityCategories & 0x20) != 0;
        this.mAllowMedia = (this.mNotificationPolicy.priorityCategories & 0x40) != 0;
        this.mAllowRinger = !ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(this.mNotificationPolicy);
        this.mStreamType = streamType;
        this.mAffectedByRingerMode = this.mAudioManager.isStreamAffectedByRingerMode(this.mStreamType);
        this.mNotificationOrRing = SeekBarVolumizer.isNotificationOrRing(this.mStreamType);
        if (this.mNotificationOrRing) {
            this.mRingerMode = this.mAudioManager.getRingerModeInternal();
        }
        this.mZenMode = this.mNotificationManager.getZenMode();
        if (this.hasAudioProductStrategies()) {
            this.mVolumeGroupId = this.getVolumeGroupIdForLegacyStreamType(this.mStreamType);
            this.mAttributes = this.getAudioAttributesForLegacyStreamType(this.mStreamType);
        }
        this.mMaxStreamVolume = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
        this.mCallback = callback2;
        this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
        this.mLastAudibleStreamVolume = this.mAudioManager.getLastAudibleStreamVolume(this.mStreamType);
        this.mMuted = this.mAudioManager.isStreamMute(this.mStreamType);
        this.mPlaySample = playSample;
        if (this.mCallback != null) {
            this.mCallback.onMuted(this.mMuted, this.isZenMuted());
        }
        if (defaultUri == null) {
            defaultUri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
        }
        this.mDefaultUri = defaultUri;
    }

    private boolean hasAudioProductStrategies() {
        return AudioManager.getAudioProductStrategies().size() > 0;
    }

    private int getVolumeGroupIdForLegacyStreamType(int streamType) {
        for (AudioProductStrategy productStrategy : AudioManager.getAudioProductStrategies()) {
            int volumeGroupId2 = productStrategy.getVolumeGroupIdForLegacyStreamType(streamType);
            if (volumeGroupId2 == -1) continue;
            return volumeGroupId2;
        }
        return AudioManager.getAudioProductStrategies().stream().map(strategy -> strategy.getVolumeGroupIdForAudioAttributes(AudioProductStrategy.getDefaultAttributes())).filter(volumeGroupId -> volumeGroupId != -1).findFirst().orElse(-1);
    }

    private AudioAttributes getAudioAttributesForLegacyStreamType(int streamType) {
        for (AudioProductStrategy productStrategy : AudioManager.getAudioProductStrategies()) {
            AudioAttributes aa = productStrategy.getAudioAttributesForLegacyStreamType(streamType);
            if (aa == null) continue;
            return aa;
        }
        return new AudioAttributes.Builder().setContentType(0).setUsage(0).build();
    }

    private static boolean isNotificationOrRing(int stream) {
        return stream == 2 || stream == 5;
    }

    private static boolean isAlarmsStream(int stream) {
        return stream == 4;
    }

    private static boolean isMediaStream(int stream) {
        return stream == 3;
    }

    public void setSeekBar(SeekBar seekBar) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }
        this.mSeekBar = seekBar;
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mSeekBar.setMax(this.mMaxStreamVolume);
        this.updateSeekBar();
        this.mSeekBar.setOnSeekBarChangeListener(this);
    }

    private boolean isZenMuted() {
        return this.mNotificationOrRing && this.mZenMode == 3 || this.mZenMode == 2 || this.mZenMode == 1 && (!this.mAllowAlarms && SeekBarVolumizer.isAlarmsStream(this.mStreamType) || !this.mAllowMedia && SeekBarVolumizer.isMediaStream(this.mStreamType) || !this.mAllowRinger && SeekBarVolumizer.isNotificationOrRing(this.mStreamType));
    }

    protected void updateSeekBar() {
        boolean zenMuted = this.isZenMuted();
        this.mSeekBar.setEnabled(!zenMuted);
        if (zenMuted) {
            this.mSeekBar.setProgress(this.mLastAudibleStreamVolume, true);
        } else if (this.mNotificationOrRing && this.mRingerMode == 1) {
            this.mSeekBar.setProgress(0, true);
        } else if (this.mMuted) {
            this.mSeekBar.setProgress(0, true);
        } else {
            this.mSeekBar.setProgress(this.mLastProgress > -1 ? this.mLastProgress : this.mOriginalStreamVolume, true);
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.mMuted && this.mLastProgress > 0) {
                    this.mAudioManager.adjustStreamVolume(this.mStreamType, 100, 0);
                } else if (!this.mMuted && this.mLastProgress == 0) {
                    this.mAudioManager.adjustStreamVolume(this.mStreamType, -100, 0);
                }
                this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 1024);
                break;
            }
            case 1: {
                if (!this.mPlaySample) break;
                this.onStartSample();
                break;
            }
            case 2: {
                if (!this.mPlaySample) break;
                this.onStopSample();
                break;
            }
            case 3: {
                if (!this.mPlaySample) break;
                this.onInitSample();
                break;
            }
            default: {
                Log.e(TAG, "invalid SeekBarVolumizer message: " + msg.what);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInitSample() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            this.mRingtone = RingtoneManager.getRingtone(this.mContext, this.mDefaultUri);
            if (this.mRingtone != null) {
                this.mRingtone.setStreamType(this.mStreamType);
            }
        }
    }

    private void postStartSample() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), this.isSamplePlaying() ? 1000L : (this.isDelay() ? START_SAMPLE_DELAY_MS : 0L));
    }

    private boolean isDelay() {
        long durationTime = System_Delegate.currentTimeMillis() - sStopVolumeTime;
        return durationTime >= 0L && durationTime < DURATION_TO_START_DELAYING;
    }

    private void setStopVolumeTime() {
        if (this.mStreamType == 0 || this.mStreamType == 2 || this.mStreamType == 4) {
            sStopVolumeTime = System_Delegate.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartSample() {
        if (!this.isSamplePlaying()) {
            if (this.mCallback != null) {
                this.mCallback.onSampleStarting(this);
            }
            SeekBarVolumizer seekBarVolumizer = this;
            synchronized (seekBarVolumizer) {
                if (this.mRingtone != null) {
                    try {
                        this.mRingtone.setAudioAttributes(new AudioAttributes.Builder(this.mRingtone.getAudioAttributes()).setFlags(128).build());
                        this.mRingtone.play();
                    }
                    catch (Throwable e) {
                        Log.w(TAG, "Error playing ringtone, stream " + this.mStreamType, e);
                    }
                }
            }
        }
    }

    private void postStopSample() {
        if (this.mHandler == null) {
            return;
        }
        this.setStopVolumeTime();
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopSample() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            if (this.mRingtone != null) {
                this.mRingtone.stop();
            }
        }
    }

    @UnsupportedAppUsage
    public void stop() {
        if (this.mHandler == null) {
            return;
        }
        this.postStopSample();
        this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
        this.mReceiver.setListening(false);
        if (this.hasAudioProductStrategies()) {
            this.unregisterVolumeGroupCb();
        }
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mHandler.getLooper().quitSafely();
        this.mHandler = null;
        this.mVolumeObserver = null;
    }

    public void start() {
        if (this.mHandler != null) {
            return;
        }
        HandlerThread thread = new HandlerThread("SeekBarVolumizer.CallbackHandler");
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this);
        this.mHandler.sendEmptyMessage(3);
        this.mVolumeObserver = new Observer(this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS_INT[this.mStreamType]), false, this.mVolumeObserver);
        this.mReceiver.setListening(true);
        if (this.hasAudioProductStrategies()) {
            this.registerVolumeGroupCb();
        }
    }

    public void revertVolume() {
        this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
        if (fromTouch) {
            this.postSetVolume(progress);
        }
        if (this.mCallback != null) {
            this.mCallback.onProgressChanged(seekBar, progress, fromTouch);
        }
    }

    private void postSetVolume(int progress) {
        if (this.mHandler == null) {
            return;
        }
        this.mLastProgress = progress;
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), this.isDelay() ? SET_STREAM_VOLUME_DELAY_MS : 0L);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        if (this.mCallback != null) {
            this.mCallback.onStartTrackingTouch(this);
        }
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        this.postStartSample();
        if (this.mCallback != null) {
            this.mCallback.onStopTrackingTouch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSamplePlaying() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            return this.mRingtone != null && this.mRingtone.isPlaying();
        }
    }

    public void startSample() {
        this.postStartSample();
    }

    public void stopSample() {
        this.postStopSample();
    }

    public SeekBar getSeekBar() {
        return this.mSeekBar;
    }

    public void changeVolumeBy(int amount) {
        this.mSeekBar.incrementProgressBy(amount);
        this.postSetVolume(this.mSeekBar.getProgress());
        this.postStartSample();
        this.mVolumeBeforeMute = -1;
    }

    public void muteVolume() {
        if (this.mVolumeBeforeMute != -1) {
            this.mSeekBar.setProgress(this.mVolumeBeforeMute, true);
            this.postSetVolume(this.mVolumeBeforeMute);
            this.postStartSample();
            this.mVolumeBeforeMute = -1;
        } else {
            this.mVolumeBeforeMute = this.mSeekBar.getProgress();
            this.mSeekBar.setProgress(0, true);
            this.postStopSample();
            this.postSetVolume(0);
        }
    }

    public void onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (this.mLastProgress >= 0) {
            volumeStore.volume = this.mLastProgress;
            volumeStore.originalVolume = this.mOriginalStreamVolume;
        }
    }

    public void onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (volumeStore.volume != -1) {
            this.mOriginalStreamVolume = volumeStore.originalVolume;
            this.mLastProgress = volumeStore.volume;
            this.postSetVolume(this.mLastProgress);
        }
    }

    private void updateSlider() {
        if (this.mSeekBar != null && this.mAudioManager != null) {
            int volume = this.mAudioManager.getStreamVolume(this.mStreamType);
            int lastAudibleVolume = this.mAudioManager.getLastAudibleStreamVolume(this.mStreamType);
            boolean mute = this.mAudioManager.isStreamMute(this.mStreamType);
            this.mUiHandler.postUpdateSlider(volume, lastAudibleVolume, mute);
        }
    }

    private void registerVolumeGroupCb() {
        if (this.mVolumeGroupId != -1) {
            this.mAudioManager.registerVolumeGroupCallback(Runnable::run, this.mVolumeGroupCallback);
            this.updateSlider();
        }
    }

    private void unregisterVolumeGroupCb() {
        if (this.mVolumeGroupId != -1) {
            this.mAudioManager.unregisterVolumeGroupCallback(this.mVolumeGroupCallback);
        }
    }

    private class VolumeHandler
    extends Handler {
        private VolumeHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            switch (msg.what) {
                case 1: {
                    int group = (Integer)args.arg1;
                    if (SeekBarVolumizer.this.mVolumeGroupId != group || SeekBarVolumizer.this.mVolumeGroupId == -1) {
                        return;
                    }
                    SeekBarVolumizer.this.updateSlider();
                }
            }
        }
    }

    private class Receiver
    extends BroadcastReceiver {
        private boolean mListening;

        private Receiver() {
        }

        public void setListening(boolean listening) {
            if (this.mListening == listening) {
                return;
            }
            this.mListening = listening;
            if (listening) {
                IntentFilter filter2 = new IntentFilter("android.media.VOLUME_CHANGED_ACTION");
                filter2.addAction("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION");
                filter2.addAction("android.app.action.INTERRUPTION_FILTER_CHANGED");
                filter2.addAction("android.app.action.NOTIFICATION_POLICY_CHANGED");
                filter2.addAction("android.media.STREAM_DEVICES_CHANGED_ACTION");
                SeekBarVolumizer.this.mContext.registerReceiver(this, filter2);
            } else {
                SeekBarVolumizer.this.mContext.unregisterReceiver(this);
            }
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action2 = intent.getAction();
            if ("android.media.VOLUME_CHANGED_ACTION".equals(action2)) {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                int streamValue = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", -1);
                if (SeekBarVolumizer.this.hasAudioProductStrategies() && !SeekBarVolumizer.this.isDelay()) {
                    this.updateVolumeSlider(streamType, streamValue);
                }
            } else if ("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION".equals(action2)) {
                if (SeekBarVolumizer.this.mNotificationOrRing) {
                    SeekBarVolumizer.this.mRingerMode = SeekBarVolumizer.this.mAudioManager.getRingerModeInternal();
                }
                if (SeekBarVolumizer.this.mAffectedByRingerMode) {
                    SeekBarVolumizer.this.updateSlider();
                }
            } else if ("android.media.STREAM_DEVICES_CHANGED_ACTION".equals(action2)) {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                if (SeekBarVolumizer.this.hasAudioProductStrategies() && !SeekBarVolumizer.this.isDelay()) {
                    int streamVolume = SeekBarVolumizer.this.mAudioManager.getStreamVolume(streamType);
                    this.updateVolumeSlider(streamType, streamVolume);
                } else {
                    int volumeGroup = SeekBarVolumizer.this.getVolumeGroupIdForLegacyStreamType(streamType);
                    if (volumeGroup != -1 && volumeGroup == SeekBarVolumizer.this.mVolumeGroupId) {
                        int streamVolume = SeekBarVolumizer.this.mAudioManager.getStreamVolume(streamType);
                        if (!SeekBarVolumizer.this.isDelay()) {
                            this.updateVolumeSlider(streamType, streamVolume);
                        }
                    }
                }
            } else if ("android.app.action.INTERRUPTION_FILTER_CHANGED".equals(action2)) {
                SeekBarVolumizer.this.mZenMode = SeekBarVolumizer.this.mNotificationManager.getZenMode();
                SeekBarVolumizer.this.updateSlider();
            } else if ("android.app.action.NOTIFICATION_POLICY_CHANGED".equals(action2)) {
                SeekBarVolumizer.this.mNotificationPolicy = SeekBarVolumizer.this.mNotificationManager.getConsolidatedNotificationPolicy();
                SeekBarVolumizer.this.mAllowAlarms = (SeekBarVolumizer.this.mNotificationPolicy.priorityCategories & 0x20) != 0;
                SeekBarVolumizer.this.mAllowMedia = (SeekBarVolumizer.this.mNotificationPolicy.priorityCategories & 0x40) != 0;
                SeekBarVolumizer.this.mAllowRinger = !ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(SeekBarVolumizer.this.mNotificationPolicy);
                SeekBarVolumizer.this.updateSlider();
            }
        }

        private void updateVolumeSlider(int streamType, int streamValue) {
            boolean streamMatch;
            boolean bl = SeekBarVolumizer.this.mNotificationOrRing ? SeekBarVolumizer.isNotificationOrRing(streamType) : (streamMatch = streamType == SeekBarVolumizer.this.mStreamType);
            if (SeekBarVolumizer.this.mSeekBar != null && streamMatch && streamValue != -1) {
                boolean muted = SeekBarVolumizer.this.mAudioManager.isStreamMute(SeekBarVolumizer.this.mStreamType) || streamValue == 0;
                SeekBarVolumizer.this.mUiHandler.postUpdateSlider(streamValue, SeekBarVolumizer.this.mLastAudibleStreamVolume, muted);
            }
        }
    }

    private class Observer
    extends ContentObserver {
        public Observer(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            SeekBarVolumizer.this.updateSlider();
        }
    }

    private class H
    extends Handler {
        private static final int UPDATE_SLIDER = 1;

        private H() {
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1 && SeekBarVolumizer.this.mSeekBar != null) {
                SeekBarVolumizer.this.mLastProgress = msg.arg1;
                SeekBarVolumizer.this.mLastAudibleStreamVolume = msg.arg2;
                boolean muted = (Boolean)msg.obj;
                if (muted != SeekBarVolumizer.this.mMuted) {
                    SeekBarVolumizer.this.mMuted = muted;
                    if (SeekBarVolumizer.this.mCallback != null) {
                        SeekBarVolumizer.this.mCallback.onMuted(SeekBarVolumizer.this.mMuted, SeekBarVolumizer.this.isZenMuted());
                    }
                }
                SeekBarVolumizer.this.updateSeekBar();
            }
        }

        public void postUpdateSlider(int volume, int lastAudibleVolume, boolean mute) {
            this.obtainMessage(1, volume, lastAudibleVolume, new Boolean(mute)).sendToTarget();
        }
    }

    public static interface Callback {
        public void onSampleStarting(SeekBarVolumizer var1);

        public void onProgressChanged(SeekBar var1, int var2, boolean var3);

        public void onMuted(boolean var1, boolean var2);

        public void onStartTrackingTouch(SeekBarVolumizer var1);

        default public void onStopTrackingTouch(SeekBarVolumizer sbv) {
        }
    }
}

