/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapterObserver;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;

public interface IPrintDocumentAdapter
extends IInterface {
    public void setObserver(IPrintDocumentAdapterObserver var1) throws RemoteException;

    public void start() throws RemoteException;

    public void layout(PrintAttributes var1, PrintAttributes var2, ILayoutResultCallback var3, Bundle var4, int var5) throws RemoteException;

    public void write(PageRange[] var1, ParcelFileDescriptor var2, IWriteResultCallback var3, int var4) throws RemoteException;

    public void finish() throws RemoteException;

    public void kill(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPrintDocumentAdapter {
        public static final String DESCRIPTOR = "android.print.IPrintDocumentAdapter";
        static final int TRANSACTION_setObserver = 1;
        static final int TRANSACTION_start = 2;
        static final int TRANSACTION_layout = 3;
        static final int TRANSACTION_write = 4;
        static final int TRANSACTION_finish = 5;
        static final int TRANSACTION_kill = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPrintDocumentAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPrintDocumentAdapter) {
                return (IPrintDocumentAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setObserver";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "layout";
                }
                case 4: {
                    return "write";
                }
                case 5: {
                    return "finish";
                }
                case 6: {
                    return "kill";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IPrintDocumentAdapterObserver _arg0 = IPrintDocumentAdapterObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setObserver(_arg0);
                    break;
                }
                case 2: {
                    this.start();
                    break;
                }
                case 3: {
                    PrintAttributes _arg0 = data.readTypedObject(PrintAttributes.CREATOR);
                    PrintAttributes _arg1 = data.readTypedObject(PrintAttributes.CREATOR);
                    ILayoutResultCallback _arg2 = ILayoutResultCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.layout(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    PageRange[] _arg0 = data.createTypedArray(PageRange.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    IWriteResultCallback _arg2 = IWriteResultCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.write(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    this.finish();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.kill(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IPrintDocumentAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setObserver(IPrintDocumentAdapterObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void start() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback2, Bundle metadata, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(oldAttributes, 0);
                    _data.writeTypedObject(newAttributes, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeTypedObject(metadata, 0);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback2, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(pages, 0);
                    _data.writeTypedObject(fd, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finish() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void kill(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPrintDocumentAdapter {
        @Override
        public void setObserver(IPrintDocumentAdapterObserver observer) throws RemoteException {
        }

        @Override
        public void start() throws RemoteException {
        }

        @Override
        public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback2, Bundle metadata, int sequence) throws RemoteException {
        }

        @Override
        public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback2, int sequence) throws RemoteException {
        }

        @Override
        public void finish() throws RemoteException {
        }

        @Override
        public void kill(String reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

