/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.print.IPrintManager;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class PrinterDiscoverySession {
    private static final String LOG_TAG = "PrinterDiscoverySession";
    private static final int MSG_PRINTERS_ADDED = 1;
    private static final int MSG_PRINTERS_REMOVED = 2;
    private final LinkedHashMap<PrinterId, PrinterInfo> mPrinters = new LinkedHashMap();
    private final IPrintManager mPrintManager;
    private final int mUserId;
    private final Handler mHandler;
    private IPrinterDiscoveryObserver mObserver;
    private OnPrintersChangeListener mListener;
    private boolean mIsPrinterDiscoveryStarted;

    PrinterDiscoverySession(IPrintManager printManager, Context context, int userId) {
        this.mPrintManager = printManager;
        this.mUserId = userId;
        this.mHandler = new SessionHandler(context.getMainLooper());
        this.mObserver = new PrinterDiscoveryObserver(this);
        try {
            this.mPrintManager.createPrinterDiscoverySession(this.mObserver, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error creating printer discovery session", re);
        }
    }

    public void startPrinterDiscovery(List<PrinterId> priorityList) {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring start printers discovery - session destroyed");
            return;
        }
        if (!this.mIsPrinterDiscoveryStarted) {
            this.mIsPrinterDiscoveryStarted = true;
            try {
                this.mPrintManager.startPrinterDiscovery(this.mObserver, priorityList, this.mUserId);
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error starting printer discovery", re);
            }
        }
    }

    public void stopPrinterDiscovery() {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring stop printers discovery - session destroyed");
            return;
        }
        if (this.mIsPrinterDiscoveryStarted) {
            this.mIsPrinterDiscoveryStarted = false;
            try {
                this.mPrintManager.stopPrinterDiscovery(this.mObserver, this.mUserId);
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error stopping printer discovery", re);
            }
        }
    }

    public void startPrinterStateTracking(PrinterId printerId) {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring start printer state tracking - session destroyed");
            return;
        }
        try {
            this.mPrintManager.startPrinterStateTracking(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error starting printer state tracking", re);
        }
    }

    public void stopPrinterStateTracking(PrinterId printerId) {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring stop printer state tracking - session destroyed");
            return;
        }
        try {
            this.mPrintManager.stopPrinterStateTracking(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error stopping printer state tracking", re);
        }
    }

    public void validatePrinters(List<PrinterId> printerIds) {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring validate printers - session destroyed");
            return;
        }
        try {
            this.mPrintManager.validatePrinters(printerIds, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error validating printers", re);
        }
    }

    public void destroy() {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring destroy - session destroyed");
        }
        this.destroyNoCheck();
    }

    public List<PrinterInfo> getPrinters() {
        if (this.isDestroyed()) {
            Log.w(LOG_TAG, "Ignoring get printers - session destroyed");
            return Collections.emptyList();
        }
        return new ArrayList<PrinterInfo>(this.mPrinters.values());
    }

    public boolean isDestroyed() {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        return this.isDestroyedNoCheck();
    }

    public boolean isPrinterDiscoveryStarted() {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        return this.mIsPrinterDiscoveryStarted;
    }

    public void setOnPrintersChangeListener(OnPrintersChangeListener listener2) {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        this.mListener = listener2;
    }

    protected void finalize() throws Throwable {
        if (!this.isDestroyedNoCheck()) {
            Log.e(LOG_TAG, "Destroying leaked printer discovery session");
            this.destroyNoCheck();
        }
        super.finalize();
    }

    private boolean isDestroyedNoCheck() {
        return this.mObserver == null;
    }

    private void destroyNoCheck() {
        this.stopPrinterDiscovery();
        try {
            this.mPrintManager.destroyPrinterDiscoverySession(this.mObserver, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error destroying printer discovery session", re);
        }
        finally {
            this.mObserver = null;
            this.mPrinters.clear();
        }
    }

    private void handlePrintersAdded(List<PrinterInfo> addedPrinters) {
        if (this.isDestroyed()) {
            return;
        }
        if (this.mPrinters.isEmpty()) {
            int printerCount = addedPrinters.size();
            for (int i = 0; i < printerCount; ++i) {
                PrinterInfo printer = addedPrinters.get(i);
                this.mPrinters.put(printer.getId(), printer);
            }
            this.notifyOnPrintersChanged();
            return;
        }
        ArrayMap<PrinterId, PrinterInfo> addedPrintersMap = new ArrayMap<PrinterId, PrinterInfo>();
        int printerCount = addedPrinters.size();
        for (int i = 0; i < printerCount; ++i) {
            PrinterInfo printer = addedPrinters.get(i);
            addedPrintersMap.put(printer.getId(), printer);
        }
        for (PrinterId oldPrinterId : this.mPrinters.keySet()) {
            PrinterInfo updatedPrinter = (PrinterInfo)addedPrintersMap.remove(oldPrinterId);
            if (updatedPrinter == null) continue;
            this.mPrinters.put(oldPrinterId, updatedPrinter);
        }
        this.mPrinters.putAll(addedPrintersMap);
        this.notifyOnPrintersChanged();
    }

    private void handlePrintersRemoved(List<PrinterId> printerIds) {
        if (this.isDestroyed()) {
            return;
        }
        boolean printersChanged = false;
        int removedPrinterIdCount = printerIds.size();
        for (int i = 0; i < removedPrinterIdCount; ++i) {
            PrinterId removedPrinterId = printerIds.get(i);
            if (this.mPrinters.remove(removedPrinterId) == null) continue;
            printersChanged = true;
        }
        if (printersChanged) {
            this.notifyOnPrintersChanged();
        }
    }

    private void notifyOnPrintersChanged() {
        if (this.mListener != null) {
            this.mListener.onPrintersChanged();
        }
    }

    private static void throwIfNotCalledOnMainThread() {
        if (!Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalAccessError("must be called from the main thread");
        }
    }

    public static class PrinterDiscoveryObserver
    extends IPrinterDiscoveryObserver.Stub {
        private final WeakReference<PrinterDiscoverySession> mWeakSession;

        public PrinterDiscoveryObserver(PrinterDiscoverySession session) {
            this.mWeakSession = new WeakReference<PrinterDiscoverySession>(session);
        }

        @Override
        public void onPrintersAdded(ParceledListSlice printers) {
            PrinterDiscoverySession session = (PrinterDiscoverySession)this.mWeakSession.get();
            if (session != null) {
                session.mHandler.obtainMessage(1, printers.getList()).sendToTarget();
            }
        }

        @Override
        public void onPrintersRemoved(ParceledListSlice printerIds) {
            PrinterDiscoverySession session = (PrinterDiscoverySession)this.mWeakSession.get();
            if (session != null) {
                session.mHandler.obtainMessage(2, printerIds.getList()).sendToTarget();
            }
        }
    }

    private class SessionHandler
    extends Handler {
        public SessionHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    List printers = (List)message.obj;
                    PrinterDiscoverySession.this.handlePrintersAdded(printers);
                    break;
                }
                case 2: {
                    List printerIds = (List)message.obj;
                    PrinterDiscoverySession.this.handlePrintersRemoved(printerIds);
                }
            }
        }
    }

    public static interface OnPrintersChangeListener {
        public void onPrintersChanged();
    }
}

