/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.print.PrintManager;
import android.print.PrinterCapabilitiesInfo;
import android.print.PrinterId;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PrinterInfo
implements Parcelable {
    public static final int STATUS_IDLE = 1;
    public static final int STATUS_BUSY = 2;
    public static final int STATUS_UNAVAILABLE = 3;
    private final PrinterId mId;
    private final int mIconResourceId;
    private final boolean mHasCustomPrinterIcon;
    private final int mCustomPrinterIconGen;
    private final PendingIntent mInfoIntent;
    private final String mName;
    private final int mStatus;
    private final String mDescription;
    private final PrinterCapabilitiesInfo mCapabilities;
    public static final Parcelable.Creator<PrinterInfo> CREATOR = new Parcelable.Creator<PrinterInfo>(){

        @Override
        public PrinterInfo createFromParcel(Parcel parcel) {
            return new PrinterInfo(parcel);
        }

        public PrinterInfo[] newArray(int size) {
            return new PrinterInfo[size];
        }
    };

    private PrinterInfo(PrinterId printerId, String name, int status, int iconResourceId, boolean hasCustomPrinterIcon, String description, PendingIntent infoIntent, PrinterCapabilitiesInfo capabilities, int customPrinterIconGen) {
        this.mId = printerId;
        this.mName = name;
        this.mStatus = status;
        this.mIconResourceId = iconResourceId;
        this.mHasCustomPrinterIcon = hasCustomPrinterIcon;
        this.mDescription = description;
        this.mInfoIntent = infoIntent;
        this.mCapabilities = capabilities;
        this.mCustomPrinterIconGen = customPrinterIconGen;
    }

    public PrinterId getId() {
        return this.mId;
    }

    public Drawable loadIcon(Context context) {
        PrintManager printManager;
        Icon icon2;
        Drawable drawable2 = null;
        PackageManager packageManager = context.getPackageManager();
        if (this.mHasCustomPrinterIcon && (icon2 = (printManager = (PrintManager)context.getSystemService("print")).getCustomPrinterIcon(this.mId)) != null) {
            drawable2 = icon2.loadDrawable(context);
        }
        if (drawable2 == null) {
            try {
                String packageName = this.mId.getServiceName().getPackageName();
                PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
                ApplicationInfo appInfo = packageInfo.applicationInfo;
                if (this.mIconResourceId != 0) {
                    drawable2 = packageManager.getDrawable(packageName, this.mIconResourceId, appInfo);
                }
                if (drawable2 == null) {
                    drawable2 = appInfo.loadIcon(packageManager);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return drawable2;
    }

    public boolean getHasCustomPrinterIcon() {
        return this.mHasCustomPrinterIcon;
    }

    public String getName() {
        return this.mName;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public PendingIntent getInfoIntent() {
        return this.mInfoIntent;
    }

    public PrinterCapabilitiesInfo getCapabilities() {
        return this.mCapabilities;
    }

    private static PrinterId checkPrinterId(PrinterId printerId) {
        return Preconditions.checkNotNull(printerId, "printerId cannot be null.");
    }

    private static int checkStatus(int status) {
        if (status != 1 && status != 2 && status != 3) {
            throw new IllegalArgumentException("status is invalid.");
        }
        return status;
    }

    private static String checkName(String name) {
        return Preconditions.checkStringNotEmpty(name, "name cannot be empty.");
    }

    private PrinterInfo(Parcel parcel) {
        this.mId = PrinterInfo.checkPrinterId(parcel.readParcelable(null, PrinterId.class));
        this.mName = PrinterInfo.checkName(parcel.readString());
        this.mStatus = PrinterInfo.checkStatus(parcel.readInt());
        this.mDescription = parcel.readString();
        this.mCapabilities = parcel.readParcelable(null, PrinterCapabilitiesInfo.class);
        this.mIconResourceId = parcel.readInt();
        this.mHasCustomPrinterIcon = parcel.readByte() != 0;
        this.mCustomPrinterIconGen = parcel.readInt();
        this.mInfoIntent = parcel.readParcelable(null, PendingIntent.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mStatus);
        parcel.writeString(this.mDescription);
        parcel.writeParcelable(this.mCapabilities, flags);
        parcel.writeInt(this.mIconResourceId);
        parcel.writeByte((byte)(this.mHasCustomPrinterIcon ? 1 : 0));
        parcel.writeInt(this.mCustomPrinterIconGen);
        parcel.writeParcelable(this.mInfoIntent, flags);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mId.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + this.mStatus;
        result = 31 * result + (this.mDescription != null ? this.mDescription.hashCode() : 0);
        result = 31 * result + (this.mCapabilities != null ? this.mCapabilities.hashCode() : 0);
        result = 31 * result + this.mIconResourceId;
        result = 31 * result + (this.mHasCustomPrinterIcon ? 1 : 0);
        result = 31 * result + this.mCustomPrinterIconGen;
        result = 31 * result + (this.mInfoIntent != null ? this.mInfoIntent.hashCode() : 0);
        return result;
    }

    public boolean equalsIgnoringStatus(PrinterInfo other) {
        if (!this.mId.equals(other.mId)) {
            return false;
        }
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        if (!TextUtils.equals(this.mDescription, other.mDescription)) {
            return false;
        }
        if (this.mCapabilities == null ? other.mCapabilities != null : !this.mCapabilities.equals(other.mCapabilities)) {
            return false;
        }
        if (this.mIconResourceId != other.mIconResourceId) {
            return false;
        }
        if (this.mHasCustomPrinterIcon != other.mHasCustomPrinterIcon) {
            return false;
        }
        if (this.mCustomPrinterIconGen != other.mCustomPrinterIconGen) {
            return false;
        }
        return !(this.mInfoIntent == null ? other.mInfoIntent != null : !this.mInfoIntent.equals(other.mInfoIntent));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrinterInfo other = (PrinterInfo)obj;
        if (!this.equalsIgnoringStatus(other)) {
            return false;
        }
        return this.mStatus == other.mStatus;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("PrinterInfo{");
        builder2.append("id=").append(this.mId);
        builder2.append(", name=").append(this.mName);
        builder2.append(", status=").append(this.mStatus);
        builder2.append(", description=").append(this.mDescription);
        builder2.append(", capabilities=").append(this.mCapabilities);
        builder2.append(", iconResId=").append(this.mIconResourceId);
        builder2.append(", hasCustomPrinterIcon=").append(this.mHasCustomPrinterIcon);
        builder2.append(", customPrinterIconGen=").append(this.mCustomPrinterIconGen);
        builder2.append(", infoIntent=").append(this.mInfoIntent);
        builder2.append("\"}");
        return builder2.toString();
    }

    public static class Builder {
        private PrinterId mPrinterId;
        private String mName;
        private int mStatus;
        private int mIconResourceId;
        private boolean mHasCustomPrinterIcon;
        private String mDescription;
        private PendingIntent mInfoIntent;
        private PrinterCapabilitiesInfo mCapabilities;
        private int mCustomPrinterIconGen;

        public Builder(PrinterId printerId, String name, int status) {
            this.mPrinterId = PrinterInfo.checkPrinterId(printerId);
            this.mName = PrinterInfo.checkName(name);
            this.mStatus = PrinterInfo.checkStatus(status);
        }

        public Builder(PrinterInfo other) {
            this.mPrinterId = other.mId;
            this.mName = other.mName;
            this.mStatus = other.mStatus;
            this.mIconResourceId = other.mIconResourceId;
            this.mHasCustomPrinterIcon = other.mHasCustomPrinterIcon;
            this.mDescription = other.mDescription;
            this.mInfoIntent = other.mInfoIntent;
            this.mCapabilities = other.mCapabilities;
            this.mCustomPrinterIconGen = other.mCustomPrinterIconGen;
        }

        public Builder setStatus(int status) {
            this.mStatus = PrinterInfo.checkStatus(status);
            return this;
        }

        public Builder setIconResourceId(int iconResourceId) {
            this.mIconResourceId = Preconditions.checkArgumentNonnegative(iconResourceId, "iconResourceId can't be negative");
            return this;
        }

        public Builder setHasCustomPrinterIcon(boolean hasCustomPrinterIcon) {
            this.mHasCustomPrinterIcon = hasCustomPrinterIcon;
            return this;
        }

        public Builder setName(String name) {
            this.mName = PrinterInfo.checkName(name);
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setInfoIntent(PendingIntent infoIntent) {
            this.mInfoIntent = infoIntent;
            return this;
        }

        public Builder setCapabilities(PrinterCapabilitiesInfo capabilities) {
            this.mCapabilities = capabilities;
            return this;
        }

        public PrinterInfo build() {
            return new PrinterInfo(this.mPrinterId, this.mName, this.mStatus, this.mIconResourceId, this.mHasCustomPrinterIcon, this.mDescription, this.mInfoIntent, this.mCapabilities, this.mCustomPrinterIconGen);
        }

        public Builder incCustomPrinterIconGen() {
            ++this.mCustomPrinterIconGen;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

