/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

@Deprecated
public class Program
extends BaseObj {
    static final int MAX_INPUT = 8;
    static final int MAX_OUTPUT = 8;
    static final int MAX_CONSTANT = 8;
    static final int MAX_TEXTURE = 8;
    Element[] mInputs;
    Element[] mOutputs;
    Type[] mConstants;
    TextureType[] mTextures;
    String[] mTextureNames;
    int mTextureCount;
    String mShader;

    Program(long id2, RenderScript rs) {
        super(id2, rs);
        this.guard.open("destroy");
    }

    public int getConstantCount() {
        return this.mConstants != null ? this.mConstants.length : 0;
    }

    public Type getConstant(int slot) {
        if (slot < 0 || slot >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mConstants[slot];
    }

    public int getTextureCount() {
        return this.mTextureCount;
    }

    public TextureType getTextureType(int slot) {
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextures[slot];
    }

    public String getTextureName(int slot) {
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextureNames[slot];
    }

    public void bindConstants(Allocation a, int slot) {
        if (slot < 0 || slot >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (a != null && a.getType().getID(this.mRS) != this.mConstants[slot].getID(this.mRS)) {
            throw new IllegalArgumentException("Allocation type does not match slot type.");
        }
        long id2 = a != null ? a.getID(this.mRS) : 0L;
        this.mRS.nProgramBindConstants(this.getID(this.mRS), slot, id2);
    }

    public void bindTexture(Allocation va, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (va != null && va.getType().hasFaces() && this.mTextures[slot] != TextureType.TEXTURE_CUBE) {
            throw new IllegalArgumentException("Cannot bind cubemap to 2d texture slot");
        }
        long id2 = va != null ? va.getID(this.mRS) : 0L;
        this.mRS.nProgramBindTexture(this.getID(this.mRS), slot, id2);
    }

    public void bindSampler(Sampler vs, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        long id2 = vs != null ? vs.getID(this.mRS) : 0L;
        this.mRS.nProgramBindSampler(this.getID(this.mRS), slot, id2);
    }

    public static class BaseProgramBuilder {
        @UnsupportedAppUsage
        RenderScript mRS;
        @UnsupportedAppUsage
        Element[] mInputs;
        @UnsupportedAppUsage
        Element[] mOutputs;
        @UnsupportedAppUsage
        Type[] mConstants;
        Type[] mTextures;
        TextureType[] mTextureTypes;
        String[] mTextureNames;
        @UnsupportedAppUsage
        int mInputCount;
        @UnsupportedAppUsage
        int mOutputCount;
        @UnsupportedAppUsage
        int mConstantCount;
        @UnsupportedAppUsage
        int mTextureCount;
        @UnsupportedAppUsage
        String mShader;

        @UnsupportedAppUsage
        protected BaseProgramBuilder(RenderScript rs) {
            this.mRS = rs;
            this.mInputs = new Element[8];
            this.mOutputs = new Element[8];
            this.mConstants = new Type[8];
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
            this.mTextureTypes = new TextureType[8];
            this.mTextureNames = new String[8];
        }

        public BaseProgramBuilder setShader(String s) {
            this.mShader = s;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BaseProgramBuilder setShader(Resources resources, int resourceID) {
            int strLength;
            byte[] str;
            InputStream is = resources.openRawResource(resourceID);
            try {
                try {
                    str = new byte[1024];
                    strLength = 0;
                    while (true) {
                        int bytesRead;
                        int bytesLeft;
                        if ((bytesLeft = str.length - strLength) == 0) {
                            byte[] buf2 = new byte[str.length * 2];
                            System.arraycopy(str, 0, buf2, 0, str.length);
                            str = buf2;
                            bytesLeft = str.length - strLength;
                        }
                        if ((bytesRead = is.read(str, strLength, bytesLeft)) <= 0) {
                            break;
                        }
                        strLength += bytesRead;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new Resources.NotFoundException();
            }
            try {
                this.mShader = new String(str, 0, strLength, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e("RenderScript shader creation", "Could not decode shader string");
            }
            return this;
        }

        public int getCurrentConstantIndex() {
            return this.mConstantCount - 1;
        }

        public int getCurrentTextureIndex() {
            return this.mTextureCount - 1;
        }

        public BaseProgramBuilder addConstant(Type t) throws IllegalStateException {
            if (this.mConstantCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (t.getElement().isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mConstants[this.mConstantCount] = t;
            ++this.mConstantCount;
            return this;
        }

        public BaseProgramBuilder addTexture(TextureType texType) throws IllegalArgumentException {
            this.addTexture(texType, "Tex" + this.mTextureCount);
            return this;
        }

        public BaseProgramBuilder addTexture(TextureType texType, String texName) throws IllegalArgumentException {
            if (this.mTextureCount >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureTypes[this.mTextureCount] = texType;
            this.mTextureNames[this.mTextureCount] = texName;
            ++this.mTextureCount;
            return this;
        }

        protected void initProgram(Program p) {
            p.mInputs = new Element[this.mInputCount];
            System.arraycopy(this.mInputs, 0, p.mInputs, 0, this.mInputCount);
            p.mOutputs = new Element[this.mOutputCount];
            System.arraycopy(this.mOutputs, 0, p.mOutputs, 0, this.mOutputCount);
            p.mConstants = new Type[this.mConstantCount];
            System.arraycopy(this.mConstants, 0, p.mConstants, 0, this.mConstantCount);
            p.mTextureCount = this.mTextureCount;
            p.mTextures = new TextureType[this.mTextureCount];
            System.arraycopy(this.mTextureTypes, 0, p.mTextures, 0, this.mTextureCount);
            p.mTextureNames = new String[this.mTextureCount];
            System.arraycopy(this.mTextureNames, 0, p.mTextureNames, 0, this.mTextureCount);
        }
    }

    static enum ProgramParam {
        INPUT(0),
        OUTPUT(1),
        CONSTANT(2),
        TEXTURE_TYPE(3);

        int mID;

        private ProgramParam(int id2) {
            this.mID = id2;
        }
    }

    public static enum TextureType {
        TEXTURE_2D(0),
        TEXTURE_CUBE(1);

        int mID;

        private TextureType(int id2) {
            this.mID = id2;
        }
    }
}

