/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RenderScript;

@Deprecated
public class Type
extends BaseObj {
    int mDimX;
    int mDimY;
    int mDimZ;
    boolean mDimMipmaps;
    boolean mDimFaces;
    int mDimYuv;
    int mElementCount;
    Element mElement;
    int[] mArrays;
    static final int mMaxArrays = 4;

    public Element getElement() {
        return this.mElement;
    }

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public int getYuv() {
        return this.mDimYuv;
    }

    public boolean hasMipmaps() {
        return this.mDimMipmaps;
    }

    public boolean hasFaces() {
        return this.mDimFaces;
    }

    public int getCount() {
        return this.mElementCount;
    }

    public int getArray(int arrayNum) {
        if (arrayNum < 0 || arrayNum >= 4) {
            throw new RSIllegalArgumentException("Array dimension out of range.");
        }
        if (this.mArrays == null || arrayNum >= this.mArrays.length) {
            return 0;
        }
        return this.mArrays[arrayNum];
    }

    public int getArrayCount() {
        if (this.mArrays != null) {
            return this.mArrays.length;
        }
        return 0;
    }

    void calcElementCount() {
        boolean hasLod = this.hasMipmaps();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        int faces = 1;
        if (this.hasFaces()) {
            faces = 6;
        }
        if (x == 0) {
            x = 1;
        }
        if (y == 0) {
            y = 1;
        }
        if (z == 0) {
            z = 1;
        }
        int count = x * y * z * faces;
        while (hasLod && (x > 1 || y > 1 || z > 1)) {
            if (x > 1) {
                x >>= 1;
            }
            if (y > 1) {
                y >>= 1;
            }
            if (z > 1) {
                z >>= 1;
            }
            count += x * y * z * faces;
        }
        if (this.mArrays != null) {
            for (int ct = 0; ct < this.mArrays.length; ++ct) {
                count *= this.mArrays[ct];
            }
        }
        this.mElementCount = count;
    }

    Type(long id2, RenderScript rs) {
        super(id2, rs);
    }

    @Override
    void updateFromNative() {
        long[] dataBuffer = new long[6];
        this.mRS.nTypeGetNativeData(this.getID(this.mRS), dataBuffer);
        this.mDimX = (int)dataBuffer[0];
        this.mDimY = (int)dataBuffer[1];
        this.mDimZ = (int)dataBuffer[2];
        this.mDimMipmaps = dataBuffer[3] == 1L;
        this.mDimFaces = dataBuffer[4] == 1L;
        long elementID = dataBuffer[5];
        if (elementID != 0L) {
            this.mElement = new Element(elementID, this.mRS);
            this.mElement.updateFromNative();
        }
        this.calcElementCount();
    }

    public static Type createX(RenderScript rs, Element e, int dimX) {
        if (dimX < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        long id2 = rs.nTypeCreate(e.getID(rs), dimX, 0, 0, false, false, 0);
        Type t = new Type(id2, rs);
        t.mElement = e;
        t.mDimX = dimX;
        t.calcElementCount();
        return t;
    }

    public static Type createXY(RenderScript rs, Element e, int dimX, int dimY) {
        if (dimX < 1 || dimY < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        long id2 = rs.nTypeCreate(e.getID(rs), dimX, dimY, 0, false, false, 0);
        Type t = new Type(id2, rs);
        t.mElement = e;
        t.mDimX = dimX;
        t.mDimY = dimY;
        t.calcElementCount();
        return t;
    }

    public static Type createXYZ(RenderScript rs, Element e, int dimX, int dimY, int dimZ) {
        if (dimX < 1 || dimY < 1 || dimZ < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        long id2 = rs.nTypeCreate(e.getID(rs), dimX, dimY, dimZ, false, false, 0);
        Type t = new Type(id2, rs);
        t.mElement = e;
        t.mDimX = dimX;
        t.mDimY = dimY;
        t.mDimZ = dimZ;
        t.calcElementCount();
        return t;
    }

    public static class Builder {
        RenderScript mRS;
        int mDimX = 1;
        int mDimY;
        int mDimZ;
        boolean mDimMipmaps;
        boolean mDimFaces;
        int mYuv;
        int[] mArray = new int[4];
        Element mElement;

        public Builder(RenderScript rs, Element e) {
            e.checkValid();
            this.mRS = rs;
            this.mElement = e;
        }

        public Builder setX(int value2) {
            if (value2 < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension X are not valid.");
            }
            this.mDimX = value2;
            return this;
        }

        public Builder setY(int value2) {
            if (value2 < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension Y are not valid.");
            }
            this.mDimY = value2;
            return this;
        }

        public Builder setZ(int value2) {
            if (value2 < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension Z are not valid.");
            }
            this.mDimZ = value2;
            return this;
        }

        public Builder setArray(int dim2, int value2) {
            if (dim2 < 0 || dim2 >= 4) {
                throw new RSIllegalArgumentException("Array dimension out of range.");
            }
            this.mArray[dim2] = value2;
            return this;
        }

        public Builder setMipmaps(boolean value2) {
            this.mDimMipmaps = value2;
            return this;
        }

        public Builder setFaces(boolean value2) {
            this.mDimFaces = value2;
            return this;
        }

        public Builder setYuvFormat(int yuvFormat) {
            switch (yuvFormat) {
                case 17: 
                case 35: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new RSIllegalArgumentException("Only ImageFormat.NV21, .YV12, and .YUV_420_888 are supported..");
                }
            }
            this.mYuv = yuvFormat;
            return this;
        }

        public Type create() {
            if (this.mDimZ > 0) {
                if (this.mDimX < 1 || this.mDimY < 1) {
                    throw new RSInvalidStateException("Both X and Y dimension required when Z is present.");
                }
                if (this.mDimFaces) {
                    throw new RSInvalidStateException("Cube maps not supported with 3D types.");
                }
            }
            if (this.mDimY > 0 && this.mDimX < 1) {
                throw new RSInvalidStateException("X dimension required when Y is present.");
            }
            if (this.mDimFaces && this.mDimY < 1) {
                throw new RSInvalidStateException("Cube maps require 2D Types.");
            }
            if (this.mYuv != 0 && (this.mDimZ != 0 || this.mDimFaces || this.mDimMipmaps)) {
                throw new RSInvalidStateException("YUV only supports basic 2D.");
            }
            int[] arrays = null;
            for (int ct = 3; ct >= 0; --ct) {
                if (this.mArray[ct] != 0 && arrays == null) {
                    arrays = new int[ct];
                }
                if (this.mArray[ct] != 0 || arrays == null) continue;
                throw new RSInvalidStateException("Array dimensions must be contigous from 0.");
            }
            long id2 = this.mRS.nTypeCreate(this.mElement.getID(this.mRS), this.mDimX, this.mDimY, this.mDimZ, this.mDimMipmaps, this.mDimFaces, this.mYuv);
            Type t = new Type(id2, this.mRS);
            t.mElement = this.mElement;
            t.mDimX = this.mDimX;
            t.mDimY = this.mDimY;
            t.mDimZ = this.mDimZ;
            t.mDimMipmaps = this.mDimMipmaps;
            t.mDimFaces = this.mDimFaces;
            t.mDimYuv = this.mYuv;
            t.mArrays = arrays;
            t.calcElementCount();
            return t;
        }
    }

    public static enum CubemapFace {
        POSITIVE_X(0),
        NEGATIVE_X(1),
        POSITIVE_Y(2),
        NEGATIVE_Y(3),
        POSITIVE_Z(4),
        NEGATIVE_Z(5),
        POSITVE_X(0),
        POSITVE_Y(2),
        POSITVE_Z(4);

        int mID;

        private CubemapFace(int id2) {
            this.mID = id2;
        }
    }
}

