/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterEntry
implements Parcelable {
    public static final int ENTRY_SEVERITY_LEVEL_UNKNOWN = 3000;
    public static final int ENTRY_SEVERITY_LEVEL_UNSPECIFIED = 3100;
    public static final int ENTRY_SEVERITY_LEVEL_OK = 3200;
    public static final int ENTRY_SEVERITY_LEVEL_RECOMMENDATION = 3300;
    public static final int ENTRY_SEVERITY_LEVEL_CRITICAL_WARNING = 3400;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_NO_ICON = 0;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_PRIVACY = 1;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_NO_RECOMMENDATION = 2;
    public static final Parcelable.Creator<SafetyCenterEntry> CREATOR = new Parcelable.Creator<SafetyCenterEntry>(){

        @Override
        public SafetyCenterEntry createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(id2, title).setSummary(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).setSeverityLevel(in.readInt()).setSeverityUnspecifiedIconType(in.readInt()).setEnabled(in.readBoolean()).setPendingIntent(in.readTypedObject(PendingIntent.CREATOR)).setIconAction(in.readTypedObject(IconAction.CREATOR)).build();
        }

        public SafetyCenterEntry[] newArray(int size) {
            return new SafetyCenterEntry[size];
        }
    };
    private final String mId;
    private final CharSequence mTitle;
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final int mSeverityUnspecifiedIconType;
    private final boolean mEnabled;
    private final PendingIntent mPendingIntent;
    private final IconAction mIconAction;

    private SafetyCenterEntry(String id2, CharSequence title, CharSequence summary, int severityLevel, int severityUnspecifiedIconType, boolean enabled, PendingIntent pendingIntent, IconAction iconAction) {
        this.mId = id2;
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mSeverityUnspecifiedIconType = severityUnspecifiedIconType;
        this.mEnabled = enabled;
        this.mPendingIntent = pendingIntent;
        this.mIconAction = iconAction;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getSeverityUnspecifiedIconType() {
        return this.mSeverityUnspecifiedIconType;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public IconAction getIconAction() {
        return this.mIconAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterEntry)) {
            return false;
        }
        SafetyCenterEntry that = (SafetyCenterEntry)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mSeverityUnspecifiedIconType == that.mSeverityUnspecifiedIconType && this.mEnabled == that.mEnabled && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mPendingIntent, that.mPendingIntent) && Objects.equals(this.mIconAction, that.mIconAction);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEnabled, this.mPendingIntent, this.mIconAction);
    }

    public String toString() {
        return "SafetyCenterEntry{mId='" + this.mId + '\'' + ", mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mSeverityUnspecifiedIconType=" + this.mSeverityUnspecifiedIconType + ", mEnabled=" + this.mEnabled + ", mPendingIntent=" + this.mPendingIntent + ", mIconAction=" + this.mIconAction + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mSeverityUnspecifiedIconType);
        dest.writeBoolean(this.mEnabled);
        dest.writeTypedObject(this.mPendingIntent, flags);
        dest.writeTypedObject(this.mIconAction, flags);
    }

    private static int validateEntrySeverityLevel(int value2) {
        switch (value2) {
            case 3000: 
            case 3100: 
            case 3200: 
            case 3300: 
            case 3400: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected EntrySeverityLevel for SafetyCenterEntry: %s", value2));
    }

    private static int validateSeverityUnspecifiedIconType(int value2) {
        switch (value2) {
            case 0: 
            case 1: 
            case 2: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected SeverityUnspecifiedIconType for SafetyCenterEntry: %s", value2));
    }

    public static class IconAction
    implements Parcelable {
        public static final int ICON_ACTION_TYPE_GEAR = 30100;
        public static final int ICON_ACTION_TYPE_INFO = 30200;
        public static final Parcelable.Creator<IconAction> CREATOR = new Parcelable.Creator<IconAction>(){

            @Override
            public IconAction createFromParcel(Parcel in) {
                int type = in.readInt();
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                return new IconAction(type, pendingIntent);
            }

            public IconAction[] newArray(int size) {
                return new IconAction[size];
            }
        };
        private final int mType;
        private final PendingIntent mPendingIntent;

        public IconAction(int type, PendingIntent pendingIntent) {
            this.mType = IconAction.validateIconActionType(type);
            this.mPendingIntent = Objects.requireNonNull(pendingIntent);
        }

        public int getType() {
            return this.mType;
        }

        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IconAction)) {
                return false;
            }
            IconAction that = (IconAction)o;
            return this.mType == that.mType && Objects.equals(this.mPendingIntent, that.mPendingIntent);
        }

        public int hashCode() {
            return Objects.hash(this.mType, this.mPendingIntent);
        }

        public String toString() {
            return "IconAction{mType=" + this.mType + ", mPendingIntent=" + this.mPendingIntent + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeTypedObject(this.mPendingIntent, flags);
        }

        private static int validateIconActionType(int value2) {
            switch (value2) {
                case 30100: 
                case 30200: {
                    return value2;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected IconActionType for IconAction: %s", value2));
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconActionType {
        }
    }

    public static class Builder {
        private String mId;
        private CharSequence mTitle;
        private CharSequence mSummary;
        private int mSeverityLevel = 3000;
        private int mSeverityUnspecifiedIconType = 0;
        private boolean mEnabled = true;
        private PendingIntent mPendingIntent;
        private IconAction mIconAction;

        public Builder(String id2, CharSequence title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder(SafetyCenterEntry safetyCenterEntry) {
            this.mId = safetyCenterEntry.mId;
            this.mTitle = safetyCenterEntry.mTitle;
            this.mSummary = safetyCenterEntry.mSummary;
            this.mSeverityLevel = safetyCenterEntry.mSeverityLevel;
            this.mSeverityUnspecifiedIconType = safetyCenterEntry.mSeverityUnspecifiedIconType;
            this.mEnabled = safetyCenterEntry.mEnabled;
            this.mPendingIntent = safetyCenterEntry.mPendingIntent;
            this.mIconAction = safetyCenterEntry.mIconAction;
        }

        public Builder setId(String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterEntry.validateEntrySeverityLevel(severityLevel);
            return this;
        }

        public Builder setSeverityUnspecifiedIconType(int severityUnspecifiedIconType) {
            this.mSeverityUnspecifiedIconType = SafetyCenterEntry.validateSeverityUnspecifiedIconType(severityUnspecifiedIconType);
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        public Builder setIconAction(IconAction iconAction) {
            this.mIconAction = iconAction;
            return this;
        }

        public Builder setIconAction(int type, PendingIntent pendingIntent) {
            this.mIconAction = new IconAction(type, pendingIntent);
            return this;
        }

        public SafetyCenterEntry build() {
            return new SafetyCenterEntry(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEnabled, this.mPendingIntent, this.mIconAction);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeverityUnspecifiedIconType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntrySeverityLevel {
    }
}

