/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.SafetyCenterEntry;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterEntryGroup
implements Parcelable {
    public static final Parcelable.Creator<SafetyCenterEntryGroup> CREATOR = new Parcelable.Creator<SafetyCenterEntryGroup>(){

        @Override
        public SafetyCenterEntryGroup createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(id2, title).setSummary(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).setSeverityLevel(in.readInt()).setSeverityUnspecifiedIconType(in.readInt()).setEntries(in.createTypedArrayList(SafetyCenterEntry.CREATOR)).build();
        }

        public SafetyCenterEntryGroup[] newArray(int size) {
            return new SafetyCenterEntryGroup[size];
        }
    };
    private final String mId;
    private final CharSequence mTitle;
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final int mSeverityUnspecifiedIconType;
    private final List<SafetyCenterEntry> mEntries;

    private SafetyCenterEntryGroup(String id2, CharSequence title, CharSequence summary, int severityLevel, int severityUnspecifiedIconType, List<SafetyCenterEntry> entries) {
        this.mId = id2;
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mSeverityUnspecifiedIconType = severityUnspecifiedIconType;
        this.mEntries = entries;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getSeverityUnspecifiedIconType() {
        return this.mSeverityUnspecifiedIconType;
    }

    public List<SafetyCenterEntry> getEntries() {
        return this.mEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterEntryGroup)) {
            return false;
        }
        SafetyCenterEntryGroup that = (SafetyCenterEntryGroup)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mSeverityUnspecifiedIconType == that.mSeverityUnspecifiedIconType && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mEntries, that.mEntries);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEntries);
    }

    public String toString() {
        return "SafetyCenterEntryGroup{mId='" + this.mId + '\'' + ", mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mSeverityUnspecifiedIconType=" + this.mSeverityUnspecifiedIconType + ", mEntries=" + this.mEntries + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mSeverityUnspecifiedIconType);
        dest.writeTypedList(this.mEntries);
    }

    private static int validateEntrySeverityLevel(int value2) {
        switch (value2) {
            case 3000: 
            case 3100: 
            case 3200: 
            case 3300: 
            case 3400: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected EntrySeverityLevel for SafetyCenterEntryGroup: %s", value2));
    }

    private static int validateSeverityUnspecifiedIconType(int value2) {
        switch (value2) {
            case 0: 
            case 1: 
            case 2: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected SeverityUnspecifiedIconType for SafetyCenterEntryGroup: %s", value2));
    }

    public static class Builder {
        private String mId;
        private CharSequence mTitle;
        private CharSequence mSummary;
        private int mSeverityLevel = 3000;
        private int mSeverityUnspecifiedIconType = 0;
        private List<SafetyCenterEntry> mEntries = new ArrayList<SafetyCenterEntry>();

        public Builder(String id2, CharSequence title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder(SafetyCenterEntryGroup safetyCenterEntryGroup) {
            this.mId = safetyCenterEntryGroup.mId;
            this.mTitle = safetyCenterEntryGroup.mTitle;
            this.mSummary = safetyCenterEntryGroup.mSummary;
            this.mSeverityLevel = safetyCenterEntryGroup.mSeverityLevel;
            this.mSeverityUnspecifiedIconType = safetyCenterEntryGroup.mSeverityUnspecifiedIconType;
            this.mEntries = new ArrayList<SafetyCenterEntry>(safetyCenterEntryGroup.mEntries);
        }

        public Builder setId(String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterEntryGroup.validateEntrySeverityLevel(severityLevel);
            return this;
        }

        public Builder setSeverityUnspecifiedIconType(int severityUnspecifiedIconType) {
            this.mSeverityUnspecifiedIconType = SafetyCenterEntryGroup.validateSeverityUnspecifiedIconType(severityUnspecifiedIconType);
            return this;
        }

        public Builder setEntries(List<SafetyCenterEntry> entries) {
            this.mEntries = Objects.requireNonNull(entries);
            return this;
        }

        public SafetyCenterEntryGroup build() {
            return new SafetyCenterEntryGroup(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, Collections.unmodifiableList(new ArrayList<SafetyCenterEntry>(this.mEntries)));
        }
    }
}

