/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterIssue
implements Parcelable {
    public static final int ISSUE_SEVERITY_LEVEL_OK = 2100;
    public static final int ISSUE_SEVERITY_LEVEL_RECOMMENDATION = 2200;
    public static final int ISSUE_SEVERITY_LEVEL_CRITICAL_WARNING = 2300;
    public static final Parcelable.Creator<SafetyCenterIssue> CREATOR = new Parcelable.Creator<SafetyCenterIssue>(){

        @Override
        public SafetyCenterIssue createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence subtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(id2, title, summary).setSubtitle(subtitle).setSeverityLevel(in.readInt()).setDismissible(in.readBoolean()).setShouldConfirmDismissal(in.readBoolean()).setActions(in.createTypedArrayList(Action.CREATOR)).build();
        }

        public SafetyCenterIssue[] newArray(int size) {
            return new SafetyCenterIssue[size];
        }
    };
    private final String mId;
    private final CharSequence mTitle;
    private final CharSequence mSubtitle;
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final boolean mDismissible;
    private final boolean mShouldConfirmDismissal;
    private final List<Action> mActions;

    private SafetyCenterIssue(String id2, CharSequence title, CharSequence subtitle, CharSequence summary, int severityLevel, boolean isDismissible, boolean shouldConfirmDismissal, List<Action> actions2) {
        this.mId = id2;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mDismissible = isDismissible;
        this.mShouldConfirmDismissal = shouldConfirmDismissal;
        this.mActions = actions2;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public boolean isDismissible() {
        return this.mDismissible;
    }

    public boolean shouldConfirmDismissal() {
        return this.mShouldConfirmDismissal;
    }

    public List<Action> getActions() {
        return this.mActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterIssue)) {
            return false;
        }
        SafetyCenterIssue that = (SafetyCenterIssue)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mDismissible == that.mDismissible && this.mShouldConfirmDismissal == that.mShouldConfirmDismissal && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSubtitle, that.mSubtitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mActions, that.mActions);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mDismissible, this.mShouldConfirmDismissal, this.mActions);
    }

    public String toString() {
        return "SafetyCenterIssue{mId='" + this.mId + '\'' + ", mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mDismissible=" + this.mDismissible + ", mConfirmDismissal=" + this.mShouldConfirmDismissal + ", mActions=" + this.mActions + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSubtitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeBoolean(this.mDismissible);
        dest.writeBoolean(this.mShouldConfirmDismissal);
        dest.writeTypedList(this.mActions);
    }

    private static int validateIssueSeverityLevel(int value2) {
        switch (value2) {
            case 2100: 
            case 2200: 
            case 2300: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected IssueSeverityLevel for SafetyCenterIssue: %s", value2));
    }

    @SystemApi
    public static class Action
    implements Parcelable {
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                String id2 = in.readString();
                CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                return new Builder(id2, label, pendingIntent).setWillResolve(in.readBoolean()).setIsInFlight(in.readBoolean()).setSuccessMessage(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).build();
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };
        private final String mId;
        private final CharSequence mLabel;
        private final PendingIntent mPendingIntent;
        private final boolean mWillResolve;
        private final boolean mInFlight;
        private final CharSequence mSuccessMessage;

        private Action(String id2, CharSequence label, PendingIntent pendingIntent, boolean willResolve, boolean inFlight, CharSequence successMessage) {
            this.mId = id2;
            this.mLabel = label;
            this.mPendingIntent = pendingIntent;
            this.mWillResolve = willResolve;
            this.mInFlight = inFlight;
            this.mSuccessMessage = successMessage;
        }

        public String getId() {
            return this.mId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean willResolve() {
            return this.mWillResolve;
        }

        public boolean isInFlight() {
            return this.mInFlight;
        }

        public CharSequence getSuccessMessage() {
            return this.mSuccessMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action action2 = (Action)o;
            return Objects.equals(this.mId, action2.mId) && TextUtils.equals(this.mLabel, action2.mLabel) && Objects.equals(this.mPendingIntent, action2.mPendingIntent) && this.mWillResolve == action2.mWillResolve && this.mInFlight == action2.mInFlight && TextUtils.equals(this.mSuccessMessage, action2.mSuccessMessage);
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mLabel, this.mSuccessMessage, this.mWillResolve, this.mInFlight, this.mPendingIntent);
        }

        public String toString() {
            return "Action{mId=" + this.mId + ", mLabel=" + this.mLabel + ", mPendingIntent=" + this.mPendingIntent + ", mWillResolve=" + this.mWillResolve + ", mInFlight=" + this.mInFlight + ", mSuccessMessage=" + this.mSuccessMessage + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mId);
            TextUtils.writeToParcel(this.mLabel, dest, flags);
            dest.writeTypedObject(this.mPendingIntent, flags);
            dest.writeBoolean(this.mWillResolve);
            dest.writeBoolean(this.mInFlight);
            TextUtils.writeToParcel(this.mSuccessMessage, dest, flags);
        }

        public static class Builder {
            private String mId;
            private CharSequence mLabel;
            private PendingIntent mPendingIntent;
            private boolean mWillResolve;
            private boolean mInFlight;
            private CharSequence mSuccessMessage;

            public Builder(String id2, CharSequence label, PendingIntent pendingIntent) {
                this.mId = Objects.requireNonNull(id2);
                this.mLabel = Objects.requireNonNull(label);
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
            }

            public Builder setId(String id2) {
                this.mId = Objects.requireNonNull(id2);
                return this;
            }

            public Builder setLabel(CharSequence label) {
                this.mLabel = Objects.requireNonNull(label);
                return this;
            }

            public Builder setPendingIntent(PendingIntent pendingIntent) {
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
                return this;
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            public Builder setWillResolve(boolean willResolve) {
                this.mWillResolve = willResolve;
                return this;
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            public Builder setIsInFlight(boolean inFlight) {
                this.mInFlight = inFlight;
                return this;
            }

            public Builder setSuccessMessage(CharSequence successMessage) {
                this.mSuccessMessage = successMessage;
                return this;
            }

            public Action build() {
                return new Action(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mInFlight, this.mSuccessMessage);
            }
        }
    }

    public static class Builder {
        private String mId;
        private CharSequence mTitle;
        private CharSequence mSummary;
        private CharSequence mSubtitle;
        private int mSeverityLevel = 2100;
        private boolean mDismissible = true;
        private boolean mShouldConfirmDismissal = true;
        private List<Action> mActions = new ArrayList<Action>();

        public Builder(String id2, CharSequence title, CharSequence summary) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
        }

        public Builder(SafetyCenterIssue issue) {
            this.mId = issue.mId;
            this.mTitle = issue.mTitle;
            this.mSubtitle = issue.mSubtitle;
            this.mSummary = issue.mSummary;
            this.mSeverityLevel = issue.mSeverityLevel;
            this.mDismissible = issue.mDismissible;
            this.mShouldConfirmDismissal = issue.mShouldConfirmDismissal;
            this.mActions = new ArrayList<Action>(issue.mActions);
        }

        public Builder setId(String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = Objects.requireNonNull(summary);
            return this;
        }

        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterIssue.validateIssueSeverityLevel(severityLevel);
            return this;
        }

        public Builder setDismissible(boolean dismissible) {
            this.mDismissible = dismissible;
            return this;
        }

        public Builder setShouldConfirmDismissal(boolean confirmDismissal) {
            this.mShouldConfirmDismissal = confirmDismissal;
            return this;
        }

        public Builder setActions(List<Action> actions2) {
            this.mActions = Objects.requireNonNull(actions2);
            return this;
        }

        public SafetyCenterIssue build() {
            return new SafetyCenterIssue(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mDismissible, this.mShouldConfirmDismissal, Collections.unmodifiableList(new ArrayList<Action>(this.mActions)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IssueSeverityLevel {
    }
}

