/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.safetycenter.IOnSafetyCenterDataChangedListener;
import android.safetycenter.ISafetyCenterManager;
import android.safetycenter.SafetyCenterData;
import android.safetycenter.SafetyCenterErrorDetails;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import android.safetycenter.config.SafetyCenterConfig;
import android.util.ArrayMap;
import androidx.annotation.RequiresApi;
import com.android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterManager {
    public static final String ACTION_SAFETY_CENTER_ENABLED_CHANGED = "android.safetycenter.action.SAFETY_CENTER_ENABLED_CHANGED";
    public static final String ACTION_REFRESH_SAFETY_SOURCES = "android.safetycenter.action.REFRESH_SAFETY_SOURCES";
    public static final String EXTRA_REFRESH_SAFETY_SOURCE_IDS = "android.safetycenter.extra.REFRESH_SAFETY_SOURCE_IDS";
    public static final String EXTRA_REFRESH_SAFETY_SOURCES_REQUEST_TYPE = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_REQUEST_TYPE";
    public static final String EXTRA_REFRESH_SAFETY_SOURCES_BROADCAST_ID = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_BROADCAST_ID";
    public static final String EXTRA_SAFETY_SOURCE_ISSUE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ISSUE_ID";
    public static final String EXTRA_SAFETY_SOURCE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ID";
    public static final String EXTRA_SAFETY_SOURCE_USER_HANDLE = "android.safetycenter.extra.SAFETY_SOURCE_USER_HANDLE";
    public static final int EXTRA_REFRESH_REQUEST_TYPE_FETCH_FRESH_DATA = 0;
    public static final int EXTRA_REFRESH_REQUEST_TYPE_GET_DATA = 1;
    public static final int REFRESH_REASON_PAGE_OPEN = 100;
    public static final int REFRESH_REASON_RESCAN_BUTTON_CLICK = 200;
    public static final int REFRESH_REASON_DEVICE_REBOOT = 300;
    public static final int REFRESH_REASON_DEVICE_LOCALE_CHANGE = 400;
    public static final int REFRESH_REASON_SAFETY_CENTER_ENABLED = 500;
    public static final int REFRESH_REASON_OTHER = 600;
    private final Object mListenersLock = new Object();
    @GuardedBy(value={"mListenersLock"})
    private final Map<OnSafetyCenterDataChangedListener, ListenerDelegate> mListenersToDelegates = new ArrayMap<OnSafetyCenterDataChangedListener, ListenerDelegate>();
    private final Context mContext;
    private final ISafetyCenterManager mService;

    public SafetyCenterManager(Context context, ISafetyCenterManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(anyOf={"android.permission.READ_SAFETY_CENTER_STATUS", "android.permission.SEND_SAFETY_CENTER_UPDATE"})
    public boolean isSafetyCenterEnabled() {
        try {
            return this.mService.isSafetyCenterEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    public void setSafetySourceData(String safetySourceId, SafetySourceData safetySourceData, SafetyEvent safetyEvent) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        Objects.requireNonNull(safetyEvent, "safetyEvent cannot be null");
        try {
            this.mService.setSafetySourceData(safetySourceId, safetySourceData, safetyEvent, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    public SafetySourceData getSafetySourceData(String safetySourceId) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        try {
            return this.mService.getSafetySourceData(safetySourceId, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SEND_SAFETY_CENTER_UPDATE")
    public void reportSafetySourceError(String safetySourceId, SafetySourceErrorDetails safetySourceErrorDetails) {
        Objects.requireNonNull(safetySourceId, "safetySourceId cannot be null");
        Objects.requireNonNull(safetySourceErrorDetails, "safetySourceErrorDetails cannot be null");
        try {
            this.mService.reportSafetySourceError(safetySourceId, safetySourceErrorDetails, this.mContext.getPackageName(), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void refreshSafetySources(int refreshReason) {
        try {
            this.mService.refreshSafetySources(refreshReason, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public SafetyCenterConfig getSafetyCenterConfig() {
        try {
            return this.mService.getSafetyCenterConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public SafetyCenterData getSafetyCenterData() {
        try {
            return this.mService.getSafetyCenterData(this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void addOnSafetyCenterDataChangedListener(Executor executor, OnSafetyCenterDataChangedListener listener2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener2, "listener cannot be null");
        Object object = this.mListenersLock;
        synchronized (object) {
            if (this.mListenersToDelegates.containsKey(listener2)) {
                return;
            }
            ListenerDelegate delegate = new ListenerDelegate(executor, listener2);
            try {
                this.mService.addOnSafetyCenterDataChangedListener(delegate, this.mContext.getUser().getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mListenersToDelegates.put(listener2, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void removeOnSafetyCenterDataChangedListener(OnSafetyCenterDataChangedListener listener2) {
        Objects.requireNonNull(listener2, "listener cannot be null");
        Object object = this.mListenersLock;
        synchronized (object) {
            ListenerDelegate delegate = this.mListenersToDelegates.get(listener2);
            if (delegate == null) {
                return;
            }
            try {
                this.mService.removeOnSafetyCenterDataChangedListener(delegate, this.mContext.getUser().getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            delegate.markAsRemoved();
            this.mListenersToDelegates.remove(listener2);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void dismissSafetyCenterIssue(String safetyCenterIssueId) {
        Objects.requireNonNull(safetyCenterIssueId, "safetyCenterIssueId cannot be null");
        try {
            this.mService.dismissSafetyCenterIssue(safetyCenterIssueId, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void executeSafetyCenterIssueAction(String safetyCenterIssueId, String safetyCenterIssueActionId) {
        Objects.requireNonNull(safetyCenterIssueId, "safetyCenterIssueId cannot be null");
        Objects.requireNonNull(safetyCenterIssueActionId, "safetyCenterIssueActionId cannot be null");
        try {
            this.mService.executeSafetyCenterIssueAction(safetyCenterIssueId, safetyCenterIssueActionId, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void clearAllSafetySourceDataForTests() {
        try {
            this.mService.clearAllSafetySourceDataForTests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void setSafetyCenterConfigForTests(SafetyCenterConfig safetyCenterConfig) {
        Objects.requireNonNull(safetyCenterConfig, "safetyCenterConfig cannot be null");
        try {
            this.mService.setSafetyCenterConfigForTests(safetyCenterConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SAFETY_CENTER")
    public void clearSafetyCenterConfigForTests() {
        try {
            this.mService.clearSafetyCenterConfigForTests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class ListenerDelegate
    extends IOnSafetyCenterDataChangedListener.Stub {
        private final Executor mExecutor;
        private final OnSafetyCenterDataChangedListener mOriginalListener;
        private volatile boolean mRemoved = false;

        private ListenerDelegate(Executor executor, OnSafetyCenterDataChangedListener originalListener) {
            this.mExecutor = executor;
            this.mOriginalListener = originalListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSafetyCenterDataChanged(SafetyCenterData safetyCenterData) {
            Objects.requireNonNull(safetyCenterData, "safetyCenterData cannot be null");
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    if (this.mRemoved) {
                        return;
                    }
                    this.mOriginalListener.onSafetyCenterDataChanged(safetyCenterData);
                });
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(SafetyCenterErrorDetails safetyCenterErrorDetails) {
            Objects.requireNonNull(safetyCenterErrorDetails, "safetyCenterErrorDetails cannot be null");
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    if (this.mRemoved) {
                        return;
                    }
                    this.mOriginalListener.onError(safetyCenterErrorDetails);
                });
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void markAsRemoved() {
            this.mRemoved = true;
        }
    }

    public static interface OnSafetyCenterDataChangedListener {
        public void onSafetyCenterDataChanged(SafetyCenterData var1);

        default public void onError(SafetyCenterErrorDetails errorDetails) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RefreshReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RefreshRequestType {
    }
}

