/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.SafetySourceIssue;
import android.safetycenter.SafetySourceStatus;
import androidx.annotation.RequiresApi;
import com.android.permission.jarjar.com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourceData
implements Parcelable {
    public static final int SEVERITY_LEVEL_UNSPECIFIED = 100;
    public static final int SEVERITY_LEVEL_INFORMATION = 200;
    public static final int SEVERITY_LEVEL_RECOMMENDATION = 300;
    public static final int SEVERITY_LEVEL_CRITICAL_WARNING = 400;
    public static final Parcelable.Creator<SafetySourceData> CREATOR = new Parcelable.Creator<SafetySourceData>(){

        @Override
        public SafetySourceData createFromParcel(Parcel in) {
            SafetySourceStatus status = in.readTypedObject(SafetySourceStatus.CREATOR);
            List issues = Objects.requireNonNull(in.createTypedArrayList(SafetySourceIssue.CREATOR));
            Builder builder2 = new Builder().setStatus(status);
            for (int i = 0; i < issues.size(); ++i) {
                builder2.addIssue((SafetySourceIssue)issues.get(i));
            }
            return builder2.build();
        }

        public SafetySourceData[] newArray(int size) {
            return new SafetySourceData[size];
        }
    };
    private final SafetySourceStatus mStatus;
    private final List<SafetySourceIssue> mIssues;

    private SafetySourceData(SafetySourceStatus status, List<SafetySourceIssue> issues) {
        this.mStatus = status;
        this.mIssues = issues;
    }

    public SafetySourceStatus getStatus() {
        return this.mStatus;
    }

    public List<SafetySourceIssue> getIssues() {
        return this.mIssues;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mStatus, flags);
        dest.writeTypedList(this.mIssues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourceData)) {
            return false;
        }
        SafetySourceData that = (SafetySourceData)o;
        return Objects.equals(this.mStatus, that.mStatus) && this.mIssues.equals(that.mIssues);
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mIssues);
    }

    public String toString() {
        return "SafetySourceData{, mStatus=" + this.mStatus + ", mIssues=" + this.mIssues + '}';
    }

    public static class Builder {
        private final List<SafetySourceIssue> mIssues = new ArrayList<SafetySourceIssue>();
        private SafetySourceStatus mStatus;

        public Builder setStatus(SafetySourceStatus status) {
            this.mStatus = status;
            return this;
        }

        public Builder addIssue(SafetySourceIssue safetySourceIssue) {
            this.mIssues.add(Objects.requireNonNull(safetySourceIssue));
            return this;
        }

        public Builder clearIssues() {
            this.mIssues.clear();
            return this;
        }

        public SafetySourceData build() {
            int issuesMaxSeverityLevel;
            List<SafetySourceIssue> issues = Collections.unmodifiableList(new ArrayList<SafetySourceIssue>(this.mIssues));
            if (this.mStatus != null && (issuesMaxSeverityLevel = Builder.getIssuesMaxSeverityLevel(issues)) > 200) {
                Preconditions.checkArgument(issuesMaxSeverityLevel <= this.mStatus.getSeverityLevel(), "Safety source data must not contain any issue with a severity level both greater than SEVERITY_LEVEL_INFORMATION and greater than the status severity level");
            }
            return new SafetySourceData(this.mStatus, issues);
        }

        private static int getIssuesMaxSeverityLevel(List<SafetySourceIssue> issues) {
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < issues.size(); ++i) {
                max = Math.max(max, issues.get(i).getSeverityLevel());
            }
            return max;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeverityLevel {
    }
}

