/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.android.permission.jarjar.com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourceIssue
implements Parcelable {
    public static final int ISSUE_CATEGORY_DEVICE = 100;
    public static final int ISSUE_CATEGORY_ACCOUNT = 200;
    public static final int ISSUE_CATEGORY_GENERAL = 300;
    public static final Parcelable.Creator<SafetySourceIssue> CREATOR = new Parcelable.Creator<SafetySourceIssue>(){

        @Override
        public SafetySourceIssue createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence subtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            int severityLevel = in.readInt();
            int issueCategory = in.readInt();
            List actions2 = Objects.requireNonNull(in.createTypedArrayList(Action.CREATOR));
            PendingIntent onDismissPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
            String issueTypeId = in.readString();
            Builder builder2 = new Builder(id2, title, summary, severityLevel, issueTypeId).setSubtitle(subtitle).setIssueCategory(issueCategory).setOnDismissPendingIntent(onDismissPendingIntent);
            for (int i = 0; i < actions2.size(); ++i) {
                builder2.addAction((Action)actions2.get(i));
            }
            return builder2.build();
        }

        public SafetySourceIssue[] newArray(int size) {
            return new SafetySourceIssue[size];
        }
    };
    private final String mId;
    private final CharSequence mTitle;
    private final CharSequence mSubtitle;
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final List<Action> mActions;
    private final PendingIntent mOnDismissPendingIntent;
    private final int mIssueCategory;
    private final String mIssueTypeId;

    private SafetySourceIssue(String id2, CharSequence title, CharSequence subtitle, CharSequence summary, int severityLevel, int issueCategory, List<Action> actions2, PendingIntent onDismissPendingIntent, String issueTypeId) {
        this.mId = id2;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mIssueCategory = issueCategory;
        this.mActions = actions2;
        this.mOnDismissPendingIntent = onDismissPendingIntent;
        this.mIssueTypeId = issueTypeId;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getIssueCategory() {
        return this.mIssueCategory;
    }

    public List<Action> getActions() {
        return this.mActions;
    }

    public PendingIntent getOnDismissPendingIntent() {
        return this.mOnDismissPendingIntent;
    }

    public String getIssueTypeId() {
        return this.mIssueTypeId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSubtitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mIssueCategory);
        dest.writeTypedList(this.mActions);
        dest.writeTypedObject(this.mOnDismissPendingIntent, flags);
        dest.writeString(this.mIssueTypeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourceIssue)) {
            return false;
        }
        SafetySourceIssue that = (SafetySourceIssue)o;
        return this.mSeverityLevel == that.mSeverityLevel && TextUtils.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSubtitle, that.mSubtitle) && TextUtils.equals(this.mSummary, that.mSummary) && this.mIssueCategory == that.mIssueCategory && this.mActions.equals(that.mActions) && Objects.equals(this.mOnDismissPendingIntent, that.mOnDismissPendingIntent) && TextUtils.equals(this.mIssueTypeId, that.mIssueTypeId);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mIssueCategory, this.mActions, this.mOnDismissPendingIntent, this.mIssueTypeId);
    }

    public String toString() {
        return "SafetySourceIssue{mId=" + this.mId + "mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mIssueCategory=" + this.mIssueCategory + ", mActions=" + this.mActions + ", mOnDismissPendingIntent=" + this.mOnDismissPendingIntent + ", mIssueTypeId=" + this.mIssueTypeId + '}';
    }

    private static int validateSeverityLevel(int value2) {
        switch (value2) {
            case 200: 
            case 300: 
            case 400: {
                return value2;
            }
            case 100: {
                throw new IllegalArgumentException("SeverityLevel for SafetySourceIssue must not be SEVERITY_LEVEL_UNSPECIFIED");
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected SeverityLevel for SafetySourceIssue: %s", value2));
    }

    private static int validateIssueCategory(int value2) {
        switch (value2) {
            case 100: 
            case 200: 
            case 300: {
                return value2;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected IssueCategory for SafetySourceIssue: %s", value2));
    }

    public static class Builder {
        private final String mId;
        private final CharSequence mTitle;
        private final CharSequence mSummary;
        private final int mSeverityLevel;
        private final String mIssueTypeId;
        private final List<Action> mActions = new ArrayList<Action>();
        private CharSequence mSubtitle;
        private int mIssueCategory = 300;
        private PendingIntent mOnDismissPendingIntent;

        public Builder(String id2, CharSequence title, CharSequence summary, int severityLevel, String issueTypeId) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
            this.mSeverityLevel = SafetySourceIssue.validateSeverityLevel(severityLevel);
            this.mIssueTypeId = Objects.requireNonNull(issueTypeId);
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        public Builder setIssueCategory(int issueCategory) {
            this.mIssueCategory = SafetySourceIssue.validateIssueCategory(issueCategory);
            return this;
        }

        public Builder addAction(Action actionData2) {
            this.mActions.add(Objects.requireNonNull(actionData2));
            return this;
        }

        public Builder clearActions() {
            this.mActions.clear();
            return this;
        }

        public Builder setOnDismissPendingIntent(PendingIntent onDismissPendingIntent) {
            Preconditions.checkArgument(onDismissPendingIntent == null || !onDismissPendingIntent.isActivity(), "Safety source issue on dismiss pending intent must not start an activity");
            this.mOnDismissPendingIntent = onDismissPendingIntent;
            return this;
        }

        public SafetySourceIssue build() {
            List<Action> actions2 = Collections.unmodifiableList(new ArrayList<Action>(this.mActions));
            Preconditions.checkArgument(!actions2.isEmpty(), "Safety source issue must contain at least 1 action");
            Preconditions.checkArgument(actions2.size() <= 2, "Safety source issue must not contain more than 2 actions");
            return new SafetySourceIssue(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mIssueCategory, actions2, this.mOnDismissPendingIntent, this.mIssueTypeId);
        }
    }

    @SystemApi
    public static class Action
    implements Parcelable {
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                String id2 = in.readString();
                CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                return new Builder(id2, label, pendingIntent).setWillResolve(in.readBoolean()).setSuccessMessage(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).build();
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };
        private final String mId;
        private final CharSequence mLabel;
        private final PendingIntent mPendingIntent;
        private final boolean mWillResolve;
        private final CharSequence mSuccessMessage;

        private Action(String id2, CharSequence label, PendingIntent pendingIntent, boolean willResolve, CharSequence successMessage) {
            this.mId = id2;
            this.mLabel = label;
            this.mPendingIntent = pendingIntent;
            this.mWillResolve = willResolve;
            this.mSuccessMessage = successMessage;
        }

        public String getId() {
            return this.mId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean willResolve() {
            return this.mWillResolve;
        }

        public CharSequence getSuccessMessage() {
            return this.mSuccessMessage;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mId);
            TextUtils.writeToParcel(this.mLabel, dest, flags);
            dest.writeTypedObject(this.mPendingIntent, flags);
            dest.writeBoolean(this.mWillResolve);
            TextUtils.writeToParcel(this.mSuccessMessage, dest, flags);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action that = (Action)o;
            return this.mId.equals(that.mId) && TextUtils.equals(this.mLabel, that.mLabel) && this.mPendingIntent.equals(that.mPendingIntent) && this.mWillResolve == that.mWillResolve && TextUtils.equals(this.mSuccessMessage, that.mSuccessMessage);
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mSuccessMessage);
        }

        public String toString() {
            return "Action{mId=" + this.mId + ", mLabel=" + this.mLabel + ", mPendingIntent=" + this.mPendingIntent + ", mWillResolve=" + this.mWillResolve + ", mSuccessMessage=" + this.mSuccessMessage + '}';
        }

        public static class Builder {
            private final String mId;
            private final CharSequence mLabel;
            private final PendingIntent mPendingIntent;
            private boolean mWillResolve = false;
            private CharSequence mSuccessMessage;

            public Builder(String id2, CharSequence label, PendingIntent pendingIntent) {
                this.mId = Objects.requireNonNull(id2);
                this.mLabel = Objects.requireNonNull(label);
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            public Builder setWillResolve(boolean willResolve) {
                this.mWillResolve = willResolve;
                return this;
            }

            public Builder setSuccessMessage(CharSequence successMessage) {
                this.mSuccessMessage = successMessage;
                return this;
            }

            public Action build() {
                return new Action(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mSuccessMessage);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IssueCategory {
    }
}

