/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import androidx.annotation.RequiresApi;
import java.util.Objects;

@RequiresApi(value=33)
class BuilderUtils {
    private BuilderUtils() {
    }

    private static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited, Object defaultValue) {
        boolean checkProhibited;
        if (attribute == null && required) {
            throw new IllegalStateException(String.format("Required attribute %s missing", name));
        }
        boolean nonDefaultValueProvided = !Objects.equals(attribute, defaultValue);
        boolean bl = checkProhibited = prohibited && nonDefaultValueProvided;
        if (attribute != null && checkProhibited) {
            throw new IllegalStateException(String.format("Prohibited attribute %s present", name));
        }
    }

    static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(attribute, name, required, prohibited, null);
    }

    static int validateResId(Integer value2, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(value2, name, required, prohibited, 0);
        if (value2 == null) {
            return 0;
        }
        if (required && value2 == 0) {
            throw new IllegalStateException(String.format("Required attribute %s invalid", name));
        }
        return value2;
    }

    static int validateIntDef(Integer value2, String name, boolean required, boolean prohibited, int defaultValue, int ... validValues) {
        BuilderUtils.validateAttribute(value2, name, required, prohibited, defaultValue);
        if (value2 == null) {
            return defaultValue;
        }
        boolean found = false;
        for (int i = 0; i < validValues.length; ++i) {
            found |= value2 == validValues[i];
        }
        if (!found) {
            throw new IllegalStateException(String.format("Attribute %s invalid", name));
        }
        return value2;
    }

    static int validateInteger(Integer value2, String name, boolean required, boolean prohibited, int defaultValue) {
        BuilderUtils.validateAttribute(value2, name, required, prohibited, defaultValue);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    static boolean validateBoolean(Boolean value2, String name, boolean required, boolean prohibited, boolean defaultValue) {
        BuilderUtils.validateAttribute(value2, name, required, prohibited, defaultValue);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }
}

