/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.config.SafetySource;
import android.safetycenter.config.SafetySourcesGroup;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterConfig
implements Parcelable {
    public static final Parcelable.Creator<SafetyCenterConfig> CREATOR = new Parcelable.Creator<SafetyCenterConfig>(){

        @Override
        public SafetyCenterConfig createFromParcel(Parcel in) {
            List safetySourcesGroups = Objects.requireNonNull(in.createTypedArrayList(SafetySourcesGroup.CREATOR));
            Builder builder2 = new Builder();
            for (int i = 0; i < safetySourcesGroups.size(); ++i) {
                builder2.addSafetySourcesGroup((SafetySourcesGroup)safetySourcesGroups.get(i));
            }
            return builder2.build();
        }

        public SafetyCenterConfig[] newArray(int size) {
            return new SafetyCenterConfig[size];
        }
    };
    private final List<SafetySourcesGroup> mSafetySourcesGroups;

    private SafetyCenterConfig(List<SafetySourcesGroup> safetySourcesGroups) {
        this.mSafetySourcesGroups = safetySourcesGroups;
    }

    public List<SafetySourcesGroup> getSafetySourcesGroups() {
        return this.mSafetySourcesGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterConfig)) {
            return false;
        }
        SafetyCenterConfig that = (SafetyCenterConfig)o;
        return Objects.equals(this.mSafetySourcesGroups, that.mSafetySourcesGroups);
    }

    public int hashCode() {
        return Objects.hash(this.mSafetySourcesGroups);
    }

    public String toString() {
        return "SafetyCenterConfig{mSafetySourcesGroups=" + this.mSafetySourcesGroups + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mSafetySourcesGroups);
    }

    public static class Builder {
        private final List<SafetySourcesGroup> mSafetySourcesGroups = new ArrayList<SafetySourcesGroup>();

        public Builder addSafetySourcesGroup(SafetySourcesGroup safetySourcesGroup) {
            this.mSafetySourcesGroups.add(Objects.requireNonNull(safetySourcesGroup));
            return this;
        }

        public SafetyCenterConfig build() {
            List<SafetySourcesGroup> safetySourcesGroups = Collections.unmodifiableList(new ArrayList<SafetySourcesGroup>(this.mSafetySourcesGroups));
            if (safetySourcesGroups.isEmpty()) {
                throw new IllegalStateException("No safety sources groups present");
            }
            HashSet<String> safetySourceIds = new HashSet<String>();
            HashSet<String> safetySourcesGroupsIds = new HashSet<String>();
            int safetySourcesGroupsSize = safetySourcesGroups.size();
            for (int i = 0; i < safetySourcesGroupsSize; ++i) {
                SafetySourcesGroup safetySourcesGroup = safetySourcesGroups.get(i);
                String groupId = safetySourcesGroup.getId();
                if (safetySourcesGroupsIds.contains(groupId)) {
                    throw new IllegalStateException(String.format("Duplicate id %s among safety sources groups", groupId));
                }
                safetySourcesGroupsIds.add(groupId);
                List<SafetySource> safetySources = safetySourcesGroup.getSafetySources();
                int safetySourcesSize = safetySources.size();
                for (int j = 0; j < safetySourcesSize; ++j) {
                    SafetySource staticSafetySource = safetySources.get(j);
                    String sourceId = staticSafetySource.getId();
                    if (safetySourceIds.contains(sourceId)) {
                        throw new IllegalStateException(String.format("Duplicate id %s among safety sources", sourceId));
                    }
                    safetySourceIds.add(sourceId);
                }
            }
            return new SafetyCenterConfig(safetySourcesGroups);
        }
    }
}

