/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.config.BuilderUtils;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySource
implements Parcelable {
    public static final int SAFETY_SOURCE_TYPE_STATIC = 1;
    public static final int SAFETY_SOURCE_TYPE_DYNAMIC = 2;
    public static final int SAFETY_SOURCE_TYPE_ISSUE_ONLY = 3;
    public static final int PROFILE_NONE = 0;
    public static final int PROFILE_PRIMARY = 1;
    public static final int PROFILE_ALL = 2;
    public static final int INITIAL_DISPLAY_STATE_ENABLED = 0;
    public static final int INITIAL_DISPLAY_STATE_DISABLED = 1;
    public static final int INITIAL_DISPLAY_STATE_HIDDEN = 2;
    public static final Parcelable.Creator<SafetySource> CREATOR = new Parcelable.Creator<SafetySource>(){

        @Override
        public SafetySource createFromParcel(Parcel in) {
            int type = in.readInt();
            return new Builder(type).setId(in.readString()).setPackageName(in.readString()).setTitleResId(in.readInt()).setTitleForWorkResId(in.readInt()).setSummaryResId(in.readInt()).setIntentAction(in.readString()).setProfile(in.readInt()).setInitialDisplayState(in.readInt()).setMaxSeverityLevel(in.readInt()).setSearchTermsResId(in.readInt()).setLoggingAllowed(in.readBoolean()).setRefreshOnPageOpenAllowed(in.readBoolean()).build();
        }

        public SafetySource[] newArray(int size) {
            return new SafetySource[size];
        }
    };
    private final int mType;
    private final String mId;
    private final String mPackageName;
    private final int mTitleResId;
    private final int mTitleForWorkResId;
    private final int mSummaryResId;
    private final String mIntentAction;
    private final int mProfile;
    private final int mInitialDisplayState;
    private final int mMaxSeverityLevel;
    private final int mSearchTermsResId;
    private final boolean mLoggingAllowed;
    private final boolean mRefreshOnPageOpenAllowed;

    private SafetySource(int type, String id2, String packageName, int titleResId, int titleForWorkResId, int summaryResId, String intentAction, int profile, int initialDisplayState, int maxSeverityLevel, int searchTermsResId, boolean loggingAllowed, boolean refreshOnPageOpenAllowed) {
        this.mType = type;
        this.mId = id2;
        this.mPackageName = packageName;
        this.mTitleResId = titleResId;
        this.mTitleForWorkResId = titleForWorkResId;
        this.mSummaryResId = summaryResId;
        this.mIntentAction = intentAction;
        this.mProfile = profile;
        this.mInitialDisplayState = initialDisplayState;
        this.mMaxSeverityLevel = maxSeverityLevel;
        this.mSearchTermsResId = searchTermsResId;
        this.mLoggingAllowed = loggingAllowed;
        this.mRefreshOnPageOpenAllowed = refreshOnPageOpenAllowed;
    }

    public int getType() {
        return this.mType;
    }

    public String getId() {
        return this.mId;
    }

    public String getPackageName() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getPackageName unsupported for static safety source");
        }
        return this.mPackageName;
    }

    public int getTitleResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getTitleResId unsupported for issue-only safety source");
        }
        return this.mTitleResId;
    }

    public int getTitleForWorkResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getTitleForWorkResId unsupported for issue-only safety source");
        }
        if (this.mProfile == 1) {
            throw new UnsupportedOperationException("getTitleForWorkResId unsupported for primary profile safety source");
        }
        return this.mTitleForWorkResId;
    }

    public int getSummaryResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getSummaryResId unsupported for issue-only safety source");
        }
        return this.mSummaryResId;
    }

    public String getIntentAction() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getIntentAction unsupported for issue-only safety source");
        }
        return this.mIntentAction;
    }

    public int getProfile() {
        return this.mProfile;
    }

    public int getInitialDisplayState() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getInitialDisplayState unsupported for static safety source");
        }
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getInitialDisplayState unsupported for issue-only safety source");
        }
        return this.mInitialDisplayState;
    }

    public int getMaxSeverityLevel() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getMaxSeverityLevel unsupported for static safety source");
        }
        return this.mMaxSeverityLevel;
    }

    public int getSearchTermsResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getSearchTermsResId unsupported for issue-only safety source");
        }
        return this.mSearchTermsResId;
    }

    public boolean isLoggingAllowed() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("isLoggingAllowed unsupported for static safety source");
        }
        return this.mLoggingAllowed;
    }

    public boolean isRefreshOnPageOpenAllowed() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("isRefreshOnPageOpenAllowed unsupported for static safety source");
        }
        return this.mRefreshOnPageOpenAllowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySource)) {
            return false;
        }
        SafetySource that = (SafetySource)o;
        return this.mType == that.mType && Objects.equals(this.mId, that.mId) && Objects.equals(this.mPackageName, that.mPackageName) && this.mTitleResId == that.mTitleResId && this.mTitleForWorkResId == that.mTitleForWorkResId && this.mSummaryResId == that.mSummaryResId && Objects.equals(this.mIntentAction, that.mIntentAction) && this.mProfile == that.mProfile && this.mInitialDisplayState == that.mInitialDisplayState && this.mMaxSeverityLevel == that.mMaxSeverityLevel && this.mSearchTermsResId == that.mSearchTermsResId && this.mLoggingAllowed == that.mLoggingAllowed && this.mRefreshOnPageOpenAllowed == that.mRefreshOnPageOpenAllowed;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mId, this.mPackageName, this.mTitleResId, this.mTitleForWorkResId, this.mSummaryResId, this.mIntentAction, this.mProfile, this.mInitialDisplayState, this.mMaxSeverityLevel, this.mSearchTermsResId, this.mLoggingAllowed, this.mRefreshOnPageOpenAllowed);
    }

    public String toString() {
        return "SafetySource{mType=" + this.mType + ", mId='" + this.mId + '\'' + ", mPackageName='" + this.mPackageName + '\'' + ", mTitleResId=" + this.mTitleResId + ", mTitleForWorkResId=" + this.mTitleForWorkResId + ", mSummaryResId=" + this.mSummaryResId + ", mIntentAction='" + this.mIntentAction + '\'' + ", mProfile=" + this.mProfile + ", mInitialDisplayState=" + this.mInitialDisplayState + ", mMaxSeverityLevel=" + this.mMaxSeverityLevel + ", mSearchTermsResId=" + this.mSearchTermsResId + ", mLoggingAllowed=" + this.mLoggingAllowed + ", mRefreshOnPageOpenAllowed=" + this.mRefreshOnPageOpenAllowed + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeString(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mTitleResId);
        dest.writeInt(this.mTitleForWorkResId);
        dest.writeInt(this.mSummaryResId);
        dest.writeString(this.mIntentAction);
        dest.writeInt(this.mProfile);
        dest.writeInt(this.mInitialDisplayState);
        dest.writeInt(this.mMaxSeverityLevel);
        dest.writeInt(this.mSearchTermsResId);
        dest.writeBoolean(this.mLoggingAllowed);
        dest.writeBoolean(this.mRefreshOnPageOpenAllowed);
    }

    public static class Builder {
        private final int mType;
        private String mId;
        private String mPackageName;
        private Integer mTitleResId;
        private Integer mTitleForWorkResId;
        private Integer mSummaryResId;
        private String mIntentAction;
        private Integer mProfile;
        private Integer mInitialDisplayState;
        private Integer mMaxSeverityLevel;
        private Integer mSearchTermsResId;
        private Boolean mLoggingAllowed;
        private Boolean mRefreshOnPageOpenAllowed;

        public Builder(int type) {
            this.mType = type;
        }

        public Builder setId(String id2) {
            this.mId = id2;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setTitleResId(int titleResId) {
            this.mTitleResId = titleResId;
            return this;
        }

        public Builder setTitleForWorkResId(int titleForWorkResId) {
            this.mTitleForWorkResId = titleForWorkResId;
            return this;
        }

        public Builder setSummaryResId(int summaryResId) {
            this.mSummaryResId = summaryResId;
            return this;
        }

        public Builder setIntentAction(String intentAction) {
            this.mIntentAction = intentAction;
            return this;
        }

        public Builder setProfile(int profile) {
            this.mProfile = profile;
            return this;
        }

        public Builder setInitialDisplayState(int initialDisplayState) {
            this.mInitialDisplayState = initialDisplayState;
            return this;
        }

        public Builder setMaxSeverityLevel(int maxSeverityLevel) {
            this.mMaxSeverityLevel = maxSeverityLevel;
            return this;
        }

        public Builder setSearchTermsResId(int searchTermsResId) {
            this.mSearchTermsResId = searchTermsResId;
            return this;
        }

        public Builder setLoggingAllowed(boolean loggingAllowed) {
            this.mLoggingAllowed = loggingAllowed;
            return this;
        }

        public Builder setRefreshOnPageOpenAllowed(boolean refreshOnPageOpenAllowed) {
            this.mRefreshOnPageOpenAllowed = refreshOnPageOpenAllowed;
            return this;
        }

        public SafetySource build() {
            if (this.mType != 1 && this.mType != 2 && this.mType != 3) {
                throw new IllegalStateException("Unexpected type");
            }
            boolean isStatic = this.mType == 1;
            boolean isDynamic = this.mType == 2;
            boolean isIssueOnly = this.mType == 3;
            BuilderUtils.validateAttribute(this.mId, "id", true, false);
            BuilderUtils.validateAttribute(this.mPackageName, "packageName", isDynamic || isIssueOnly, isStatic);
            int initialDisplayState = BuilderUtils.validateIntDef(this.mInitialDisplayState, "initialDisplayState", false, isStatic || isIssueOnly, 0, 0, 1, 2);
            boolean isEnabled = initialDisplayState == 0;
            boolean isHidden = initialDisplayState == 2;
            boolean isDynamicNotHidden = isDynamic && !isHidden;
            int profile = BuilderUtils.validateIntDef(this.mProfile, "profile", true, false, 0, 1, 2);
            boolean hasWork = profile == 2;
            int searchTermsResId = BuilderUtils.validateResId(this.mSearchTermsResId, "searchTerms", false, isIssueOnly);
            boolean isDynamicHiddenWithSearch = isDynamic && isHidden && searchTermsResId != 0;
            boolean titleRequired = isDynamicNotHidden || isDynamicHiddenWithSearch || isStatic;
            int titleResId = BuilderUtils.validateResId(this.mTitleResId, "title", titleRequired, isIssueOnly);
            int titleForWorkResId = BuilderUtils.validateResId(this.mTitleForWorkResId, "titleForWork", hasWork && titleRequired, !hasWork || isIssueOnly);
            int summaryResId = BuilderUtils.validateResId(this.mSummaryResId, "summary", isDynamicNotHidden, isIssueOnly);
            BuilderUtils.validateAttribute(this.mIntentAction, "intentAction", isDynamic && isEnabled || isStatic, isIssueOnly);
            int maxSeverityLevel = BuilderUtils.validateInteger(this.mMaxSeverityLevel, "maxSeverityLevel", false, isStatic, Integer.MAX_VALUE);
            boolean loggingAllowed = BuilderUtils.validateBoolean(this.mLoggingAllowed, "loggingAllowed", false, isStatic, true);
            boolean refreshOnPageOpenAllowed = BuilderUtils.validateBoolean(this.mRefreshOnPageOpenAllowed, "refreshOnPageOpenAllowed", false, isStatic, false);
            return new SafetySource(this.mType, this.mId, this.mPackageName, titleResId, titleForWorkResId, summaryResId, this.mIntentAction, profile, initialDisplayState, maxSeverityLevel, searchTermsResId, loggingAllowed, refreshOnPageOpenAllowed);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InitialDisplayState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Profile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SafetySourceType {
    }
}

