/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.config.BuilderUtils;
import android.safetycenter.config.SafetySource;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourcesGroup
implements Parcelable {
    public static final int SAFETY_SOURCES_GROUP_TYPE_COLLAPSIBLE = 0;
    public static final int SAFETY_SOURCES_GROUP_TYPE_RIGID = 1;
    public static final int SAFETY_SOURCES_GROUP_TYPE_HIDDEN = 2;
    public static final int STATELESS_ICON_TYPE_NONE = 0;
    public static final int STATELESS_ICON_TYPE_PRIVACY = 1;
    public static final Parcelable.Creator<SafetySourcesGroup> CREATOR = new Parcelable.Creator<SafetySourcesGroup>(){

        @Override
        public SafetySourcesGroup createFromParcel(Parcel in) {
            Builder builder2 = new Builder().setId(in.readString()).setTitleResId(in.readInt()).setSummaryResId(in.readInt()).setStatelessIconType(in.readInt());
            List safetySources = Objects.requireNonNull(in.createTypedArrayList(SafetySource.CREATOR));
            for (int i = 0; i < safetySources.size(); ++i) {
                builder2.addSafetySource((SafetySource)safetySources.get(i));
            }
            return builder2.build();
        }

        public SafetySourcesGroup[] newArray(int size) {
            return new SafetySourcesGroup[size];
        }
    };
    private final String mId;
    private final int mTitleResId;
    private final int mSummaryResId;
    private final int mStatelessIconType;
    private final List<SafetySource> mSafetySources;

    private SafetySourcesGroup(String id2, int titleResId, int summaryResId, int statelessIconType, List<SafetySource> safetySources) {
        this.mId = id2;
        this.mTitleResId = titleResId;
        this.mSummaryResId = summaryResId;
        this.mStatelessIconType = statelessIconType;
        this.mSafetySources = safetySources;
    }

    public int getType() {
        if (this.mTitleResId == 0) {
            return 2;
        }
        if (this.mSummaryResId != 0 || this.mStatelessIconType != 0) {
            return 0;
        }
        return 1;
    }

    public String getId() {
        return this.mId;
    }

    public int getTitleResId() {
        return this.mTitleResId;
    }

    public int getSummaryResId() {
        return this.mSummaryResId;
    }

    public int getStatelessIconType() {
        return this.mStatelessIconType;
    }

    public List<SafetySource> getSafetySources() {
        return this.mSafetySources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourcesGroup)) {
            return false;
        }
        SafetySourcesGroup that = (SafetySourcesGroup)o;
        return Objects.equals(this.mId, that.mId) && this.mTitleResId == that.mTitleResId && this.mSummaryResId == that.mSummaryResId && this.mStatelessIconType == that.mStatelessIconType && Objects.equals(this.mSafetySources, that.mSafetySources);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitleResId, this.mSummaryResId, this.mStatelessIconType, this.mSafetySources);
    }

    public String toString() {
        return "SafetySourcesGroup{mId='" + this.mId + '\'' + ", mTitleResId=" + this.mTitleResId + ", mSummaryResId=" + this.mSummaryResId + ", mStatelessIconType=" + this.mStatelessIconType + ", mSafetySources=" + this.mSafetySources + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mTitleResId);
        dest.writeInt(this.mSummaryResId);
        dest.writeInt(this.mStatelessIconType);
        dest.writeTypedList(this.mSafetySources);
    }

    public static class Builder {
        private final List<SafetySource> mSafetySources = new ArrayList<SafetySource>();
        private String mId;
        private Integer mTitleResId;
        private Integer mSummaryResId;
        private Integer mStatelessIconType;

        public Builder setId(String id2) {
            this.mId = id2;
            return this;
        }

        public Builder setTitleResId(int titleResId) {
            this.mTitleResId = titleResId;
            return this;
        }

        public Builder setSummaryResId(int summaryResId) {
            this.mSummaryResId = summaryResId;
            return this;
        }

        public Builder setStatelessIconType(int statelessIconType) {
            this.mStatelessIconType = statelessIconType;
            return this;
        }

        public Builder addSafetySource(SafetySource safetySource) {
            this.mSafetySources.add(Objects.requireNonNull(safetySource));
            return this;
        }

        public SafetySourcesGroup build() {
            BuilderUtils.validateAttribute(this.mId, "id", true, false);
            List<SafetySource> safetySources = Collections.unmodifiableList(new ArrayList<SafetySource>(this.mSafetySources));
            if (safetySources.isEmpty()) {
                throw new IllegalStateException("Safety sources group empty");
            }
            boolean titleRequired = false;
            int safetySourcesSize = safetySources.size();
            for (int i = 0; i < safetySourcesSize; ++i) {
                int type = safetySources.get(i).getType();
                if (type == 3) continue;
                titleRequired = true;
                break;
            }
            int titleResId = BuilderUtils.validateResId(this.mTitleResId, "title", titleRequired, false);
            int summaryResId = BuilderUtils.validateResId(this.mSummaryResId, "summary", false, false);
            int statelessIconType = BuilderUtils.validateIntDef(this.mStatelessIconType, "statelessIconType", false, false, 0, 0, 1);
            return new SafetySourcesGroup(this.mId, titleResId, summaryResId, statelessIconType, safetySources);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatelessIconType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SafetySourceGroupType {
    }
}

