/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.UrisToAliases;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class AppUriAuthenticationPolicy
implements Parcelable {
    private static final String KEY_AUTHENTICATION_POLICY_APP_TO_URIS = "authentication_policy_app_to_uris";
    private static final String KEY_AUTHENTICATION_POLICY_APP = "policy_app";
    private final Map<String, UrisToAliases> mAppToUris;
    public static final Parcelable.Creator<AppUriAuthenticationPolicy> CREATOR = new Parcelable.Creator<AppUriAuthenticationPolicy>(){

        @Override
        public AppUriAuthenticationPolicy createFromParcel(Parcel in) {
            HashMap<String, UrisToAliases> appToUris = new HashMap<String, UrisToAliases>();
            in.readMap(appToUris, UrisToAliases.class.getClassLoader());
            return new AppUriAuthenticationPolicy(appToUris);
        }

        public AppUriAuthenticationPolicy[] newArray(int size) {
            return new AppUriAuthenticationPolicy[size];
        }
    };

    private AppUriAuthenticationPolicy(Map<String, UrisToAliases> appToUris) {
        Objects.requireNonNull(appToUris);
        this.mAppToUris = appToUris;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeMap(this.mAppToUris);
    }

    public String toString() {
        return "AppUriAuthenticationPolicy{mPackageNameToUris=" + this.mAppToUris + '}';
    }

    public Map<String, Map<Uri, String>> getAppAndUriMappings() {
        HashMap<String, Map<Uri, String>> appAndUris = new HashMap<String, Map<Uri, String>>();
        for (Map.Entry<String, UrisToAliases> entry : this.mAppToUris.entrySet()) {
            appAndUris.put(entry.getKey(), entry.getValue().getUrisToAliases());
        }
        return appAndUris;
    }

    public static AppUriAuthenticationPolicy readFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        Builder builder2 = new Builder();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4 || !parser.getName().equals(KEY_AUTHENTICATION_POLICY_APP_TO_URIS)) continue;
            String app = parser.getAttributeValue(null, KEY_AUTHENTICATION_POLICY_APP);
            UrisToAliases urisToAliases = UrisToAliases.readFromXml(parser);
            builder2.addAppAndUriMapping(app, urisToAliases);
        }
        return builder2.build();
    }

    public void writeToXml(XmlSerializer out) throws IOException {
        for (Map.Entry<String, UrisToAliases> appsToUris : this.mAppToUris.entrySet()) {
            out.startTag(null, KEY_AUTHENTICATION_POLICY_APP_TO_URIS);
            out.attribute(null, KEY_AUTHENTICATION_POLICY_APP, appsToUris.getKey());
            appsToUris.getValue().writeToXml(out);
            out.endTag(null, KEY_AUTHENTICATION_POLICY_APP_TO_URIS);
        }
    }

    public Set<String> getAliases() {
        HashSet<String> aliases = new HashSet<String>();
        for (UrisToAliases appsToUris : this.mAppToUris.values()) {
            aliases.addAll(appsToUris.getUrisToAliases().values());
        }
        return aliases;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AppUriAuthenticationPolicy)) {
            return false;
        }
        AppUriAuthenticationPolicy other = (AppUriAuthenticationPolicy)obj;
        return Objects.equals(this.mAppToUris, other.mAppToUris);
    }

    public int hashCode() {
        return this.mAppToUris.hashCode();
    }

    public static class Builder {
        private Map<String, UrisToAliases> mPackageNameToUris = new HashMap<String, UrisToAliases>();

        public Builder addAppAndUriMapping(String appPackageName, Uri uri, String alias) {
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(uri);
            Objects.requireNonNull(alias);
            UrisToAliases urisToAliases = this.mPackageNameToUris.getOrDefault(appPackageName, new UrisToAliases());
            urisToAliases.addUriToAlias(uri, alias);
            this.mPackageNameToUris.put(appPackageName, urisToAliases);
            return this;
        }

        public Builder addAppAndUriMapping(String appPackageName, UrisToAliases urisToAliases) {
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(urisToAliases);
            this.mPackageNameToUris.put(appPackageName, urisToAliases);
            return this;
        }

        public AppUriAuthenticationPolicy build() {
            return new AppUriAuthenticationPolicy(this.mPackageNameToUris);
        }
    }
}

