/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.AppUriAuthenticationPolicy;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.security.KeyStore2;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore2.AndroidKeyStoreProvider;
import android.system.keystore2.KeyDescriptor;
import android.util.Log;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.x500.X500Principal;

public class KeyChain {
    public static final String LOG = "KeyChain";
    public static final String ACCOUNT_TYPE = "com.android.keychain";
    private static final String KEYCHAIN_PACKAGE = "com.android.keychain";
    private static final String ACTION_CHOOSER = "com.android.keychain.CHOOSER";
    private static final String CERT_INSTALLER_PACKAGE = "com.android.certinstaller";
    private static final String SETTINGS_PACKAGE = "com.android.settings";
    public static final String EXTRA_RESPONSE = "response";
    public static final String EXTRA_URI = "uri";
    public static final String EXTRA_ALIAS = "alias";
    public static final String EXTRA_SENDER = "sender";
    public static final String EXTRA_KEY_TYPES = "key_types";
    public static final String EXTRA_ISSUERS = "issuers";
    private static final String ACTION_INSTALL = "android.credentials.INSTALL";
    public static final String EXTRA_NAME = "name";
    public static final String EXTRA_CERTIFICATE = "CERT";
    public static final String EXTRA_PKCS12 = "PKCS12";
    public static final String EXTRA_AUTHENTICATION_POLICY = "android.security.extra.AUTHENTICATION_POLICY";
    public static final String ACTION_STORAGE_CHANGED = "android.security.STORAGE_CHANGED";
    public static final String ACTION_KEYCHAIN_CHANGED = "android.security.action.KEYCHAIN_CHANGED";
    public static final String ACTION_TRUST_STORE_CHANGED = "android.security.action.TRUST_STORE_CHANGED";
    public static final String ACTION_KEY_ACCESS_CHANGED = "android.security.action.KEY_ACCESS_CHANGED";
    public static final String EXTRA_KEY_ALIAS = "android.security.extra.KEY_ALIAS";
    public static final String EXTRA_KEY_ACCESSIBLE = "android.security.extra.KEY_ACCESSIBLE";
    public static final int KEY_GEN_SUCCESS = 0;
    public static final int KEY_GEN_MISSING_ALIAS = 1;
    public static final int KEY_GEN_SUPERFLUOUS_ATTESTATION_CHALLENGE = 2;
    public static final int KEY_GEN_NO_SUCH_ALGORITHM = 3;
    public static final int KEY_GEN_INVALID_ALGORITHM_PARAMETERS = 4;
    public static final int KEY_GEN_NO_KEYSTORE_PROVIDER = 5;
    public static final int KEY_GEN_STRONGBOX_UNAVAILABLE = 6;
    public static final int KEY_GEN_FAILURE = 7;
    public static final int KEY_ATTESTATION_SUCCESS = 0;
    public static final int KEY_ATTESTATION_MISSING_CHALLENGE = 1;
    public static final int KEY_ATTESTATION_CANNOT_COLLECT_DATA = 2;
    public static final int KEY_ATTESTATION_CANNOT_ATTEST_IDS = 3;
    public static final int KEY_ATTESTATION_FAILURE = 4;
    public static final String KEY_ALIAS_SELECTION_DENIED = "android:alias-selection-denied";
    public static final String GRANT_ALIAS_PREFIX = "ks2_keychain_grant_id:";

    public static Intent createInstallIntent() {
        Intent intent = new Intent(ACTION_INSTALL);
        intent.setClassName(CERT_INSTALLER_PACKAGE, "com.android.certinstaller.CertInstallerMain");
        return intent;
    }

    public static Intent createManageCredentialsIntent(AppUriAuthenticationPolicy policy) {
        Intent intent = new Intent("android.security.MANAGE_CREDENTIALS");
        intent.setComponent(ComponentName.createRelative(SETTINGS_PACKAGE, ".security.RequestManageCredentials"));
        intent.putExtra(EXTRA_AUTHENTICATION_POLICY, policy);
        return intent;
    }

    public static void choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback response, String[] keyTypes, Principal[] issuers, String host, int port, String alias) {
        Uri uri = null;
        if (host != null) {
            uri = new Uri.Builder().authority(host + (port != -1 ? ":" + port : "")).build();
        }
        KeyChain.choosePrivateKeyAlias(activity, response, keyTypes, issuers, uri, alias);
    }

    public static void choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback response, String[] keyTypes, Principal[] issuers, Uri uri, String alias) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        Intent intent = new Intent(ACTION_CHOOSER);
        intent.setPackage("com.android.keychain");
        intent.putExtra(EXTRA_RESPONSE, new AliasResponse(response));
        intent.putExtra(EXTRA_URI, uri);
        intent.putExtra(EXTRA_ALIAS, alias);
        intent.putExtra(EXTRA_KEY_TYPES, keyTypes);
        ArrayList<byte[]> issuersList = new ArrayList<byte[]>();
        if (issuers != null) {
            for (Principal issuer : issuers) {
                if (!(issuer instanceof X500Principal)) {
                    throw new IllegalArgumentException(String.format("Issuer %s is of type %s, not X500Principal", issuer.toString(), issuer.getClass()));
                }
                issuersList.add(((X500Principal)issuer).getEncoded());
            }
        }
        intent.putExtra(EXTRA_ISSUERS, issuersList);
        intent.putExtra(EXTRA_SENDER, PendingIntent.getActivity(activity, 0, new Intent(), 0x4000000));
        activity.startActivity(intent);
    }

    public static boolean isCredentialManagementApp(Context context) {
        boolean isCredentialManagementApp = false;
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context);){
            isCredentialManagementApp = keyChainConnection.getService().isCredentialManagementApp(context.getPackageName());
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while checking whether the caller is the credential management app.", e);
        }
        catch (SecurityException e) {
            isCredentialManagementApp = false;
        }
        return isCredentialManagementApp;
    }

    public static AppUriAuthenticationPolicy getCredentialManagementAppPolicy(Context context) throws SecurityException {
        AppUriAuthenticationPolicy policy = null;
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context);){
            policy = keyChainConnection.getService().getCredentialManagementAppPolicy();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while getting credential management app policy.", e);
        }
        return policy;
    }

    @RequiresPermission(value="android.permission.MANAGE_CREDENTIAL_MANAGEMENT_APP")
    public static boolean setCredentialManagementApp(Context context, String packageName, AppUriAuthenticationPolicy authenticationPolicy) {
        KeyChainConnection keyChainConnection = KeyChain.bind(context);
        try {
            keyChainConnection.getService().setCredentialManagementApp(packageName, authenticationPolicy);
            boolean bl = true;
            if (keyChainConnection != null) {
                keyChainConnection.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (keyChainConnection != null) {
                    try {
                        keyChainConnection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException | InterruptedException e) {
                Log.w(LOG, "Set credential management app failed", e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CREDENTIAL_MANAGEMENT_APP", conditional=true)
    public static boolean removeCredentialManagementApp(Context context) {
        KeyChainConnection keyChainConnection = KeyChain.bind(context);
        try {
            keyChainConnection.getService().removeCredentialManagementApp();
            boolean bl = true;
            if (keyChainConnection != null) {
                keyChainConnection.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (keyChainConnection != null) {
                    try {
                        keyChainConnection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException | InterruptedException e) {
                Log.w(LOG, "Remove credential management app failed", e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public static PrivateKey getPrivateKey(Context context, String alias) throws KeyChainException, InterruptedException {
        KeyPair keyPair = KeyChain.getKeyPair(context, alias);
        if (keyPair != null) {
            return keyPair.getPrivate();
        }
        return null;
    }

    private static KeyDescriptor getGrantDescriptor(String keyid) {
        KeyDescriptor result = new KeyDescriptor();
        result.domain = 1;
        result.blob = null;
        result.alias = null;
        try {
            result.nspace = Long.parseUnsignedLong(keyid.substring(GRANT_ALIAS_PREFIX.length()), 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    public static String getGrantString(KeyDescriptor key) {
        return String.format("ks2_keychain_grant_id:%016X", key.nspace);
    }

    public static KeyPair getKeyPair(Context context, String alias) throws KeyChainException, InterruptedException {
        String keyId;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context.getApplicationContext());){
            keyId = keyChainConnection.getService().requestPrivateKey(alias);
        }
        catch (RemoteException e) {
            throw new KeyChainException(e);
        }
        catch (RuntimeException e) {
            throw new KeyChainException(e);
        }
        if (keyId == null) {
            return null;
        }
        try {
            return AndroidKeyStoreProvider.loadAndroidKeyStoreKeyPairFromKeystore(KeyStore2.getInstance(), KeyChain.getGrantDescriptor(keyId));
        }
        catch (KeyPermanentlyInvalidatedException | UnrecoverableKeyException e) {
            throw new KeyChainException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate[] getCertificateChain(Context context, String alias) throws KeyChainException, InterruptedException {
        byte[] certChainBytes;
        byte[] certificateBytes;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context.getApplicationContext());){
            IKeyChainService keyChainService222 = keyChainConnection.getService();
            certificateBytes = keyChainService222.getCertificate(alias);
            if (certificateBytes == null) {
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            certChainBytes = keyChainService222.getCaCertificates(alias);
        }
        catch (RemoteException e) {
            throw new KeyChainException(e);
        }
        catch (RuntimeException e) {
            throw new KeyChainException(e);
        }
        try {
            X509Certificate leafCert = KeyChain.toCertificate(certificateBytes);
            if (certChainBytes != null && certChainBytes.length != 0) {
                Collection<X509Certificate> chain = KeyChain.toCertificates(certChainBytes);
                ArrayList<X509Certificate> fullChain = new ArrayList<X509Certificate>(chain.size() + 1);
                fullChain.add(leafCert);
                fullChain.addAll(chain);
                return fullChain.toArray(new X509Certificate[fullChain.size()]);
            }
            TrustedCertificateStore store = new TrustedCertificateStore();
            List chain = store.getCertificateChain(leafCert);
            return chain.toArray(new X509Certificate[chain.size()]);
        }
        catch (RuntimeException | CertificateException e) {
            throw new KeyChainException(e);
        }
    }

    public static boolean isKeyAlgorithmSupported(String algorithm) {
        String algUpper = algorithm.toUpperCase(Locale.US);
        return "EC".equals(algUpper) || "RSA".equals(algUpper);
    }

    @Deprecated
    public static boolean isBoundKeyAlgorithm(String algorithm) {
        return true;
    }

    public static X509Certificate toCertificate(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate cert = certFactory.generateCertificate(new ByteArrayInputStream(bytes));
            return (X509Certificate)cert;
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Collection<X509Certificate> toCertificates(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static KeyChainConnection bind(Context context) throws InterruptedException {
        return KeyChain.bindAsUser(context, Process.myUserHandle());
    }

    public static KeyChainConnection bindAsUser(Context context, UserHandle user) throws InterruptedException {
        return KeyChain.bindAsUser(context, null, user);
    }

    @SystemApi
    public static String getWifiKeyGrantAsUser(Context context, UserHandle user, String alias) {
        KeyChainConnection keyChainConnection = KeyChain.bindAsUser(context.getApplicationContext(), user);
        try {
            String string2 = keyChainConnection.getService().getWifiKeyGrantAsUser(alias);
            if (keyChainConnection != null) {
                keyChainConnection.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (keyChainConnection != null) {
                    try {
                        keyChainConnection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException | RuntimeException e) {
                Log.i(LOG, "Couldn't get grant for wifi", e);
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.i(LOG, "Interrupted while getting grant for wifi", e);
                return null;
            }
        }
    }

    @SystemApi
    public static boolean hasWifiKeyGrantAsUser(Context context, UserHandle user, String alias) {
        KeyChainConnection keyChainConnection = KeyChain.bindAsUser(context.getApplicationContext(), user);
        try {
            boolean bl = keyChainConnection.getService().hasGrant(1010, alias);
            if (keyChainConnection != null) {
                keyChainConnection.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (keyChainConnection != null) {
                    try {
                        keyChainConnection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException | RuntimeException e) {
                Log.i(LOG, "Couldn't query grant for wifi", e);
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.i(LOG, "Interrupted while querying grant for wifi", e);
                return false;
            }
        }
    }

    public static KeyChainConnection bindAsUser(Context context, Handler handler, UserHandle user) throws InterruptedException {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (handler == null) {
            KeyChain.ensureNotOnMainThread(context);
        }
        if (!UserManager.get(context).isUserUnlocked(user)) {
            throw new IllegalStateException("User must be unlocked");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference keyChainService = new AtomicReference();
        ServiceConnection keyChainServiceConnection = new ServiceConnection(){
            volatile boolean mConnectedAtLeastOnce = false;

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                if (!this.mConnectedAtLeastOnce) {
                    this.mConnectedAtLeastOnce = true;
                    keyChainService.set(IKeyChainService.Stub.asInterface(Binder.allowBlocking(service)));
                    countDownLatch.countDown();
                }
            }

            @Override
            public void onBindingDied(ComponentName name) {
                if (!this.mConnectedAtLeastOnce) {
                    this.mConnectedAtLeastOnce = true;
                    countDownLatch.countDown();
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
            }
        };
        Intent intent = new Intent(IKeyChainService.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        if (comp == null) {
            throw new AssertionError((Object)"could not resolve KeyChainService");
        }
        intent.setComponent(comp);
        boolean bindSucceed = handler != null ? context.bindServiceAsUser(intent, keyChainServiceConnection, 1, handler, user) : context.bindServiceAsUser(intent, keyChainServiceConnection, 1, user);
        if (!bindSucceed) {
            context.unbindService(keyChainServiceConnection);
            throw new AssertionError((Object)"could not bind to KeyChainService");
        }
        countDownLatch.await();
        IKeyChainService service = (IKeyChainService)keyChainService.get();
        if (service != null) {
            return new KeyChainConnection(context, keyChainServiceConnection, service);
        }
        context.unbindService(keyChainServiceConnection);
        throw new AssertionError((Object)"KeyChainService died while binding");
    }

    private static void ensureNotOnMainThread(Context context) {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == context.getMainLooper()) {
            throw new IllegalStateException("calling this from your main thread can lead to deadlock");
        }
    }

    public static class KeyChainConnection
    implements Closeable {
        private final Context mContext;
        private final ServiceConnection mServiceConnection;
        private final IKeyChainService mService;

        protected KeyChainConnection(Context context, ServiceConnection serviceConnection, IKeyChainService service) {
            this.mContext = context;
            this.mServiceConnection = serviceConnection;
            this.mService = service;
        }

        @Override
        public void close() {
            this.mContext.unbindService(this.mServiceConnection);
        }

        public IKeyChainService getService() {
            return this.mService;
        }
    }

    private static class AliasResponse
    extends IKeyChainAliasCallback.Stub {
        private final KeyChainAliasCallback keyChainAliasResponse;

        private AliasResponse(KeyChainAliasCallback keyChainAliasResponse) {
            this.keyChainAliasResponse = keyChainAliasResponse;
        }

        @Override
        public void alias(String alias) {
            this.keyChainAliasResponse.alias(alias);
        }
    }
}

