/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.attestationverification.AttestationProfile;
import android.security.attestationverification.AttestationVerificationManager;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import java.time.Instant;

public class VerificationToken
implements Parcelable {
    private final AttestationProfile mAttestationProfile;
    private final int mLocalBindingType;
    private final Bundle mRequirements;
    private final int mVerificationResult;
    private final Instant mVerificationTime;
    private final byte[] mHmac;
    private int mUid;
    static Parcelling<Instant> sParcellingForVerificationTime = Parcelling.Cache.get(Parcelling.BuiltIn.ForInstant.class);
    public static final Parcelable.Creator<VerificationToken> CREATOR;

    VerificationToken(AttestationProfile attestationProfile, int localBindingType, Bundle requirements, int verificationResult, Instant verificationTime, byte[] hmac, int uid) {
        this.mAttestationProfile = attestationProfile;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
        this.mLocalBindingType = localBindingType;
        AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
        this.mRequirements = requirements;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
        this.mVerificationResult = verificationResult;
        AnnotationValidations.validate(AttestationVerificationManager.VerificationResult.class, null, this.mVerificationResult);
        this.mVerificationTime = verificationTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
        this.mUid = uid;
    }

    public AttestationProfile getAttestationProfile() {
        return this.mAttestationProfile;
    }

    public int getLocalBindingType() {
        return this.mLocalBindingType;
    }

    public Bundle getRequirements() {
        return this.mRequirements;
    }

    public int getVerificationResult() {
        return this.mVerificationResult;
    }

    public Instant getVerificationTime() {
        return this.mVerificationTime;
    }

    public byte[] getHmac() {
        return this.mHmac;
    }

    public int getUid() {
        return this.mUid;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mAttestationProfile, flags);
        dest.writeInt(this.mLocalBindingType);
        dest.writeBundle(this.mRequirements);
        dest.writeInt(this.mVerificationResult);
        sParcellingForVerificationTime.parcel(this.mVerificationTime, dest, flags);
        dest.writeByteArray(this.mHmac);
        dest.writeInt(this.mUid);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VerificationToken(Parcel in) {
        AttestationProfile attestationProfile = in.readTypedObject(AttestationProfile.CREATOR);
        int localBindingType = in.readInt();
        Bundle requirements = in.readBundle();
        int verificationResult = in.readInt();
        Instant verificationTime = sParcellingForVerificationTime.unparcel(in);
        byte[] hmac = in.createByteArray();
        int uid = in.readInt();
        this.mAttestationProfile = attestationProfile;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
        this.mLocalBindingType = localBindingType;
        AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
        this.mRequirements = requirements;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
        this.mVerificationResult = verificationResult;
        AnnotationValidations.validate(AttestationVerificationManager.VerificationResult.class, null, this.mVerificationResult);
        this.mVerificationTime = verificationTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
        this.mUid = uid;
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForVerificationTime == null) {
            sParcellingForVerificationTime = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInstant());
        }
        CREATOR = new Parcelable.Creator<VerificationToken>(){

            public VerificationToken[] newArray(int size) {
                return new VerificationToken[size];
            }

            @Override
            public VerificationToken createFromParcel(Parcel in) {
                return new VerificationToken(in);
            }
        };
    }

    public static class Builder {
        private AttestationProfile mAttestationProfile;
        private int mLocalBindingType;
        private Bundle mRequirements;
        private int mVerificationResult;
        private Instant mVerificationTime;
        private byte[] mHmac;
        private int mUid;
        private long mBuilderFieldsSet = 0L;

        public Builder(AttestationProfile attestationProfile, int localBindingType, Bundle requirements, int verificationResult, Instant verificationTime, byte[] hmac, int uid) {
            this.mAttestationProfile = attestationProfile;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
            this.mLocalBindingType = localBindingType;
            AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
            this.mRequirements = requirements;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
            this.mVerificationResult = verificationResult;
            AnnotationValidations.validate(AttestationVerificationManager.VerificationResult.class, null, this.mVerificationResult);
            this.mVerificationTime = verificationTime;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
            this.mHmac = hmac;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
            this.mUid = uid;
        }

        public Builder setAttestationProfile(AttestationProfile value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mAttestationProfile = value2;
            return this;
        }

        public Builder setLocalBindingType(int value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mLocalBindingType = value2;
            return this;
        }

        public Builder setRequirements(Bundle value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mRequirements = value2;
            return this;
        }

        public Builder setVerificationResult(int value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mVerificationResult = value2;
            return this;
        }

        public Builder setVerificationTime(Instant value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mVerificationTime = value2;
            return this;
        }

        public Builder setHmac(byte ... value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mHmac = value2;
            return this;
        }

        public Builder setUid(int value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mUid = value2;
            return this;
        }

        public VerificationToken build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            VerificationToken o = new VerificationToken(this.mAttestationProfile, this.mLocalBindingType, this.mRequirements, this.mVerificationResult, this.mVerificationTime, this.mHmac, this.mUid);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x80L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

