/*
 * Decompiled with CFR 0.152.
 */
package android.security.keymaster;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keymaster.KeymasterArgument;
import android.security.keymaster.KeymasterBlobArgument;
import android.security.keymaster.KeymasterBooleanArgument;
import android.security.keymaster.KeymasterDateArgument;
import android.security.keymaster.KeymasterDefs;
import android.security.keymaster.KeymasterIntArgument;
import android.security.keymaster.KeymasterLongArgument;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class KeymasterArguments
implements Parcelable {
    private static final long UINT32_RANGE = 0x100000000L;
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    private static final BigInteger UINT64_RANGE = BigInteger.ONE.shiftLeft(64);
    public static final BigInteger UINT64_MAX_VALUE = UINT64_RANGE.subtract(BigInteger.ONE);
    private List<KeymasterArgument> mArguments;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final Parcelable.Creator<KeymasterArguments> CREATOR = new Parcelable.Creator<KeymasterArguments>(){

        @Override
        public KeymasterArguments createFromParcel(Parcel in) {
            return new KeymasterArguments(in);
        }

        public KeymasterArguments[] newArray(int size) {
            return new KeymasterArguments[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public KeymasterArguments() {
        this.mArguments = new ArrayList<KeymasterArgument>();
    }

    private KeymasterArguments(Parcel in) {
        this.mArguments = in.createTypedArrayList(KeymasterArgument.CREATOR);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addEnum(int tag2, int value2) {
        int tagType = KeymasterDefs.getTagType(tag2);
        if (tagType != 0x10000000 && tagType != 0x20000000) {
            throw new IllegalArgumentException("Not an enum or repeating enum tag: " + tag2);
        }
        this.addEnumTag(tag2, value2);
    }

    public void addEnums(int tag2, int ... values2) {
        if (KeymasterDefs.getTagType(tag2) != 0x20000000) {
            throw new IllegalArgumentException("Not a repeating enum tag: " + tag2);
        }
        for (int value2 : values2) {
            this.addEnumTag(tag2, value2);
        }
    }

    public int getEnum(int tag2, int defaultValue) {
        if (KeymasterDefs.getTagType(tag2) != 0x10000000) {
            throw new IllegalArgumentException("Not an enum tag: " + tag2);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag2);
        if (arg == null) {
            return defaultValue;
        }
        return this.getEnumTagValue(arg);
    }

    public List<Integer> getEnums(int tag2) {
        if (KeymasterDefs.getTagType(tag2) != 0x20000000) {
            throw new IllegalArgumentException("Not a repeating enum tag: " + tag2);
        }
        ArrayList<Integer> values2 = new ArrayList<Integer>();
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag2) continue;
            values2.add(this.getEnumTagValue(arg));
        }
        return values2;
    }

    private void addEnumTag(int tag2, int value2) {
        this.mArguments.add(new KeymasterIntArgument(tag2, value2));
    }

    private int getEnumTagValue(KeymasterArgument arg) {
        return ((KeymasterIntArgument)arg).value;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addUnsignedInt(int tag2, long value2) {
        int tagType = KeymasterDefs.getTagType(tag2);
        if (tagType != 0x30000000 && tagType != 0x40000000) {
            throw new IllegalArgumentException("Not an int or repeating int tag: " + tag2);
        }
        if (value2 < 0L || value2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Int tag value out of range: " + value2);
        }
        this.mArguments.add(new KeymasterIntArgument(tag2, (int)value2));
    }

    public long getUnsignedInt(int tag2, long defaultValue) {
        if (KeymasterDefs.getTagType(tag2) != 0x30000000) {
            throw new IllegalArgumentException("Not an int tag: " + tag2);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag2);
        if (arg == null) {
            return defaultValue;
        }
        return (long)((KeymasterIntArgument)arg).value & 0xFFFFFFFFL;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addUnsignedLong(int tag2, BigInteger value2) {
        int tagType = KeymasterDefs.getTagType(tag2);
        if (tagType != 0x50000000 && tagType != -1610612736) {
            throw new IllegalArgumentException("Not a long or repeating long tag: " + tag2);
        }
        this.addLongTag(tag2, value2);
    }

    public List<BigInteger> getUnsignedLongs(int tag2) {
        if (KeymasterDefs.getTagType(tag2) != -1610612736) {
            throw new IllegalArgumentException("Tag is not a repeating long: " + tag2);
        }
        ArrayList<BigInteger> values2 = new ArrayList<BigInteger>();
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag2) continue;
            values2.add(this.getLongTagValue(arg));
        }
        return values2;
    }

    private void addLongTag(int tag2, BigInteger value2) {
        if (value2.signum() == -1 || value2.compareTo(UINT64_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Long tag value out of range: " + value2);
        }
        this.mArguments.add(new KeymasterLongArgument(tag2, value2.longValue()));
    }

    private BigInteger getLongTagValue(KeymasterArgument arg) {
        return KeymasterArguments.toUint64(((KeymasterLongArgument)arg).value);
    }

    public void addBoolean(int tag2) {
        if (KeymasterDefs.getTagType(tag2) != 0x70000000) {
            throw new IllegalArgumentException("Not a boolean tag: " + tag2);
        }
        this.mArguments.add(new KeymasterBooleanArgument(tag2));
    }

    public boolean getBoolean(int tag2) {
        if (KeymasterDefs.getTagType(tag2) != 0x70000000) {
            throw new IllegalArgumentException("Not a boolean tag: " + tag2);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag2);
        return arg != null;
    }

    public void addBytes(int tag2, byte[] value2) {
        if (KeymasterDefs.getTagType(tag2) != -1879048192) {
            throw new IllegalArgumentException("Not a bytes tag: " + tag2);
        }
        if (value2 == null) {
            throw new NullPointerException("value == nulll");
        }
        this.mArguments.add(new KeymasterBlobArgument(tag2, value2));
    }

    public byte[] getBytes(int tag2, byte[] defaultValue) {
        if (KeymasterDefs.getTagType(tag2) != -1879048192) {
            throw new IllegalArgumentException("Not a bytes tag: " + tag2);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag2);
        if (arg == null) {
            return defaultValue;
        }
        return ((KeymasterBlobArgument)arg).blob;
    }

    public void addDate(int tag2, Date value2) {
        if (KeymasterDefs.getTagType(tag2) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + tag2);
        }
        if (value2 == null) {
            throw new NullPointerException("value == nulll");
        }
        if (value2.getTime() < 0L) {
            throw new IllegalArgumentException("Date tag value out of range: " + value2);
        }
        this.mArguments.add(new KeymasterDateArgument(tag2, value2));
    }

    public void addDateIfNotNull(int tag2, Date value2) {
        if (KeymasterDefs.getTagType(tag2) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + tag2);
        }
        if (value2 != null) {
            this.addDate(tag2, value2);
        }
    }

    public Date getDate(int tag2, Date defaultValue) {
        if (KeymasterDefs.getTagType(tag2) != 0x60000000) {
            throw new IllegalArgumentException("Tag is not a date type: " + tag2);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag2);
        if (arg == null) {
            return defaultValue;
        }
        Date result = ((KeymasterDateArgument)arg).date;
        if (result.getTime() < 0L) {
            throw new IllegalArgumentException("Tag value too large. Tag: " + tag2);
        }
        return result;
    }

    private KeymasterArgument getArgumentByTag(int tag2) {
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag2) continue;
            return arg;
        }
        return null;
    }

    public boolean containsTag(int tag2) {
        return this.getArgumentByTag(tag2) != null;
    }

    public int size() {
        return this.mArguments.size();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedList(this.mArguments);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void readFromParcel(Parcel in) {
        in.readTypedList(this.mArguments, KeymasterArgument.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static BigInteger toUint64(long value2) {
        if (value2 >= 0L) {
            return BigInteger.valueOf(value2);
        }
        return BigInteger.valueOf(value2).add(UINT64_RANGE);
    }
}

