/*
 * Decompiled with CFR 0.152.
 */
package android.security.keymaster;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.security.keymaster.KeymasterArgument;
import android.security.keymaster.KeymasterDefs;
import java.util.Date;

class KeymasterDateArgument
extends KeymasterArgument {
    public final Date date;

    public KeymasterDateArgument(int tag2, Date date) {
        super(tag2);
        switch (KeymasterDefs.getTagType(tag2)) {
            case 0x60000000: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad date tag " + tag2);
            }
        }
        this.date = date;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public KeymasterDateArgument(int tag2, Parcel in) {
        super(tag2);
        this.date = new Date(in.readLong());
    }

    @Override
    public void writeValue(Parcel out) {
        out.writeLong(this.date.getTime());
    }
}

