/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.keymaster.KeymasterArguments;
import android.security.keystore.KeyProperties;
import com.android.internal.util.ArrayUtils;
import java.security.ProviderException;

public abstract class KeymasterUtils {
    private KeymasterUtils() {
    }

    static int getDigestOutputSizeBits(int keymasterDigest) {
        switch (keymasterDigest) {
            case 0: {
                return -1;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 160;
            }
            case 3: {
                return 224;
            }
            case 4: {
                return 256;
            }
            case 5: {
                return 384;
            }
            case 6: {
                return 512;
            }
        }
        throw new IllegalArgumentException("Unknown digest: " + keymasterDigest);
    }

    static boolean isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int keymasterBlockMode) {
        switch (keymasterBlockMode) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: 
            case 32: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported block mode: " + keymasterBlockMode);
    }

    static boolean isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int keymasterPadding) {
        switch (keymasterPadding) {
            case 1: {
                return false;
            }
            case 2: 
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported asymmetric encryption padding scheme: " + keymasterPadding);
    }

    public static void addMinMacLengthAuthorizationIfNecessary(KeymasterArguments args, int keymasterAlgorithm, int[] keymasterBlockModes, int[] keymasterDigests) {
        switch (keymasterAlgorithm) {
            case 32: {
                if (!ArrayUtils.contains(keymasterBlockModes, 32)) break;
                args.addUnsignedInt(0x30000008, 96L);
                break;
            }
            case 128: {
                if (keymasterDigests.length != 1) {
                    throw new ProviderException("Unsupported number of authorized digests for HMAC key: " + keymasterDigests.length + ". Exactly one digest must be authorized");
                }
                int keymasterDigest = keymasterDigests[0];
                int digestOutputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                if (digestOutputSizeBits == -1) {
                    throw new ProviderException("HMAC key authorized for unsupported digest: " + KeyProperties.Digest.fromKeymaster(keymasterDigest));
                }
                args.addUnsignedInt(0x30000008, digestOutputSizeBits);
            }
        }
    }
}

