/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.SurfaceControl;
import java.util.ArrayList;
import java.util.List;

public interface IWallpaperEngine
extends IInterface {
    public void setDesiredSize(int var1, int var2) throws RemoteException;

    public void setDisplayPadding(Rect var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:33:1:33:25")
    public void setVisibility(boolean var1) throws RemoteException;

    public void setInAmbientMode(boolean var1, long var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:36:1:36:25")
    public void dispatchPointer(MotionEvent var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:38:1:38:25")
    public void dispatchWallpaperCommand(String var1, int var2, int var3, int var4, Bundle var5) throws RemoteException;

    public void requestWallpaperColors() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:42:1:42:25")
    public void destroy() throws RemoteException;

    public void setZoomOut(float var1) throws RemoteException;

    public void scalePreview(Rect var1) throws RemoteException;

    public void removeLocalColorsAreas(List<RectF> var1) throws RemoteException;

    public void addLocalColorsAreas(List<RectF> var1) throws RemoteException;

    public SurfaceControl mirrorSurfaceControl() throws RemoteException;

    public void applyDimming(float var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWallpaperEngine {
        public static final String DESCRIPTOR = "android.service.wallpaper.IWallpaperEngine";
        static final int TRANSACTION_setDesiredSize = 1;
        static final int TRANSACTION_setDisplayPadding = 2;
        static final int TRANSACTION_setVisibility = 3;
        static final int TRANSACTION_setInAmbientMode = 4;
        static final int TRANSACTION_dispatchPointer = 5;
        static final int TRANSACTION_dispatchWallpaperCommand = 6;
        static final int TRANSACTION_requestWallpaperColors = 7;
        static final int TRANSACTION_destroy = 8;
        static final int TRANSACTION_setZoomOut = 9;
        static final int TRANSACTION_scalePreview = 10;
        static final int TRANSACTION_removeLocalColorsAreas = 11;
        static final int TRANSACTION_addLocalColorsAreas = 12;
        static final int TRANSACTION_mirrorSurfaceControl = 13;
        static final int TRANSACTION_applyDimming = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWallpaperEngine asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWallpaperEngine) {
                return (IWallpaperEngine)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setDesiredSize";
                }
                case 2: {
                    return "setDisplayPadding";
                }
                case 3: {
                    return "setVisibility";
                }
                case 4: {
                    return "setInAmbientMode";
                }
                case 5: {
                    return "dispatchPointer";
                }
                case 6: {
                    return "dispatchWallpaperCommand";
                }
                case 7: {
                    return "requestWallpaperColors";
                }
                case 8: {
                    return "destroy";
                }
                case 9: {
                    return "setZoomOut";
                }
                case 10: {
                    return "scalePreview";
                }
                case 11: {
                    return "removeLocalColorsAreas";
                }
                case 12: {
                    return "addLocalColorsAreas";
                }
                case 13: {
                    return "mirrorSurfaceControl";
                }
                case 14: {
                    return "applyDimming";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDesiredSize(_arg0, _arg1);
                    break;
                }
                case 2: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDisplayPadding(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setVisibility(_arg0);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setInAmbientMode(_arg0, _arg1);
                    break;
                }
                case 5: {
                    MotionEvent _arg0 = data.readTypedObject(MotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchPointer(_arg0);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 7: {
                    this.requestWallpaperColors();
                    break;
                }
                case 8: {
                    this.destroy();
                    break;
                }
                case 9: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setZoomOut(_arg0);
                    break;
                }
                case 10: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.scalePreview(_arg0);
                    break;
                }
                case 11: {
                    ArrayList<RectF> _arg0 = data.createTypedArrayList(RectF.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeLocalColorsAreas(_arg0);
                    break;
                }
                case 12: {
                    ArrayList<RectF> _arg0 = data.createTypedArrayList(RectF.CREATOR);
                    data.enforceNoDataAvail();
                    this.addLocalColorsAreas(_arg0);
                    break;
                }
                case 13: {
                    SurfaceControl _result = this.mirrorSurfaceControl();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.applyDimming(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IWallpaperEngine {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredSize(int width2, int height2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width2);
                    _data.writeInt(height2);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayPadding(Rect padding) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(padding, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inAmbientDisplay);
                    _data.writeLong(animationDuration);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchPointer(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action2, int x, int y, int z, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action2);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestWallpaperColors() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void destroy() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setZoomOut(float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scalePreview(Rect positionInWindow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(positionInWindow, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLocalColorsAreas(List<RectF> regions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(regions);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLocalColorsAreas(List<RectF> regions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(regions);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl mirrorSurfaceControl() throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyDimming(float dimAmount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(dimAmount);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWallpaperEngine {
        @Override
        public void setDesiredSize(int width2, int height2) throws RemoteException {
        }

        @Override
        public void setDisplayPadding(Rect padding) throws RemoteException {
        }

        @Override
        public void setVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
        }

        @Override
        public void dispatchPointer(MotionEvent event) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperCommand(String action2, int x, int y, int z, Bundle extras) throws RemoteException {
        }

        @Override
        public void requestWallpaperColors() throws RemoteException {
        }

        @Override
        public void destroy() throws RemoteException {
        }

        @Override
        public void setZoomOut(float scale) throws RemoteException {
        }

        @Override
        public void scalePreview(Rect positionInWindow) throws RemoteException {
        }

        @Override
        public void removeLocalColorsAreas(List<RectF> regions) throws RemoteException {
        }

        @Override
        public void addLocalColorsAreas(List<RectF> regions) throws RemoteException {
        }

        @Override
        public SurfaceControl mirrorSurfaceControl() throws RemoteException {
            return null;
        }

        @Override
        public void applyDimming(float dimAmount) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

